/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.dataio.ceos.prism;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import javax.imageio.stream.FileImageInputStream;
import org.esa.s3tbx.dataio.ceos.CeosFileReader;
import org.esa.s3tbx.dataio.ceos.CeosHelper;
import org.esa.s3tbx.dataio.ceos.IllegalCeosFormatException;
import org.esa.s3tbx.dataio.ceos.records.FilePointerRecord;
import org.esa.s3tbx.dataio.ceos.records.TextRecord;
import org.esa.s3tbx.dataio.ceos.records.VolumeDescriptorRecord;
import org.esa.snap.core.datamodel.MetadataElement;

class PrismVolumeDirectoryFile {
    private CeosFileReader _ceosReader;
    private VolumeDescriptorRecord _volumeDescriptorRecord;
    private FilePointerRecord[] _filePointerRecords;
    private TextRecord _textRecord;

    public PrismVolumeDirectoryFile(File baseDir) throws IOException, IllegalCeosFormatException {
        File volumeFile = CeosHelper.getVolumeFile(baseDir);
        this._ceosReader = new CeosFileReader(new FileImageInputStream(volumeFile));
        this._volumeDescriptorRecord = new VolumeDescriptorRecord(this._ceosReader);
        this._filePointerRecords = CeosHelper.readFilePointers(this._volumeDescriptorRecord);
        this._textRecord = new TextRecord(this._ceosReader);
    }

    public String getLeaderFileName() {
        return CeosHelper.getLeaderFileName(this._textRecord);
    }

    public String getTrailerFileName() {
        return CeosHelper.getTrailerFileName(this._textRecord);
    }

    public String getSupplementalFileName() {
        return CeosHelper.getSupplementalFileName(this._textRecord);
    }

    public String[] getImageFileNames() {
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < this._filePointerRecords.length; ++i) {
            FilePointerRecord filePointerRecord = this._filePointerRecords[i];
            if (!filePointerRecord.isImageFileRecord()) continue;
            String fileID = filePointerRecord.getFileID();
            list.add(CeosHelper.getImageFileName(this._textRecord, fileID.substring(15)));
        }
        return list.toArray(new String[list.size()]);
    }

    public void close() throws IOException {
        this._ceosReader.close();
        this._ceosReader = null;
        for (int i = 0; i < this._filePointerRecords.length; ++i) {
            this._filePointerRecords[i] = null;
        }
        this._filePointerRecords = null;
        this._volumeDescriptorRecord = null;
        this._textRecord = null;
    }

    public String getProductName() {
        return CeosHelper.getProductName(this._textRecord);
    }

    public void assignMetadataTo(MetadataElement elem) {
        MetadataElement vdfElem = new MetadataElement("VOLUME_DESCRIPTOR");
        elem.addElement(vdfElem);
        this._volumeDescriptorRecord.assignMetadataTo(vdfElem, null);
        for (int i = 0; i < this._filePointerRecords.length; ++i) {
            this._filePointerRecords[i].assignMetadataTo(vdfElem, "" + (i + 1));
        }
    }
}

