/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.dataio.ceos.prism;

import java.io.File;
import java.io.FilenameFilter;
import java.util.Locale;
import org.esa.s3tbx.dataio.ceos.CeosHelper;
import org.esa.s3tbx.dataio.ceos.prism.PrismConstants;
import org.esa.s3tbx.dataio.ceos.prism.PrismProductReader;
import org.esa.snap.core.dataio.DecodeQualification;
import org.esa.snap.core.dataio.ProductReader;
import org.esa.snap.core.dataio.ProductReaderPlugIn;
import org.esa.snap.core.util.io.FileUtils;
import org.esa.snap.core.util.io.SnapFileFilter;

public class PrismProductReaderPlugIn
implements ProductReaderPlugIn {
    private static final String _PRISM_INDICATION_KEY = "ALPSM";
    private static final int _MINIMUM_FILES = 4;

    public DecodeQualification getDecodeQualification(Object input) {
        FilenameFilter filter;
        File[] files;
        File file = CeosHelper.getFileFromInput(input);
        if (file == null) {
            return DecodeQualification.UNABLE;
        }
        String filename = FileUtils.getFilenameWithoutExtension((File)file);
        if (!filename.startsWith("VOL-ALPSM")) {
            return DecodeQualification.UNABLE;
        }
        File parentDir = file.getParentFile();
        if (file.isFile() && parentDir != null && parentDir.isDirectory() && (files = parentDir.listFiles(filter = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.contains(PrismProductReaderPlugIn._PRISM_INDICATION_KEY);
            }
        })) != null && files.length >= 4) {
            return DecodeQualification.INTENDED;
        }
        return DecodeQualification.UNABLE;
    }

    public Class[] getInputTypes() {
        return PrismConstants.VALID_INPUT_TYPES;
    }

    public ProductReader createReaderInstance() {
        return new PrismProductReader(this);
    }

    public SnapFileFilter getProductFileFilter() {
        return new PrismFileFilter();
    }

    public String[] getFormatNames() {
        return PrismConstants.FORMAT_NAMES;
    }

    public String[] getDefaultFileExtensions() {
        return PrismConstants.FORMAT_FILE_EXTENSIONS;
    }

    public String getDescription(Locale locale) {
        return "PRISM Products";
    }

    public static class PrismFileFilter
    extends SnapFileFilter {
        public PrismFileFilter() {
            this.setFormatName(PrismConstants.FORMAT_NAMES[0]);
            this.setDescription("PRISM Products");
        }

        public boolean accept(File file) {
            return super.accept(file) && (file.isDirectory() || file.getName().startsWith("VOL-ALPSM"));
        }
    }
}

