/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.dataio.ceos.avnir2.records;

import java.io.IOException;
import org.esa.s3tbx.dataio.ceos.CeosFileReader;
import org.esa.s3tbx.dataio.ceos.IllegalCeosFormatException;
import org.esa.s3tbx.dataio.ceos.records.BaseTrailerRecord;

public class Avnir2TrailerRecord
extends BaseTrailerRecord {
    private int[][] _bandHistograms;

    public Avnir2TrailerRecord(CeosFileReader reader) throws IOException, IllegalCeosFormatException {
        this(reader, -1L);
    }

    public Avnir2TrailerRecord(CeosFileReader reader, long startPos) throws IOException, IllegalCeosFormatException {
        super(reader, startPos);
    }

    @Override
    protected void readSpecificFields(CeosFileReader reader) throws IOException, IllegalCeosFormatException {
        reader.seek(this.getAbsolutPosition(20L));
        this._bandHistograms = new int[4][256];
        this.readHistograms(reader, this._bandHistograms);
    }

    @Override
    public int[] getHistogramFor(int bandNumber) {
        return this._bandHistograms[bandNumber - 1];
    }
}

