/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.dataio.ceos.avnir2.records;

import java.io.IOException;
import org.esa.s3tbx.dataio.ceos.CeosFileReader;
import org.esa.s3tbx.dataio.ceos.IllegalCeosFormatException;
import org.esa.s3tbx.dataio.ceos.records.BaseLeaderFileDescriptorRecord;

public class Avnir2LeaderFDR
extends BaseLeaderFileDescriptorRecord {
    private long _pixelSizeLocator;
    private long _pixelSizeLocatorDataStart;
    private long _pixelSizeLocatorNumBytes;
    private String _pixelSizeLocatorDataType;

    public Avnir2LeaderFDR(CeosFileReader reader) throws IOException, IllegalCeosFormatException {
        this(reader, -1L);
    }

    public Avnir2LeaderFDR(CeosFileReader reader, long startPos) throws IOException, IllegalCeosFormatException {
        super(reader, startPos);
    }

    @Override
    protected void readSpecificFields(CeosFileReader reader) throws IOException, IllegalCeosFormatException {
        reader.seek(this.getAbsolutPosition(376L));
        this._pixelSizeLocator = reader.readIn(6);
        this._pixelSizeLocatorDataStart = reader.readIn(6);
        this._pixelSizeLocatorNumBytes = reader.readIn(3);
        this._pixelSizeLocatorDataType = reader.readAn(1);
    }

    public long getPixelSizeLocator() {
        return this._pixelSizeLocator;
    }

    public long getPixelSizeLocatorDataStart() {
        return this._pixelSizeLocatorDataStart;
    }

    public long getPixelSizeLocatorNumBytes() {
        return this._pixelSizeLocatorNumBytes;
    }

    public String getPixelSizeLocatorDataType() {
        return this._pixelSizeLocatorDataType;
    }
}

