/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.dataio.ceos.avnir2.records;

import java.io.IOException;
import org.esa.s3tbx.dataio.ceos.CeosFileReader;
import org.esa.s3tbx.dataio.ceos.IllegalCeosFormatException;
import org.esa.s3tbx.dataio.ceos.records.BaseImageFileDescriptorRecord;

public class Avnir2ImageFDR
extends BaseImageFileDescriptorRecord {
    private String _locatorDummyPixel;
    private String _locatorOpticalBlack;
    private String _locatorOpticalWhite;
    private String _locatorElectricalCalibration;
    private String _locatorImageAuxiliaryData;
    private String _locatorQualityInformation;

    public Avnir2ImageFDR(CeosFileReader reader) throws IOException, IllegalCeosFormatException {
        this(reader, -1L);
    }

    public Avnir2ImageFDR(CeosFileReader reader, long startPos) throws IOException, IllegalCeosFormatException {
        super(reader, startPos);
    }

    @Override
    protected void readSpecificFields(CeosFileReader reader) throws IOException, IllegalCeosFormatException {
        reader.seek(this.getAbsolutPosition(340L));
        this._locatorDummyPixel = reader.readAn(8);
        this._locatorOpticalBlack = reader.readAn(8);
        this._locatorOpticalWhite = reader.readAn(8);
        this._locatorElectricalCalibration = reader.readAn(8);
        this._locatorImageAuxiliaryData = reader.readAn(8);
        this._locatorQualityInformation = reader.readAn(8);
    }

    public String getLocatorDummyPixel() {
        return this._locatorDummyPixel;
    }

    public String getLocatorElectricalCalibration() {
        return this._locatorElectricalCalibration;
    }

    public String getLocatorImageAuxiliaryData() {
        return this._locatorImageAuxiliaryData;
    }

    public String getLocatorOpticalBlack() {
        return this._locatorOpticalBlack;
    }

    public String getLocatorOpticalWhite() {
        return this._locatorOpticalWhite;
    }

    public String getLocatorQualityInformation() {
        return this._locatorQualityInformation;
    }
}

