/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.dataio.ceos.avnir2.records;

import java.io.IOException;
import org.esa.s3tbx.dataio.ceos.CeosFileReader;
import org.esa.s3tbx.dataio.ceos.IllegalCeosFormatException;
import org.esa.s3tbx.dataio.ceos.records.Ancillary2Record;

public class Avnir2Ancillary2Record
extends Ancillary2Record {
    private long[] _bandExposureCoefficients;
    private double[] _bandDetectorTemperature;
    private double[] _bandDetectorAssemblyTemperature;
    private double[] _bandGains;
    private double[] _bandOffsets;
    private double _signalProcessingUnitTemperature;

    public Avnir2Ancillary2Record(CeosFileReader reader) throws IOException, IllegalCeosFormatException {
        this(reader, -1L);
    }

    public Avnir2Ancillary2Record(CeosFileReader reader, long startPos) throws IOException, IllegalCeosFormatException {
        super(reader, startPos);
    }

    @Override
    protected void readSpecificFields(CeosFileReader reader) throws IOException, IllegalCeosFormatException {
        reader.seek(this.getAbsolutPosition(24L));
        this._bandExposureCoefficients = new long[4];
        this._bandExposureCoefficients[0] = reader.readIn(5);
        this._bandExposureCoefficients[1] = reader.readIn(5);
        this._bandExposureCoefficients[2] = reader.readIn(5);
        this._bandExposureCoefficients[3] = reader.readIn(5);
        reader.seek(this.getAbsolutPosition(78L));
        this._bandDetectorTemperature = new double[4];
        this._bandDetectorTemperature[0] = reader.readFn(8);
        this._bandDetectorTemperature[1] = reader.readFn(8);
        this._bandDetectorTemperature[2] = reader.readFn(8);
        this._bandDetectorTemperature[3] = reader.readFn(8);
        this._bandDetectorAssemblyTemperature = new double[4];
        this._bandDetectorAssemblyTemperature[0] = reader.readFn(8);
        this._bandDetectorAssemblyTemperature[1] = reader.readFn(8);
        this._bandDetectorAssemblyTemperature[2] = reader.readFn(8);
        this._bandDetectorAssemblyTemperature[3] = reader.readFn(8);
        this._signalProcessingUnitTemperature = reader.readFn(8);
        reader.seek(this.getAbsolutPosition(2702L));
        this._bandGains = new double[4];
        this._bandOffsets = new double[4];
        this._bandGains[0] = reader.readFn(8);
        this._bandOffsets[0] = reader.readFn(8);
        this._bandGains[1] = reader.readFn(8);
        this._bandOffsets[1] = reader.readFn(8);
        this._bandGains[2] = reader.readFn(8);
        this._bandOffsets[2] = reader.readFn(8);
        this._bandGains[3] = reader.readFn(8);
        this._bandOffsets[3] = reader.readFn(8);
    }

    public double getDetectorAssemblyTemperature(int bandNumber) {
        return this._bandDetectorAssemblyTemperature[bandNumber - 1];
    }

    public double getDetectorTemperature(int bandNumber) {
        return this._bandDetectorTemperature[bandNumber - 1];
    }

    public long getExposureCoefficient(int bandNumber) {
        return this._bandExposureCoefficients[bandNumber - 1];
    }

    public double getSignalProcessingUnitTemperature() {
        return this._signalProcessingUnitTemperature;
    }

    public double getAbsoluteCalibrationGain(int bandNumber) {
        return this._bandGains[bandNumber - 1];
    }

    public double getAbsoluteCalibrationOffset(int bandNumber) {
        return this._bandOffsets[bandNumber - 1];
    }
}

