/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.dataio.ceos.avnir2;

import java.io.IOException;
import javax.imageio.stream.ImageInputStream;
import org.esa.s3tbx.dataio.ceos.CeosFileReader;
import org.esa.s3tbx.dataio.ceos.IllegalCeosFormatException;
import org.esa.s3tbx.dataio.ceos.avnir2.records.Avnir2TrailerRecord;
import org.esa.s3tbx.dataio.ceos.records.TrailerFileDescriptorRecord;

class Avnir2TrailerFile {
    private Avnir2TrailerRecord _trailerRecord;
    private CeosFileReader _ceosReader;

    public Avnir2TrailerFile(ImageInputStream trailerStream) throws IOException, IllegalCeosFormatException {
        this._ceosReader = new CeosFileReader(trailerStream);
        new TrailerFileDescriptorRecord(this._ceosReader);
        this._trailerRecord = new Avnir2TrailerRecord(this._ceosReader);
    }

    public int[] getHistogramBinsForBand(int index) throws IOException, IllegalCeosFormatException {
        return this._trailerRecord.getHistogramFor(index);
    }

    public void close() throws IOException {
        this._ceosReader.close();
        this._ceosReader = null;
        this._trailerRecord = null;
    }
}

