/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.dataio.ceos.avnir2;

import java.io.File;
import java.io.FilenameFilter;
import java.util.Locale;
import org.esa.s3tbx.dataio.ceos.CeosHelper;
import org.esa.s3tbx.dataio.ceos.avnir2.Avnir2Constants;
import org.esa.s3tbx.dataio.ceos.avnir2.Avnir2ProductReader;
import org.esa.snap.core.dataio.DecodeQualification;
import org.esa.snap.core.dataio.ProductReader;
import org.esa.snap.core.dataio.ProductReaderPlugIn;
import org.esa.snap.core.datamodel.RGBImageProfile;
import org.esa.snap.core.datamodel.RGBImageProfileManager;
import org.esa.snap.core.util.io.FileUtils;
import org.esa.snap.core.util.io.SnapFileFilter;

public class Avnir2ProductReaderPlugIn
implements ProductReaderPlugIn {
    private static final String AVNIR2_INDICATION_KEY = "ALAV2";
    private static final int MINIMUM_FILES = 7;

    public DecodeQualification getDecodeQualification(Object input) {
        FilenameFilter filter;
        File[] files;
        File file = CeosHelper.getFileFromInput(input);
        if (file == null) {
            return DecodeQualification.UNABLE;
        }
        String filename = FileUtils.getFilenameWithoutExtension((File)file);
        if (!filename.startsWith("VOL-ALAV2")) {
            return DecodeQualification.UNABLE;
        }
        File parentDir = file.getParentFile();
        if (file.isFile() && parentDir != null && parentDir.isDirectory() && (files = parentDir.listFiles(filter = (dir, name) -> name.contains(AVNIR2_INDICATION_KEY))) != null && files.length >= 7) {
            return DecodeQualification.INTENDED;
        }
        return DecodeQualification.UNABLE;
    }

    public Class[] getInputTypes() {
        return Avnir2Constants.VALID_INPUT_TYPES;
    }

    public ProductReader createReaderInstance() {
        return new Avnir2ProductReader(this);
    }

    public SnapFileFilter getProductFileFilter() {
        return new Avnir2FileFilter();
    }

    public String[] getFormatNames() {
        return Avnir2Constants.FORMAT_NAMES;
    }

    public String[] getDefaultFileExtensions() {
        return Avnir2Constants.FORMAT_FILE_EXTENSIONS;
    }

    public String getDescription(Locale locale) {
        return "AVNIR-2 Products";
    }

    private static void registerRGBProfile() {
        RGBImageProfile profile = new RGBImageProfile("AVNIR-2 - 3,2,1", new String[]{"radiance_3", "radiance_2", "radiance_1"});
        RGBImageProfileManager.getInstance().addProfile(profile);
    }

    static {
        Avnir2ProductReaderPlugIn.registerRGBProfile();
    }

    public static class Avnir2FileFilter
    extends SnapFileFilter {
        public Avnir2FileFilter() {
            this.setFormatName(Avnir2Constants.FORMAT_NAMES[0]);
            this.setDescription("AVNIR-2 Products");
        }

        public boolean accept(File file) {
            return super.accept(file) && (file.isDirectory() || file.getName().startsWith("VOL-ALAV2"));
        }
    }
}

