/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.dataio.ceos.avnir2;

import com.bc.ceres.core.ProgressMonitor;
import java.io.IOException;
import javax.imageio.stream.ImageInputStream;
import org.esa.s3tbx.dataio.ceos.CeosFileReader;
import org.esa.s3tbx.dataio.ceos.IllegalCeosFormatException;
import org.esa.s3tbx.dataio.ceos.avnir2.records.Avnir2ImageFDR;
import org.esa.s3tbx.dataio.ceos.records.ImageRecord;
import org.esa.snap.core.datamodel.ProductData;

class Avnir2ImageFile {
    public final Avnir2ImageFDR _imageFDR;
    public final ImageRecord[] _imageRecords;
    private CeosFileReader _ceosReader;
    private final int _imageNumber;
    private int _imageRecordLength;
    private long _startPosImageRecords;

    public Avnir2ImageFile(ImageInputStream imageStream) throws IOException, IllegalCeosFormatException {
        this._ceosReader = new CeosFileReader(imageStream);
        this._imageFDR = new Avnir2ImageFDR(this._ceosReader);
        this._imageRecords = new ImageRecord[this._imageFDR.getNumLinesPerBand()];
        this._imageRecords[0] = new ImageRecord(this._ceosReader);
        this._imageRecordLength = this._imageRecords[0].getRecordLength();
        this._startPosImageRecords = this._imageRecords[0].getStartPos();
        this._imageNumber = this._imageRecords[0].getImageNumber();
    }

    public String getBandName() throws IOException, IllegalCeosFormatException {
        return "radiance_" + this.getBandIndex();
    }

    public String getBandDescription() throws IOException, IllegalCeosFormatException {
        return String.format("Radiance, Band %d", this.getBandIndex());
    }

    public int getBandIndex() throws IOException, IllegalCeosFormatException {
        return this._imageNumber;
    }

    public int getRasterWidth() throws IOException, IllegalCeosFormatException {
        return this._imageFDR.getNumImagePixelsPerLine();
    }

    public int getRasterHeight() throws IOException, IllegalCeosFormatException {
        return this._imageFDR.getNumLinesPerBand();
    }

    public String getGeophysicalUnit() {
        return "mw / (m^2*sr*nm)";
    }

    public float getSpectralWavelength() throws IOException, IllegalCeosFormatException {
        int bandIndex = this.getBandIndex();
        switch (bandIndex) {
            case 1: {
                return 420.0f;
            }
            case 2: {
                return 520.0f;
            }
            case 3: {
                return 610.0f;
            }
            case 4: {
                return 760.0f;
            }
        }
        return 0.0f;
    }

    public float getSpectralBandwidth() throws IOException, IllegalCeosFormatException {
        int bandIndex = this.getBandIndex();
        switch (bandIndex) {
            case 1: {
                return 80.0f;
            }
            case 2: {
                return 80.0f;
            }
            case 3: {
                return 80.0f;
            }
            case 4: {
                return 130.0f;
            }
        }
        return 0.0f;
    }

    public int getTotalMillisInDayOfLine(int y) throws IOException, IllegalCeosFormatException {
        return this.getImageRecord(y).getScanStartTimeMillisAtDay();
    }

    public int getMicrosecondsOfLine(int y) throws IOException, IllegalCeosFormatException {
        return this.getImageRecord(y).getScanStartTimeMicros();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readBandRasterData(int sourceOffsetX, int sourceOffsetY, int sourceWidth, int sourceHeight, int sourceStepX, int sourceStepY, int destOffsetX, int destOffsetY, int destWidth, int destHeight, ProductData destBuffer, ProgressMonitor pm) throws IOException, IllegalCeosFormatException {
        int sourceMinY = sourceOffsetY;
        int sourceMaxY = sourceOffsetY + sourceHeight - 1;
        pm.beginTask("Reading band '" + this.getBandName() + "'...", sourceMaxY - sourceMinY);
        try {
            byte[] srcLine = new byte[sourceWidth];
            byte[] destLine = new byte[destWidth];
            for (int y = sourceMinY; y <= sourceMaxY; y += sourceStepY) {
                if (pm.isCanceled()) {
                    break;
                }
                this.readSourceLine(y, sourceOffsetX, srcLine);
                this.copyLine(srcLine, destLine, sourceStepX);
                int currentLineIndex = (y - sourceMinY) * destWidth;
                System.arraycopy(destLine, 0, destBuffer.getElems(), currentLineIndex, destWidth);
                pm.worked(1);
            }
        }
        finally {
            pm.done();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readSourceLine(int y, int sourceOffsetX, byte[] srcLine) throws IOException, IllegalCeosFormatException {
        CeosFileReader ceosFileReader = this._ceosReader;
        synchronized (ceosFileReader) {
            ImageRecord imageRecord = this.getImageRecord(y);
            this._ceosReader.seek(imageRecord.getImageDataStart() + (long)sourceOffsetX);
            this._ceosReader.readB1(srcLine);
        }
    }

    private ImageRecord getImageRecord(int line) throws IOException, IllegalCeosFormatException {
        if (this._imageRecords[line] == null) {
            this._ceosReader.seek((long)(this._imageRecordLength * line) + this._startPosImageRecords);
            this._imageRecords[line] = new ImageRecord(this._ceosReader);
        }
        return this._imageRecords[line];
    }

    private void copyLine(byte[] srcLine, byte[] destLine, int sourceStepX) {
        if (sourceStepX == 1) {
            System.arraycopy(srcLine, 0, destLine, 0, destLine.length);
        } else {
            int x = 0;
            int i = 0;
            while (x < destLine.length) {
                destLine[x] = srcLine[i];
                ++x;
                i += sourceStepX;
            }
        }
    }

    public void close() throws IOException {
        this._ceosReader.close();
        this._ceosReader = null;
    }
}

