/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.dataio.ceos;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.Calendar;
import java.util.Date;
import org.esa.s3tbx.dataio.ceos.CeosFileReader;
import org.esa.s3tbx.dataio.ceos.IllegalCeosFormatException;
import org.esa.s3tbx.dataio.ceos.records.FilePointerRecord;
import org.esa.s3tbx.dataio.ceos.records.TextRecord;
import org.esa.s3tbx.dataio.ceos.records.VolumeDescriptorRecord;
import org.esa.snap.core.datamodel.ProductData;

public class CeosHelper {
    private static final String VOLUME_FILE_PREFIX = "VOL-";
    private static final String LEADER_FILE_PREFIX = "LED-";
    private static final String IMAGE_FILE_PREFIX = "IMG-";
    private static final String TRAILER_FILE_PREFIX = "TRL-";
    private static final String SUPPLEMENTAL_FILE_PREFIX = "SUP-";

    public static File getVolumeFile(File baseDir) throws IOException {
        File[] files = baseDir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.startsWith(CeosHelper.VOLUME_FILE_PREFIX) && name.indexOf(46) == -1;
            }
        });
        if (files == null || files.length < 1) {
            throw new IOException("No volume descriptor file found in directory:\n" + baseDir.getPath());
        }
        if (files.length > 1) {
            throw new IOException("Multiple volume descriptor files found in directory:\n" + baseDir.getPath());
        }
        return files[0];
    }

    public static FilePointerRecord[] readFilePointers(VolumeDescriptorRecord vdr) throws IllegalCeosFormatException, IOException {
        int numFilePointers = vdr.getNumberOfFilepointerRecords();
        CeosFileReader reader = vdr.getReader();
        reader.seek(vdr.getRecordLength());
        FilePointerRecord[] filePointers = new FilePointerRecord[numFilePointers];
        for (int i = 0; i < numFilePointers; ++i) {
            filePointers[i] = new FilePointerRecord(reader);
        }
        return filePointers;
    }

    public static String getLeaderFileName(TextRecord textRecord) {
        return LEADER_FILE_PREFIX + CeosHelper.getProductName(textRecord);
    }

    public static String getTrailerFileName(TextRecord textRecord) {
        return TRAILER_FILE_PREFIX + CeosHelper.getProductName(textRecord);
    }

    public static String getSupplementalFileName(TextRecord textRecord) {
        return SUPPLEMENTAL_FILE_PREFIX + CeosHelper.getProductName(textRecord);
    }

    public static String getImageFileName(TextRecord textRecord, String ccd) {
        if (ccd != null && ccd.trim().length() > 0) {
            return "IMG-0" + ccd + "-" + CeosHelper.getProductName(textRecord);
        }
        return IMAGE_FILE_PREFIX + CeosHelper.getProductName(textRecord);
    }

    public static String getProductName(TextRecord textRecord) {
        return textRecord.getSceneID() + "-" + textRecord.getProductID();
    }

    public static ProductData.UTC createUTCDate(int year, int dayOfYear, int millisInDay) {
        Calendar calendar = ProductData.UTC.createCalendar();
        calendar.set(1, year);
        calendar.set(6, dayOfYear);
        calendar.add(14, millisInDay);
        return ProductData.UTC.create((Date)calendar.getTime(), (long)0L);
    }

    public static double[] sortToFXYSumOrder(double[] coeffs) {
        double[] newOrder = new double[coeffs.length];
        newOrder[0] = coeffs[0];
        newOrder[1] = coeffs[1];
        newOrder[2] = coeffs[2];
        newOrder[3] = coeffs[4];
        newOrder[4] = coeffs[3];
        newOrder[5] = coeffs[5];
        newOrder[6] = coeffs[8];
        newOrder[7] = coeffs[6];
        newOrder[8] = coeffs[7];
        newOrder[9] = coeffs[9];
        return newOrder;
    }

    public static double[] convertLongToDouble(long[] longs) {
        double[] doubles = new double[longs.length];
        for (int i = 0; i < longs.length; ++i) {
            doubles[i] = Double.longBitsToDouble(longs[i]);
        }
        return doubles;
    }

    public static File getFileFromInput(Object input) {
        if (input instanceof String) {
            return new File((String)input);
        }
        if (input instanceof File) {
            return (File)input;
        }
        return null;
    }
}

