/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.dataio.ceos.records;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.MemoryCacheImageOutputStream;
import org.esa.s3tbx.dataio.ceos.CeosFileReader;
import org.esa.s3tbx.dataio.ceos.CeosTestHelper;
import org.esa.s3tbx.dataio.ceos.IllegalCeosFormatException;
import org.esa.s3tbx.dataio.ceos.records.BaseRecord;
import org.esa.s3tbx.dataio.ceos.records.BaseRecordTest;
import org.esa.s3tbx.dataio.ceos.records.VolumeDescriptorRecord;
import org.esa.snap.core.datamodel.MetadataElement;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class VolumeDescriptorRecordTest {
    private MemoryCacheImageOutputStream _ios;
    private String _prefix;
    private CeosFileReader _reader;

    @Before
    public void setUp() throws Exception {
        ByteArrayOutputStream os = new ByteArrayOutputStream(24);
        this._ios = new MemoryCacheImageOutputStream(os);
        this._prefix = "VolumeDescriptorRecordTest_prefix";
        this._ios.writeBytes(this._prefix);
        this.writeRecordData(this._ios);
        this._ios.writeBytes("VolumeDescriptorRecordTest_suffix");
        this._reader = new CeosFileReader((ImageInputStream)this._ios);
    }

    @Test
    public void testInit_SimpleConstructor() throws IOException, IllegalCeosFormatException {
        this._reader.seek((long)this._prefix.length());
        VolumeDescriptorRecord record = new VolumeDescriptorRecord(this._reader);
        this.assertRecord(record);
    }

    @Test
    public void testInit() throws IOException, IllegalCeosFormatException {
        VolumeDescriptorRecord record = new VolumeDescriptorRecord(this._reader, (long)this._prefix.length());
        this.assertRecord(record);
    }

    @Test
    public void testAssignMetadata() throws IOException, IllegalCeosFormatException {
        VolumeDescriptorRecord record = new VolumeDescriptorRecord(this._reader, (long)this._prefix.length());
        MetadataElement volumeMetadata = new MetadataElement("VOLUME_DESCRIPTOR");
        record.assignMetadataTo(volumeMetadata, "suffix");
        Assert.assertEquals((long)23L, (long)volumeMetadata.getNumAttributes());
        Assert.assertEquals((long)0L, (long)volumeMetadata.getNumElements());
        this.assertMetadata(volumeMetadata);
    }

    private void assertMetadata(MetadataElement elem) {
        BaseRecordTest.assertMetadata(elem);
        BaseRecordTest.assertStringAttribute(elem, "Ascii code character", "AB");
        BaseRecordTest.assertStringAttribute(elem, "Specification number", "abcdefghijkl");
        BaseRecordTest.assertStringAttribute(elem, "Specification revision number", "CD");
        BaseRecordTest.assertStringAttribute(elem, "Record format revision number", "EF");
        BaseRecordTest.assertStringAttribute(elem, "Software version number", "bcdefghijklm");
        BaseRecordTest.assertStringAttribute(elem, "Logical volume ID", "cdefghijklmnopqr");
        BaseRecordTest.assertStringAttribute(elem, "Volume set ID", "defghijklmnopqrs");
        BaseRecordTest.assertIntAttribute(elem, "Volume number of this volume descriptor record", 12);
        BaseRecordTest.assertIntAttribute(elem, "Number of first file following the volume directory file", 2345);
        BaseRecordTest.assertIntAttribute(elem, "Logical volume number in volume set", 3456);
        BaseRecordTest.assertStringAttribute(elem, "Logical volume preparation date", "efghijkl");
        BaseRecordTest.assertStringAttribute(elem, "Logical volume preparation time", "fghijklm");
        BaseRecordTest.assertStringAttribute(elem, "Logical volume preparation country", "ghijklmnopqr");
        BaseRecordTest.assertStringAttribute(elem, "Logical volume preparing agent", "hijklmno");
        BaseRecordTest.assertStringAttribute(elem, "Logical volume preparing facility", "ijklmnopqrst");
        BaseRecordTest.assertIntAttribute(elem, "Number of filepointer records", 4567);
        BaseRecordTest.assertIntAttribute(elem, "Number of records", 5678);
    }

    private void writeRecordData(MemoryCacheImageOutputStream ios) throws IOException {
        BaseRecordTest.writeRecordData(ios);
        ios.writeBytes("AB");
        CeosTestHelper.writeBlanks(ios, 2);
        ios.writeBytes("abcdefghijkl");
        ios.writeBytes("CD");
        ios.writeBytes("EF");
        ios.writeBytes("bcdefghijklm");
        CeosTestHelper.writeBlanks(ios, 16);
        ios.writeBytes("cdefghijklmnopqr");
        ios.writeBytes("defghijklmnopqrs");
        CeosTestHelper.writeBlanks(ios, 6);
        ios.writeBytes("12");
        ios.writeBytes("2345");
        ios.writeBytes("3456");
        CeosTestHelper.writeBlanks(ios, 4);
        ios.writeBytes("efghijkl");
        ios.writeBytes("fghijklm");
        ios.writeBytes("ghijklmnopqr");
        ios.writeBytes("hijklmno");
        ios.writeBytes("ijklmnopqrst");
        ios.writeBytes("4567");
        ios.writeBytes("5678");
        CeosTestHelper.writeBlanks(ios, 192);
    }

    private void assertRecord(VolumeDescriptorRecord record) throws IOException {
        BaseRecordTest.assertRecord((BaseRecord)record);
        Assert.assertEquals((long)this._prefix.length(), (long)record.getStartPos());
        Assert.assertEquals((long)(this._prefix.length() + 360), (long)this._ios.getStreamPosition());
        Assert.assertEquals((Object)"AB", (Object)record.getAsciiCodeCharacter());
        Assert.assertEquals((Object)"abcdefghijkl", (Object)record.getSpecificationNumber());
        Assert.assertEquals((Object)"CD", (Object)record.getSpecificationRevisionNumber());
        Assert.assertEquals((Object)"EF", (Object)record.getRecordFormatRevisionNumer());
        Assert.assertEquals((Object)"bcdefghijklm", (Object)record.getSoftwareVersionNumber());
        Assert.assertEquals((Object)"cdefghijklmnopqr", (Object)record.getLogicalVolumeID());
        Assert.assertEquals((Object)"defghijklmnopqrs", (Object)record.getVolumeSetID());
        Assert.assertEquals((long)12L, (long)record.getVolumeNumberOfThisVolumeDescritorRecord());
        Assert.assertEquals((long)2345L, (long)record.getNumberOfFirstFileFollowingTheVolumeDirectoryFile());
        Assert.assertEquals((long)3456L, (long)record.getLogicalVolumeNumberInVolumeSet());
        Assert.assertEquals((Object)"efghijkl", (Object)record.getLogicalVolumePreparationDate());
        Assert.assertEquals((Object)"fghijklm", (Object)record.getLogicalVolumePreparationTime());
        Assert.assertEquals((Object)"ghijklmnopqr", (Object)record.getLogicalVolumePreparationCountry());
        Assert.assertEquals((Object)"hijklmno", (Object)record.getLogicalVolumePreparingAgent());
        Assert.assertEquals((Object)"ijklmnopqrst", (Object)record.getLogicalVolumePreparingFacility());
        Assert.assertEquals((long)4567L, (long)record.getNumberOfFilepointerRecords());
        Assert.assertEquals((long)5678L, (long)record.getNumberOfRecords());
    }
}

