/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.dataio.ceos.records;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.ImageOutputStream;
import javax.imageio.stream.MemoryCacheImageOutputStream;
import org.esa.s3tbx.dataio.ceos.CeosFileReader;
import org.esa.s3tbx.dataio.ceos.CeosTestHelper;
import org.esa.s3tbx.dataio.ceos.IllegalCeosFormatException;
import org.esa.s3tbx.dataio.ceos.records.BaseRecord;
import org.esa.s3tbx.dataio.ceos.records.BaseRecordTest;
import org.esa.s3tbx.dataio.ceos.records.CommonFileDescriptorRecord;
import org.junit.Assert;
import org.junit.Test;

public class CommonFileDescriptorRecordTest {
    @Test
    public void testInitCommonFileDescriptorRecord() throws IOException, IllegalCeosFormatException {
        ByteArrayOutputStream os = new ByteArrayOutputStream(24);
        MemoryCacheImageOutputStream ios = new MemoryCacheImageOutputStream(os);
        String prefix = "fdkjglsdkfhierr.m b9b0970w34";
        ios.writeBytes("fdkjglsdkfhierr.m b9b0970w34");
        CommonFileDescriptorRecordTest.writeRecordData(ios);
        ios.writeBytes("nq3tf9\u00df8nvnvpdi er 0 324p3f");
        CommonFileDescriptorRecord record = new CommonFileDescriptorRecord(new CeosFileReader((ImageInputStream)ios), (long)"fdkjglsdkfhierr.m b9b0970w34".length());
        CommonFileDescriptorRecordTest.assertRecord(record);
        Assert.assertEquals((long)"fdkjglsdkfhierr.m b9b0970w34".length(), (long)record.getStartPos());
        Assert.assertEquals((long)("fdkjglsdkfhierr.m b9b0970w34".length() + 180), (long)ios.getStreamPosition());
    }

    public static void assertRecord(CommonFileDescriptorRecord record) {
        BaseRecordTest.assertRecord((BaseRecord)record);
        Assert.assertEquals((Object)"A ", (Object)record.getCodeCharacter());
        Assert.assertEquals((Object)"manno       ", (Object)record.getFileDocumentNumber());
        Assert.assertEquals((Object)"A ", (Object)record.getFileDokumentRevisionNumber());
        Assert.assertEquals((Object)"A ", (Object)record.getFileDesignRevisionLetter());
        Assert.assertEquals((Object)"prdsys      ", (Object)record.getLogicalVolPrepSysRelNum());
        Assert.assertEquals((long)1L, (long)record.getFileNumber());
        Assert.assertEquals((Object)"AL PSMB2LEADBSQ ", (Object)record.getFileID());
        Assert.assertEquals((Object)"FSEQ", (Object)record.getFlagRecordComposition());
        Assert.assertEquals((long)1L, (long)record.getRecordNumberPositionOfEachFile());
        Assert.assertEquals((long)4L, (long)record.getFieldLengthForRecordData());
        Assert.assertEquals((Object)"FTYP", (Object)record.getFlagOfRecordTypeCode());
        Assert.assertEquals((long)5L, (long)record.getRecordTypeCodeBytePosition());
        Assert.assertEquals((long)4L, (long)record.getRecordTypeCodeFieldLength());
        Assert.assertEquals((Object)"FLGT", (Object)record.getFlagRecordLength());
        Assert.assertEquals((long)9L, (long)record.getBytePosOfRecLength());
        Assert.assertEquals((long)4L, (long)record.getNumOfBytesOfRecLength());
        Assert.assertEquals((Object)"N", (Object)record.getFlagDataConvInfFileDescRec());
        Assert.assertEquals((Object)"O", (Object)record.getFlagDataConvInOtherRecords());
        Assert.assertEquals((Object)"P", (Object)record.getFlagDataDispFileDescRecord());
        Assert.assertEquals((Object)"Q", (Object)record.getFlagDataDispInOtherRecords());
    }

    public static void writeRecordData(ImageOutputStream ios) throws IOException {
        BaseRecordTest.writeRecordData(ios);
        ios.writeBytes("A ");
        ios.writeBytes("  ");
        ios.writeBytes("manno       ");
        ios.writeBytes("A ");
        ios.writeBytes("A ");
        ios.writeBytes("prdsys      ");
        ios.writeBytes("   1");
        ios.writeBytes("AL PSMB2LEADBSQ ");
        ios.writeBytes("FSEQ");
        ios.writeBytes("       1");
        ios.writeBytes("   4");
        ios.writeBytes("FTYP");
        ios.writeBytes("       5");
        ios.writeBytes("   4");
        ios.writeBytes("FLGT");
        ios.writeBytes("       9");
        ios.writeBytes("   4");
        ios.writeBytes("N");
        ios.writeBytes("O");
        ios.writeBytes("P");
        ios.writeBytes("Q");
        CeosTestHelper.writeBlanks(ios, 64);
    }
}

