/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.dataio.ceos.records;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.ImageOutputStream;
import javax.imageio.stream.MemoryCacheImageOutputStream;
import org.esa.s3tbx.dataio.ceos.CeosFileReader;
import org.esa.s3tbx.dataio.ceos.CeosTestHelper;
import org.esa.s3tbx.dataio.ceos.IllegalCeosFormatException;
import org.esa.s3tbx.dataio.ceos.records.BaseRecord;
import org.esa.s3tbx.dataio.ceos.records.BaseRecordTest;
import org.esa.s3tbx.dataio.ceos.records.BaseTrailerRecord;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public abstract class BaseTrailerRecordTest {
    private String _prefix;
    private CeosFileReader _reader;

    @Before
    public void setUp() throws Exception {
        ByteArrayOutputStream os = new ByteArrayOutputStream(24);
        MemoryCacheImageOutputStream ios = new MemoryCacheImageOutputStream(os);
        this._prefix = "TrailerRecordTest_prefix";
        ios.writeBytes(this._prefix);
        this.writeRecordData(ios);
        ios.writeBytes("TrailerRecordTest_suffix");
        this._reader = new CeosFileReader((ImageInputStream)ios);
    }

    @Test
    public void testInit_SimpleConstructor() throws IOException, IllegalCeosFormatException {
        this._reader.seek((long)this._prefix.length());
        BaseTrailerRecord record = this.createTrailerRecord(this._reader);
        this.assertRecord(record);
    }

    @Test
    public void testInit() throws IOException, IllegalCeosFormatException {
        BaseTrailerRecord record = this.createTrailerRecord(this._reader, this._prefix.length());
        this.assertRecord(record);
    }

    private void writeRecordData(ImageOutputStream ios) throws IOException {
        BaseRecordTest.writeRecordData(ios);
        ios.writeBytes("   1");
        ios.writeBytes("   1");
        this.writeHistograms(ios);
        CeosTestHelper.writeBlanks(ios, 248);
    }

    private void assertRecord(BaseTrailerRecord record) throws IOException {
        BaseRecordTest.assertRecord((BaseRecord)record);
        Assert.assertEquals((long)this._prefix.length(), (long)record.getStartPos());
        Assert.assertEquals((long)1L, (long)record.getNumTrailerRecords());
        Assert.assertEquals((long)1L, (long)record.getNumTrailerRecordsInOneCCDUnit());
        this.assertHistograms(record);
    }

    protected abstract BaseTrailerRecord createTrailerRecord(CeosFileReader var1) throws IOException, IllegalCeosFormatException;

    protected abstract BaseTrailerRecord createTrailerRecord(CeosFileReader var1, int var2) throws IOException, IllegalCeosFormatException;

    protected abstract void writeHistograms(ImageOutputStream var1) throws IOException;

    protected abstract void assertHistograms(BaseTrailerRecord var1);
}

