/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.dataio.ceos.records;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.ImageOutputStream;
import javax.imageio.stream.MemoryCacheImageOutputStream;
import org.esa.s3tbx.dataio.ceos.CeosFileReader;
import org.esa.s3tbx.dataio.ceos.IllegalCeosFormatException;
import org.esa.s3tbx.dataio.ceos.records.BaseRecord;
import org.esa.snap.core.datamodel.MetadataAttribute;
import org.esa.snap.core.datamodel.MetadataElement;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class BaseRecordTest {
    static final int RECORD_LENGTH = 4680;
    private ImageOutputStream _ios;
    private String _prefix;
    private CeosFileReader _reader;

    @Before
    public void setUp() throws Exception {
        ByteArrayOutputStream os = new ByteArrayOutputStream(24);
        this._ios = new MemoryCacheImageOutputStream(os);
        this._prefix = "BaseRecordTest_prefix";
        this._ios.writeBytes(this._prefix);
        BaseRecordTest.writeRecordData(this._ios);
        this._ios.writeBytes("BaseRecordTest_suffix");
        this._reader = new CeosFileReader((ImageInputStream)this._ios);
    }

    @Test
    public void testInitBaseRecord() throws IOException, IllegalCeosFormatException {
        BaseRecord record = new BaseRecord(this._reader, (long)this._prefix.length());
        BaseRecordTest.assertRecord(record);
        Assert.assertSame((Object)this._reader, (Object)record.getReader());
        Assert.assertEquals((long)this._prefix.length(), (long)record.getStartPos());
        Assert.assertEquals((long)(this._prefix.length() + 12), (long)this._ios.getStreamPosition());
    }

    @Test
    public void testAssignMetadataTo() throws IOException, IllegalCeosFormatException {
        BaseRecord record = new BaseRecord(this._reader, (long)this._prefix.length());
        MetadataElement elem = new MetadataElement("elem");
        record.assignMetadataTo(elem, null);
        BaseRecordTest.assertMetadata(elem);
        Assert.assertEquals((long)0L, (long)elem.getNumElements());
        Assert.assertEquals((long)6L, (long)elem.getNumAttributes());
    }

    static void assertMetadata(MetadataElement elem) {
        BaseRecordTest.assertIntAttribute(elem, "Record number", 1);
        BaseRecordTest.assertIntAttribute(elem, "First record subtype", 63);
        BaseRecordTest.assertIntAttribute(elem, "Record type code", 192);
        BaseRecordTest.assertIntAttribute(elem, "Second record subtype", 18);
        BaseRecordTest.assertIntAttribute(elem, "Third record subtype", 17);
        BaseRecordTest.assertIntAttribute(elem, "Record length", 4680);
    }

    static void assertIntAttribute(MetadataElement elem, String attributeName, int expectedValue) {
        MetadataAttribute attribute = elem.getAttribute(attributeName);
        Assert.assertNotNull((Object)attribute);
        Assert.assertEquals((long)12L, (long)attribute.getDataType());
        Assert.assertEquals((long)1L, (long)attribute.getNumDataElems());
        Assert.assertEquals((long)expectedValue, (long)attribute.getData().getElemInt());
    }

    static void assertStringAttribute(MetadataElement elem, String attibuteName, String expectedValue) {
        MetadataAttribute attribute = elem.getAttribute(attibuteName);
        Assert.assertNotNull((Object)attribute);
        Assert.assertEquals((Object)"ascii", (Object)attribute.getData().getTypeString());
        Assert.assertEquals((Object)expectedValue, (Object)attribute.getData().getElemString());
    }

    public static void assertRecord(BaseRecord record) {
        Assert.assertNotNull((Object)record);
        Assert.assertEquals((long)1L, (long)record.getRecordNumber());
        Assert.assertEquals((long)63L, (long)record.getFirstRecordSubtype());
        Assert.assertEquals((long)192L, (long)record.getRecordTypeCode());
        Assert.assertEquals((long)18L, (long)record.getSecondRecordSubtype());
        Assert.assertEquals((long)17L, (long)record.getThirdRecordSubtype());
        Assert.assertEquals((long)4680L, (long)record.getRecordLength());
    }

    public static void writeRecordData(ImageOutputStream ios) throws IOException {
        ios.writeInt(1);
        ios.write(63);
        ios.write(192);
        ios.write(18);
        ios.write(17);
        ios.writeInt(4680);
    }

    @Test
    public void testCreateMetadataElement() {
        String suffix = "suffix";
        MetadataElement elem = BaseRecord.createMetadataElement((String)"name", (String)suffix);
        Assert.assertNotNull((Object)elem);
        Assert.assertEquals((Object)"name suffix", (Object)elem.getName());
        suffix = "   ";
        elem = BaseRecord.createMetadataElement((String)"name", (String)suffix);
        Assert.assertNotNull((Object)elem);
        Assert.assertEquals((Object)"name", (Object)elem.getName());
        suffix = "";
        elem = BaseRecord.createMetadataElement((String)"name", (String)suffix);
        Assert.assertNotNull((Object)elem);
        Assert.assertEquals((Object)"name", (Object)elem.getName());
        suffix = null;
        elem = BaseRecord.createMetadataElement((String)"name", (String)suffix);
        Assert.assertNotNull((Object)elem);
        Assert.assertEquals((Object)"name", (Object)elem.getName());
    }
}

