/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.dataio.ceos.records;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.ImageOutputStream;
import javax.imageio.stream.MemoryCacheImageOutputStream;
import org.esa.s3tbx.dataio.ceos.CeosFileReader;
import org.esa.s3tbx.dataio.ceos.IllegalCeosFormatException;
import org.esa.s3tbx.dataio.ceos.records.BaseLeaderFileDescriptorRecord;
import org.esa.s3tbx.dataio.ceos.records.CommonFileDescriptorRecord;
import org.esa.s3tbx.dataio.ceos.records.CommonFileDescriptorRecordTest;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public abstract class BaseLeaderFileDescriptorRecordTest {
    private ImageOutputStream _ios;
    private String _prefix;
    private CeosFileReader _reader;

    @Before
    public void setUp() throws Exception {
        ByteArrayOutputStream os = new ByteArrayOutputStream(24);
        this._ios = new MemoryCacheImageOutputStream(os);
        this._prefix = "fdkjglsdkfhierr.m b9b0970w34";
        this._ios.writeBytes(this._prefix);
        this.writeRecordData(this._ios);
        this._ios.writeBytes("nq3tf9\u00df8nvnvpdi er 0 324p3f");
        this._reader = new CeosFileReader((ImageInputStream)this._ios);
    }

    @Test
    public void testInit_SimpleConstructor() throws IOException, IllegalCeosFormatException {
        this._reader.seek((long)this._prefix.length());
        CeosFileReader reader = this._reader;
        BaseLeaderFileDescriptorRecord record = this.createLeaderFDR(reader);
        this.assertRecord(record);
    }

    @Test
    public void testInit() throws IOException, IllegalCeosFormatException {
        CeosFileReader reader = this._reader;
        int startPos = this._prefix.length();
        BaseLeaderFileDescriptorRecord record = this.createLeaderFDR(reader, startPos);
        this.assertRecord(record);
    }

    private void assertRecord(BaseLeaderFileDescriptorRecord record) throws IOException {
        CommonFileDescriptorRecordTest.assertRecord((CommonFileDescriptorRecord)record);
        Assert.assertEquals((long)this._prefix.length(), (long)record.getStartPos());
        Assert.assertEquals((long)(this._prefix.length() + 4680), (long)this._ios.getStreamPosition());
        Assert.assertNotNull((Object)record);
        Assert.assertEquals((long)1L, (long)record.getNumSceneHeaderRecords());
        Assert.assertEquals((long)4680L, (long)record.getSceneHeaderRecordLength());
        Assert.assertEquals((long)3L, (long)record.getNumAncillaryRecords());
        Assert.assertEquals((long)4680L, (long)record.getAncillaryRecordLength());
        Assert.assertEquals((long)1L, (long)record.getSceneIdFieldLocator());
        Assert.assertEquals((long)2L, (long)record.getSceneIdFieldDataStart());
        Assert.assertEquals((long)3L, (long)record.getSceneIdFieldNumBytes());
        Assert.assertEquals((Object)"A", (Object)record.getSceneIdFieldDataType());
        Assert.assertEquals((long)4L, (long)record.getRSPIdLocator());
        Assert.assertEquals((long)5L, (long)record.getRSPIdDataStart());
        Assert.assertEquals((long)6L, (long)record.getRSPIdNumBytes());
        Assert.assertEquals((Object)"B", (Object)record.getRSPIdDataType());
        Assert.assertEquals((long)7L, (long)record.getMissionIdLocator());
        Assert.assertEquals((long)8L, (long)record.getMissionIdDataStart());
        Assert.assertEquals((long)9L, (long)record.getMissionIdNumBytes());
        Assert.assertEquals((Object)"C", (Object)record.getMissionIdDataType());
        Assert.assertEquals((long)10L, (long)record.getSensorIdLocator());
        Assert.assertEquals((long)11L, (long)record.getSensorIdDataStart());
        Assert.assertEquals((long)12L, (long)record.getSensorIdNumBytes());
        Assert.assertEquals((Object)"D", (Object)record.getSensorIdDataType());
        Assert.assertEquals((long)13L, (long)record.getSceneCenterTimeLocator());
        Assert.assertEquals((long)14L, (long)record.getSceneCenterTimeDataStart());
        Assert.assertEquals((long)15L, (long)record.getSceneCenterTimeNumBytes());
        Assert.assertEquals((Object)"E", (Object)record.getSceneCenterTimeDataType());
        Assert.assertEquals((long)16L, (long)record.getSceneCenterLatLonLocator());
        Assert.assertEquals((long)17L, (long)record.getSceneCenterLatLonDataStart());
        Assert.assertEquals((long)18L, (long)record.getSceneCenterLatLonNumBytes());
        Assert.assertEquals((Object)"F", (Object)record.getSceneCenterLatLonDataType());
        Assert.assertEquals((long)19L, (long)record.getProcessingLevelLocator());
        Assert.assertEquals((long)20L, (long)record.getProcessingLevelDataStart());
        Assert.assertEquals((long)21L, (long)record.getProcessingLevelNumBytes());
        Assert.assertEquals((Object)"G", (Object)record.getProcessingLevelDataType());
        Assert.assertEquals((long)22L, (long)record.getImageFormatLocator());
        Assert.assertEquals((long)23L, (long)record.getImageFormatDataStart());
        Assert.assertEquals((long)24L, (long)record.getImageFormatNumBytes());
        Assert.assertEquals((Object)"H", (Object)record.getImageFormatDataType());
        Assert.assertEquals((long)25L, (long)record.getEffektiveBandLocator());
        Assert.assertEquals((long)26L, (long)record.getEffektiveBandDataStart());
        Assert.assertEquals((long)27L, (long)record.getEffektiveBandNumBytes());
        Assert.assertEquals((Object)"I", (Object)record.getEffektiveBandDataType());
        this.assertRecords17To21(record);
    }

    private void writeRecordData(ImageOutputStream ios) throws IOException {
        CommonFileDescriptorRecordTest.writeRecordData(ios);
        ios.writeBytes("     1");
        ios.writeBytes("  4680");
        ios.writeBytes("     3");
        ios.writeBytes("  4680");
        ios.writeBytes("      ");
        ios.writeBytes("      ");
        ios.writeBytes("     1");
        ios.writeBytes("     2");
        ios.writeBytes("  3");
        ios.writeBytes("A");
        ios.writeBytes("     4");
        ios.writeBytes("     5");
        ios.writeBytes("  6");
        ios.writeBytes("B");
        ios.writeBytes("     7");
        ios.writeBytes("     8");
        ios.writeBytes("  9");
        ios.writeBytes("C");
        ios.writeBytes("    10");
        ios.writeBytes("    11");
        ios.writeBytes(" 12");
        ios.writeBytes("D");
        ios.writeBytes("    13");
        ios.writeBytes("    14");
        ios.writeBytes(" 15");
        ios.writeBytes("E");
        ios.writeBytes("    16");
        ios.writeBytes("    17");
        ios.writeBytes(" 18");
        ios.writeBytes("F");
        ios.writeBytes("    19");
        ios.writeBytes("    20");
        ios.writeBytes(" 21");
        ios.writeBytes("G");
        ios.writeBytes("    22");
        ios.writeBytes("    23");
        ios.writeBytes(" 24");
        ios.writeBytes("H");
        ios.writeBytes("    25");
        ios.writeBytes("    26");
        ios.writeBytes(" 27");
        ios.writeBytes("I");
        this.writeFields17To21(ios);
    }

    protected abstract BaseLeaderFileDescriptorRecord createLeaderFDR(CeosFileReader var1, int var2) throws IOException, IllegalCeosFormatException;

    protected abstract BaseLeaderFileDescriptorRecord createLeaderFDR(CeosFileReader var1) throws IOException, IllegalCeosFormatException;

    protected abstract void writeFields17To21(ImageOutputStream var1) throws IOException;

    protected abstract void assertRecords17To21(BaseLeaderFileDescriptorRecord var1);
}

