/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.dataio.ceos.prism.records;

import java.io.IOException;
import javax.imageio.stream.ImageOutputStream;
import org.esa.s3tbx.dataio.ceos.CeosFileReader;
import org.esa.s3tbx.dataio.ceos.CeosTestHelper;
import org.esa.s3tbx.dataio.ceos.IllegalCeosFormatException;
import org.esa.s3tbx.dataio.ceos.prism.records.SceneHeaderRecord;
import org.esa.s3tbx.dataio.ceos.records.BaseSceneHeaderRecord;
import org.esa.s3tbx.dataio.ceos.records.BaseSceneHeaderRecordTest;
import org.junit.Assert;

public class SceneHeaderRecordTest
extends BaseSceneHeaderRecordTest {
    @Override
    protected BaseSceneHeaderRecord createSceneHeaderRecord(CeosFileReader reader) throws IOException, IllegalCeosFormatException {
        return new SceneHeaderRecord(reader);
    }

    @Override
    protected BaseSceneHeaderRecord createSceneHeaderRecord(CeosFileReader reader, int startPos) throws IOException, IllegalCeosFormatException {
        return new SceneHeaderRecord(reader, (long)startPos);
    }

    @Override
    protected void writeFields30To31(ImageOutputStream ios) throws IOException {
        CeosTestHelper.writeBlanks(ios, 16);
        ios.writeBytes("2");
    }

    @Override
    protected void writeFields73ToEnd(ImageOutputStream ios) throws IOException {
        ios.writeBytes("KJHGF");
        ios.writeBytes("54");
        CeosTestHelper.writeBlanks(ios, 2803);
    }

    @Override
    protected void assertFields30To31(BaseSceneHeaderRecord record) {
        SceneHeaderRecord sceneHeaderRecord = (SceneHeaderRecord)record;
        Assert.assertEquals((Object)"2", (Object)sceneHeaderRecord.getCompressionMode());
    }

    @Override
    protected void assertFields73ToEnd(BaseSceneHeaderRecord record) {
        SceneHeaderRecord sceneHeaderRecord = (SceneHeaderRecord)record;
        Assert.assertEquals((Object)"KJHGF", (Object)sceneHeaderRecord.getImageExtractionPoint());
        Assert.assertEquals((Object)"54", (Object)sceneHeaderRecord.getYawSteeringFlag());
    }
}

