/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.dataio.ceos.avnir2.records;

import java.io.IOException;
import javax.imageio.stream.ImageOutputStream;
import org.esa.s3tbx.dataio.ceos.CeosFileReader;
import org.esa.s3tbx.dataio.ceos.IllegalCeosFormatException;
import org.esa.s3tbx.dataio.ceos.avnir2.records.Avnir2TrailerRecord;
import org.esa.s3tbx.dataio.ceos.records.BaseTrailerRecord;
import org.esa.s3tbx.dataio.ceos.records.BaseTrailerRecordTest;
import org.junit.Assert;

public class Avnir2TrailerRecordTest
extends BaseTrailerRecordTest {
    @Override
    protected BaseTrailerRecord createTrailerRecord(CeosFileReader reader) throws IOException, IllegalCeosFormatException {
        return new Avnir2TrailerRecord(reader);
    }

    @Override
    protected BaseTrailerRecord createTrailerRecord(CeosFileReader reader, int startPos) throws IOException, IllegalCeosFormatException {
        return new Avnir2TrailerRecord(reader, (long)startPos);
    }

    @Override
    protected void writeHistograms(ImageOutputStream ios) throws IOException {
        for (int i = 0; i < 4000; i += 1000) {
            for (int j = 0; j < 256; ++j) {
                ios.writeInt(i + j);
            }
        }
    }

    @Override
    protected void assertHistograms(BaseTrailerRecord record) {
        Avnir2TrailerRecord trailerRecord = (Avnir2TrailerRecord)record;
        for (int i = 0; i < 4000; i += 1000) {
            int bandNumber = i / 1000 + 1;
            int[] histoForBand = trailerRecord.getHistogramFor(bandNumber);
            for (int j = 0; j < 256; ++j) {
                Assert.assertEquals((long)(i + j), (long)histoForBand[j]);
            }
        }
    }
}

