/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.dataio.ceos.avnir2.records;

import java.io.IOException;
import javax.imageio.stream.ImageOutputStream;
import org.esa.s3tbx.dataio.ceos.CeosFileReader;
import org.esa.s3tbx.dataio.ceos.CeosTestHelper;
import org.esa.s3tbx.dataio.ceos.IllegalCeosFormatException;
import org.esa.s3tbx.dataio.ceos.avnir2.records.Avnir2SceneHeaderRecord;
import org.esa.s3tbx.dataio.ceos.records.BaseSceneHeaderRecord;
import org.esa.s3tbx.dataio.ceos.records.BaseSceneHeaderRecordTest;
import org.junit.Assert;

public class Avnir2SceneHeaderRecordTest
extends BaseSceneHeaderRecordTest {
    @Override
    protected BaseSceneHeaderRecord createSceneHeaderRecord(CeosFileReader reader) throws IOException, IllegalCeosFormatException {
        return new Avnir2SceneHeaderRecord(reader);
    }

    @Override
    protected BaseSceneHeaderRecord createSceneHeaderRecord(CeosFileReader reader, int startPos) throws IOException, IllegalCeosFormatException {
        return new Avnir2SceneHeaderRecord(reader, (long)startPos);
    }

    @Override
    protected void writeFields30To31(ImageOutputStream ios) throws IOException {
        ios.writeBytes("         -26.000");
        ios.writeBytes(" ");
    }

    @Override
    protected void writeFields73ToEnd(ImageOutputStream ios) throws IOException {
        ios.writeBytes(" 1");
        CeosTestHelper.writeBlanks(ios, 2808);
    }

    @Override
    protected void assertFields30To31(BaseSceneHeaderRecord record) {
        Avnir2SceneHeaderRecord sceneHeaderRecord = (Avnir2SceneHeaderRecord)record;
        Assert.assertEquals((Object)"         -26.000", (Object)sceneHeaderRecord.getOffNadirMirrorPointAngle());
    }

    @Override
    protected void assertFields73ToEnd(BaseSceneHeaderRecord record) {
        Avnir2SceneHeaderRecord sceneHeaderRecord = (Avnir2SceneHeaderRecord)record;
        Assert.assertEquals((Object)" 1", (Object)sceneHeaderRecord.getYawSteeringFlag());
    }
}

