/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s3tbx.dataio.ceos;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.MemoryCacheImageOutputStream;
import org.esa.s3tbx.dataio.ceos.CeosFileReader;
import org.esa.s3tbx.dataio.ceos.IllegalCeosFormatException;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class CeosFileReaderTest {
    private MemoryCacheImageOutputStream _ios;

    @Before
    public void setUp() throws Exception {
        ByteArrayOutputStream os = new ByteArrayOutputStream(24);
        this._ios = new MemoryCacheImageOutputStream(os);
    }

    @Test
    public void testSeek() throws IOException, IllegalCeosFormatException {
        byte[] bytes = new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15};
        this._ios.write(bytes);
        CeosFileReader ceosReader = new CeosFileReader((ImageInputStream)this._ios);
        ceosReader.seek(1L);
        Assert.assertEquals((long)1L, (long)ceosReader.readB1());
        ceosReader.seek(3L);
        Assert.assertEquals((long)3L, (long)ceosReader.readB1());
        ceosReader.seek(9L);
        Assert.assertEquals((long)9L, (long)ceosReader.readB1());
        ceosReader.seek(4L);
        Assert.assertEquals((long)4L, (long)ceosReader.readB1());
        ceosReader.seek(14L);
        Assert.assertEquals((long)14L, (long)ceosReader.readB1());
    }

    @Test
    public void testSkipBytes() throws IOException, IllegalCeosFormatException {
        byte[] bytes = new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15};
        this._ios.write(bytes);
        this._ios.seek(0L);
        CeosFileReader ceosReader = new CeosFileReader((ImageInputStream)this._ios);
        ceosReader.skipBytes(1L);
        Assert.assertEquals((long)1L, (long)ceosReader.readB1());
        ceosReader.skipBytes(3L);
        Assert.assertEquals((long)5L, (long)ceosReader.readB1());
        ceosReader.skipBytes(5L);
        Assert.assertEquals((long)11L, (long)ceosReader.readB1());
    }

    @Test
    public void testReadB1() throws IOException, IllegalCeosFormatException {
        this._ios.writeByte(122);
        this._ios.seek(0L);
        CeosFileReader ceosReader = new CeosFileReader((ImageInputStream)this._ios);
        Assert.assertEquals((long)122L, (long)ceosReader.readB1());
    }

    @Test
    public void testReadB1GreatValue() throws IOException, IllegalCeosFormatException {
        this._ios.writeByte(245);
        this._ios.seek(0L);
        CeosFileReader ceosReader = new CeosFileReader((ImageInputStream)this._ios);
        Assert.assertEquals((long)245L, (long)ceosReader.readB1());
    }

    @Test
    public void testReadB1ThrowsException() throws IOException {
        String prefix = "ddz716d51n+dn4drh1td6r4nh64n1687";
        this._ios.writeBytes("ddz716d51n+dn4drh1td6r4nh64n1687");
        this._ios.seek(0L);
        CeosFileReader ceosReader = new CeosFileReader((ImageInputStream)this._ios);
        ceosReader.seek((long)"ddz716d51n+dn4drh1td6r4nh64n1687".length());
        try {
            ceosReader.readB1();
            Assert.fail((String)"IllegalCeosFormatException expected");
        }
        catch (IllegalCeosFormatException e) {
            Assert.assertEquals((long)"ddz716d51n+dn4drh1td6r4nh64n1687".length(), (long)e.getStreamPos());
        }
    }

    @Test
    public void testReadB2() throws IOException, IllegalCeosFormatException {
        String prefix = "\u00df3534a\u00df0uawemqw34mfavsdpvhawef\u00f6ldv:";
        String suffix = "lfjldfkjvg45";
        int expected = -12354;
        this._ios.writeBytes("\u00df3534a\u00df0uawemqw34mfavsdpvhawef\u00f6ldv:");
        this._ios.writeShort(-12354);
        this._ios.writeBytes("lfjldfkjvg45");
        CeosFileReader ceosReader = new CeosFileReader((ImageInputStream)this._ios);
        ceosReader.seek((long)"\u00df3534a\u00df0uawemqw34mfavsdpvhawef\u00f6ldv:".length());
        Assert.assertEquals((long)-12354L, (long)ceosReader.readB2());
    }

    @Test
    public void testReadB4() throws IOException, IllegalCeosFormatException {
        String prefix = "\u00df3534a\u00df0uawemqw34mfavsdpvhawef\u00f6ldv:";
        String suffix = "lfjldfkjvg45";
        this._ios.writeBytes("\u00df3534a\u00df0uawemqw34mfavsdpvhawef\u00f6ldv:");
        this._ios.writeInt(7100);
        this._ios.writeBytes("lfjldfkjvg45");
        CeosFileReader ceosReader = new CeosFileReader((ImageInputStream)this._ios);
        ceosReader.seek((long)"\u00df3534a\u00df0uawemqw34mfavsdpvhawef\u00f6ldv:".length());
        Assert.assertEquals((long)7100L, (long)ceosReader.readB4());
    }

    @Test
    public void testReadB4Array() throws IOException, IllegalCeosFormatException {
        String prefix = "gf654hdf4f46514s:";
        String suffix = "lfjldfkjvg45";
        int expected1 = 7100;
        int expected2 = -98769342;
        this._ios.writeBytes("gf654hdf4f46514s:");
        this._ios.writeInt(7100);
        this._ios.writeInt(-98769342);
        this._ios.writeBytes("lfjldfkjvg45");
        CeosFileReader ceosReader = new CeosFileReader((ImageInputStream)this._ios);
        ceosReader.seek((long)"gf654hdf4f46514s:".length());
        int[] intsToRead = new int[2];
        ceosReader.readB4(intsToRead);
        Assert.assertEquals((long)7100L, (long)intsToRead[0]);
        Assert.assertEquals((long)-98769342L, (long)intsToRead[1]);
    }

    @Test
    public void testReadB4ArrayThrowsException() throws IOException {
        String prefix = "ddz716d51n+dn4drh1td6r4nh64n1687";
        this._ios.writeBytes("ddz716d51n+dn4drh1td6r4nh64n1687");
        this._ios.writeInt(234521431);
        CeosFileReader ceosReader = new CeosFileReader((ImageInputStream)this._ios);
        ceosReader.seek((long)"ddz716d51n+dn4drh1td6r4nh64n1687".length());
        int[] intsToRead = new int[2];
        try {
            ceosReader.readB4(intsToRead);
            Assert.fail((String)"IllegalCeosFormatException expected");
        }
        catch (IllegalCeosFormatException e) {
            Assert.assertEquals((long)"ddz716d51n+dn4drh1td6r4nh64n1687".length(), (long)e.getStreamPos());
        }
    }

    @Test
    public void testReadB8() throws IOException, IllegalCeosFormatException {
        byte[] bytes = new byte[]{0, 1, 0, 17, 0, 0, 27, -68};
        this._ios.write(bytes);
        this._ios.seek(0L);
        CeosFileReader ceosReader = new CeosFileReader((ImageInputStream)this._ios);
        Assert.assertEquals((long)281547991161788L, (long)ceosReader.readB8());
    }

    @Test
    public void testReadB8Array() throws IOException, IllegalCeosFormatException {
        long expected1 = 281547991161788L;
        long expected2 = 1L;
        this._ios.writeLong(281547991161788L);
        this._ios.writeLong(1L);
        this._ios.seek(0L);
        CeosFileReader ceosReader = new CeosFileReader((ImageInputStream)this._ios);
        long[] values = new long[2];
        ceosReader.readB8(values);
        Assert.assertEquals((long)281547991161788L, (long)values[0]);
        Assert.assertEquals((long)1L, (long)values[1]);
    }

    @Test
    public void testReadB1Array() throws IOException, IllegalCeosFormatException {
        boolean expected1 = true;
        int expected2 = 2;
        int expected3 = 3;
        int expected4 = 4;
        int expected5 = 27;
        int expected6 = -10;
        int expected7 = 9;
        int expected8 = 11;
        this._ios.write(1);
        this._ios.write(2);
        this._ios.write(3);
        this._ios.write(4);
        this._ios.write(27);
        this._ios.write(-10);
        this._ios.write(9);
        this._ios.write(11);
        this._ios.seek(0L);
        CeosFileReader ceosReader = new CeosFileReader((ImageInputStream)this._ios);
        byte[] values = new byte[8];
        ceosReader.readB1(values);
        Assert.assertEquals((long)1L, (long)values[0]);
        Assert.assertEquals((long)2L, (long)values[1]);
        Assert.assertEquals((long)3L, (long)values[2]);
        Assert.assertEquals((long)4L, (long)values[3]);
        Assert.assertEquals((long)27L, (long)values[4]);
        Assert.assertEquals((long)-10L, (long)values[5]);
        Assert.assertEquals((long)9L, (long)values[6]);
        Assert.assertEquals((long)11L, (long)values[7]);
    }

    @Test
    public void testReadI4() throws IllegalCeosFormatException, IOException {
        this._ios.writeBytes("19730060");
        this._ios.seek(0L);
        CeosFileReader ceosReader = new CeosFileReader((ImageInputStream)this._ios);
        Assert.assertEquals((long)1973L, (long)ceosReader.readI4());
        Assert.assertEquals((long)60L, (long)ceosReader.readI4());
    }

    @Test
    public void testReadIn() throws IllegalCeosFormatException, IOException {
        this._ios.writeBytes("  7358");
        this._ios.seek(0L);
        CeosFileReader ceosReader = new CeosFileReader((ImageInputStream)this._ios);
        Assert.assertEquals((long)7358L, (long)ceosReader.readIn(6));
    }

    @Test
    public void testReadFnWithNegative() throws IllegalCeosFormatException, IOException {
        this._ios.writeBytes("     -89.0060123");
        this._ios.seek(0L);
        CeosFileReader ceosReader = new CeosFileReader((ImageInputStream)this._ios);
        Assert.assertEquals((double)-89.0060123, (double)ceosReader.readFn(16), (double)1.0E-10);
    }

    @Test
    public void testReadFnWithPositive() throws IllegalCeosFormatException, IOException {
        this._ios.writeBytes("      19.0060123");
        this._ios.seek(0L);
        CeosFileReader ceosReader = new CeosFileReader((ImageInputStream)this._ios);
        Assert.assertEquals((double)19.0060123, (double)ceosReader.readFn(16), (double)1.0E-10);
    }

    @Test
    public void testReadFnWithLeadingZero() throws IllegalCeosFormatException, IOException {
        this._ios.writeBytes("       9.0060123");
        this._ios.seek(0L);
        CeosFileReader ceosReader = new CeosFileReader((ImageInputStream)this._ios);
        Assert.assertEquals((double)9.0060123, (double)ceosReader.readFn(16), (double)1.0E-10);
    }

    @Test
    public void testReadFnWithTrailingZero() throws IllegalCeosFormatException, IOException {
        this._ios.writeBytes("       9.0060000");
        this._ios.seek(0L);
        CeosFileReader ceosReader = new CeosFileReader((ImageInputStream)this._ios);
        Assert.assertEquals((double)9.006, (double)ceosReader.readFn(16), (double)1.0E-6);
    }

    @Test
    public void testReadFnWithEmpty() throws IllegalCeosFormatException, IOException {
        String prefix = "iufkdjker";
        String value = "                ";
        String suffix = "oiunkasdjnf";
        this._ios.writeBytes("iufkdjker");
        this._ios.writeBytes("                ");
        this._ios.writeBytes("oiunkasdjnf");
        CeosFileReader ceosReader = new CeosFileReader((ImageInputStream)this._ios);
        ceosReader.seek((long)"iufkdjker".length());
        try {
            ceosReader.readFn(16);
            Assert.fail((String)"IllegalCeosFormatException expected");
        }
        catch (IllegalCeosFormatException e) {
            Assert.assertEquals((long)"iufkdjker".length(), (long)e.getStreamPos());
        }
    }

    @Test
    public void testReadEn() throws IllegalCeosFormatException, IOException {
        this._ios.writeBytes(" 1.782000000000000E+04");
        this._ios.seek(0L);
        CeosFileReader ceosReader = new CeosFileReader((ImageInputStream)this._ios);
        Assert.assertEquals((double)17820.0, (double)ceosReader.readEn(22), (double)1.0E-6);
    }

    @Test
    public void testReadGn() throws IllegalCeosFormatException, IOException {
        this._ios.writeBytes("-1.06962770630708111E+01");
        this._ios.seek(0L);
        CeosFileReader ceosReader = new CeosFileReader((ImageInputStream)this._ios);
        Assert.assertEquals((double)-10.696277063070811, (double)ceosReader.readGn(24), (double)1.0E-25);
    }

    @Test
    public void testReadGnArray() throws IllegalCeosFormatException, IOException {
        this._ios.writeBytes("-1.06962770630708111E+01");
        this._ios.writeBytes(" 1.28993192035406507E-05");
        this._ios.writeBytes("-8.94946528898421729E-05");
        this._ios.writeBytes(" 6.75271499535523411E-13");
        this._ios.seek(0L);
        CeosFileReader ceosReader = new CeosFileReader((ImageInputStream)this._ios);
        double[] values = new double[4];
        ceosReader.readGn(24, values);
        Assert.assertEquals((double)-10.696277063070811, (double)values[0], (double)1.0E-25);
        Assert.assertEquals((double)1.289931920354065E-5, (double)values[1], (double)1.0E-25);
        Assert.assertEquals((double)-8.949465288984217E-5, (double)values[2], (double)1.0E-25);
        Assert.assertEquals((double)6.752714995355234E-13, (double)values[3], (double)1.0E-25);
    }

    @Test
    public void testReadAn() throws IllegalCeosFormatException, IOException {
        String expected = "Kinkerlitzchen";
        this._ios.writeBytes("Kinkerlitzchen");
        this._ios.seek(0L);
        CeosFileReader ceosReader = new CeosFileReader((ImageInputStream)this._ios);
        Assert.assertEquals((Object)"Kinkerlitzchen", (Object)ceosReader.readAn("Kinkerlitzchen".length()));
    }

    @Test
    public void testReadB1ArrayThrowsException() throws IOException {
        String prefix = "ddz716d51n+dn4drh1td6r4nh64n1687";
        this._ios.writeBytes("ddz716d51n+dn4drh1td6r4nh64n1687");
        this._ios.write(new byte[]{0, -68, 0, 1});
        CeosFileReader ceosReader = new CeosFileReader((ImageInputStream)this._ios);
        ceosReader.seek((long)"ddz716d51n+dn4drh1td6r4nh64n1687".length());
        byte[] bytesToRead = new byte[8];
        try {
            ceosReader.readB1(bytesToRead);
            Assert.fail((String)"IllegalCeosFormatException expected");
        }
        catch (IllegalCeosFormatException e) {
            Assert.assertEquals((long)"ddz716d51n+dn4drh1td6r4nh64n1687".length(), (long)e.getStreamPos());
        }
    }

    @Test
    public void testReadAnThrowsExceptionBecauseStreamIsToShort() throws IOException {
        String prefix = "dflkjoieng nvivbaewr vpivbydv";
        String charsToRead = "To lon";
        this._ios.writeBytes("dflkjoieng nvivbaewr vpivbydv");
        this._ios.writeBytes("To lon");
        CeosFileReader ceosReader = new CeosFileReader((ImageInputStream)this._ios);
        ceosReader.seek((long)"dflkjoieng nvivbaewr vpivbydv".length());
        try {
            ceosReader.readAn(7);
            Assert.fail((String)"IllegalCeosFormatException expected");
        }
        catch (IllegalCeosFormatException e) {
            Assert.assertEquals((long)"dflkjoieng nvivbaewr vpivbydv".length(), (long)e.getStreamPos());
        }
    }

    @Test
    public void testReadFnWithExceptionBecauseStreamIsToShort() throws IOException {
        String prefix = "following only 15 characters but it should read 16: ";
        String only15Characters = "123456789.12345";
        this._ios.writeBytes("following only 15 characters but it should read 16: ");
        this._ios.writeBytes("123456789.12345");
        CeosFileReader ceosReader = new CeosFileReader((ImageInputStream)this._ios);
        ceosReader.seek((long)"following only 15 characters but it should read 16: ".length());
        try {
            ceosReader.readFn(16);
            Assert.fail((String)"IllegalCeosFormatException expected");
        }
        catch (IllegalCeosFormatException e) {
            Assert.assertEquals((long)"following only 15 characters but it should read 16: ".length(), (long)e.getStreamPos());
        }
    }

    @Test
    public void testReadFnWithExceptionBecauseDoubleIsNotParsable() throws IOException {
        String prefix = "following a not parsable double value : ";
        String notParsable16Double = "1234g6789.123456";
        this._ios.writeBytes("following a not parsable double value : ");
        this._ios.writeBytes("1234g6789.123456");
        this._ios.writeBytes("suffix letters");
        CeosFileReader ceosReader = new CeosFileReader((ImageInputStream)this._ios);
        ceosReader.seek((long)"following a not parsable double value : ".length());
        try {
            ceosReader.readFn(16);
            Assert.fail((String)"IllegalCeosFormatException expected");
        }
        catch (IllegalCeosFormatException e) {
            Assert.assertEquals((long)"following a not parsable double value : ".length(), (long)e.getStreamPos());
        }
    }

    @Test
    public void testReadInArray() throws IOException, IllegalCeosFormatException {
        String prefix = "vspdfoperilfdkposnsern";
        this._ios.writeBytes("vspdfoperilfdkposnsern");
        this._ios.writeBytes("123");
        this._ios.writeBytes(" 45");
        this._ios.writeBytes("  6");
        this._ios.writeBytes(" 46");
        this._ios.writeBytes(" 7 ");
        this._ios.writeBytes("234");
        this._ios.writeBytes("suffix");
        CeosFileReader ceosReader = new CeosFileReader((ImageInputStream)this._ios);
        ceosReader.seek((long)"vspdfoperilfdkposnsern".length());
        int[] ints = ceosReader.readInArray(6, 3);
        Assert.assertNotNull((Object)ints);
        Assert.assertEquals((long)6L, (long)ints.length);
        Assert.assertEquals((long)123L, (long)ints[0]);
        Assert.assertEquals((long)45L, (long)ints[1]);
        Assert.assertEquals((long)6L, (long)ints[2]);
        Assert.assertEquals((long)46L, (long)ints[3]);
        Assert.assertEquals((long)7L, (long)ints[4]);
        Assert.assertEquals((long)234L, (long)ints[5]);
        Assert.assertEquals((long)("vspdfoperilfdkposnsern".length() + 18), (long)this._ios.getStreamPosition());
    }

    @Test
    public void testReadInArrayWithBlanks() throws IOException, IllegalCeosFormatException {
        String prefix = "vspdfoperilfdkposnsern";
        this._ios.writeBytes("vspdfoperilfdkposnsern");
        this._ios.writeBytes("123 45 67");
        this._ios.writeBytes("suffix");
        CeosFileReader ceosReader = new CeosFileReader((ImageInputStream)this._ios);
        ceosReader.seek((long)"vspdfoperilfdkposnsern".length());
        int[] ints = ceosReader.readInArray(9, 1);
        Assert.assertNotNull((Object)ints);
        Assert.assertEquals((long)9L, (long)ints.length);
        Assert.assertEquals((long)1L, (long)ints[0]);
        Assert.assertEquals((long)2L, (long)ints[1]);
        Assert.assertEquals((long)3L, (long)ints[2]);
        Assert.assertEquals((long)0L, (long)ints[3]);
        Assert.assertEquals((long)4L, (long)ints[4]);
        Assert.assertEquals((long)5L, (long)ints[5]);
        Assert.assertEquals((long)0L, (long)ints[6]);
        Assert.assertEquals((long)6L, (long)ints[7]);
        Assert.assertEquals((long)7L, (long)ints[8]);
        Assert.assertEquals((long)("vspdfoperilfdkposnsern".length() + 9), (long)this._ios.getStreamPosition());
    }

    @Test
    public void testReadInArrayWithErrors() throws IOException {
        String prefix = "vspdfoperilfdkposnsern";
        this._ios.writeBytes("vspdfoperilfdkposnsern");
        this._ios.writeBytes("123a45");
        this._ios.writeBytes("suffix");
        CeosFileReader ceosReader = new CeosFileReader((ImageInputStream)this._ios);
        ceosReader.seek((long)"vspdfoperilfdkposnsern".length());
        try {
            ceosReader.readInArray(6, 1);
            Assert.fail((String)"IllegalCeosFormatException expected");
        }
        catch (IllegalCeosFormatException e) {
            Assert.assertEquals((long)("vspdfoperilfdkposnsern".length() + 3), (long)e.getStreamPos());
        }
    }
}

