/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s1tbx.sentinel1.gpf.experimental;

import com.bc.ceres.core.ProgressMonitor;
import edu.emory.mathcs.jtransforms.fft.DoubleFFT_1D;
import java.awt.Rectangle;
import java.util.Map;
import org.apache.commons.math3.util.FastMath;
import org.esa.s1tbx.insar.gpf.support.Sentinel1Utils;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.gpf.Operator;
import org.esa.snap.core.gpf.OperatorException;
import org.esa.snap.core.gpf.OperatorSpi;
import org.esa.snap.core.gpf.Tile;
import org.esa.snap.core.gpf.annotations.OperatorMetadata;
import org.esa.snap.core.gpf.annotations.Parameter;
import org.esa.snap.core.gpf.annotations.SourceProduct;
import org.esa.snap.core.gpf.annotations.TargetProduct;
import org.esa.snap.engine_utilities.gpf.InputProductValidator;
import org.esa.snap.engine_utilities.gpf.OperatorUtils;
import org.esa.snap.engine_utilities.gpf.TileIndex;

@OperatorMetadata(alias="Azimuth-Spectrum", category="Radar/Coregistration/S-1 TOPS Coregistration", authors="Jun Lu, Luis Veci", version="1.0", copyright="Copyright (C) 2014 by Array Systems Computing Inc.", description="Compute azimuth spectrum for each deramped burst", internal=true)
public final class DerampedAzimuthSpectrumOp
extends Operator {
    @SourceProduct(alias="source")
    private Product sourceProduct;
    @TargetProduct
    private Product targetProduct;
    @Parameter(defaultValue="true", label="Perform Deramp Only")
    private boolean derampOnly = true;
    @Parameter(defaultValue="false", label="Output Deramp Phase")
    private boolean outputDerampPhase = false;
    @Parameter(defaultValue="false", label="Output Demodulation Phase")
    private boolean outputDemodPhase = false;
    private Sentinel1Utils su = null;
    private Sentinel1Utils.SubSwathInfo[] subSwath = null;
    private int subSwathIndex = 0;
    private String swathIndexStr = null;
    private String polarization = null;

    public void initialize() throws OperatorException {
        try {
            if (this.sourceProduct == null) {
                return;
            }
            InputProductValidator validator = new InputProductValidator(this.sourceProduct);
            validator.checkIfSARProduct();
            validator.checkIfSentinel1Product();
            validator.checkIfSLC();
            this.su = new Sentinel1Utils(this.sourceProduct);
            this.su.computeDopplerRate();
            this.su.computeReferenceTime();
            this.subSwath = this.su.getSubSwath();
            String[] subSwathNames = this.su.getSubSwathNames();
            if (subSwathNames.length != 1) {
                throw new OperatorException("Split product is expected.");
            }
            this.subSwathIndex = 1;
            this.swathIndexStr = subSwathNames[0].substring(2);
            String[] polarizations = this.su.getPolarizations();
            if (polarizations.length != 1) {
                throw new OperatorException("Split product with one polarization is expected.");
            }
            this.polarization = polarizations[0];
            this.createTargetProduct();
        }
        catch (Throwable e) {
            throw new OperatorException(e.getMessage());
        }
    }

    private void createTargetProduct() {
        int sourceImageWidth = this.sourceProduct.getSceneRasterWidth();
        int sourceImageHeight = this.sourceProduct.getSceneRasterHeight();
        this.targetProduct = new Product(this.sourceProduct.getName(), this.sourceProduct.getProductType(), sourceImageWidth, sourceImageHeight);
        Band azSpecBand = new Band("azSpec", 30, sourceImageWidth, sourceImageHeight);
        azSpecBand.setUnit("intensity");
        this.targetProduct.addBand(azSpecBand);
        if (this.outputDerampPhase) {
            Band derampPhaseBand = new Band("derampPhase", 30, sourceImageWidth, sourceImageHeight);
            derampPhaseBand.setUnit("radian");
            this.targetProduct.addBand(derampPhaseBand);
        }
        if (this.outputDemodPhase) {
            Band demodPhaseBand = new Band("demodPhase", 30, sourceImageWidth, sourceImageHeight);
            demodPhaseBand.setUnit("radian");
            this.targetProduct.addBand(demodPhaseBand);
        }
        this.targetProduct.setPreferredTileSize(512, this.subSwath[0].linesPerBurst);
    }

    public void computeTileStack(Map<Band, Tile> targetTileMap, Rectangle targetRectangle, ProgressMonitor pm) throws OperatorException {
        try {
            int x0 = targetRectangle.x;
            int y0 = targetRectangle.y;
            int w = targetRectangle.width;
            int h = targetRectangle.height;
            System.out.println("x0 = " + x0 + ", y0 = " + y0 + ", w = " + w + ", h = " + h);
            int burstIndex = y0 / this.subSwath[this.subSwathIndex - 1].linesPerBurst;
            double[][] derampDemodPhase = this.computeDerampDemodPhase(this.subSwathIndex, burstIndex, targetRectangle, targetTileMap);
            if (derampDemodPhase == null) {
                return;
            }
            Band srcBandI = this.getBand(this.sourceProduct, "i_", this.swathIndexStr, this.polarization);
            Band srcBandQ = this.getBand(this.sourceProduct, "q_", this.swathIndexStr, this.polarization);
            Tile srcTileI = this.getSourceTile((RasterDataNode)srcBandI, targetRectangle);
            Tile srcTileQ = this.getSourceTile((RasterDataNode)srcBandQ, targetRectangle);
            double[][] derampDemodI = new double[h][w];
            double[][] derampDemodQ = new double[h][w];
            this.performDerampDemod(srcTileI, srcTileQ, targetRectangle, derampDemodPhase, derampDemodI, derampDemodQ);
            this.computeAzimuthSpectrum(w, h, derampDemodI, derampDemodQ, targetTileMap);
        }
        catch (Throwable e) {
            OperatorUtils.catchOperatorException((String)"computeTile", (Throwable)e);
        }
    }

    private double[][] computeDerampDemodPhase(int subSwathIndex, int burstIndex, Rectangle rectangle, Map<Band, Tile> targetTileMap) {
        try {
            int x0 = rectangle.x;
            int y0 = rectangle.y;
            int w = rectangle.width;
            int h = rectangle.height;
            int xMax = x0 + w;
            int yMax = y0 + h;
            int s = subSwathIndex - 1;
            Band derampPhaseBand = null;
            Tile derampPhaseTile = null;
            ProductData derampPhaseBuffer = null;
            if (this.outputDerampPhase) {
                derampPhaseBand = this.targetProduct.getBand("derampPhase");
                derampPhaseTile = targetTileMap.get(derampPhaseBand);
                derampPhaseBuffer = derampPhaseTile.getDataBuffer();
            }
            Band demodPhaseBand = null;
            Tile demodPhaseTile = null;
            ProductData demodPhaseBuffer = null;
            if (this.outputDemodPhase) {
                demodPhaseBand = this.targetProduct.getBand("demodPhase");
                demodPhaseTile = targetTileMap.get(demodPhaseBand);
                demodPhaseBuffer = demodPhaseTile.getDataBuffer();
            }
            TileIndex tgtIndex = null;
            if (derampPhaseTile != null) {
                tgtIndex = new TileIndex(derampPhaseTile);
            } else if (demodPhaseTile != null) {
                tgtIndex = new TileIndex(demodPhaseTile);
            }
            double[][] phase = new double[h][w];
            int firstLineInBurst = burstIndex * this.subSwath[s].linesPerBurst;
            if (this.outputDerampPhase || this.outputDemodPhase) {
                for (int y = y0; y < yMax; ++y) {
                    tgtIndex.calculateStride(y);
                    int yy = y - y0;
                    double ta = (double)(y - firstLineInBurst) * this.subSwath[s].azimuthTimeInterval;
                    for (int x = x0; x < xMax; ++x) {
                        int tgtIdx = tgtIndex.getIndex(x);
                        int xx = x - x0;
                        double kt = this.subSwath[s].dopplerRate[burstIndex][x];
                        double deramp = -Math.PI * kt * FastMath.pow((double)(ta - this.subSwath[s].referenceTime[burstIndex][x]), (int)2);
                        double demod = Math.PI * -2 * this.subSwath[s].dopplerCentroid[burstIndex][x] * ta;
                        phase[yy][xx] = this.derampOnly ? deramp : deramp + demod;
                        if (this.outputDerampPhase) {
                            derampPhaseBuffer.setElemDoubleAt(tgtIdx, deramp);
                        }
                        if (!this.outputDemodPhase) continue;
                        demodPhaseBuffer.setElemDoubleAt(tgtIdx, demod);
                    }
                }
            } else {
                for (int y = y0; y < yMax; ++y) {
                    int yy = y - y0;
                    double ta = (double)(y - firstLineInBurst) * this.subSwath[s].azimuthTimeInterval;
                    for (int x = x0; x < xMax; ++x) {
                        int xx = x - x0;
                        double kt = this.subSwath[s].dopplerRate[burstIndex][x];
                        double deramp = -Math.PI * kt * FastMath.pow((double)(ta - this.subSwath[s].referenceTime[burstIndex][x]), (int)2);
                        if (this.derampOnly) {
                            phase[yy][xx] = deramp;
                            continue;
                        }
                        double demod = Math.PI * -2 * this.subSwath[s].dopplerCentroid[burstIndex][x] * ta;
                        phase[yy][xx] = deramp + demod;
                    }
                }
            }
            return phase;
        }
        catch (Throwable e) {
            OperatorUtils.catchOperatorException((String)"computeDerampDemodPhase", (Throwable)e);
            return null;
        }
    }

    private void performDerampDemod(Tile srcTileI, Tile srcTileQ, Rectangle rectangle, double[][] derampDemodPhase, double[][] derampDemodI, double[][] derampDemodQ) {
        try {
            int x0 = rectangle.x;
            int y0 = rectangle.y;
            int xMax = x0 + rectangle.width;
            int yMax = y0 + rectangle.height;
            ProductData srcDataI = srcTileI.getDataBuffer();
            ProductData srcDataQ = srcTileQ.getDataBuffer();
            TileIndex srcIndex = new TileIndex(srcTileI);
            for (int y = y0; y < yMax; ++y) {
                srcIndex.calculateStride(y);
                int yy = y - y0;
                for (int x = x0; x < xMax; ++x) {
                    int idx = srcIndex.getIndex(x);
                    int xx = x - x0;
                    double valueI = srcDataI.getElemDoubleAt(idx);
                    double valueQ = srcDataQ.getElemDoubleAt(idx);
                    double cosPhase = FastMath.cos((double)derampDemodPhase[yy][xx]);
                    double sinPhase = FastMath.sin((double)derampDemodPhase[yy][xx]);
                    derampDemodI[yy][xx] = valueI * cosPhase - valueQ * sinPhase;
                    derampDemodQ[yy][xx] = valueI * sinPhase + valueQ * cosPhase;
                }
            }
        }
        catch (Throwable e) {
            OperatorUtils.catchOperatorException((String)"performDerampDemod", (Throwable)e);
        }
    }

    private void computeAzimuthSpectrum(int w, int h, double[][] derampDemodI, double[][] derampDemodQ, Map<Band, Tile> targetTileMap) {
        try {
            Band targetBand = this.targetProduct.getBand("azSpec");
            Tile targetTile = targetTileMap.get(targetBand);
            float[] tgtArray = (float[])targetTile.getDataBuffer().getElems();
            double[] col = new double[2 * h];
            DoubleFFT_1D col_fft = new DoubleFFT_1D(h);
            int h2 = h * h;
            for (int c = 0; c < w; ++c) {
                int r;
                for (r = 0; r < h; ++r) {
                    col[2 * r] = derampDemodI[r][c];
                    col[2 * r + 1] = derampDemodQ[r][c];
                }
                col_fft.complexForward(col);
                for (r = 0; r < h; ++r) {
                    tgtArray[r * w + c] = (float)(col[2 * r] * col[2 * r] + col[2 * r + 1] * col[2 * r + 1]) / (float)h2;
                }
            }
        }
        catch (Throwable e) {
            OperatorUtils.catchOperatorException((String)"computeAzimuthSpectrum", (Throwable)e);
        }
    }

    private Band getBand(Product product, String prefix, String swathIndexStr, String polarization) {
        String[] bandNames;
        for (String bandName : bandNames = product.getBandNames()) {
            if (!bandName.contains(prefix) || !bandName.contains(swathIndexStr) || !bandName.contains(polarization)) continue;
            return product.getBand(bandName);
        }
        return null;
    }

    public static class Spi
    extends OperatorSpi {
        public Spi() {
            super(DerampedAzimuthSpectrumOp.class);
        }
    }
}

