/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s1tbx.sentinel1.gpf.experimental;

import com.bc.ceres.core.ProgressMonitor;
import java.awt.Rectangle;
import java.util.Map;
import org.apache.commons.math3.util.FastMath;
import org.esa.s1tbx.insar.gpf.support.Sentinel1Utils;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.gpf.Operator;
import org.esa.snap.core.gpf.OperatorException;
import org.esa.snap.core.gpf.OperatorSpi;
import org.esa.snap.core.gpf.Tile;
import org.esa.snap.core.gpf.annotations.OperatorMetadata;
import org.esa.snap.core.gpf.annotations.SourceProduct;
import org.esa.snap.core.gpf.annotations.TargetProduct;
import org.esa.snap.engine_utilities.gpf.InputProductValidator;
import org.esa.snap.engine_utilities.gpf.OperatorUtils;
import org.esa.snap.engine_utilities.gpf.TileIndex;

@OperatorMetadata(alias="Deramp-Demod-Phase", category="Radar/Coregistration/S-1 TOPS Coregistration", authors="Jun Lu, Luis Veci", version="1.0", copyright="Copyright (C) 2014 by Array Systems Computing Inc.", description="Compute Deramp and Demodulation Phases", internal=true)
public final class DerampDemodPhaseOp
extends Operator {
    @SourceProduct(alias="source")
    private Product sourceProduct;
    @TargetProduct
    private Product targetProduct;
    private Sentinel1Utils su = null;
    private Sentinel1Utils.SubSwathInfo[] subSwath = null;
    private int subSwathIndex = 0;
    private int sourceImageWidth = 0;
    private int sourceImageHeight = 0;

    public float[] computeDopplerRate(int burstIndex) throws Exception {
        float[] kt = new float[this.sourceImageWidth];
        for (int x = 0; x < this.sourceImageWidth; ++x) {
            kt[x] = (float)this.subSwath[0].dopplerRate[burstIndex][x];
        }
        return kt;
    }

    public float[] computeDopplerCentroid(int burstIndex) throws Exception {
        float[] fdc = new float[this.sourceImageWidth];
        for (int x = 0; x < this.sourceImageWidth; ++x) {
            fdc[x] = (float)this.subSwath[0].dopplerCentroid[burstIndex][x];
        }
        return fdc;
    }

    public float[] computeSlantRange() throws Exception {
        float[] slr = new float[this.sourceImageWidth];
        for (int x = 0; x < this.sourceImageWidth; ++x) {
            slr[x] = (float)(this.subSwath[0].slrTimeToFirstPixel * 2.99792458E8 + (double)x * this.subSwath[this.subSwathIndex - 1].rangePixelSpacing);
        }
        return slr;
    }

    public float[] computeReferenceTime(int burstIndex) throws Exception {
        float[] tref = new float[this.sourceImageWidth];
        for (int x = 0; x < this.sourceImageWidth; ++x) {
            tref[x] = (float)this.subSwath[0].referenceTime[burstIndex][x];
        }
        return tref;
    }

    public void initialize() throws OperatorException {
        try {
            InputProductValidator validator = new InputProductValidator(this.sourceProduct);
            validator.checkIfSARProduct();
            validator.checkIfSentinel1Product();
            validator.checkIfSLC();
            this.su = new Sentinel1Utils(this.sourceProduct);
            this.su.computeDopplerRate();
            this.su.computeReferenceTime();
            this.subSwath = this.su.getSubSwath();
            String[] subSwathNames = this.su.getSubSwathNames();
            if (subSwathNames.length != 1) {
                throw new OperatorException("Split product is expected.");
            }
            this.subSwathIndex = 1;
            String[] polarizations = this.su.getPolarizations();
            if (polarizations.length != 1) {
                throw new OperatorException("Split product with one polarization is expected.");
            }
            this.createTargetProduct();
        }
        catch (Throwable e) {
            throw new OperatorException(e.getMessage());
        }
    }

    private void createTargetProduct() {
        this.sourceImageWidth = this.sourceProduct.getSceneRasterWidth();
        this.sourceImageHeight = this.sourceProduct.getSceneRasterHeight();
        this.targetProduct = new Product(this.sourceProduct.getName(), this.sourceProduct.getProductType(), this.sourceImageWidth, this.sourceImageHeight);
        Band derampPhaseBand = new Band("derampPhase", 30, this.sourceImageWidth, this.sourceImageHeight);
        derampPhaseBand.setUnit("radian");
        this.targetProduct.addBand(derampPhaseBand);
        Band demodPhaseBand = new Band("demodPhase", 30, this.sourceImageWidth, this.sourceImageHeight);
        demodPhaseBand.setUnit("radian");
        this.targetProduct.addBand(demodPhaseBand);
    }

    public void computeTileStack(Map<Band, Tile> targetTileMap, Rectangle targetRectangle, ProgressMonitor pm) throws OperatorException {
        try {
            int tx0 = targetRectangle.x;
            int ty0 = targetRectangle.y;
            int tw = targetRectangle.width;
            int th = targetRectangle.height;
            int tyMax = ty0 + th;
            for (int burstIndex = 0; burstIndex < this.subSwath[this.subSwathIndex - 1].numOfBursts; ++burstIndex) {
                int firstLineIdx = burstIndex * this.subSwath[this.subSwathIndex - 1].linesPerBurst;
                int lastLineIdx = firstLineIdx + this.subSwath[this.subSwathIndex - 1].linesPerBurst - 1;
                if (tyMax <= firstLineIdx || ty0 > lastLineIdx) continue;
                int ntx0 = tx0;
                int ntw = tw;
                int nty0 = Math.max(ty0, firstLineIdx);
                int ntyMax = Math.min(tyMax, lastLineIdx + 1);
                int nth = ntyMax - nty0;
                System.out.println("burstIndex = " + burstIndex + ": ntx0 = " + ntx0 + ", nty0 = " + nty0 + ", ntw = " + ntw + ", nth = " + nth);
                this.computeDerampDemodPhase(this.subSwathIndex, burstIndex, ntx0, nty0, ntw, nth, targetTileMap, pm);
            }
        }
        catch (Throwable e) {
            throw new OperatorException(e.getMessage());
        }
    }

    private void computeDerampDemodPhase(int subSwathIndex, int burstIndex, int x0, int y0, int w, int h, Map<Band, Tile> targetTileMap, ProgressMonitor pm) throws Exception {
        try {
            int xMax = x0 + w;
            int yMax = y0 + h;
            int s = subSwathIndex - 1;
            Band derampPhaseBand = this.targetProduct.getBand("derampPhase");
            Band demodPhaseBand = this.targetProduct.getBand("demodPhase");
            Tile tgtTileDerampPhase = targetTileMap.get(derampPhaseBand);
            Tile tgtTileDemodPhase = targetTileMap.get(demodPhaseBand);
            ProductData tgtBufferDerampPhase = tgtTileDerampPhase.getDataBuffer();
            ProductData tgtBufferDemodPhase = tgtTileDemodPhase.getDataBuffer();
            TileIndex tgtIndex = new TileIndex(tgtTileDerampPhase);
            int firstLineInBurst = burstIndex * this.subSwath[s].linesPerBurst;
            for (int y = y0; y < yMax; ++y) {
                tgtIndex.calculateStride(y);
                double ta = (double)(y - firstLineInBurst) * this.subSwath[s].azimuthTimeInterval;
                for (int x = x0; x < xMax; ++x) {
                    int idx = tgtIndex.getIndex(x);
                    double kt = this.subSwath[s].dopplerRate[burstIndex][x];
                    double deramp = -Math.PI * kt * FastMath.pow((double)(ta - this.subSwath[s].referenceTime[burstIndex][x]), (int)2);
                    double demod = Math.PI * -2 * this.subSwath[s].dopplerCentroid[burstIndex][x] * ta;
                    tgtBufferDerampPhase.setElemFloatAt(idx, (float)deramp);
                    tgtBufferDemodPhase.setElemFloatAt(idx, (float)demod);
                }
            }
        }
        catch (Throwable e) {
            OperatorUtils.catchOperatorException((String)"computeDerampDemodPhase", (Throwable)e);
        }
    }

    public static class Spi
    extends OperatorSpi {
        public Spi() {
            super(DerampDemodPhaseOp.class);
        }
    }
}

