/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s1tbx.sentinel1.gpf;

import com.bc.ceres.core.ProgressMonitor;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.awt.Rectangle;
import java.util.Arrays;
import java.util.Map;
import org.esa.s1tbx.insar.gpf.support.Sentinel1Utils;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.GeoCoding;
import org.esa.snap.core.datamodel.MetadataElement;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.datamodel.TiePointGeoCoding;
import org.esa.snap.core.datamodel.TiePointGrid;
import org.esa.snap.core.datamodel.VirtualBand;
import org.esa.snap.core.gpf.Operator;
import org.esa.snap.core.gpf.OperatorException;
import org.esa.snap.core.gpf.OperatorSpi;
import org.esa.snap.core.gpf.Tile;
import org.esa.snap.core.gpf.annotations.OperatorMetadata;
import org.esa.snap.core.gpf.annotations.Parameter;
import org.esa.snap.core.gpf.annotations.SourceProducts;
import org.esa.snap.core.gpf.annotations.TargetProduct;
import org.esa.snap.core.util.ProductUtils;
import org.esa.snap.engine_utilities.datamodel.AbstractMetadata;
import org.esa.snap.engine_utilities.datamodel.Unit;
import org.esa.snap.engine_utilities.gpf.InputProductValidator;
import org.esa.snap.engine_utilities.gpf.OperatorUtils;
import org.esa.snap.engine_utilities.gpf.ReaderUtils;
import org.esa.snap.engine_utilities.gpf.TileIndex;
import org.esa.snap.engine_utilities.util.Maths;

@OperatorMetadata(alias="TOPSAR-Merge", category="Radar/Sentinel-1 TOPS", authors="Jun Lu, Luis Veci", version="1.0", copyright="Copyright (C) 2014 by Array Systems Computing Inc.", description="Merge subswaths of a Sentinel-1 TOPSAR product")
public final class TOPSARMergeOp
extends Operator {
    @SourceProducts
    private Product[] sourceProduct;
    @TargetProduct
    private Product targetProduct;
    @Parameter(description="The list of polarisations", label="Polarisations")
    private String[] selectedPolarisations;
    private String acquisitionMode = null;
    private String productType = null;
    private int numOfSubSwath = 0;
    private int refSubSwathIndex = 0;
    private int targetWidth = 0;
    private int targetHeight = 0;
    private double targetFirstLineTime = 0.0;
    private double targetLastLineTime = 0.0;
    private double targetLineTimeInterval = 0.0;
    private double targetSlantRangeTimeToFirstPixel = 0.0;
    private double targetSlantRangeTimeToLastPixel = 0.0;
    private double targetDeltaSlantRangeTime = 0.0;
    private Sentinel1Utils[] su = null;
    private Sentinel1Utils.SubSwathInfo[] subSwath = null;
    private final BiMap<Integer, Integer> sourceProductIndexToSubSwathIndexMap = HashBiMap.create();
    private static final String PRODUCT_SUFFIX = "_mrg";

    public void initialize() throws OperatorException {
        try {
            if (this.sourceProduct == null) {
                return;
            }
            this.checkSourceProductValidity();
            this.getSubSwathParameters();
            this.computeTargetStartEndTime();
            this.computeTargetSlantRangeTimeToFirstAndLastPixels();
            this.computeTargetWidthAndHeight();
            this.createTargetProduct();
            this.updateTargetProductMetadata();
        }
        catch (Throwable e) {
            OperatorUtils.catchOperatorException((String)this.getId(), (Throwable)e);
        }
    }

    private void checkSourceProductValidity() {
        if (this.sourceProduct.length < 2) {
            throw new OperatorException("Please select split sub-swaths of the same Sentinel-1 products");
        }
        InputProductValidator validator = new InputProductValidator(this.sourceProduct[0]);
        validator.checkIfSARProduct();
        validator.checkIfSentinel1Product();
        validator.isTOPSARProduct();
        validator.checkIfTOPSARBurstProduct(false);
        validator.checkIfMapProjected(false);
        MetadataElement absRoot0 = AbstractMetadata.getAbstractedMetadata((Product)this.sourceProduct[0]);
        this.numOfSubSwath = this.sourceProduct.length;
        int numOfBands0 = this.sourceProduct[0].getNumBands();
        int[] subSwathIndexArray = new int[this.numOfSubSwath];
        String product0 = absRoot0.getAttributeString("PRODUCT");
        this.acquisitionMode = absRoot0.getAttributeString("ACQUISITION_MODE");
        this.productType = absRoot0.getAttributeString("PRODUCT_TYPE");
        String subSwathName0 = absRoot0.getAttributeString("swath");
        if (subSwathName0.equals("")) {
            throw new OperatorException("Cannot get \"swath\" information from source product abstracted metadata");
        }
        subSwathIndexArray[0] = this.getSubSwathIndex(subSwathName0);
        this.sourceProductIndexToSubSwathIndexMap.put((Object)0, (Object)subSwathIndexArray[0]);
        for (int p = 1; p < this.numOfSubSwath; ++p) {
            MetadataElement absRoot = AbstractMetadata.getAbstractedMetadata((Product)this.sourceProduct[p]);
            String product = absRoot.getAttributeString("PRODUCT");
            if (!product.equals(product0)) {
                throw new OperatorException("Source products are not from the same Sentinel-1 product");
            }
            String acMode = absRoot.getAttributeString("ACQUISITION_MODE");
            if (!acMode.equals(this.acquisitionMode)) {
                throw new OperatorException("Source products do not have the same acquisition mode");
            }
            int numOfBands = this.sourceProduct[p].getNumBands();
            if (numOfBands != numOfBands0) {
                throw new OperatorException("Source products do not have the same number of bands");
            }
            String subSwathName = absRoot.getAttributeString("swath");
            if (subSwathName.equals("")) {
                throw new OperatorException("Cannot get \"swath\" information from source product abstracted metadata");
            }
            subSwathIndexArray[p] = this.getSubSwathIndex(subSwathName);
            this.sourceProductIndexToSubSwathIndexMap.put((Object)p, (Object)subSwathIndexArray[p]);
        }
        Arrays.sort(subSwathIndexArray);
        this.refSubSwathIndex = subSwathIndexArray[0];
        for (int s = 0; s < this.numOfSubSwath - 1; ++s) {
            if (subSwathIndexArray[s + 1] - subSwathIndexArray[s] == 1) continue;
            throw new OperatorException("Isolate sub-swath detected in source products");
        }
    }

    private int getSubSwathIndex(String subswath) {
        String idxStr = subswath.substring(2);
        return Integer.parseInt(idxStr);
    }

    private void getSubSwathParameters() {
        try {
            this.su = new Sentinel1Utils[this.numOfSubSwath];
            this.subSwath = new Sentinel1Utils.SubSwathInfo[this.numOfSubSwath];
            for (int p = 0; p < this.numOfSubSwath; ++p) {
                int s = (Integer)this.sourceProductIndexToSubSwathIndexMap.get((Object)p) - this.refSubSwathIndex;
                this.su[s] = new Sentinel1Utils(this.sourceProduct[p]);
                this.subSwath[s] = this.su[s].getSubSwath()[0];
                if (this.selectedPolarisations == null || this.selectedPolarisations.length == 0) {
                    this.selectedPolarisations = this.su[s].getPolarizations();
                }
                MetadataElement absRoot = AbstractMetadata.getAbstractedMetadata((Product)this.sourceProduct[p]);
                this.subSwath[s].firstValidPixel = AbstractMetadata.getAttributeInt((MetadataElement)absRoot, (String)"firstValidPixel");
                this.subSwath[s].lastValidPixel = AbstractMetadata.getAttributeInt((MetadataElement)absRoot, (String)"lastValidPixel");
                this.subSwath[s].slrTimeToFirstValidPixel = AbstractMetadata.getAttributeDouble((MetadataElement)absRoot, (String)"slrTimeToFirstValidPixel");
                this.subSwath[s].slrTimeToLastValidPixel = AbstractMetadata.getAttributeDouble((MetadataElement)absRoot, (String)"slrTimeToLastValidPixel");
                this.subSwath[s].firstValidLineTime = AbstractMetadata.getAttributeDouble((MetadataElement)absRoot, (String)"firstValidLineTime");
                this.subSwath[s].lastValidLineTime = AbstractMetadata.getAttributeDouble((MetadataElement)absRoot, (String)"lastValidLineTime");
            }
        }
        catch (Throwable e) {
            throw new OperatorException(e.getMessage());
        }
    }

    private void computeTargetStartEndTime() {
        this.targetFirstLineTime = this.subSwath[0].firstLineTime;
        this.targetLastLineTime = this.subSwath[0].lastLineTime;
        for (int i = 1; i < this.numOfSubSwath; ++i) {
            if (this.targetFirstLineTime > this.subSwath[i].firstLineTime) {
                this.targetFirstLineTime = this.subSwath[i].firstLineTime;
            }
            if (!(this.targetLastLineTime < this.subSwath[i].lastLineTime)) continue;
            this.targetLastLineTime = this.subSwath[i].lastLineTime;
        }
        this.targetLineTimeInterval = this.subSwath[0].azimuthTimeInterval;
    }

    private void computeTargetSlantRangeTimeToFirstAndLastPixels() {
        this.targetSlantRangeTimeToFirstPixel = this.subSwath[0].slrTimeToFirstValidPixel;
        this.targetSlantRangeTimeToLastPixel = this.subSwath[this.numOfSubSwath - 1].slrTimeToLastValidPixel;
        this.targetDeltaSlantRangeTime = this.subSwath[0].rangePixelSpacing / 2.99792458E8;
    }

    private void computeTargetWidthAndHeight() {
        this.targetHeight = (int)((this.targetLastLineTime - this.targetFirstLineTime) / this.targetLineTimeInterval);
        this.targetWidth = (int)((this.targetSlantRangeTimeToLastPixel - this.targetSlantRangeTimeToFirstPixel) / this.targetDeltaSlantRangeTime);
    }

    private void createTargetProduct() {
        int prodIdx = (Integer)this.sourceProductIndexToSubSwathIndexMap.inverse().get((Object)this.refSubSwathIndex);
        this.targetProduct = new Product(this.sourceProduct[prodIdx].getName() + PRODUCT_SUFFIX, this.productType, this.targetWidth, this.targetHeight);
        Band[] sourceBands = this.sourceProduct[prodIdx].getBands();
        boolean hasVirtualPhaseBand = false;
        for (Band srcBand : sourceBands) {
            String srcBandName = srcBand.getName();
            if (!this.containSelectedPolarisations(srcBandName)) continue;
            if (srcBand instanceof VirtualBand) {
                if (!srcBandName.toLowerCase().contains("phase")) continue;
                hasVirtualPhaseBand = true;
                continue;
            }
            String tgtBandName = this.getTargetBandNameFromSourceBandName(srcBandName);
            if (this.targetProduct.containsBand(tgtBandName)) continue;
            Band trgBand = this.targetProduct.addBand(tgtBandName, srcBand.getDataType());
            trgBand.setUnit(srcBand.getUnit());
            trgBand.setNoDataValueUsed(true);
            trgBand.setNoDataValue(srcBand.getNoDataValue());
        }
        Band[] targetBands = this.targetProduct.getBands();
        for (int i = 0; i < targetBands.length; ++i) {
            Unit.UnitType qBandUnit;
            Unit.UnitType iBandUnit = Unit.getUnitType((Band)targetBands[i]);
            if (iBandUnit != Unit.UnitType.REAL || i + 1 >= targetBands.length || (qBandUnit = Unit.getUnitType((Band)targetBands[i + 1])) != Unit.UnitType.IMAGINARY) continue;
            ReaderUtils.createVirtualIntensityBand((Product)this.targetProduct, (Band)targetBands[i], (Band)targetBands[i + 1], (String)('_' + TOPSARMergeOp.getPrefix(targetBands[i].getName())));
            if (hasVirtualPhaseBand) {
                ReaderUtils.createVirtualPhaseBand((Product)this.targetProduct, (Band)targetBands[i], (Band)targetBands[i + 1], (String)('_' + TOPSARMergeOp.getPrefix(targetBands[i].getName())));
            }
            ++i;
        }
        ProductUtils.copyMetadata((Product)this.sourceProduct[prodIdx], (Product)this.targetProduct);
        ProductUtils.copyFlagCodings((Product)this.sourceProduct[prodIdx], (Product)this.targetProduct);
        this.targetProduct.setStartTime(new ProductData.UTC(this.targetFirstLineTime / 86400.0));
        this.targetProduct.setEndTime(new ProductData.UTC(this.targetLastLineTime / 86400.0));
        this.targetProduct.setDescription(this.sourceProduct[prodIdx].getDescription());
        this.createTiePointGrids();
    }

    private String getTargetBandNameFromSourceBandName(String srcBandName) {
        if (!srcBandName.contains(this.acquisitionMode)) {
            return srcBandName;
        }
        int firstSeparationIdx = srcBandName.indexOf(this.acquisitionMode);
        int secondSeparationIdx = srcBandName.indexOf("_", firstSeparationIdx + 1);
        return srcBandName.substring(0, firstSeparationIdx) + srcBandName.substring(secondSeparationIdx + 1);
    }

    private void createTiePointGrids() {
        int gridWidth = 20;
        int gridHeight = 5;
        int subSamplingX = this.targetWidth / 20;
        int subSamplingY = this.targetHeight / 5;
        float[] latList = new float[100];
        float[] lonList = new float[100];
        float[] slrtList = new float[100];
        float[] incList = new float[100];
        int k = 0;
        for (int i = 0; i < 5; ++i) {
            int y = i * subSamplingY;
            double azTime = this.targetFirstLineTime + (double)y * this.targetLineTimeInterval;
            for (int j = 0; j < 20; ++j) {
                int x = j * subSamplingX;
                double slrTime = this.targetSlantRangeTimeToFirstPixel + (double)x * this.targetDeltaSlantRangeTime;
                int s = this.getSubSwathIndex(slrTime);
                latList[k] = (float)this.su[s].getLatitude(azTime, slrTime);
                lonList[k] = (float)this.su[s].getLongitude(azTime, slrTime);
                slrtList[k] = (float)(this.su[s].getSlantRangeTime(azTime, slrTime) * 2.0 * 1.0E9);
                incList[k] = (float)this.su[s].getIncidenceAngle(azTime, slrTime);
                ++k;
            }
        }
        TiePointGrid latGrid = new TiePointGrid("latitude", 20, 5, 0.0, 0.0, (double)subSamplingX, (double)subSamplingY, latList);
        TiePointGrid lonGrid = new TiePointGrid("longitude", 20, 5, 0.0, 0.0, (double)subSamplingX, (double)subSamplingY, lonList);
        TiePointGrid slrtGrid = new TiePointGrid("slant_range_time", 20, 5, 0.0, 0.0, (double)subSamplingX, (double)subSamplingY, slrtList);
        TiePointGrid incGrid = new TiePointGrid("incident_angle", 20, 5, 0.0, 0.0, (double)subSamplingX, (double)subSamplingY, incList);
        latGrid.setUnit("deg");
        lonGrid.setUnit("deg");
        slrtGrid.setUnit("ns");
        incGrid.setUnit("deg");
        this.targetProduct.addTiePointGrid(latGrid);
        this.targetProduct.addTiePointGrid(lonGrid);
        this.targetProduct.addTiePointGrid(slrtGrid);
        this.targetProduct.addTiePointGrid(incGrid);
        TiePointGeoCoding tpGeoCoding = new TiePointGeoCoding(latGrid, lonGrid);
        this.targetProduct.setSceneGeoCoding((GeoCoding)tpGeoCoding);
    }

    private int getSubSwathIndex(double slrTime) {
        for (int i = 0; i < this.numOfSubSwath; ++i) {
            double startTime = i == 0 ? this.subSwath[i].slrTimeToFirstValidPixel : 0.5 * (this.subSwath[i].slrTimeToFirstValidPixel + this.subSwath[i - 1].slrTimeToLastPixel);
            double endTime = i == this.numOfSubSwath - 1 ? this.subSwath[i].slrTimeToLastPixel : 0.5 * (this.subSwath[i].slrTimeToLastPixel + this.subSwath[i + 1].slrTimeToFirstValidPixel);
            if (!(slrTime >= startTime) || !(slrTime < endTime)) continue;
            return i;
        }
        return 0;
    }

    private Band getSourceBandFromTargetBandName(String tgtBandName, String acquisitionMode, String swathIndexStr) {
        for (int s = 0; s < this.numOfSubSwath; ++s) {
            String[] srcBandNames;
            for (String srcBandName : srcBandNames = this.sourceProduct[s].getBandNames()) {
                if (!srcBandName.contains(acquisitionMode + swathIndexStr) || !this.getTargetBandNameFromSourceBandName(srcBandName).equals(tgtBandName)) continue;
                return this.sourceProduct[s].getBand(srcBandName);
            }
        }
        return null;
    }

    private static String getPrefix(String tgtBandName) {
        int firstSeparationIdx = tgtBandName.indexOf("_");
        return tgtBandName.substring(firstSeparationIdx + 1);
    }

    private boolean containSelectedPolarisations(String bandName) {
        for (String pol : this.selectedPolarisations) {
            if (!bandName.contains(pol)) continue;
            return true;
        }
        return false;
    }

    private void updateTargetProductMetadata() {
        this.updateAbstractMetadata();
        this.updateOriginalMetadata();
    }

    private void updateAbstractMetadata() {
        MetadataElement absTgt = AbstractMetadata.getAbstractedMetadata((Product)this.targetProduct);
        AbstractMetadata.setAttribute((MetadataElement)absTgt, (String)"num_output_lines", (int)this.targetHeight);
        AbstractMetadata.setAttribute((MetadataElement)absTgt, (String)"num_samples_per_line", (int)this.targetWidth);
        absTgt.setAttributeUTC("first_line_time", new ProductData.UTC(this.targetFirstLineTime / 86400.0));
        absTgt.setAttributeUTC("last_line_time", new ProductData.UTC(this.targetLastLineTime / 86400.0));
        absTgt.setAttributeDouble("line_time_interval", this.targetLineTimeInterval);
        absTgt.setAttributeDouble("slant_range_to_first_pixel", this.targetSlantRangeTimeToFirstPixel * 2.99792458E8);
        TiePointGrid latGrid = this.targetProduct.getTiePointGrid("latitude");
        TiePointGrid lonGrid = this.targetProduct.getTiePointGrid("longitude");
        AbstractMetadata.setAttribute((MetadataElement)absTgt, (String)"first_near_lat", (double)latGrid.getPixelFloat(0, 0));
        AbstractMetadata.setAttribute((MetadataElement)absTgt, (String)"first_near_long", (double)lonGrid.getPixelFloat(0, 0));
        AbstractMetadata.setAttribute((MetadataElement)absTgt, (String)"first_far_lat", (double)latGrid.getPixelFloat(this.targetWidth, 0));
        AbstractMetadata.setAttribute((MetadataElement)absTgt, (String)"first_far_long", (double)lonGrid.getPixelFloat(this.targetWidth, 0));
        AbstractMetadata.setAttribute((MetadataElement)absTgt, (String)"last_near_lat", (double)latGrid.getPixelFloat(0, this.targetHeight));
        AbstractMetadata.setAttribute((MetadataElement)absTgt, (String)"last_near_long", (double)lonGrid.getPixelFloat(0, this.targetHeight));
        AbstractMetadata.setAttribute((MetadataElement)absTgt, (String)"last_far_lat", (double)latGrid.getPixelFloat(this.targetWidth, this.targetHeight));
        AbstractMetadata.setAttribute((MetadataElement)absTgt, (String)"last_far_long", (double)lonGrid.getPixelFloat(this.targetWidth, this.targetHeight));
        double incidenceNear = OperatorUtils.getIncidenceAngle((Product)this.targetProduct).getPixelDouble(0, this.targetProduct.getSceneRasterHeight() / 2);
        AbstractMetadata.setAttribute((MetadataElement)absTgt, (String)"incidence_near", (double)incidenceNear);
        double incidenceFar = OperatorUtils.getIncidenceAngle((Product)this.targetProduct).getPixelDouble(this.targetProduct.getSceneRasterWidth() - 1, this.targetProduct.getSceneRasterHeight() / 2);
        AbstractMetadata.setAttribute((MetadataElement)absTgt, (String)"incidence_far", (double)incidenceFar);
        absTgt.removeAttribute(absTgt.getAttribute("firstValidPixel"));
        absTgt.removeAttribute(absTgt.getAttribute("lastValidPixel"));
        absTgt.removeAttribute(absTgt.getAttribute("slrTimeToFirstValidPixel"));
        absTgt.removeAttribute(absTgt.getAttribute("slrTimeToLastValidPixel"));
        absTgt.removeAttribute(absTgt.getAttribute("firstValidLineTime"));
        absTgt.removeAttribute(absTgt.getAttribute("lastValidLineTime"));
        absTgt.removeElement(absTgt.getElement("BurstBoundary"));
        MetadataElement burstBoundaryTgt = new MetadataElement("BurstBoundary");
        for (int p = 0; p < this.numOfSubSwath; ++p) {
            MetadataElement element;
            MetadataElement absRoot = AbstractMetadata.getAbstractedMetadata((Product)this.sourceProduct[p]);
            MetadataElement burstBoundarySrc = absRoot.getElement("BurstBoundary");
            if (burstBoundarySrc == null || burstBoundarySrc.getNumElements() <= 0 || (element = burstBoundarySrc.getElementAt(0)) == null) continue;
            burstBoundaryTgt.addElement(element.createDeepClone());
        }
        absTgt.addElement(burstBoundaryTgt);
        absTgt.removeElement(absTgt.getElement("ESD_Measurement"));
        MetadataElement ESDMeasurementTgt = new MetadataElement("ESD_Measurement");
        for (int p = 0; p < this.numOfSubSwath; ++p) {
            MetadataElement element;
            MetadataElement absRoot = AbstractMetadata.getAbstractedMetadata((Product)this.sourceProduct[p]);
            MetadataElement ESDMeasurementSrc = absRoot.getElement("ESD_Measurement");
            if (ESDMeasurementSrc == null || (element = ESDMeasurementSrc.getElementAt(0)) == null) continue;
            ESDMeasurementTgt.addElement(element.createDeepClone());
        }
        absTgt.addElement(ESDMeasurementTgt);
    }

    private void updateOriginalMetadata() {
        if (this.numOfSubSwath > 1) {
            // empty if block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void computeTileStack(Map<Band, Tile> targetTiles, Rectangle targetRectangle, ProgressMonitor pm) throws OperatorException {
        try {
            Band[] tgtBands;
            int numOfSourceTiles;
            int i;
            int tx0 = targetRectangle.x;
            int ty0 = targetRectangle.y;
            int tw = targetRectangle.width;
            int th = targetRectangle.height;
            double tileSlrtToFirstPixel = this.targetSlantRangeTimeToFirstPixel + (double)tx0 * this.targetDeltaSlantRangeTime;
            double tileSlrtToLastPixel = this.targetSlantRangeTimeToFirstPixel + (double)(tx0 + tw - 1) * this.targetDeltaSlantRangeTime;
            double tileFirstLineTime = this.targetFirstLineTime + (double)ty0 * this.targetLineTimeInterval;
            double tileLastLineTime = this.targetFirstLineTime + (double)(ty0 + th - 1) * this.targetLineTimeInterval;
            int firstSubSwathIndex = -1;
            int lastSubSwathIndex = -1;
            for (i = 0; i < this.numOfSubSwath; ++i) {
                if (!(tileSlrtToFirstPixel >= this.subSwath[i].slrTimeToFirstValidPixel) || !(tileSlrtToFirstPixel <= this.subSwath[i].slrTimeToLastValidPixel) || !(tileFirstLineTime >= this.subSwath[i].firstValidLineTime && tileFirstLineTime < this.subSwath[i].lastValidLineTime) && (!(tileLastLineTime >= this.subSwath[i].firstValidLineTime) || !(tileLastLineTime < this.subSwath[i].lastValidLineTime))) continue;
                firstSubSwathIndex = i;
                break;
            }
            if (firstSubSwathIndex == this.numOfSubSwath) {
                lastSubSwathIndex = firstSubSwathIndex;
            } else {
                for (i = 0; i < this.numOfSubSwath; ++i) {
                    if (!(tileSlrtToLastPixel >= this.subSwath[i].slrTimeToFirstValidPixel) || !(tileSlrtToLastPixel <= this.subSwath[i].slrTimeToLastValidPixel) || !(tileFirstLineTime >= this.subSwath[i].firstValidLineTime && tileFirstLineTime < this.subSwath[i].lastValidLineTime) && (!(tileLastLineTime >= this.subSwath[i].firstValidLineTime) || !(tileLastLineTime < this.subSwath[i].lastValidLineTime))) continue;
                    lastSubSwathIndex = i;
                }
            }
            if (firstSubSwathIndex == -1 && lastSubSwathIndex == -1) {
                return;
            }
            if (firstSubSwathIndex != -1 && lastSubSwathIndex == -1) {
                lastSubSwathIndex = firstSubSwathIndex;
            }
            if (firstSubSwathIndex == -1 && lastSubSwathIndex != -1) {
                firstSubSwathIndex = lastSubSwathIndex;
            }
            boolean tileInOneSubSwath = (numOfSourceTiles = lastSubSwathIndex - firstSubSwathIndex + 1) == 1;
            Rectangle[] sourceRectangle = new Rectangle[numOfSourceTiles];
            int k = 0;
            for (int i2 = firstSubSwathIndex; i2 <= lastSubSwathIndex; ++i2) {
                sourceRectangle[k++] = this.getSourceRectangle(tx0, ty0, tw, th, i2);
            }
            int txMax = tx0 + tw;
            int tyMax = ty0 + th;
            for (Band tgtBand : tgtBands = this.targetProduct.getBands()) {
                if (tgtBand instanceof VirtualBand) continue;
                String tgtBandName = tgtBand.getName();
                int dataType = tgtBand.getDataType();
                Tile tgtTile = targetTiles.get(tgtBand);
                if (tileInOneSubSwath) {
                    if (dataType == 11) {
                        this.computeTileInOneSwathShort(tx0, ty0, txMax, tyMax, firstSubSwathIndex, sourceRectangle, tgtBandName, tgtTile);
                        continue;
                    }
                    this.computeTileInOneSwathFloat(tx0, ty0, txMax, tyMax, firstSubSwathIndex, sourceRectangle, tgtBandName, tgtTile);
                    continue;
                }
                if (dataType == 11) {
                    this.computeMultipleSubSwathsShort(tx0, ty0, txMax, tyMax, firstSubSwathIndex, lastSubSwathIndex, sourceRectangle, tgtBandName, tgtTile);
                    continue;
                }
                this.computeMultipleSubSwathsFloat(tx0, ty0, txMax, tyMax, firstSubSwathIndex, lastSubSwathIndex, sourceRectangle, tgtBandName, tgtTile);
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        finally {
            pm.done();
        }
    }

    private void computeTileInOneSwathShort(int tx0, int ty0, int txMax, int tyMax, int firstSubSwathIndex, Rectangle[] sourceRectangle, String tgtBandName, Tile tgtTile) {
        int yMin = this.computeYMin(this.subSwath[firstSubSwathIndex]);
        int yMax = this.computeYMax(this.subSwath[firstSubSwathIndex]);
        int xMin = this.computeXMin(this.subSwath[firstSubSwathIndex]);
        int xMax = this.computeXMax(this.subSwath[firstSubSwathIndex]);
        int firstY = Math.max(ty0, yMin);
        int lastY = Math.min(tyMax, yMax + 1);
        int firstX = Math.max(tx0, xMin);
        int lastX = Math.min(txMax, xMax + 1);
        if (firstY >= lastY || firstX >= lastX) {
            return;
        }
        String swathIndexStr = String.valueOf(this.getSubSwathIndex(this.subSwath[firstSubSwathIndex].subSwathName));
        Band srcBand = this.getSourceBandFromTargetBandName(tgtBandName, this.acquisitionMode, swathIndexStr);
        Tile srcRaster = this.getSourceTile((RasterDataNode)srcBand, sourceRectangle[0]);
        TileIndex srcTileIndex = new TileIndex(srcRaster);
        TileIndex tgtIndex = new TileIndex(tgtTile);
        short[] srcArray = (short[])srcRaster.getDataBuffer().getElems();
        short[] tgtArray = (short[])tgtTile.getDataBuffer().getElems();
        for (int y = firstY; y < lastY; ++y) {
            int sy0 = this.getLineIndexInSourceProduct(y, this.subSwath[firstSubSwathIndex]);
            int tgtOffset = tgtIndex.calculateStride(y);
            Sentinel1Utils.SubSwathInfo firstSubSwath = this.subSwath[firstSubSwathIndex];
            int offset = srcTileIndex.calculateStride(sy0);
            int sx0 = (int)Math.round((this.targetSlantRangeTimeToFirstPixel + (double)firstX * this.targetDeltaSlantRangeTime - firstSubSwath.slrTimeToFirstPixel) / this.targetDeltaSlantRangeTime);
            System.arraycopy(srcArray, sx0 - offset, tgtArray, firstX - tgtOffset, lastX - firstX);
        }
    }

    private void computeTileInOneSwathFloat(int tx0, int ty0, int txMax, int tyMax, int firstSubSwathIndex, Rectangle[] sourceRectangle, String tgtBandName, Tile tgtTile) {
        int yMin = this.computeYMin(this.subSwath[firstSubSwathIndex]);
        int yMax = this.computeYMax(this.subSwath[firstSubSwathIndex]);
        int xMin = this.computeXMin(this.subSwath[firstSubSwathIndex]);
        int xMax = this.computeXMax(this.subSwath[firstSubSwathIndex]);
        int firstY = Math.max(ty0, yMin);
        int lastY = Math.min(tyMax, yMax + 1);
        int firstX = Math.max(tx0, xMin);
        int lastX = Math.min(txMax, xMax + 1);
        if (firstY >= lastY || firstX >= lastX) {
            return;
        }
        String swathIndexStr = String.valueOf(this.getSubSwathIndex(this.subSwath[firstSubSwathIndex].subSwathName));
        Band srcBand = this.getSourceBandFromTargetBandName(tgtBandName, this.acquisitionMode, swathIndexStr);
        Tile srcRaster = this.getSourceTile((RasterDataNode)srcBand, sourceRectangle[0]);
        TileIndex srcTileIndex = new TileIndex(srcRaster);
        TileIndex tgtIndex = new TileIndex(tgtTile);
        float[] srcArray = (float[])srcRaster.getDataBuffer().getElems();
        float[] tgtArray = (float[])tgtTile.getDataBuffer().getElems();
        for (int y = firstY; y < lastY; ++y) {
            int sy0 = this.getLineIndexInSourceProduct(y, this.subSwath[firstSubSwathIndex]);
            int tgtOffset = tgtIndex.calculateStride(y);
            Sentinel1Utils.SubSwathInfo firstSubSwath = this.subSwath[firstSubSwathIndex];
            int offset = srcTileIndex.calculateStride(sy0);
            int sx0 = (int)Math.round((this.targetSlantRangeTimeToFirstPixel + (double)firstX * this.targetDeltaSlantRangeTime - firstSubSwath.slrTimeToFirstPixel) / this.targetDeltaSlantRangeTime);
            System.arraycopy(srcArray, sx0 - offset, tgtArray, firstX - tgtOffset, lastX - firstX);
        }
    }

    private void computeMultipleSubSwathsShort(int tx0, int ty0, int txMax, int tyMax, int firstSubSwathIndex, int lastSubSwathIndex, Rectangle[] sourceRectangle, String tgtBandName, Tile tgtTile) {
        int numOfSourceTiles = lastSubSwathIndex - firstSubSwathIndex + 1;
        TileIndex tgtIndex = new TileIndex(tgtTile);
        Tile[] srcTiles = new Tile[numOfSourceTiles];
        short[][] srcArray = new short[numOfSourceTiles][];
        short[] tgtArray = (short[])tgtTile.getDataBuffer().getElems();
        int k = 0;
        for (int i = firstSubSwathIndex; i <= lastSubSwathIndex; ++i) {
            Tile srcRaster;
            String swathIndexStr = String.valueOf(this.getSubSwathIndex(this.subSwath[i].subSwathName));
            Band srcBand = this.getSourceBandFromTargetBandName(tgtBandName, this.acquisitionMode, swathIndexStr);
            srcTiles[k] = srcRaster = this.getSourceTile((RasterDataNode)srcBand, sourceRectangle[k]);
            srcArray[k] = (short[])srcRaster.getDataBuffer().getElems();
            ++k;
        }
        for (int y = ty0; y < tyMax; ++y) {
            int tgtOffset = tgtIndex.calculateStride(y);
            for (int x = tx0; x < txMax; ++x) {
                int subSwathIndex = this.getSubSwathIndex(x, y, firstSubSwathIndex, lastSubSwathIndex);
                if (subSwathIndex == -1) continue;
                int sy = this.getLineIndexInSourceProduct(y, this.subSwath[subSwathIndex]);
                int sx = this.getSampleIndexInSourceProduct(x, this.subSwath[subSwathIndex]);
                short val = 0;
                k = subSwathIndex - firstSubSwathIndex;
                int idx = srcTiles[k].getDataBufferIndex(sx, sy);
                if (idx >= 0) {
                    val = srcArray[k][idx];
                }
                tgtArray[x - tgtOffset] = val;
            }
        }
    }

    private void computeMultipleSubSwathsFloat(int tx0, int ty0, int txMax, int tyMax, int firstSubSwathIndex, int lastSubSwathIndex, Rectangle[] sourceRectangle, String tgtBandName, Tile tgtTile) {
        int numOfSourceTiles = lastSubSwathIndex - firstSubSwathIndex + 1;
        TileIndex tgtIndex = new TileIndex(tgtTile);
        Tile[] srcTiles = new Tile[numOfSourceTiles];
        float[][] srcArray = new float[numOfSourceTiles][];
        float[] tgtArray = (float[])tgtTile.getDataBuffer().getElems();
        int k = 0;
        for (int i = firstSubSwathIndex; i <= lastSubSwathIndex; ++i) {
            Tile srcRaster;
            String swathIndexStr = String.valueOf(this.getSubSwathIndex(this.subSwath[i].subSwathName));
            Band srcBand = this.getSourceBandFromTargetBandName(tgtBandName, this.acquisitionMode, swathIndexStr);
            srcTiles[k] = srcRaster = this.getSourceTile((RasterDataNode)srcBand, sourceRectangle[k]);
            srcArray[k] = (float[])srcRaster.getDataBuffer().getElems();
            ++k;
        }
        for (int y = ty0; y < tyMax; ++y) {
            int tgtOffset = tgtIndex.calculateStride(y);
            for (int x = tx0; x < txMax; ++x) {
                int subSwathIndex = this.getSubSwathIndex(x, y, firstSubSwathIndex, lastSubSwathIndex);
                if (subSwathIndex == -1) continue;
                int sy = this.getLineIndexInSourceProduct(y, this.subSwath[subSwathIndex]);
                int sx = this.getSampleIndexInSourceProduct(x, this.subSwath[subSwathIndex]);
                float val = 0.0f;
                k = subSwathIndex - firstSubSwathIndex;
                int idx = srcTiles[k].getDataBufferIndex(sx, sy);
                if (idx >= 0) {
                    val = srcArray[k][idx];
                }
                tgtArray[x - tgtOffset] = val;
            }
        }
    }

    private Rectangle getSourceRectangle(int tx0, int ty0, int tw, int th, int subSwathIndex) {
        Sentinel1Utils.SubSwathInfo sw = this.subSwath[subSwathIndex];
        int x0 = this.getSampleIndexInSourceProduct(tx0, sw);
        int xMax = this.getSampleIndexInSourceProduct(tx0 + tw - 1, sw);
        int y0 = this.getLineIndexInSourceProduct(ty0, sw);
        int yMax = this.getLineIndexInSourceProduct(ty0 + th - 1, sw);
        int w = xMax - x0 + 1;
        int h = yMax - y0 + 1;
        return new Rectangle(x0, y0, w, h);
    }

    private int getSampleIndexInSourceProduct(int tx, Sentinel1Utils.SubSwathInfo subSwath) {
        int sx = (int)((this.targetSlantRangeTimeToFirstPixel + (double)tx * this.targetDeltaSlantRangeTime - subSwath.slrTimeToFirstPixel) / this.targetDeltaSlantRangeTime + 0.5);
        return sx < 0 ? 0 : (sx > subSwath.numOfSamples - 1 ? subSwath.numOfSamples - 1 : sx);
    }

    private int getLineIndexInSourceProduct(int ty, Sentinel1Utils.SubSwathInfo subSwath) {
        double targetLineTime = this.targetFirstLineTime + (double)ty * this.targetLineTimeInterval;
        int sy = (int)((targetLineTime - subSwath.firstLineTime) / subSwath.azimuthTimeInterval + 0.5);
        return sy < 0 ? 0 : (sy > subSwath.numOfLines - 1 ? subSwath.numOfLines - 1 : sy);
    }

    private int computeYMin(Sentinel1Utils.SubSwathInfo subSwath) {
        return (int)Math.round((subSwath.firstLineTime - this.targetFirstLineTime) / this.targetLineTimeInterval);
    }

    private int computeYMax(Sentinel1Utils.SubSwathInfo subSwath) {
        return (int)Math.round((subSwath.lastLineTime - this.targetFirstLineTime) / this.targetLineTimeInterval);
    }

    private int computeXMin(Sentinel1Utils.SubSwathInfo subSwath) {
        return (int)Math.round((subSwath.slrTimeToFirstValidPixel - this.targetSlantRangeTimeToFirstPixel) / this.targetDeltaSlantRangeTime);
    }

    private int computeXMax(Sentinel1Utils.SubSwathInfo subSwath) {
        return (int)Math.round((subSwath.slrTimeToLastValidPixel - this.targetSlantRangeTimeToFirstPixel) / this.targetDeltaSlantRangeTime);
    }

    private int getSubSwathIndex(int tx, int ty, int firstSubSwathIndex, int lastSubSwathIndex) {
        double middleTime;
        double targetSampleSlrTime = this.targetSlantRangeTimeToFirstPixel + (double)tx * this.targetDeltaSlantRangeTime;
        double targetLineTime = this.targetFirstLineTime + (double)ty * this.targetLineTimeInterval;
        int cnt = 0;
        int swath0 = -1;
        int swath1 = -1;
        for (int i = firstSubSwathIndex; i <= lastSubSwathIndex; ++i) {
            Sentinel1Utils.SubSwathInfo info = this.subSwath[i];
            if (!(targetLineTime >= info.firstValidLineTime) || !(targetLineTime <= info.lastValidLineTime) || !(targetSampleSlrTime >= info.slrTimeToFirstValidPixel) || !(targetSampleSlrTime <= info.slrTimeToLastValidPixel)) continue;
            if (cnt != 0) {
                swath1 = i;
                break;
            }
            swath0 = i;
            ++cnt;
        }
        if (swath1 != -1 && targetSampleSlrTime > (middleTime = (this.subSwath[swath0].slrTimeToLastValidPixel + this.subSwath[swath1].slrTimeToFirstValidPixel) / 2.0)) {
            return swath1;
        }
        return swath0;
    }

    private double getSubSwathNoise(int tx, double targetLineTime, Sentinel1Utils.SubSwathInfo sw, String pol) {
        Sentinel1Utils.NoiseVector[] vectorList = (Sentinel1Utils.NoiseVector[])sw.noise.get(pol);
        int sx = this.getSampleIndexInSourceProduct(tx, sw);
        int sy = (int)((targetLineTime - vectorList[0].timeMJD * 86400.0) / this.targetLineTimeInterval);
        int l0 = -1;
        int l1 = -1;
        int vectorIdx0 = -1;
        int vectorIdxInc = 0;
        if (sy < vectorList[0].line) {
            l1 = l0 = vectorList[0].line;
            vectorIdx0 = 0;
        } else if (sy >= vectorList[vectorList.length - 1].line) {
            l1 = l0 = vectorList[vectorList.length - 1].line;
            vectorIdx0 = vectorList.length - 1;
        } else {
            vectorIdxInc = 1;
            int max = vectorList.length - 1;
            for (int i = 0; i < max; ++i) {
                if (sy < vectorList[i].line || sy >= vectorList[i + 1].line) continue;
                l0 = vectorList[i].line;
                l1 = vectorList[i + 1].line;
                vectorIdx0 = i;
                break;
            }
        }
        int[] pixels = vectorList[vectorIdx0].pixels;
        int p0 = -1;
        int p1 = -1;
        int pixelIdx0 = -1;
        int pixelIdxInc = 0;
        if (sx < pixels[0]) {
            p1 = p0 = pixels[0];
            pixelIdx0 = 0;
        } else if (sx >= pixels[pixels.length - 1]) {
            p1 = p0 = pixels[pixels.length - 1];
            pixelIdx0 = pixels.length - 1;
        } else {
            pixelIdxInc = 1;
            int max = pixels.length - 1;
            for (int i = 0; i < max; ++i) {
                if (sx < pixels[i] || sx >= pixels[i + 1]) continue;
                p0 = pixels[i];
                p1 = pixels[i + 1];
                pixelIdx0 = i;
                break;
            }
        }
        float[] noiseLUT0 = vectorList[vectorIdx0].noiseLUT;
        float[] noiseLUT1 = vectorList[vectorIdx0 + vectorIdxInc].noiseLUT;
        double dx = p0 == p1 ? 0.0 : (double)((sx - p0) / (p1 - p0));
        double dy = l0 == l1 ? 0.0 : (double)((sy - l0) / (l1 - l0));
        return Maths.interpolationBiLinear((double)noiseLUT0[pixelIdx0], (double)noiseLUT0[pixelIdx0 + pixelIdxInc], (double)noiseLUT1[pixelIdx0], (double)noiseLUT1[pixelIdx0 + pixelIdxInc], (double)dx, (double)dy);
    }

    public static class Spi
    extends OperatorSpi {
        public Spi() {
            super(TOPSARMergeOp.class);
        }
    }
}

