/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s1tbx.sentinel1.gpf;

import com.bc.ceres.core.ProgressMonitor;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Map;
import java.util.StringTokenizer;
import org.esa.s1tbx.insar.gpf.support.Sentinel1Utils;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.GeoCoding;
import org.esa.snap.core.datamodel.GeoPos;
import org.esa.snap.core.datamodel.MetadataAttribute;
import org.esa.snap.core.datamodel.MetadataElement;
import org.esa.snap.core.datamodel.PixelPos;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.datamodel.TiePointGeoCoding;
import org.esa.snap.core.datamodel.TiePointGrid;
import org.esa.snap.core.datamodel.VirtualBand;
import org.esa.snap.core.gpf.Operator;
import org.esa.snap.core.gpf.OperatorException;
import org.esa.snap.core.gpf.OperatorSpi;
import org.esa.snap.core.gpf.Tile;
import org.esa.snap.core.gpf.annotations.OperatorMetadata;
import org.esa.snap.core.gpf.annotations.Parameter;
import org.esa.snap.core.gpf.annotations.SourceProduct;
import org.esa.snap.core.gpf.annotations.TargetProduct;
import org.esa.snap.core.util.ProductUtils;
import org.esa.snap.engine_utilities.datamodel.AbstractMetadata;
import org.esa.snap.engine_utilities.gpf.InputProductValidator;
import org.esa.snap.engine_utilities.gpf.OperatorUtils;
import org.esa.snap.engine_utilities.gpf.ReaderUtils;
import org.esa.snap.engine_utilities.gpf.TileIndex;
import org.esa.snap.engine_utilities.util.Maths;

@OperatorMetadata(alias="TOPSAR-Deburst", category="Radar/Sentinel-1 TOPS", authors="Jun Lu, Luis Veci", version="1.0", copyright="Copyright (C) 2014 by Array Systems Computing Inc.", description="Debursts a Sentinel-1 TOPSAR product")
public final class TOPSARDeburstOp
extends Operator {
    @SourceProduct(alias="source")
    private Product sourceProduct;
    @TargetProduct
    private Product targetProduct;
    @Parameter(description="The list of polarisations", label="Polarisations")
    private String[] selectedPolarisations;
    private MetadataElement absRoot = null;
    private String acquisitionMode = null;
    private String productType = null;
    private int numOfSubSwath = 0;
    private int subSwathIndex = 0;
    private int targetWidth = 0;
    private int targetHeight = 0;
    private double targetFirstLineTime = 0.0;
    private double targetLastLineTime = 0.0;
    private double targetLineTimeInterval = 0.0;
    private double targetSlantRangeTimeToFirstPixel = 0.0;
    private double targetSlantRangeTimeToLastPixel = 0.0;
    private double targetDeltaSlantRangeTime = 0.0;
    private SubSwathEffectStartEndPixels[] subSwathEffectStartEndPixels = null;
    private Sentinel1Utils su = null;
    private Sentinel1Utils.SubSwathInfo[] subSwath = null;
    private static int numOfBoundaryPoints = 6;
    private static final String PRODUCT_SUFFIX = "_Deb";

    public void initialize() throws OperatorException {
        try {
            InputProductValidator validator = new InputProductValidator(this.sourceProduct);
            validator.checkIfSARProduct();
            validator.checkIfSentinel1Product();
            validator.checkProductType(new String[]{"SLC"});
            validator.checkAcquisitionMode(new String[]{"IW", "EW"});
            this.absRoot = AbstractMetadata.getAbstractedMetadata((Product)this.sourceProduct);
            this.getProductType();
            this.getAcquisitionMode();
            this.su = new Sentinel1Utils(this.sourceProduct);
            this.subSwath = this.su.getSubSwath();
            this.numOfSubSwath = this.su.getNumOfSubSwath();
            if (this.selectedPolarisations == null || this.selectedPolarisations.length == 0) {
                this.selectedPolarisations = this.su.getPolarizations();
            }
            this.computeTargetStartEndTime();
            this.computeTargetSlantRangeTimeToFirstAndLastPixels();
            this.computeTargetWidthAndHeight();
            this.createTargetProduct();
            this.computeSubSwathEffectStartEndPixels();
            this.updateTargetProductMetadata();
        }
        catch (Throwable e) {
            OperatorUtils.catchOperatorException((String)this.getId(), (Throwable)e);
        }
    }

    private void getProductType() {
        this.productType = this.absRoot.getAttributeString("PRODUCT_TYPE");
    }

    private void getAcquisitionMode() throws OperatorException {
        this.acquisitionMode = this.absRoot.getAttributeString("ACQUISITION_MODE");
    }

    private void computeTargetStartEndTime() {
        this.targetFirstLineTime = this.subSwath[0].firstLineTime;
        this.targetLastLineTime = this.subSwath[0].lastLineTime;
        for (int i = 1; i < this.numOfSubSwath; ++i) {
            if (this.targetFirstLineTime > this.subSwath[i].firstLineTime) {
                this.targetFirstLineTime = this.subSwath[i].firstLineTime;
            }
            if (!(this.targetLastLineTime < this.subSwath[i].lastLineTime)) continue;
            this.targetLastLineTime = this.subSwath[i].lastLineTime;
        }
        this.targetLineTimeInterval = this.subSwath[0].azimuthTimeInterval;
    }

    private void computeTargetSlantRangeTimeToFirstAndLastPixels() {
        this.targetSlantRangeTimeToFirstPixel = this.subSwath[0].slrTimeToFirstPixel;
        this.targetSlantRangeTimeToLastPixel = this.subSwath[this.numOfSubSwath - 1].slrTimeToLastPixel;
        this.targetDeltaSlantRangeTime = this.subSwath[0].rangePixelSpacing / 2.99792458E8;
    }

    private void computeTargetWidthAndHeight() {
        this.targetHeight = (int)((this.targetLastLineTime - this.targetFirstLineTime) / this.targetLineTimeInterval);
        this.targetWidth = (int)((this.targetSlantRangeTimeToLastPixel - this.targetSlantRangeTimeToFirstPixel) / this.targetDeltaSlantRangeTime);
    }

    private void computeSubSwathEffectStartEndPixels() {
        this.subSwathEffectStartEndPixels = new SubSwathEffectStartEndPixels[this.numOfSubSwath];
        for (int i = 0; i < this.numOfSubSwath; ++i) {
            double midTime;
            this.subSwathEffectStartEndPixels[i] = new SubSwathEffectStartEndPixels();
            if (i == 0) {
                this.subSwathEffectStartEndPixels[i].xMin = 0;
            } else {
                midTime = (this.subSwath[i - 1].slrTimeToLastValidPixel + this.subSwath[i].slrTimeToFirstValidPixel) / 2.0;
                this.subSwathEffectStartEndPixels[i].xMin = (int)Math.round((midTime - this.subSwath[i].slrTimeToFirstPixel) / this.targetDeltaSlantRangeTime);
            }
            if (i < this.numOfSubSwath - 1) {
                midTime = (this.subSwath[i].slrTimeToLastValidPixel + this.subSwath[i + 1].slrTimeToFirstValidPixel) / 2.0;
                this.subSwathEffectStartEndPixels[i].xMax = (int)Math.round((midTime - this.subSwath[i].slrTimeToFirstPixel) / this.targetDeltaSlantRangeTime);
                continue;
            }
            this.subSwathEffectStartEndPixels[i].xMax = (int)Math.round((this.subSwath[i].slrTimeToLastPixel - this.subSwath[i].slrTimeToFirstPixel) / this.targetDeltaSlantRangeTime);
        }
    }

    private void createTargetProduct() {
        this.targetProduct = new Product(this.sourceProduct.getName() + PRODUCT_SUFFIX, this.sourceProduct.getProductType(), this.targetWidth, this.targetHeight);
        Band[] sourceBands = this.sourceProduct.getBands();
        boolean hasVirtualPhaseBands = false;
        for (Band srcBand : sourceBands) {
            if (!(srcBand instanceof VirtualBand) || !srcBand.getName().toLowerCase().contains("phase")) continue;
            hasVirtualPhaseBands = true;
            break;
        }
        for (Band srcBand : sourceBands) {
            Band iBand;
            String tgtBandName;
            String srcBandName = srcBand.getName();
            if (!this.containSelectedPolarisations(srcBandName) || srcBand instanceof VirtualBand || this.targetProduct.containsBand(tgtBandName = this.getTargetBandNameFromSourceBandName(srcBandName))) continue;
            Band trgBand = this.targetProduct.addBand(tgtBandName, srcBand.getDataType());
            trgBand.setUnit(srcBand.getUnit());
            trgBand.setNoDataValueUsed(true);
            trgBand.setNoDataValue(srcBand.getNoDataValue());
            int i = this.targetProduct.getBandIndex(tgtBandName);
            if (!trgBand.getUnit().equals("imaginary") || i - 1 < 0 || !(iBand = this.targetProduct.getBandAt(i - 1)).getUnit().equals("real")) continue;
            ReaderUtils.createVirtualIntensityBand((Product)this.targetProduct, (Band)iBand, (Band)trgBand, (String)('_' + TOPSARDeburstOp.getPrefix(trgBand.getName())));
            if (!hasVirtualPhaseBands) continue;
            ReaderUtils.createVirtualPhaseBand((Product)this.targetProduct, (Band)iBand, (Band)trgBand, (String)('_' + TOPSARDeburstOp.getPrefix(trgBand.getName())));
        }
        ProductUtils.copyMetadata((Product)this.sourceProduct, (Product)this.targetProduct);
        ProductUtils.copyFlagCodings((Product)this.sourceProduct, (Product)this.targetProduct);
        ProductUtils.copyQuicklookBandName((Product)this.sourceProduct, (Product)this.targetProduct);
        this.targetProduct.setStartTime(new ProductData.UTC(this.targetFirstLineTime / 86400.0));
        this.targetProduct.setEndTime(new ProductData.UTC(this.targetLastLineTime / 86400.0));
        this.targetProduct.setDescription(this.sourceProduct.getDescription());
        this.createTiePointGrids();
        if (this.sourceProduct.getQuicklookBandName() != null && this.targetProduct.getBand(this.sourceProduct.getQuicklookBandName()) != null) {
            this.targetProduct.setQuicklookBandName(this.sourceProduct.getQuicklookBandName());
        }
    }

    private String getTargetBandNameFromSourceBandName(String srcBandName) {
        if (this.numOfSubSwath == 1) {
            return srcBandName;
        }
        int firstSeparationIdx = srcBandName.indexOf(this.acquisitionMode);
        int secondSeparationIdx = srcBandName.indexOf(95, firstSeparationIdx + 1);
        return srcBandName.substring(0, firstSeparationIdx) + srcBandName.substring(secondSeparationIdx + 1);
    }

    private String getSourceBandNameFromTargetBandName(String tgtBandName, String acquisitionMode, String swathIndexStr) {
        String[] srcBandNames;
        if (this.numOfSubSwath == 1) {
            return tgtBandName;
        }
        for (String srcBandName : srcBandNames = this.sourceProduct.getBandNames()) {
            if (!srcBandName.contains(acquisitionMode + swathIndexStr) || !this.getTargetBandNameFromSourceBandName(srcBandName).equals(tgtBandName)) continue;
            return srcBandName;
        }
        return null;
    }

    private static String getPrefix(String tgtBandName) {
        int firstSeparationIdx = tgtBandName.indexOf(95);
        return tgtBandName.substring(firstSeparationIdx + 1);
    }

    private boolean containSelectedPolarisations(String bandName) {
        for (String pol : this.selectedPolarisations) {
            if (!bandName.contains(pol)) continue;
            return true;
        }
        return false;
    }

    private void createTiePointGrids() {
        int gridWidth = 20;
        int gridHeight = 5;
        int subSamplingX = this.targetWidth / 20;
        int subSamplingY = this.targetHeight / 5;
        int maxList = 126;
        float[] latList = new float[126];
        float[] lonList = new float[126];
        float[] slrtList = new float[126];
        float[] incList = new float[126];
        int k = 0;
        for (int i = 0; i <= 5; ++i) {
            int y = i * subSamplingY;
            double azTime = this.targetFirstLineTime + (double)y * this.targetLineTimeInterval;
            for (int j = 0; j <= 20; ++j) {
                int x = j * subSamplingX;
                double slrTime = this.targetSlantRangeTimeToFirstPixel + (double)x * this.targetDeltaSlantRangeTime;
                latList[k] = (float)this.su.getLatitude(azTime, slrTime);
                lonList[k] = (float)this.su.getLongitude(azTime, slrTime);
                slrtList[k] = (float)(this.su.getSlantRangeTime(azTime, slrTime) * 2.0 * 1.0E9);
                incList[k] = (float)this.su.getIncidenceAngle(azTime, slrTime);
                ++k;
            }
        }
        TiePointGrid latGrid = new TiePointGrid("latitude", 21, 6, 0.0, 0.0, (double)subSamplingX, (double)subSamplingY, latList);
        TiePointGrid lonGrid = new TiePointGrid("longitude", 21, 6, 0.0, 0.0, (double)subSamplingX, (double)subSamplingY, lonList);
        TiePointGrid slrtGrid = new TiePointGrid("slant_range_time", 21, 6, 0.0, 0.0, (double)subSamplingX, (double)subSamplingY, slrtList);
        TiePointGrid incGrid = new TiePointGrid("incident_angle", 21, 6, 0.0, 0.0, (double)subSamplingX, (double)subSamplingY, incList);
        latGrid.setUnit("deg");
        lonGrid.setUnit("deg");
        slrtGrid.setUnit("ns");
        incGrid.setUnit("deg");
        this.targetProduct.addTiePointGrid(latGrid);
        this.targetProduct.addTiePointGrid(lonGrid);
        this.targetProduct.addTiePointGrid(slrtGrid);
        this.targetProduct.addTiePointGrid(incGrid);
        TiePointGeoCoding tpGeoCoding = new TiePointGeoCoding(latGrid, lonGrid);
        this.targetProduct.setSceneGeoCoding((GeoCoding)tpGeoCoding);
    }

    private void updateTargetProductMetadata() {
        this.updateAbstractMetadata();
        this.updateOriginalMetadata();
    }

    private void updateAbstractMetadata() {
        MetadataElement absTgt = AbstractMetadata.getAbstractedMetadata((Product)this.targetProduct);
        AbstractMetadata.setAttribute((MetadataElement)absTgt, (String)"num_output_lines", (int)this.targetHeight);
        AbstractMetadata.setAttribute((MetadataElement)absTgt, (String)"num_samples_per_line", (int)this.targetWidth);
        absTgt.setAttributeUTC("first_line_time", new ProductData.UTC(this.targetFirstLineTime / 86400.0));
        absTgt.setAttributeUTC("last_line_time", new ProductData.UTC(this.targetLastLineTime / 86400.0));
        absTgt.setAttributeDouble("line_time_interval", this.targetLineTimeInterval);
        TiePointGrid latGrid = this.targetProduct.getTiePointGrid("latitude");
        TiePointGrid lonGrid = this.targetProduct.getTiePointGrid("longitude");
        AbstractMetadata.setAttribute((MetadataElement)absTgt, (String)"first_near_lat", (double)latGrid.getPixelFloat(0, 0));
        AbstractMetadata.setAttribute((MetadataElement)absTgt, (String)"first_near_long", (double)lonGrid.getPixelFloat(0, 0));
        AbstractMetadata.setAttribute((MetadataElement)absTgt, (String)"first_far_lat", (double)latGrid.getPixelFloat(this.targetWidth, 0));
        AbstractMetadata.setAttribute((MetadataElement)absTgt, (String)"first_far_long", (double)lonGrid.getPixelFloat(this.targetWidth, 0));
        AbstractMetadata.setAttribute((MetadataElement)absTgt, (String)"last_near_lat", (double)latGrid.getPixelFloat(0, this.targetHeight));
        AbstractMetadata.setAttribute((MetadataElement)absTgt, (String)"last_near_long", (double)lonGrid.getPixelFloat(0, this.targetHeight));
        AbstractMetadata.setAttribute((MetadataElement)absTgt, (String)"last_far_lat", (double)latGrid.getPixelFloat(this.targetWidth, this.targetHeight));
        AbstractMetadata.setAttribute((MetadataElement)absTgt, (String)"last_far_long", (double)lonGrid.getPixelFloat(this.targetWidth, this.targetHeight));
        AbstractMetadata.setAttribute((MetadataElement)absTgt, (String)"slant_range_to_first_pixel", (double)(this.targetSlantRangeTimeToFirstPixel * 2.99792458E8));
        this.addBurstBoundary(absTgt);
        for (MetadataElement elem : absTgt.getElements()) {
            if (!elem.getName().startsWith("Band_")) continue;
            absTgt.removeElement(elem);
        }
        if (this.numOfSubSwath == 1) {
            absTgt.addAttribute(new MetadataAttribute("firstValidPixel", 11));
            absTgt.setAttributeInt("firstValidPixel", this.subSwath[0].firstValidPixel);
            absTgt.addAttribute(new MetadataAttribute("lastValidPixel", 11));
            absTgt.setAttributeInt("lastValidPixel", this.subSwath[0].lastValidPixel);
            absTgt.addAttribute(new MetadataAttribute("slrTimeToFirstValidPixel", 31));
            absTgt.setAttributeDouble("slrTimeToFirstValidPixel", this.subSwath[0].slrTimeToFirstValidPixel);
            absTgt.addAttribute(new MetadataAttribute("slrTimeToLastValidPixel", 31));
            absTgt.setAttributeDouble("slrTimeToLastValidPixel", this.subSwath[0].slrTimeToLastValidPixel);
            absTgt.addAttribute(new MetadataAttribute("firstValidLineTime", 31));
            absTgt.setAttributeDouble("firstValidLineTime", this.subSwath[0].firstValidLineTime);
            absTgt.addAttribute(new MetadataAttribute("lastValidLineTime", 31));
            absTgt.setAttributeDouble("lastValidLineTime", this.subSwath[0].lastValidLineTime);
        }
    }

    private void addBurstBoundary(MetadataElement absTgt) {
        GeoCoding targetGeoCoding = this.targetProduct.getSceneGeoCoding();
        ArrayList<String> swathList = new ArrayList<String>(5);
        for (MetadataElement elem : absTgt.getElements()) {
            String swath;
            if (!elem.getName().startsWith("Band_") || (swath = elem.getAttributeString("swath")) == null || swathList.contains(swath)) continue;
            swathList.add(swath);
        }
        double firstLineTime = 0.0;
        double lastLineTime = 0.0;
        double firstPixelTime = 0.0;
        double lastPixelTime = 0.0;
        MetadataElement burstBoundary = new MetadataElement("BurstBoundary");
        for (int i = 0; i < swathList.size(); ++i) {
            String subSwathName = (String)swathList.get(i);
            MetadataElement swathElem = new MetadataElement(subSwathName);
            swathElem.addAttribute(new MetadataAttribute("count", 11));
            swathElem.setAttributeInt("count", this.subSwath[i].numOfBursts);
            for (int b = 0; b < this.subSwath[i].numOfBursts; ++b) {
                MetadataElement burstElem = new MetadataElement("Burst" + b);
                MetadataElement firstLineElem = new MetadataElement("FirstLineBoundaryPoints");
                MetadataElement lastLineElem = new MetadataElement("LastLineBoundaryPoints");
                firstLineTime = b == 0 ? this.subSwath[i].burstFirstLineTime[b] : (this.subSwath[i].burstLastLineTime[b - 1] + this.subSwath[i].burstFirstLineTime[b]) / 2.0;
                lastLineTime = b == this.subSwath[i].numOfBursts - 1 ? this.subSwath[i].burstLastLineTime[b] : (this.subSwath[i].burstLastLineTime[b] + this.subSwath[i].burstFirstLineTime[b + 1]) / 2.0;
                firstPixelTime = i == 0 ? this.subSwath[i].slrTimeToFirstValidPixel : (this.subSwath[i - 1].slrTimeToLastValidPixel + this.subSwath[i].slrTimeToFirstValidPixel) / 2.0;
                lastPixelTime = i == swathList.size() - 1 ? this.subSwath[i].slrTimeToLastValidPixel : (this.subSwath[i].slrTimeToLastValidPixel + this.subSwath[i + 1].slrTimeToFirstValidPixel) / 2.0;
                double deltaTime = (lastPixelTime - firstPixelTime) / (double)(numOfBoundaryPoints - 1);
                for (int p = 0; p < numOfBoundaryPoints; ++p) {
                    double slrtToPoint = firstPixelTime + (double)p * deltaTime;
                    MetadataElement firstLinePointElem = this.createPointElement(firstLineTime, slrtToPoint, targetGeoCoding);
                    firstLineElem.addElement(firstLinePointElem);
                    MetadataElement lastLinePointElem = this.createPointElement(lastLineTime, slrtToPoint, targetGeoCoding);
                    lastLineElem.addElement(lastLinePointElem);
                }
                burstElem.addElement(firstLineElem);
                burstElem.addElement(lastLineElem);
                swathElem.addElement(burstElem);
            }
            burstBoundary.addElement(swathElem);
        }
        absTgt.addElement(burstBoundary);
    }

    private MetadataElement createPointElement(double lineTime, double pixelTime, GeoCoding targetGeoCoding) {
        MetadataElement pointElem = new MetadataElement("BoundaryPoint");
        int x = (int)((pixelTime - this.targetSlantRangeTimeToFirstPixel) / this.targetDeltaSlantRangeTime);
        int y = (int)((lineTime - this.targetFirstLineTime) / this.targetLineTimeInterval);
        GeoPos geoPos = new GeoPos();
        targetGeoCoding.getGeoPos(new PixelPos((double)x, (double)y), geoPos);
        pointElem.addAttribute(new MetadataAttribute("lat", 30));
        pointElem.setAttributeDouble("lat", geoPos.lat);
        pointElem.addAttribute(new MetadataAttribute("lon", 30));
        pointElem.setAttributeDouble("lon", geoPos.lon);
        return pointElem;
    }

    private void updateOriginalMetadata() {
        this.updateSwathTiming();
        if (this.su.getNumOfSubSwath() > 1) {
            this.updateCalibrationVector();
        }
    }

    private void updateSwathTiming() {
        MetadataElement[] elems;
        MetadataElement origProdRoot = AbstractMetadata.getOriginalProductMetadata((Product)this.targetProduct);
        MetadataElement annotation = origProdRoot.getElement("annotation");
        if (annotation == null) {
            throw new OperatorException("Annotation Metadata not found");
        }
        for (MetadataElement elem : elems = annotation.getElements()) {
            MetadataElement[] burstListElem;
            MetadataElement product = elem.getElement("product");
            MetadataElement swathTiming = product.getElement("swathTiming");
            swathTiming.setAttributeString("linesPerBurst", "0");
            swathTiming.setAttributeString("samplesPerBurst", "0");
            MetadataElement burstList = swathTiming.getElement("burstList");
            burstList.setAttributeString("count", "0");
            for (MetadataElement aBurstListElem : burstListElem = burstList.getElements()) {
                burstList.removeElement(aBurstListElem);
            }
        }
    }

    private static String getMissionPrefix(MetadataElement absRoot) {
        String mission = absRoot.getAttributeString("MISSION");
        return "S1" + mission.substring(mission.length() - 1, mission.length());
    }

    private void updateCalibrationVector() {
        String[] selectedPols = Sentinel1Utils.getProductPolarizations((MetadataElement)this.absRoot);
        MetadataElement srcCalibration = AbstractMetadata.getOriginalProductMetadata((Product)this.sourceProduct).getElement("calibration");
        MetadataElement bandCalibration = srcCalibration.getElementAt(0).getElement("calibration");
        String missionPrefix = TOPSARDeburstOp.getMissionPrefix(this.absRoot).toLowerCase();
        MetadataElement origProdRoot = AbstractMetadata.getOriginalProductMetadata((Product)this.targetProduct);
        origProdRoot.removeElement(origProdRoot.getElement("calibration"));
        MetadataElement calibration = new MetadataElement("calibration");
        for (String pol : selectedPols) {
            String elemName = missionPrefix + '-' + this.acquisitionMode + '-' + this.productType + '-' + pol;
            MetadataElement elem = new MetadataElement(elemName);
            MetadataElement calElem = bandCalibration.createDeepClone();
            MetadataElement calibrationVectorListElem = calElem.getElement("calibrationVectorList");
            MetadataElement[] list = calibrationVectorListElem.getElements();
            int vectorIndex = 0;
            String mergedPixelStr = this.getMergedPixels(pol);
            StringTokenizer tokenizer = new StringTokenizer(mergedPixelStr, " ");
            int count = tokenizer.countTokens();
            for (MetadataElement calibrationVectorElem : list) {
                MetadataElement pixelElem = calibrationVectorElem.getElement("pixel");
                pixelElem.setAttributeString("pixel", mergedPixelStr);
                pixelElem.setAttributeString("count", Integer.toString(count));
                MetadataElement sigmaNoughtElem = calibrationVectorElem.getElement("sigmaNought");
                String mergedSigmaNoughtStr = this.getMergedVector("SigmaNought", pol, vectorIndex);
                sigmaNoughtElem.setAttributeString("sigmaNought", mergedSigmaNoughtStr);
                sigmaNoughtElem.setAttributeString("count", Integer.toString(count));
                MetadataElement betaNoughtElem = calibrationVectorElem.getElement("betaNought");
                String mergedBetaNoughtStr = this.getMergedVector("betaNought", pol, vectorIndex);
                betaNoughtElem.setAttributeString("betaNought", mergedBetaNoughtStr);
                betaNoughtElem.setAttributeString("count", Integer.toString(count));
                MetadataElement gammaNoughtElem = calibrationVectorElem.getElement("gamma");
                String mergedGammaNoughtStr = this.getMergedVector("gamma", pol, vectorIndex);
                gammaNoughtElem.setAttributeString("gamma", mergedGammaNoughtStr);
                gammaNoughtElem.setAttributeString("count", Integer.toString(count));
                MetadataElement dnElem = calibrationVectorElem.getElement("dn");
                String mergedDNStr = this.getMergedVector("dn", pol, vectorIndex);
                dnElem.setAttributeString("dn", mergedDNStr);
                dnElem.setAttributeString("count", Integer.toString(count));
                ++vectorIndex;
            }
            elem.addElement(calElem);
            calibration.addElement(elem);
        }
        origProdRoot.addElement(calibration);
    }

    private String getMergedPixels(String pol) {
        StringBuilder mergedPixelStr = new StringBuilder("");
        for (int s = 0; s < this.numOfSubSwath; ++s) {
            int[] pixelArray;
            for (int p : pixelArray = this.su.getCalibrationPixel(s + 1, pol, 0)) {
                if (p < this.subSwathEffectStartEndPixels[s].xMin || p >= this.subSwathEffectStartEndPixels[s].xMax) continue;
                double slrt = this.subSwath[s].slrTimeToFirstPixel + (double)p * this.targetDeltaSlantRangeTime;
                int targetPixelIdx = (int)Math.round((slrt - this.targetSlantRangeTimeToFirstPixel) / this.targetDeltaSlantRangeTime);
                mergedPixelStr.append(targetPixelIdx + " ");
            }
        }
        return mergedPixelStr.toString();
    }

    private String getMergedVector(String vectorName, String pol, int vectorIndex) {
        StringBuilder mergedVectorStr = new StringBuilder("");
        for (int s = 0; s < this.numOfSubSwath; ++s) {
            int[] pixelArray = this.su.getCalibrationPixel(s + 1, pol, vectorIndex);
            float[] vectorArray = this.su.getCalibrationVector(s + 1, pol, vectorIndex, vectorName);
            for (int i = 0; i < pixelArray.length; ++i) {
                if (pixelArray[i] < this.subSwathEffectStartEndPixels[s].xMin || pixelArray[i] >= this.subSwathEffectStartEndPixels[s].xMax) continue;
                mergedVectorStr.append(vectorArray[i]).append(' ');
            }
        }
        return mergedVectorStr.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void computeTileStack(Map<Band, Tile> targetTiles, Rectangle targetRectangle, ProgressMonitor pm) throws OperatorException {
        try {
            Band[] tgtBands;
            int numOfSourceTiles;
            int i;
            int tx0 = targetRectangle.x;
            int ty0 = targetRectangle.y;
            int tw = targetRectangle.width;
            int th = targetRectangle.height;
            double tileSlrtToFirstPixel = this.targetSlantRangeTimeToFirstPixel + (double)tx0 * this.targetDeltaSlantRangeTime;
            double tileSlrtToLastPixel = this.targetSlantRangeTimeToFirstPixel + (double)(tx0 + tw - 1) * this.targetDeltaSlantRangeTime;
            double tileFirstLineTime = this.targetFirstLineTime + (double)ty0 * this.targetLineTimeInterval;
            double tileLastLineTime = this.targetFirstLineTime + (double)(ty0 + th - 1) * this.targetLineTimeInterval;
            int firstSubSwathIndex = -1;
            int lastSubSwathIndex = -1;
            for (i = 0; i < this.numOfSubSwath; ++i) {
                if (!(tileSlrtToFirstPixel >= this.subSwath[i].slrTimeToFirstValidPixel) || !(tileSlrtToFirstPixel <= this.subSwath[i].slrTimeToLastValidPixel) || !(tileFirstLineTime >= this.subSwath[i].burstFirstValidLineTime[0] && tileFirstLineTime < this.subSwath[i].burstLastLineTime[this.subSwath[i].numOfBursts - 1]) && (!(tileLastLineTime >= this.subSwath[i].burstFirstValidLineTime[0]) || !(tileLastLineTime < this.subSwath[i].burstLastLineTime[this.subSwath[i].numOfBursts - 1]))) continue;
                firstSubSwathIndex = i + 1;
                break;
            }
            if (firstSubSwathIndex == this.numOfSubSwath) {
                lastSubSwathIndex = firstSubSwathIndex;
            } else {
                for (i = 0; i < this.numOfSubSwath; ++i) {
                    if (!(tileSlrtToLastPixel >= this.subSwath[i].slrTimeToFirstValidPixel) || !(tileSlrtToLastPixel <= this.subSwath[i].slrTimeToLastValidPixel) || !(tileFirstLineTime >= this.subSwath[i].burstFirstValidLineTime[0] && tileFirstLineTime < this.subSwath[i].burstLastLineTime[this.subSwath[i].numOfBursts - 1]) && (!(tileLastLineTime >= this.subSwath[i].burstFirstValidLineTime[0]) || !(tileLastLineTime < this.subSwath[i].burstLastLineTime[this.subSwath[i].numOfBursts - 1]))) continue;
                    lastSubSwathIndex = i + 1;
                }
            }
            if (firstSubSwathIndex == -1 && lastSubSwathIndex == -1) {
                return;
            }
            if (firstSubSwathIndex != -1 && lastSubSwathIndex == -1) {
                lastSubSwathIndex = firstSubSwathIndex;
            }
            if (firstSubSwathIndex == -1 && lastSubSwathIndex != -1) {
                firstSubSwathIndex = lastSubSwathIndex;
            }
            boolean tileInOneSubSwath = (numOfSourceTiles = lastSubSwathIndex - firstSubSwathIndex + 1) == 1;
            Rectangle[] sourceRectangle = new Rectangle[numOfSourceTiles];
            int k = 0;
            for (int i2 = firstSubSwathIndex; i2 <= lastSubSwathIndex; ++i2) {
                sourceRectangle[k++] = this.getSourceRectangle(tx0, ty0, tw, th, i2);
            }
            BurstInfo burstInfo = new BurstInfo();
            int txMax = tx0 + tw;
            int tyMax = ty0 + th;
            for (Band tgtBand : tgtBands = this.targetProduct.getBands()) {
                if (tgtBand instanceof VirtualBand) continue;
                String tgtBandName = tgtBand.getName();
                int dataType = tgtBand.getDataType();
                Tile tgtTile = targetTiles.get(tgtBand);
                if (tileInOneSubSwath) {
                    if (dataType == 11) {
                        this.computeTileInOneSwathShort(tx0, ty0, txMax, tyMax, firstSubSwathIndex, sourceRectangle, tgtBandName, tgtTile, burstInfo);
                        continue;
                    }
                    this.computeTileInOneSwathFloat(tx0, ty0, txMax, tyMax, firstSubSwathIndex, sourceRectangle, tgtBandName, tgtTile, burstInfo);
                    continue;
                }
                if (dataType == 11) {
                    this.computeMultipleSubSwathsShort(tx0, ty0, txMax, tyMax, firstSubSwathIndex, lastSubSwathIndex, sourceRectangle, tgtBandName, tgtTile, burstInfo);
                    continue;
                }
                this.computeMultipleSubSwathsFloat(tx0, ty0, txMax, tyMax, firstSubSwathIndex, lastSubSwathIndex, sourceRectangle, tgtBandName, tgtTile, burstInfo);
            }
        }
        catch (Throwable e) {
            OperatorUtils.catchOperatorException((String)this.getId(), (Throwable)e);
        }
        finally {
            pm.done();
        }
    }

    private void computeTileInOneSwathShort(int tx0, int ty0, int txMax, int tyMax, int firstSubSwathIndex, Rectangle[] sourceRectangle, String tgtBandName, Tile tgtTile, BurstInfo burstInfo) {
        int yMin = this.computeYMin(this.subSwath[firstSubSwathIndex - 1]);
        int yMax = this.computeYMax(this.subSwath[firstSubSwathIndex - 1]);
        int xMin = this.computeXMin(this.subSwath[firstSubSwathIndex - 1]);
        int xMax = this.computeXMax(this.subSwath[firstSubSwathIndex - 1]);
        int firstY = Math.max(ty0, yMin);
        int lastY = Math.min(tyMax, yMax + 1);
        int firstX = Math.max(tx0, xMin);
        int lastX = Math.min(txMax, xMax + 1);
        if (firstY >= lastY || firstX >= lastX) {
            return;
        }
        String swathIndexStr = this.numOfSubSwath == 1 ? this.su.getSubSwathNames()[0].substring(2) : String.valueOf(firstSubSwathIndex);
        String srcBandName = this.getSourceBandNameFromTargetBandName(tgtBandName, this.acquisitionMode, swathIndexStr);
        Band srcBand = this.sourceProduct.getBand(srcBandName);
        Tile srcRaster = this.getSourceTile((RasterDataNode)srcBand, sourceRectangle[0]);
        TileIndex srcTileIndex = new TileIndex(srcRaster);
        TileIndex tgtIndex = new TileIndex(tgtTile);
        short[] srcArray = (short[])srcRaster.getDataBuffer().getElems();
        short[] tgtArray = (short[])tgtTile.getDataBuffer().getElems();
        for (int y = firstY; y < lastY; ++y) {
            if (!this.getLineIndicesInSourceProduct(y, this.subSwath[firstSubSwathIndex - 1], burstInfo)) continue;
            int tgtOffset = tgtIndex.calculateStride(y);
            Sentinel1Utils.SubSwathInfo firstSubSwath = this.subSwath[firstSubSwathIndex - 1];
            int offset = burstInfo.sy1 != -1 && burstInfo.targetTime > burstInfo.midTime ? srcTileIndex.calculateStride(burstInfo.sy1) : srcTileIndex.calculateStride(burstInfo.sy0);
            int sx = (int)Math.round((this.targetSlantRangeTimeToFirstPixel + (double)firstX * this.targetDeltaSlantRangeTime - firstSubSwath.slrTimeToFirstPixel) / this.targetDeltaSlantRangeTime);
            System.arraycopy(srcArray, sx - offset, tgtArray, firstX - tgtOffset, lastX - firstX);
        }
    }

    private void computeTileInOneSwathFloat(int tx0, int ty0, int txMax, int tyMax, int firstSubSwathIndex, Rectangle[] sourceRectangle, String tgtBandName, Tile tgtTile, BurstInfo burstInfo) {
        int yMin = this.computeYMin(this.subSwath[firstSubSwathIndex - 1]);
        int yMax = this.computeYMax(this.subSwath[firstSubSwathIndex - 1]);
        int xMin = this.computeXMin(this.subSwath[firstSubSwathIndex - 1]);
        int xMax = this.computeXMax(this.subSwath[firstSubSwathIndex - 1]);
        int firstY = Math.max(ty0, yMin);
        int lastY = Math.min(tyMax, yMax + 1);
        int firstX = Math.max(tx0, xMin);
        int lastX = Math.min(txMax, xMax + 1);
        if (firstY >= lastY || firstX >= lastX) {
            return;
        }
        String swathIndexStr = this.numOfSubSwath == 1 ? this.su.getSubSwathNames()[0].substring(2) : String.valueOf(firstSubSwathIndex);
        String srcBandName = this.getSourceBandNameFromTargetBandName(tgtBandName, this.acquisitionMode, swathIndexStr);
        Band srcBand = this.sourceProduct.getBand(srcBandName);
        Tile srcRaster = this.getSourceTile((RasterDataNode)srcBand, sourceRectangle[0]);
        TileIndex srcTileIndex = new TileIndex(srcRaster);
        TileIndex tgtIndex = new TileIndex(tgtTile);
        float[] srcArray = (float[])srcRaster.getDataBuffer().getElems();
        float[] tgtArray = (float[])tgtTile.getDataBuffer().getElems();
        for (int y = firstY; y < lastY; ++y) {
            if (!this.getLineIndicesInSourceProduct(y, this.subSwath[firstSubSwathIndex - 1], burstInfo)) continue;
            int tgtOffset = tgtIndex.calculateStride(y);
            Sentinel1Utils.SubSwathInfo firstSubSwath = this.subSwath[firstSubSwathIndex - 1];
            int offset = burstInfo.sy1 != -1 && burstInfo.targetTime > burstInfo.midTime ? srcTileIndex.calculateStride(burstInfo.sy1) : srcTileIndex.calculateStride(burstInfo.sy0);
            int sx = (int)Math.round((this.targetSlantRangeTimeToFirstPixel + (double)firstX * this.targetDeltaSlantRangeTime - firstSubSwath.slrTimeToFirstPixel) / this.targetDeltaSlantRangeTime);
            System.arraycopy(srcArray, sx - offset, tgtArray, firstX - tgtOffset, lastX - firstX);
        }
    }

    private void computeMultipleSubSwathsShort(int tx0, int ty0, int txMax, int tyMax, int firstSubSwathIndex, int lastSubSwathIndex, Rectangle[] sourceRectangle, String tgtBandName, Tile tgtTile, BurstInfo burstInfo) {
        int numOfSourceTiles = lastSubSwathIndex - firstSubSwathIndex + 1;
        TileIndex tgtIndex = new TileIndex(tgtTile);
        Tile[] srcTiles = new Tile[numOfSourceTiles];
        short[][] srcArray = new short[numOfSourceTiles][];
        short[] tgtArray = (short[])tgtTile.getDataBuffer().getElems();
        int k = 0;
        for (int i = firstSubSwathIndex; i <= lastSubSwathIndex; ++i) {
            Tile srcRaster;
            String srcBandName = this.getSourceBandNameFromTargetBandName(tgtBandName, this.acquisitionMode, String.valueOf(i));
            Band srcBand = this.sourceProduct.getBand(srcBandName);
            srcTiles[k] = srcRaster = this.getSourceTile((RasterDataNode)srcBand, sourceRectangle[k]);
            srcArray[k] = (short[])srcRaster.getDataBuffer().getElems();
            ++k;
        }
        for (int y = ty0; y < tyMax; ++y) {
            int tgtOffset = tgtIndex.calculateStride(y);
            for (int x = tx0; x < txMax; ++x) {
                int sy;
                int subswathIndex = this.getSubSwathIndex(x, y, firstSubSwathIndex, lastSubSwathIndex, burstInfo);
                if (subswathIndex == -1 || !this.getLineIndicesInSourceProduct(y, this.subSwath[subswathIndex - 1], burstInfo)) continue;
                short val = 0;
                k = subswathIndex - firstSubSwathIndex;
                int sx = this.getSampleIndexInSourceProduct(x, this.subSwath[subswathIndex - 1]);
                int idx = srcTiles[k].getDataBufferIndex(sx, sy = burstInfo.sy1 != -1 && burstInfo.targetTime > burstInfo.midTime ? burstInfo.sy1 : burstInfo.sy0);
                if (idx >= 0) {
                    val = srcArray[k][idx];
                }
                if (burstInfo.swath1 != -1 && val == 0) {
                    subswathIndex = subswathIndex == burstInfo.swath0 ? burstInfo.swath1 : burstInfo.swath0;
                    this.getLineIndicesInSourceProduct(y, this.subSwath[subswathIndex - 1], burstInfo);
                    k = subswathIndex - firstSubSwathIndex;
                    sx = this.getSampleIndexInSourceProduct(x, this.subSwath[subswathIndex - 1]);
                    sy = burstInfo.sy1 != -1 && burstInfo.targetTime > burstInfo.midTime ? burstInfo.sy1 : burstInfo.sy0;
                    idx = srcTiles[k].getDataBufferIndex(sx, sy);
                    if (idx >= 0 && srcArray[k][idx] != 0) {
                        val = srcArray[k][idx];
                    }
                }
                tgtArray[x - tgtOffset] = val;
            }
        }
    }

    private void computeMultipleSubSwathsFloat(int tx0, int ty0, int txMax, int tyMax, int firstSubSwathIndex, int lastSubSwathIndex, Rectangle[] sourceRectangle, String tgtBandName, Tile tgtTile, BurstInfo burstInfo) {
        int numOfSourceTiles = lastSubSwathIndex - firstSubSwathIndex + 1;
        TileIndex tgtIndex = new TileIndex(tgtTile);
        Tile[] srcTiles = new Tile[numOfSourceTiles];
        float[][] srcArray = new float[numOfSourceTiles][];
        float[] tgtArray = (float[])tgtTile.getDataBuffer().getElems();
        int k = 0;
        for (int i = firstSubSwathIndex; i <= lastSubSwathIndex; ++i) {
            Tile srcRaster;
            String srcBandName = this.getSourceBandNameFromTargetBandName(tgtBandName, this.acquisitionMode, String.valueOf(i));
            Band srcBand = this.sourceProduct.getBand(srcBandName);
            srcTiles[k] = srcRaster = this.getSourceTile((RasterDataNode)srcBand, sourceRectangle[k]);
            srcArray[k] = (float[])srcRaster.getDataBuffer().getElems();
            ++k;
        }
        for (int y = ty0; y < tyMax; ++y) {
            int tgtOffset = tgtIndex.calculateStride(y);
            for (int x = tx0; x < txMax; ++x) {
                int sy;
                int subswathIndex = this.getSubSwathIndex(x, y, firstSubSwathIndex, lastSubSwathIndex, burstInfo);
                if (subswathIndex == -1 || !this.getLineIndicesInSourceProduct(y, this.subSwath[subswathIndex - 1], burstInfo)) continue;
                float val = 0.0f;
                k = subswathIndex - firstSubSwathIndex;
                int sx = this.getSampleIndexInSourceProduct(x, this.subSwath[subswathIndex - 1]);
                int idx = srcTiles[k].getDataBufferIndex(sx, sy = burstInfo.sy1 != -1 && burstInfo.targetTime > burstInfo.midTime ? burstInfo.sy1 : burstInfo.sy0);
                if (idx >= 0) {
                    val = srcArray[k][idx];
                }
                if (burstInfo.swath1 != -1 && val == 0.0f) {
                    subswathIndex = subswathIndex == burstInfo.swath0 ? burstInfo.swath1 : burstInfo.swath0;
                    this.getLineIndicesInSourceProduct(y, this.subSwath[subswathIndex - 1], burstInfo);
                    k = subswathIndex - firstSubSwathIndex;
                    sx = this.getSampleIndexInSourceProduct(x, this.subSwath[subswathIndex - 1]);
                    sy = burstInfo.sy1 != -1 && burstInfo.targetTime > burstInfo.midTime ? burstInfo.sy1 : burstInfo.sy0;
                    idx = srcTiles[k].getDataBufferIndex(sx, sy);
                    if (idx >= 0 && srcArray[k][idx] != 0.0f) {
                        val = srcArray[k][idx];
                    }
                }
                tgtArray[x - tgtOffset] = val;
            }
        }
    }

    private Rectangle getSourceRectangle(int tx0, int ty0, int tw, int th, int subSwathIndex) {
        Sentinel1Utils.SubSwathInfo sw = this.subSwath[subSwathIndex - 1];
        int x0 = this.getSampleIndexInSourceProduct(tx0, sw);
        int xMax = this.getSampleIndexInSourceProduct(tx0 + tw - 1, sw);
        BurstInfo burstTimes = new BurstInfo();
        this.getLineIndicesInSourceProduct(ty0, sw, burstTimes);
        int y0 = burstTimes.sy0 == -1 && burstTimes.sy1 == -1 ? 0 : burstTimes.sy0;
        this.getLineIndicesInSourceProduct(ty0 + th - 1, sw, burstTimes);
        int yMax = burstTimes.sy0 == -1 && burstTimes.sy1 == -1 ? sw.numOfLines - 1 : Math.max(burstTimes.sy0, burstTimes.sy1);
        int w = xMax - x0 + 1;
        int h = yMax - y0 + 1;
        return new Rectangle(x0, y0, w, h);
    }

    private int getSampleIndexInSourceProduct(int tx, Sentinel1Utils.SubSwathInfo subSwath) {
        int sx = (int)((this.targetSlantRangeTimeToFirstPixel + (double)tx * this.targetDeltaSlantRangeTime - subSwath.slrTimeToFirstPixel) / this.targetDeltaSlantRangeTime + 0.5);
        return sx < 0 ? 0 : (sx > subSwath.numOfSamples - 1 ? subSwath.numOfSamples - 1 : sx);
    }

    private boolean getLineIndicesInSourceProduct(int ty, Sentinel1Utils.SubSwathInfo subSwath, BurstInfo burstTimes) {
        double targetLineTime;
        burstTimes.targetTime = targetLineTime = this.targetFirstLineTime + (double)ty * this.targetLineTimeInterval;
        burstTimes.sy0 = -1;
        burstTimes.sy1 = -1;
        int k = 0;
        for (int i = 0; i < subSwath.numOfBursts; ++i) {
            if (!(targetLineTime >= subSwath.burstFirstLineTime[i]) || !(targetLineTime < subSwath.burstLastLineTime[i])) continue;
            int sy = i * subSwath.linesPerBurst + (int)((targetLineTime - subSwath.burstFirstLineTime[i]) / subSwath.azimuthTimeInterval + 0.5);
            if (k != 0) {
                burstTimes.sy1 = sy;
                burstTimes.burstNum1 = i;
                break;
            }
            burstTimes.sy0 = sy;
            burstTimes.burstNum0 = i;
            ++k;
        }
        if (burstTimes.sy0 != -1 && burstTimes.sy1 != -1) {
            burstTimes.midTime = (subSwath.burstLastLineTime[burstTimes.burstNum0] + subSwath.burstFirstLineTime[burstTimes.burstNum1]) / 2.0;
        }
        return burstTimes.sy0 != -1 || burstTimes.sy1 != -1;
    }

    private int computeYMin(Sentinel1Utils.SubSwathInfo subSwath) {
        return (int)((subSwath.firstValidLineTime - this.targetFirstLineTime) / this.targetLineTimeInterval);
    }

    private int computeYMax(Sentinel1Utils.SubSwathInfo subSwath) {
        return (int)((subSwath.lastValidLineTime - this.targetFirstLineTime) / this.targetLineTimeInterval);
    }

    private int computeXMin(Sentinel1Utils.SubSwathInfo subSwath) {
        return (int)((subSwath.slrTimeToFirstValidPixel - this.targetSlantRangeTimeToFirstPixel) / this.targetDeltaSlantRangeTime);
    }

    private int computeXMax(Sentinel1Utils.SubSwathInfo subSwath) {
        return (int)((subSwath.slrTimeToLastValidPixel - this.targetSlantRangeTimeToFirstPixel) / this.targetDeltaSlantRangeTime);
    }

    private int getSubSwathIndex(int tx, int ty, int firstSubSwathIndex, int lastSubSwathIndex, BurstInfo burstInfo) {
        double middleTime;
        double targetSampleSlrTime = this.targetSlantRangeTimeToFirstPixel + (double)tx * this.targetDeltaSlantRangeTime;
        double targetLineTime = this.targetFirstLineTime + (double)ty * this.targetLineTimeInterval;
        burstInfo.swath0 = -1;
        burstInfo.swath1 = -1;
        int cnt = 0;
        for (int i = firstSubSwathIndex; i <= lastSubSwathIndex; ++i) {
            int i_1 = i - 1;
            Sentinel1Utils.SubSwathInfo info = this.subSwath[i_1];
            if (!(targetLineTime >= info.firstValidLineTime) || !(targetLineTime <= info.lastValidLineTime) || !(targetSampleSlrTime >= info.slrTimeToFirstValidPixel) || !(targetSampleSlrTime <= info.slrTimeToLastValidPixel)) continue;
            if (cnt != 0) {
                burstInfo.swath1 = i;
                break;
            }
            burstInfo.swath0 = i;
            ++cnt;
        }
        if (burstInfo.swath1 != -1 && targetSampleSlrTime > (middleTime = (this.subSwath[burstInfo.swath0 - 1].slrTimeToLastValidPixel + this.subSwath[burstInfo.swath1 - 1].slrTimeToFirstValidPixel) / 2.0)) {
            return burstInfo.swath1;
        }
        return burstInfo.swath0;
    }

    private double getSubSwathNoise(int tx, double targetLineTime, Sentinel1Utils.SubSwathInfo sw, String pol) {
        Sentinel1Utils.NoiseVector[] vectorList = (Sentinel1Utils.NoiseVector[])sw.noise.get(pol);
        int sx = this.getSampleIndexInSourceProduct(tx, sw);
        int sy = (int)((targetLineTime - vectorList[0].timeMJD * 86400.0) / this.targetLineTimeInterval);
        int l0 = -1;
        int l1 = -1;
        int vectorIdx0 = -1;
        int vectorIdxInc = 0;
        if (sy < vectorList[0].line) {
            l1 = l0 = vectorList[0].line;
            vectorIdx0 = 0;
        } else if (sy >= vectorList[vectorList.length - 1].line) {
            l1 = l0 = vectorList[vectorList.length - 1].line;
            vectorIdx0 = vectorList.length - 1;
        } else {
            vectorIdxInc = 1;
            int max = vectorList.length - 1;
            for (int i = 0; i < max; ++i) {
                if (sy < vectorList[i].line || sy >= vectorList[i + 1].line) continue;
                l0 = vectorList[i].line;
                l1 = vectorList[i + 1].line;
                vectorIdx0 = i;
                break;
            }
        }
        int[] pixels = vectorList[vectorIdx0].pixels;
        int p0 = -1;
        int p1 = -1;
        int pixelIdx0 = -1;
        int pixelIdxInc = 0;
        if (sx < pixels[0]) {
            p1 = p0 = pixels[0];
            pixelIdx0 = 0;
        } else if (sx >= pixels[pixels.length - 1]) {
            p1 = p0 = pixels[pixels.length - 1];
            pixelIdx0 = pixels.length - 1;
        } else {
            pixelIdxInc = 1;
            int max = pixels.length - 1;
            for (int i = 0; i < max; ++i) {
                if (sx < pixels[i] || sx >= pixels[i + 1]) continue;
                p0 = pixels[i];
                p1 = pixels[i + 1];
                pixelIdx0 = i;
                break;
            }
        }
        float[] noiseLUT0 = vectorList[vectorIdx0].noiseLUT;
        float[] noiseLUT1 = vectorList[vectorIdx0 + vectorIdxInc].noiseLUT;
        double dx = p0 == p1 ? 0.0 : (double)((sx - p0) / (p1 - p0));
        double dy = l0 == l1 ? 0.0 : (double)((sy - l0) / (l1 - l0));
        return Maths.interpolationBiLinear((double)noiseLUT0[pixelIdx0], (double)noiseLUT0[pixelIdx0 + pixelIdxInc], (double)noiseLUT1[pixelIdx0], (double)noiseLUT1[pixelIdx0 + pixelIdxInc], (double)dx, (double)dy);
    }

    public static class Spi
    extends OperatorSpi {
        public Spi() {
            super(TOPSARDeburstOp.class);
        }
    }

    private static class SubSwathEffectStartEndPixels {
        public int xMin;
        public int xMax;
    }

    private static class BurstInfo {
        public int sy0 = -1;
        public int sy1 = -1;
        public int swath0;
        public int swath1;
        public int burstNum0 = 0;
        public int burstNum1 = 0;
        public double targetTime;
        public double midTime;
    }
}

