/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s1tbx.sentinel1.gpf;

import com.bc.ceres.core.ProgressMonitor;
import edu.emory.mathcs.jtransforms.fft.DoubleFFT_1D;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.math3.util.FastMath;
import org.esa.s1tbx.insar.gpf.support.Sentinel1Utils;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.MetadataAttribute;
import org.esa.snap.core.datamodel.MetadataElement;
import org.esa.snap.core.datamodel.PixelPos;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.datamodel.VirtualBand;
import org.esa.snap.core.dataop.downloadable.StatusProgressMonitor;
import org.esa.snap.core.gpf.Operator;
import org.esa.snap.core.gpf.OperatorException;
import org.esa.snap.core.gpf.OperatorSpi;
import org.esa.snap.core.gpf.Tile;
import org.esa.snap.core.gpf.annotations.OperatorMetadata;
import org.esa.snap.core.gpf.annotations.Parameter;
import org.esa.snap.core.gpf.annotations.SourceProduct;
import org.esa.snap.core.gpf.annotations.TargetProduct;
import org.esa.snap.core.util.ProductUtils;
import org.esa.snap.core.util.SystemUtils;
import org.esa.snap.engine_utilities.datamodel.AbstractMetadata;
import org.esa.snap.engine_utilities.gpf.InputProductValidator;
import org.esa.snap.engine_utilities.gpf.OperatorUtils;
import org.esa.snap.engine_utilities.gpf.ReaderUtils;
import org.esa.snap.engine_utilities.gpf.ThreadManager;
import org.esa.snap.engine_utilities.gpf.TileIndex;
import org.jblas.ComplexDoubleMatrix;
import org.jlinda.core.coregistration.utils.CoregistrationUtils;
import org.jlinda.nest.utils.TileUtilsDoris;

@OperatorMetadata(alias="Enhanced-Spectral-Diversity", category="Radar/Coregistration/S-1 TOPS Coregistration", authors="Jun Lu, Luis Veci", version="1.0", copyright="Copyright (C) 2016 by Array Systems Computing Inc.", description="Estimate constant range and azimuth offsets for the whole image")
public class SpectralDiversityOp
extends Operator {
    @SourceProduct(alias="source")
    private Product sourceProduct;
    @TargetProduct(description="The target product which will use the master's grid.")
    private Product targetProduct = null;
    @Parameter(valueSet={"32", "64", "128", "256", "512", "1024", "2048"}, defaultValue="512", label="Registration Window Width")
    private String fineWinWidthStr = "512";
    @Parameter(valueSet={"32", "64", "128", "256", "512", "1024", "2048"}, defaultValue="512", label="Registration Window Height")
    private String fineWinHeightStr = "512";
    @Parameter(valueSet={"2", "4", "8", "16", "32", "64"}, defaultValue="16", label="Search Window Accuracy in Azimuth Direction")
    private String fineWinAccAzimuth = "16";
    @Parameter(valueSet={"2", "4", "8", "16", "32", "64"}, defaultValue="16", label="Search Window Accuracy in Range Direction")
    private String fineWinAccRange = "16";
    @Parameter(valueSet={"32", "64", "128", "256"}, defaultValue="128", label="Window oversampling factor")
    private String fineWinOversampling = "128";
    @Parameter(description="The peak cross-correlation threshold", interval="(0, *)", defaultValue="0.1", label="Cross-Correlation Threshold")
    private double xCorrThreshold = 0.1;
    @Parameter(description="The coherence threshold for outlier removal", interval="(0, 1]", defaultValue="0.15", label="Coherence Threshold for Outlier Removal")
    private double cohThreshold = 0.15;
    @Parameter(description="The number of windows per overlap for ESD", interval="[1, 20]", defaultValue="10", label="Number of Windows Per Overlap for ESD")
    private int numBlocksPerOverlap = 10;
    @Parameter(description="Use user supplied range and azimuth shifts", defaultValue="false", label="Use user supplied shifts")
    private boolean useSuppliedShifts = false;
    @Parameter(description="The overall azimuth shift", defaultValue="0.0", label="The overall azimuth shift")
    private double overallAzimuthShift = 0.0;
    @Parameter(description="The overall range shift", defaultValue="0.0", label="The overall range shift")
    private double overallRangeShift = 0.0;
    private int fineWinWidth = 0;
    private int fineWinHeight = 0;
    private int fineWinAccY = 0;
    private int fineWinAccX = 0;
    private int fineWinOvsFactor = 0;
    private boolean isRangeOffsetAvailable = false;
    private boolean isAzimuthOffsetAvailable = false;
    private double azOffset = 0.0;
    private double rgOffset = 0.0;
    private double noDataValue = -9999.0;
    private Sentinel1Utils su;
    private Sentinel1Utils.SubSwathInfo[] subSwath = null;
    private int subSwathIndex = 0;
    private Band derampDemodPhaseBand = null;
    private String swathIndexStr = null;
    private String[] subSwathNames = null;
    private String[] polarizations = null;
    private static final int cohWin = 5;
    private static final int maxRangeShift = 1;
    private static final String DerampDemodPhase = "derampDemodPhase";

    public void initialize() throws OperatorException {
        try {
            InputProductValidator validator = new InputProductValidator(this.sourceProduct);
            validator.checkIfSARProduct();
            validator.checkIfSentinel1Product();
            this.checkDerampDemodPhaseBand();
            this.su = new Sentinel1Utils(this.sourceProduct);
            this.su.computeDopplerRate();
            this.subSwath = this.su.getSubSwath();
            this.polarizations = this.su.getPolarizations();
            this.subSwathNames = this.su.getSubSwathNames();
            if (this.subSwathNames.length != 1) {
                throw new OperatorException("Split product is expected.");
            }
            this.subSwathIndex = 1;
            this.swathIndexStr = this.subSwathNames[0].substring(2);
            if (this.useSuppliedShifts) {
                this.azOffset = this.overallAzimuthShift;
                this.rgOffset = this.overallRangeShift;
                this.isRangeOffsetAvailable = true;
                this.isAzimuthOffsetAvailable = true;
            } else {
                this.fineWinWidth = Integer.parseInt(this.fineWinWidthStr);
                this.fineWinHeight = Integer.parseInt(this.fineWinHeightStr);
                this.fineWinAccY = Integer.parseInt(this.fineWinAccAzimuth);
                this.fineWinAccX = Integer.parseInt(this.fineWinAccRange);
                this.fineWinOvsFactor = Integer.parseInt(this.fineWinOversampling);
                if (this.subSwath[this.subSwathIndex - 1].samplesPerBurst < this.fineWinWidth) {
                    throw new OperatorException("Registration window width should not be grater than burst width " + this.subSwath[this.subSwathIndex - 1].samplesPerBurst);
                }
                if (this.subSwath[this.subSwathIndex - 1].linesPerBurst < this.fineWinHeight) {
                    throw new OperatorException("Registration window height should not be grater than burst height " + this.subSwath[this.subSwathIndex - 1].linesPerBurst);
                }
            }
            this.createTargetProduct();
        }
        catch (Throwable e) {
            OperatorUtils.catchOperatorException((String)this.getId(), (Throwable)e);
        }
    }

    private void checkDerampDemodPhaseBand() {
        Band[] sourceBands;
        boolean hasDerampDemodPhaseBand = false;
        for (Band band : sourceBands = this.sourceProduct.getBands()) {
            if (!band.getName().contains(DerampDemodPhase)) continue;
            hasDerampDemodPhaseBand = true;
            break;
        }
        if (!hasDerampDemodPhaseBand) {
            throw new OperatorException("Cannot find derampDemodPhase band in source product. Please run Backgeocoding and select \"Output Deramp and Demod Phase\".");
        }
    }

    private void createTargetProduct() {
        String[] srcBandNames;
        this.targetProduct = new Product(this.sourceProduct.getName(), this.sourceProduct.getProductType(), this.sourceProduct.getSceneRasterWidth(), this.sourceProduct.getSceneRasterHeight());
        ProductUtils.copyProductNodes((Product)this.sourceProduct, (Product)this.targetProduct);
        for (String srcBandName : srcBandNames = this.sourceProduct.getBandNames()) {
            Band targetBand;
            Band band = this.sourceProduct.getBand(srcBandName);
            if (band instanceof VirtualBand) continue;
            if (srcBandName.contains("_mst") || srcBandName.contains("derampDemod")) {
                targetBand = ProductUtils.copyBand((String)srcBandName, (Product)this.sourceProduct, (String)srcBandName, (Product)this.targetProduct, (boolean)true);
                if (srcBandName.contains("derampDemod")) {
                    this.derampDemodPhaseBand = this.sourceProduct.getBand(srcBandName);
                }
            } else {
                if (srcBandName.contains("azOffset") || srcBandName.contains("rgOffset")) continue;
                targetBand = new Band(srcBandName, band.getDataType(), band.getRasterWidth(), band.getRasterHeight());
                targetBand.setUnit(band.getUnit());
                this.targetProduct.addBand(targetBand);
            }
            if (targetBand == null || !srcBandName.startsWith("q_")) continue;
            String suffix = srcBandName.substring(1);
            ReaderUtils.createVirtualIntensityBand((Product)this.targetProduct, (Band)this.targetProduct.getBand('i' + suffix), (Band)targetBand, (String)suffix);
        }
        this.targetProduct.setPreferredTileSize(512, this.subSwath[this.subSwathIndex - 1].linesPerBurst);
        this.updateTargetMetadata();
    }

    private void updateTargetMetadata() {
        MetadataElement absTgt = AbstractMetadata.getAbstractedMetadata((Product)this.targetProduct);
        if (absTgt == null) {
            return;
        }
        MetadataElement ESDMeasurement = new MetadataElement("ESD Measurement");
        MetadataElement OverallRgAzShiftElem = new MetadataElement("Overall_Range_Azimuth_Shift");
        OverallRgAzShiftElem.addElement(new MetadataElement(this.subSwathNames[0]));
        ESDMeasurement.addElement(OverallRgAzShiftElem);
        MetadataElement RgShiftPerBurstElem = new MetadataElement("Range_Shift_Per_Burst");
        RgShiftPerBurstElem.addElement(new MetadataElement(this.subSwathNames[0]));
        ESDMeasurement.addElement(RgShiftPerBurstElem);
        MetadataElement AzShiftPerOverlapElem = new MetadataElement("Azimuth_Shift_Per_Overlap");
        AzShiftPerOverlapElem.addElement(new MetadataElement(this.subSwathNames[0]));
        ESDMeasurement.addElement(AzShiftPerOverlapElem);
        MetadataElement AzShiftPerBlockElem = new MetadataElement("Azimuth_Shift_Per_Block");
        AzShiftPerBlockElem.addElement(new MetadataElement(this.subSwathNames[0]));
        ESDMeasurement.addElement(AzShiftPerBlockElem);
        absTgt.addElement(ESDMeasurement);
    }

    public void computeTileStack(Map<Band, Tile> targetTileMap, Rectangle targetRectangle, ProgressMonitor pm) throws OperatorException {
        int x0 = targetRectangle.x;
        int y0 = targetRectangle.y;
        int w = targetRectangle.width;
        int h = targetRectangle.height;
        try {
            if (!this.isRangeOffsetAvailable) {
                this.estimateRangeOffset();
            }
            if (!this.isAzimuthOffsetAvailable) {
                this.estimateAzimuthOffset();
            }
            for (String polarization : this.polarizations) {
                Band sBandI = this.getBand("_slv", "i_", this.swathIndexStr, polarization);
                Band sBandQ = this.getBand("_slv", "q_", this.swathIndexStr, polarization);
                this.performRangeAzimuthShift(x0, y0, w, h, sBandI, sBandQ, targetRectangle, targetTileMap);
            }
        }
        catch (Throwable e) {
            OperatorUtils.catchOperatorException((String)this.getId(), (Throwable)e);
        }
    }

    private synchronized void estimateRangeOffset() {
        if (this.isRangeOffsetAvailable) {
            return;
        }
        int numBursts = this.subSwath[this.subSwathIndex - 1].numOfBursts;
        final ArrayList azOffsetArray = new ArrayList(numBursts);
        final ArrayList<Double> rgOffsetArray = new ArrayList<Double>(numBursts);
        final ArrayList<Integer> burstIndexArray = new ArrayList<Integer>(numBursts);
        StatusProgressMonitor status = new StatusProgressMonitor(StatusProgressMonitor.TYPE.SUBTASK);
        status.beginTask("Estimating range offsets... ", numBursts);
        ThreadManager threadManager = new ThreadManager();
        try {
            final Band mBandI = this.getBand("_mst", "i_", this.swathIndexStr, this.polarizations[0]);
            final Band mBandQ = this.getBand("_mst", "q_", this.swathIndexStr, this.polarizations[0]);
            final Band sBandI = this.getBand("_slv", "i_", this.swathIndexStr, this.polarizations[0]);
            final Band sBandQ = this.getBand("_slv", "q_", this.swathIndexStr, this.polarizations[0]);
            int i = 0;
            while (i < numBursts) {
                this.checkForCancellation();
                final int burstIndex = i++;
                Thread worker = new Thread(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        try {
                            double[] offset = new double[2];
                            SpectralDiversityOp.this.estimateAzRgOffsets(mBandI, mBandQ, sBandI, sBandQ, burstIndex, offset);
                            List list = azOffsetArray;
                            synchronized (list) {
                                azOffsetArray.add(offset[0]);
                                rgOffsetArray.add(offset[1]);
                                burstIndexArray.add(burstIndex);
                            }
                        }
                        catch (Throwable e) {
                            OperatorUtils.catchOperatorException((String)"estimateOffset", (Throwable)e);
                        }
                    }
                };
                threadManager.add(worker);
                status.worked(1);
            }
            status.done();
            threadManager.finish();
            double sumAzOffset = 0.0;
            double sumRgOffset = 0.0;
            int count = 0;
            for (int i2 = 0; i2 < azOffsetArray.size(); ++i2) {
                double azShift = (Double)azOffsetArray.get(i2);
                double rgShift = (Double)rgOffsetArray.get(i2);
                SystemUtils.LOG.fine("RangeShiftOp: burst = " + burstIndexArray.get(i2) + ", range offset = " + rgShift + ", azimuth offset = " + azShift);
                if (azShift == this.noDataValue || rgShift == this.noDataValue || Math.abs(rgShift) > 1.0) continue;
                sumAzOffset += azShift;
                sumRgOffset += rgShift;
                ++count;
            }
            if (count <= 0) {
                throw new OperatorException("estimateOffset failed.");
            }
            this.azOffset = sumAzOffset / (double)count;
            this.rgOffset = sumRgOffset / (double)count;
            this.saveOverallRangeShift(this.rgOffset);
            this.saveRangeShiftPerBurst(rgOffsetArray, burstIndexArray);
            SystemUtils.LOG.fine("RangeShiftOp: whole image azimuth offset = " + this.azOffset);
            SystemUtils.LOG.fine("RangeShiftOp: Overall range shift = " + this.rgOffset);
        }
        catch (Throwable e) {
            OperatorUtils.catchOperatorException((String)"estimateOffset", (Throwable)e);
        }
        this.isRangeOffsetAvailable = true;
    }

    private void estimateAzRgOffsets(Band mBandI, Band mBandQ, Band sBandI, Band sBandQ, int burstIndex, double[] offset) {
        int burstHeight = this.subSwath[this.subSwathIndex - 1].linesPerBurst;
        int burstWidth = this.subSwath[this.subSwathIndex - 1].samplesPerBurst;
        int x0 = burstWidth / 2;
        int y0 = burstHeight / 2 + burstIndex * burstHeight;
        PixelPos mGCP = new PixelPos((double)x0, (double)y0);
        PixelPos sGCP = new PixelPos((double)x0, (double)y0);
        this.getFineOffsets(mBandI, mBandQ, sBandI, sBandQ, mGCP, sGCP, offset);
    }

    private void getFineOffsets(Band mBandI, Band mBandQ, Band sBandI, Band sBandQ, PixelPos mGCPPixelPos, PixelPos sGCPPixelPos, double[] offset) {
        try {
            ComplexDoubleMatrix mI = this.getComplexDoubleMatrix(mBandI, mBandQ, mGCPPixelPos, this.fineWinWidth, this.fineWinHeight);
            ComplexDoubleMatrix sI = this.getComplexDoubleMatrix(sBandI, sBandQ, sGCPPixelPos, this.fineWinWidth, this.fineWinHeight);
            double[] fineOffset = new double[]{0.0, 0.0};
            double coherence = CoregistrationUtils.crossCorrelateFFT((double[])fineOffset, (ComplexDoubleMatrix)mI, (ComplexDoubleMatrix)sI, (int)this.fineWinOvsFactor, (int)this.fineWinAccY, (int)this.fineWinAccX);
            if (coherence < this.xCorrThreshold) {
                offset[0] = this.noDataValue;
                offset[1] = this.noDataValue;
            } else {
                offset[0] = -fineOffset[0];
                offset[1] = -fineOffset[1];
            }
        }
        catch (Throwable e) {
            OperatorUtils.catchOperatorException((String)(this.getId() + " getFineOffsets "), (Throwable)e);
        }
    }

    private ComplexDoubleMatrix getComplexDoubleMatrix(Band band1, Band band2, PixelPos pixelPos, int fineWinWidth, int fineWinHeight) {
        Rectangle rectangle = SpectralDiversityOp.defineRectangleMask(pixelPos, fineWinWidth, fineWinHeight);
        Tile tileReal = this.getSourceTile((RasterDataNode)band1, rectangle);
        Tile tileImag = this.getSourceTile((RasterDataNode)band2, rectangle);
        return TileUtilsDoris.pullComplexDoubleMatrix((Tile)tileReal, (Tile)tileImag);
    }

    private static Rectangle defineRectangleMask(PixelPos pixelPos, int fineWinWidth, int fineWinHeight) {
        int l0 = (int)(pixelPos.y - (double)(fineWinHeight / 2));
        int lN = (int)(pixelPos.y + (double)(fineWinHeight / 2) - 1.0);
        int p0 = (int)(pixelPos.x - (double)(fineWinWidth / 2));
        int pN = (int)(pixelPos.x + (double)(fineWinWidth / 2) - 1.0);
        return new Rectangle(p0, l0, pN - p0 + 1, lN - l0 + 1);
    }

    private synchronized void estimateAzimuthOffset() {
        if (this.isAzimuthOffsetAvailable) {
            return;
        }
        int numOverlaps = this.subSwath[this.subSwathIndex - 1].numOfBursts - 1;
        int numShifts = numOverlaps * this.numBlocksPerOverlap;
        StatusProgressMonitor status = new StatusProgressMonitor(StatusProgressMonitor.TYPE.SUBTASK);
        status.beginTask("Estimating azimuth offset... ", numShifts);
        ThreadManager threadManager = new ThreadManager();
        try {
            final Band mBandI = this.getBand("_mst", "i_", this.swathIndexStr, this.polarizations[0]);
            final Band mBandQ = this.getBand("_mst", "q_", this.swathIndexStr, this.polarizations[0]);
            final Band sBandI = this.getBand("_slv", "i_", this.swathIndexStr, this.polarizations[0]);
            final Band sBandQ = this.getBand("_slv", "q_", this.swathIndexStr, this.polarizations[0]);
            final double spectralSeparation = this.computeSpectralSeparation();
            final ArrayList<AzimuthShiftData> azShiftArray = new ArrayList<AzimuthShiftData>(numShifts);
            for (int i = 0; i < numOverlaps; ++i) {
                Rectangle overlapInBurstOneRectangle = new Rectangle();
                Rectangle overlapInBurstTwoRectangle = new Rectangle();
                this.getOverlappedRectangles(i, overlapInBurstOneRectangle, overlapInBurstTwoRectangle);
                final double[][] coherence = this.computeCoherence(overlapInBurstOneRectangle, mBandI, mBandQ, sBandI, sBandQ, 5);
                final int w = overlapInBurstOneRectangle.width / this.numBlocksPerOverlap;
                final int h = overlapInBurstOneRectangle.height;
                int x0BurstOne = overlapInBurstOneRectangle.x;
                final int y0BurstOne = overlapInBurstOneRectangle.y;
                final int y0BurstTwo = overlapInBurstTwoRectangle.y;
                final int overlapIndex = i;
                int j = 0;
                while (j < this.numBlocksPerOverlap) {
                    this.checkForCancellation();
                    final int x0 = x0BurstOne + j * w;
                    final int blockIndex = j++;
                    Thread worker = new Thread(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            try {
                                Rectangle blockInBurstOneRectangle = new Rectangle(x0, y0BurstOne, w, h);
                                Rectangle blockInBurstTwoRectangle = new Rectangle(x0, y0BurstTwo, w, h);
                                double[] blockCoherence = SpectralDiversityOp.getBlockCoherence(blockIndex, w, h, coherence);
                                double azShift = SpectralDiversityOp.this.estimateAzOffsets(mBandI, mBandQ, sBandI, sBandQ, blockCoherence, blockInBurstTwoRectangle, blockInBurstOneRectangle, spectralSeparation);
                                List list = azShiftArray;
                                synchronized (list) {
                                    azShiftArray.add(new AzimuthShiftData(overlapIndex, blockIndex, azShift));
                                }
                            }
                            catch (Throwable e) {
                                OperatorUtils.catchOperatorException((String)"estimateOffset", (Throwable)e);
                            }
                        }
                    };
                    threadManager.add(worker);
                    status.worked(1);
                }
            }
            status.done();
            threadManager.finish();
            double[] averagedAzShiftArray = new double[numOverlaps];
            double totalOffset = 0.0;
            for (int i = 0; i < numOverlaps; ++i) {
                double sumAzOffset = 0.0;
                for (int j = 0; j < numShifts; ++j) {
                    if (((AzimuthShiftData)azShiftArray.get((int)j)).overlapIndex != i) continue;
                    sumAzOffset += ((AzimuthShiftData)azShiftArray.get((int)j)).shift;
                }
                averagedAzShiftArray[i] = sumAzOffset / (double)this.numBlocksPerOverlap;
                totalOffset += sumAzOffset;
                SystemUtils.LOG.fine("AzimuthShiftOp: overlap area = " + i + ", azimuth offset = " + averagedAzShiftArray[i]);
            }
            this.azOffset = -totalOffset / (double)numShifts;
            SystemUtils.LOG.fine("AzimuthShiftOp: Overall azimuth shift = " + this.azOffset);
            this.saveOverallAzimuthShift(this.azOffset);
            this.saveAzimuthShiftPerOverlap(averagedAzShiftArray);
            this.saveAzimuthShiftPerBlock(azShiftArray);
        }
        catch (Throwable e) {
            OperatorUtils.catchOperatorException((String)"estimateAzimuthOffset", (Throwable)e);
        }
        this.isAzimuthOffsetAvailable = true;
    }

    private double computeSpectralSeparation() {
        double tCycle = (double)this.subSwath[this.subSwathIndex - 1].linesPerBurst * this.subSwath[this.subSwathIndex - 1].azimuthTimeInterval;
        double sumSpectralSeparation = 0.0;
        for (int b = 0; b < this.subSwath[this.subSwathIndex - 1].numOfBursts; ++b) {
            for (int p = 0; p < this.subSwath[this.subSwathIndex - 1].samplesPerBurst; ++p) {
                sumSpectralSeparation += this.subSwath[this.subSwathIndex - 1].dopplerRate[b][p] * tCycle;
            }
        }
        return sumSpectralSeparation / (double)(this.subSwath[this.subSwathIndex - 1].numOfBursts * this.subSwath[this.subSwathIndex - 1].samplesPerBurst);
    }

    private void getOverlappedRectangles(int overlapIndex, Rectangle overlapInBurstOneRectangle, Rectangle overlapInBurstTwoRectangle) {
        int firstValidPixelOfBurstOne = this.getBurstFirstValidPixel(overlapIndex);
        int lastValidPixelOfBurstOne = this.getBurstLastValidPixel(overlapIndex);
        int firstValidPixelOfBurstTwo = this.getBurstFirstValidPixel(overlapIndex + 1);
        int lastValidPixelOfBurstTwo = this.getBurstLastValidPixel(overlapIndex + 1);
        int firstValidPixel = Math.max(firstValidPixelOfBurstOne, firstValidPixelOfBurstTwo);
        int lastValidPixel = Math.min(lastValidPixelOfBurstOne, lastValidPixelOfBurstTwo);
        int x0 = firstValidPixel;
        int w = lastValidPixel - firstValidPixel + 1;
        int numOfInvalidLinesInBurstOne = this.subSwath[this.subSwathIndex - 1].linesPerBurst - this.subSwath[this.subSwathIndex - 1].lastValidLine[overlapIndex] - 1;
        int numOfInvalidLinesInBurstTwo = this.subSwath[this.subSwathIndex - 1].firstValidLine[overlapIndex + 1];
        int numOverlappedLines = this.computeBurstOverlapSize(overlapIndex);
        int h = numOverlappedLines - numOfInvalidLinesInBurstOne - numOfInvalidLinesInBurstTwo;
        int y0BurstOne = this.subSwath[this.subSwathIndex - 1].linesPerBurst * (overlapIndex + 1) - numOfInvalidLinesInBurstOne - h;
        int y0BurstTwo = this.subSwath[this.subSwathIndex - 1].linesPerBurst * (overlapIndex + 1) + numOfInvalidLinesInBurstTwo;
        overlapInBurstOneRectangle.setBounds(x0, y0BurstOne, w, h);
        overlapInBurstTwoRectangle.setBounds(x0, y0BurstTwo, w, h);
    }

    private int getBurstFirstValidPixel(int burstIndex) {
        for (int lineIdx = 0; lineIdx < this.subSwath[this.subSwathIndex - 1].firstValidSample[burstIndex].length; ++lineIdx) {
            if (this.subSwath[this.subSwathIndex - 1].firstValidSample[burstIndex][lineIdx] == -1) continue;
            return this.subSwath[this.subSwathIndex - 1].firstValidSample[burstIndex][lineIdx];
        }
        return -1;
    }

    private int getBurstLastValidPixel(int burstIndex) {
        for (int lineIdx = 0; lineIdx < this.subSwath[this.subSwathIndex - 1].lastValidSample[burstIndex].length; ++lineIdx) {
            if (this.subSwath[this.subSwathIndex - 1].lastValidSample[burstIndex][lineIdx] == -1) continue;
            return this.subSwath[this.subSwathIndex - 1].lastValidSample[burstIndex][lineIdx];
        }
        return -1;
    }

    private static double[] getBlockCoherence(int blockIndex, int blockWidth, int blockHeight, double[][] coherence) {
        double[] blockCoherence = new double[blockWidth * blockHeight];
        for (int i = 0; i < blockCoherence.length; ++i) {
            int r = i / blockWidth;
            int c = blockIndex * blockWidth + i - r * blockWidth;
            blockCoherence[i] = coherence[r][c];
        }
        return blockCoherence;
    }

    private void saveOverallRangeShift(double rangeShift) {
        MetadataElement absTgt = AbstractMetadata.getAbstractedMetadata((Product)this.targetProduct);
        if (absTgt == null) {
            return;
        }
        MetadataElement ESDMeasurement = absTgt.getElement("ESD Measurement");
        MetadataElement OverallRgAzShiftElem = ESDMeasurement.getElement("Overall_Range_Azimuth_Shift");
        MetadataElement swathElem = OverallRgAzShiftElem.getElement(this.subSwathNames[0]);
        MetadataAttribute rangeShiftAttr = new MetadataAttribute("rangeShift", 30);
        rangeShiftAttr.setUnit("pixel");
        swathElem.addAttribute(rangeShiftAttr);
        swathElem.setAttributeDouble("rangeShift", rangeShift);
    }

    private void saveOverallAzimuthShift(double azimuthShift) {
        MetadataElement absTgt = AbstractMetadata.getAbstractedMetadata((Product)this.targetProduct);
        if (absTgt == null) {
            return;
        }
        MetadataElement ESDMeasurement = absTgt.getElement("ESD Measurement");
        MetadataElement OverallRgAzShiftElem = ESDMeasurement.getElement("Overall_Range_Azimuth_Shift");
        MetadataElement swathElem = OverallRgAzShiftElem.getElement(this.subSwathNames[0]);
        MetadataAttribute azimuthShiftAttr = new MetadataAttribute("azimuthShift", 30);
        azimuthShiftAttr.setUnit("pixel");
        swathElem.addAttribute(azimuthShiftAttr);
        swathElem.setAttributeDouble("azimuthShift", azimuthShift);
    }

    private void saveRangeShiftPerBurst(List<Double> rangeShiftArray, List<Integer> burstIndexArray) {
        MetadataElement absTgt = AbstractMetadata.getAbstractedMetadata((Product)this.targetProduct);
        if (absTgt == null) {
            return;
        }
        MetadataElement ESDMeasurement = absTgt.getElement("ESD Measurement");
        MetadataElement RangeShiftPerBurstElem = ESDMeasurement.getElement("Range_Shift_Per_Burst");
        MetadataElement swathElem = RangeShiftPerBurstElem.getElement(this.subSwathNames[0]);
        swathElem.addAttribute(new MetadataAttribute("count", 11));
        swathElem.setAttributeInt("count", rangeShiftArray.size());
        for (int i = 0; i < rangeShiftArray.size(); ++i) {
            MetadataElement burstListElem = new MetadataElement("RangeShiftList." + i);
            MetadataAttribute rangeShiftAttr = new MetadataAttribute("rangeShift", 30);
            rangeShiftAttr.setUnit("pixel");
            burstListElem.addAttribute(rangeShiftAttr);
            burstListElem.setAttributeDouble("rangeShift", rangeShiftArray.get(i).doubleValue());
            burstListElem.addAttribute(new MetadataAttribute("burstIndex", 11));
            burstListElem.setAttributeInt("burstIndex", burstIndexArray.get(i).intValue());
            swathElem.addElement(burstListElem);
        }
    }

    private void saveAzimuthShiftPerOverlap(double[] averagedAzShiftArray) {
        MetadataElement absTgt = AbstractMetadata.getAbstractedMetadata((Product)this.targetProduct);
        if (absTgt == null) {
            return;
        }
        MetadataElement ESDMeasurement = absTgt.getElement("ESD Measurement");
        MetadataElement AzShiftPerOverlapElem = ESDMeasurement.getElement("Azimuth_Shift_Per_Overlap");
        MetadataElement swathElem = AzShiftPerOverlapElem.getElement(this.subSwathNames[0]);
        swathElem.addAttribute(new MetadataAttribute("count", 11));
        swathElem.setAttributeInt("count", averagedAzShiftArray.length);
        for (int i = 0; i < averagedAzShiftArray.length; ++i) {
            MetadataElement overlapListElem = new MetadataElement("AzimuthShiftList." + i);
            MetadataAttribute azimuthShiftAttr = new MetadataAttribute("azimuthShift", 30);
            azimuthShiftAttr.setUnit("pixel");
            overlapListElem.addAttribute(azimuthShiftAttr);
            overlapListElem.setAttributeDouble("azimuthShift", averagedAzShiftArray[i]);
            overlapListElem.addAttribute(new MetadataAttribute("overlapIndex", 11));
            overlapListElem.setAttributeInt("overlapIndex", i);
            swathElem.addElement(overlapListElem);
        }
    }

    private void saveAzimuthShiftPerBlock(List<AzimuthShiftData> azShiftArray) {
        MetadataElement absTgt = AbstractMetadata.getAbstractedMetadata((Product)this.targetProduct);
        if (absTgt == null) {
            return;
        }
        MetadataElement ESDMeasurement = absTgt.getElement("ESD Measurement");
        MetadataElement AzShiftPerBlockElem = ESDMeasurement.getElement("Azimuth_Shift_Per_Block");
        MetadataElement swathElem = AzShiftPerBlockElem.getElement(this.subSwathNames[0]);
        swathElem.addAttribute(new MetadataAttribute("count", 11));
        swathElem.setAttributeInt("count", azShiftArray.size());
        for (int i = 0; i < azShiftArray.size(); ++i) {
            MetadataElement overlapListElem = new MetadataElement("AzimuthShiftList." + i);
            MetadataAttribute azimuthShiftAttr = new MetadataAttribute("azimuthShift", 30);
            azimuthShiftAttr.setUnit("pixel");
            overlapListElem.addAttribute(azimuthShiftAttr);
            overlapListElem.setAttributeDouble("azimuthShift", azShiftArray.get((int)i).shift);
            overlapListElem.addAttribute(new MetadataAttribute("overlapIndex", 11));
            overlapListElem.setAttributeInt("overlapIndex", azShiftArray.get((int)i).overlapIndex);
            overlapListElem.addAttribute(new MetadataAttribute("blockIndex", 11));
            overlapListElem.setAttributeInt("blockIndex", azShiftArray.get((int)i).blockIndex);
            swathElem.addElement(overlapListElem);
        }
    }

    private int computeBurstOverlapSize(int overlapIndex) {
        double endTime = this.subSwath[this.subSwathIndex - 1].burstLastLineTime[overlapIndex];
        double startTime = this.subSwath[this.subSwathIndex - 1].burstFirstLineTime[overlapIndex + 1];
        return (int)((endTime - startTime) / this.subSwath[this.subSwathIndex - 1].azimuthTimeInterval);
    }

    private double estimateAzOffsets(Band mBandI, Band mBandQ, Band sBandI, Band sBandQ, double[] blockCoherence, Rectangle backwardRectangle, Rectangle forwardRectangle, double spectralSeparation) {
        double[] mIBackArray = this.getSourceData(mBandI, backwardRectangle);
        double[] mQBackArray = this.getSourceData(mBandQ, backwardRectangle);
        double[] sIBackArray = this.getSourceData(sBandI, backwardRectangle);
        double[] sQBackArray = this.getSourceData(sBandQ, backwardRectangle);
        double[] mIForArray = this.getSourceData(mBandI, forwardRectangle);
        double[] mQForArray = this.getSourceData(mBandQ, forwardRectangle);
        double[] sIForArray = this.getSourceData(sBandI, forwardRectangle);
        double[] sQForArray = this.getSourceData(sBandQ, forwardRectangle);
        int arrayLength = mIBackArray.length;
        double[] backIntReal = new double[arrayLength];
        double[] backIntImag = new double[arrayLength];
        SpectralDiversityOp.complexArrayMultiplication(mIBackArray, mQBackArray, sIBackArray, sQBackArray, backIntReal, backIntImag);
        double[] forIntReal = new double[arrayLength];
        double[] forIntImag = new double[arrayLength];
        SpectralDiversityOp.complexArrayMultiplication(mIForArray, mQForArray, sIForArray, sQForArray, forIntReal, forIntImag);
        double[] diffIntReal = new double[arrayLength];
        double[] diffIntImag = new double[arrayLength];
        SpectralDiversityOp.complexArrayMultiplication(forIntReal, forIntImag, backIntReal, backIntImag, diffIntReal, diffIntImag);
        double sumReal = 0.0;
        double sumImag = 0.0;
        for (int i = 0; i < arrayLength; ++i) {
            if (!(blockCoherence[i] > this.cohThreshold)) continue;
            double theta = Math.atan2(diffIntImag[i], diffIntReal[i]);
            sumReal += FastMath.cos((double)theta);
            sumImag += FastMath.sin((double)theta);
        }
        double phase = Math.atan2(sumImag, sumReal);
        return phase / (Math.PI * 2 * spectralSeparation * this.subSwath[this.subSwathIndex - 1].azimuthTimeInterval);
    }

    private double[] getSourceData(Band srcBand, Rectangle rectangle) {
        double[] dataArray;
        int dataType = srcBand.getDataType();
        Tile srcTile = this.getSourceTile((RasterDataNode)srcBand, rectangle);
        if (dataType == 11) {
            short[] dataArrayShort = (short[])srcTile.getDataBuffer().getElems();
            dataArray = new double[dataArrayShort.length];
            for (int i = 0; i < dataArrayShort.length; ++i) {
                dataArray[i] = dataArrayShort[i];
            }
        } else if (dataType == 30) {
            float[] dataArrayFloat = (float[])srcTile.getDataBuffer().getElems();
            dataArray = new double[dataArrayFloat.length];
            for (int i = 0; i < dataArrayFloat.length; ++i) {
                dataArray[i] = dataArrayFloat[i];
            }
        } else {
            dataArray = (double[])srcTile.getDataBuffer().getElems();
        }
        return dataArray;
    }

    private static void complexArrayMultiplication(double[] realArray1, double[] imagArray1, double[] realArray2, double[] imagArray2, double[] realOutput, double[] imagOutput) {
        int arrayLength = realArray1.length;
        if (imagArray1.length != arrayLength || realArray2.length != arrayLength || imagArray2.length != arrayLength || realOutput.length != arrayLength || imagOutput.length != arrayLength) {
            throw new OperatorException("Arrays of the same length are expected.");
        }
        for (int i = 0; i < arrayLength; ++i) {
            realOutput[i] = realArray1[i] * realArray2[i] + imagArray1[i] * imagArray2[i];
            imagOutput[i] = imagArray1[i] * realArray2[i] - realArray1[i] * imagArray2[i];
        }
    }

    private Band getBand(String suffix, String prefix, String swathIndexStr, String polarization) {
        String[] bandNames;
        for (String bandName : bandNames = this.sourceProduct.getBandNames()) {
            if (!bandName.contains(suffix) || !bandName.contains(prefix) || !bandName.contains(swathIndexStr) || !bandName.contains(polarization)) continue;
            return this.sourceProduct.getBand(bandName);
        }
        return null;
    }

    private static void computeShiftPhaseArray(double shift, int signalLength, double[] phaseArray) {
        double phase = Math.PI * -2 * shift / (double)signalLength;
        int halfSignalLength = (int)((double)signalLength * 0.5 + 0.5);
        for (int k = 0; k < signalLength; ++k) {
            double phaseK = k < halfSignalLength ? phase * (double)k : phase * (double)(k - signalLength);
            int k2 = k * 2;
            phaseArray[k2] = FastMath.cos((double)phaseK);
            phaseArray[k2 + 1] = FastMath.sin((double)phaseK);
        }
    }

    private static void multiplySpectrumByShiftFactor(double[] array, double[] phaseArray) {
        int signalLength = array.length / 2;
        for (int k = 0; k < signalLength; ++k) {
            int k2 = k * 2;
            double c = phaseArray[k2];
            double s = phaseArray[k2 + 1];
            double real = array[k2];
            double imag = array[k2 + 1];
            array[k2] = real * c - imag * s;
            array[k2 + 1] = real * s + imag * c;
        }
    }

    private double[][] computeCoherence(Rectangle rectangle, Band mBandI, Band mBandQ, Band sBandI, Band sBandQ, int cohWin) {
        int x;
        int yy;
        int y;
        int x0 = rectangle.x;
        int y0 = rectangle.y;
        int w = rectangle.width;
        int h = rectangle.height;
        int xMax = x0 + w;
        int yMax = y0 + h;
        int halfWindowSize = cohWin / 2;
        double[][] coherence = new double[h][w];
        Tile mstTileI = this.getSourceTile((RasterDataNode)mBandI, rectangle);
        Tile mstTileQ = this.getSourceTile((RasterDataNode)mBandQ, rectangle);
        ProductData mstDataBufferI = mstTileI.getDataBuffer();
        ProductData mstDataBufferQ = mstTileQ.getDataBuffer();
        Tile slvTileI = this.getSourceTile((RasterDataNode)sBandI, rectangle);
        Tile slvTileQ = this.getSourceTile((RasterDataNode)sBandQ, rectangle);
        ProductData slvDataBufferI = slvTileI.getDataBuffer();
        ProductData slvDataBufferQ = slvTileQ.getDataBuffer();
        TileIndex srcIndex = new TileIndex(mstTileI);
        double[][] cohReal = new double[h][w];
        double[][] cohImag = new double[h][w];
        double[][] mstPower = new double[h][w];
        double[][] slvPower = new double[h][w];
        for (y = y0; y < yMax; ++y) {
            srcIndex.calculateStride(y);
            yy = y - y0;
            for (x = x0; x < xMax; ++x) {
                int srcIdx = srcIndex.getIndex(x);
                int xx = x - x0;
                float mI = mstDataBufferI.getElemFloatAt(srcIdx);
                float mQ = mstDataBufferQ.getElemFloatAt(srcIdx);
                float sI = slvDataBufferI.getElemFloatAt(srcIdx);
                float sQ = slvDataBufferQ.getElemFloatAt(srcIdx);
                cohReal[yy][xx] = mI * sI + mQ * sQ;
                cohImag[yy][xx] = mQ * sI - mI * sQ;
                mstPower[yy][xx] = mI * mI + mQ * mQ;
                slvPower[yy][xx] = sI * sI + sQ * sQ;
            }
        }
        for (y = y0; y < yMax; ++y) {
            yy = y - y0;
            for (x = x0; x < xMax; ++x) {
                int xx = x - x0;
                int rowSt = Math.max(yy - halfWindowSize, 0);
                int rowEd = Math.min(yy + halfWindowSize, h - 1);
                int colSt = Math.max(xx - halfWindowSize, 0);
                int colEd = Math.min(xx + halfWindowSize, w - 1);
                double cohRealSum = 0.0;
                double cohImagSum = 0.0;
                double mstPowerSum = 0.0;
                double slvPowerSum = 0.0;
                int count = 0;
                for (int r = rowSt; r <= rowEd; ++r) {
                    for (int c = colSt; c <= colEd; ++c) {
                        cohRealSum += cohReal[r][c];
                        cohImagSum += cohImag[r][c];
                        mstPowerSum += mstPower[r][c];
                        slvPowerSum += slvPower[r][c];
                        ++count;
                    }
                }
                if (count <= 0 || mstPowerSum == 0.0 || slvPowerSum == 0.0) continue;
                double cohRealMean = cohRealSum / (double)count;
                double cohImagMean = cohImagSum / (double)count;
                double mstPowerMean = mstPowerSum / (double)count;
                double slvPowerMean = slvPowerSum / (double)count;
                coherence[yy][xx] = Math.sqrt((cohRealMean * cohRealMean + cohImagMean * cohImagMean) / (mstPowerMean * slvPowerMean));
            }
        }
        return coherence;
    }

    private void performRangeAzimuthShift(int x0, int y0, int w, int h, Band slvBandI, Band slvBandQ, Rectangle targetRectangle, Map<Band, Tile> targetTileMap) {
        float noDataValue = (float)slvBandI.getNoDataValue();
        Tile slvTileI = this.getSourceTile((RasterDataNode)slvBandI, targetRectangle);
        Tile slvTileQ = this.getSourceTile((RasterDataNode)slvBandQ, targetRectangle);
        float[] slvArrayI = (float[])slvTileI.getDataBuffer().getElems();
        float[] slvArrayQ = (float[])slvTileQ.getDataBuffer().getElems();
        double[] line = new double[2 * w];
        double[] phaseRg = new double[2 * w];
        DoubleFFT_1D row_fft = new DoubleFFT_1D(w);
        double[][] rangeShiftedI = new double[h][w];
        double[][] rangeShiftedQ = new double[h][w];
        SpectralDiversityOp.computeShiftPhaseArray(this.rgOffset, w, phaseRg);
        for (int r = 0; r < h; ++r) {
            int c2;
            int c;
            int rw = r * w;
            for (c = 0; c < w; ++c) {
                c2 = c * 2;
                line[c2] = slvArrayI[rw + c];
                line[c2 + 1] = slvArrayQ[rw + c];
            }
            row_fft.complexForward(line);
            SpectralDiversityOp.multiplySpectrumByShiftFactor(line, phaseRg);
            row_fft.complexInverse(line, true);
            for (c = 0; c < w; ++c) {
                c2 = c * 2;
                rangeShiftedI[r][c] = line[c2];
                rangeShiftedQ[r][c] = line[c2 + 1];
            }
        }
        double[] derampDemodPhase = this.getSourceData(this.derampDemodPhaseBand, targetRectangle);
        double[][] derampDemodI = new double[h][w];
        double[][] derampDemodQ = new double[h][w];
        for (int r = 0; r < h; ++r) {
            int rw = r * w;
            for (int c = 0; c < w; ++c) {
                double cosPhase = FastMath.cos((double)derampDemodPhase[rw + c]);
                double sinPhase = FastMath.sin((double)derampDemodPhase[rw + c]);
                derampDemodI[r][c] = rangeShiftedI[r][c] * cosPhase - rangeShiftedQ[r][c] * sinPhase;
                derampDemodQ[r][c] = rangeShiftedI[r][c] * sinPhase + rangeShiftedQ[r][c] * cosPhase;
            }
        }
        double[] phaseAz = new double[2 * h];
        SpectralDiversityOp.computeShiftPhaseArray(this.azOffset, h, phaseAz);
        Band tgtBandI = this.targetProduct.getBand(slvBandI.getName());
        Band tgtBandQ = this.targetProduct.getBand(slvBandQ.getName());
        Tile tgtTileI = targetTileMap.get(tgtBandI);
        Tile tgtTileQ = targetTileMap.get(tgtBandQ);
        ProductData tgtDataI = tgtTileI.getDataBuffer();
        ProductData tgtDataQ = tgtTileQ.getDataBuffer();
        double[] col1 = new double[2 * h];
        double[] col2 = new double[2 * h];
        DoubleFFT_1D col_fft = new DoubleFFT_1D(h);
        for (int c = 0; c < w; ++c) {
            int r2;
            int r;
            int x = x0 + c;
            for (r = 0; r < h; ++r) {
                r2 = r * 2;
                col1[r2] = derampDemodI[r][c];
                col1[r2 + 1] = derampDemodQ[r][c];
                col2[r2] = derampDemodPhase[r * w + c];
                col2[r2 + 1] = 0.0;
            }
            col_fft.complexForward(col1);
            col_fft.complexForward(col2);
            SpectralDiversityOp.multiplySpectrumByShiftFactor(col1, phaseAz);
            SpectralDiversityOp.multiplySpectrumByShiftFactor(col2, phaseAz);
            col_fft.complexInverse(col1, true);
            col_fft.complexInverse(col2, true);
            for (r = 0; r < h; ++r) {
                if (slvArrayI[r * w + c] == noDataValue) continue;
                r2 = r * 2;
                int y = y0 + r;
                double cosPhase = FastMath.cos((double)col2[r2]);
                double sinPhase = FastMath.sin((double)col2[r2]);
                int idx = tgtTileI.getDataBufferIndex(x, y);
                tgtDataI.setElemDoubleAt(idx, col1[r2] * cosPhase + col1[r2 + 1] * sinPhase);
                tgtDataQ.setElemDoubleAt(idx, -col1[r2] * sinPhase + col1[r2 + 1] * cosPhase);
            }
        }
    }

    public static class Spi
    extends OperatorSpi {
        public Spi() {
            super(SpectralDiversityOp.class);
        }
    }

    private static class AzimuthShiftData {
        int overlapIndex;
        int blockIndex;
        double shift;

        public AzimuthShiftData(int overlapIndex, int blockIndex, double shift) {
            this.overlapIndex = overlapIndex;
            this.blockIndex = blockIndex;
            this.shift = shift;
        }
    }
}

