/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s1tbx.sentinel1.gpf;

import com.bc.ceres.core.ProgressMonitor;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.esa.s1tbx.insar.gpf.support.Sentinel1Utils;
import org.esa.s1tbx.io.sentinel1.Sentinel1Level1Directory;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.GeoCoding;
import org.esa.snap.core.datamodel.GeoPos;
import org.esa.snap.core.datamodel.MetadataAttribute;
import org.esa.snap.core.datamodel.MetadataElement;
import org.esa.snap.core.datamodel.PixelPos;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.datamodel.TiePointGeoCoding;
import org.esa.snap.core.datamodel.TiePointGrid;
import org.esa.snap.core.datamodel.VirtualBand;
import org.esa.snap.core.dataop.barithm.BandArithmetic;
import org.esa.snap.core.dataop.barithm.RasterDataSymbol;
import org.esa.snap.core.gpf.Operator;
import org.esa.snap.core.gpf.OperatorException;
import org.esa.snap.core.gpf.OperatorSpi;
import org.esa.snap.core.gpf.Tile;
import org.esa.snap.core.gpf.annotations.OperatorMetadata;
import org.esa.snap.core.gpf.annotations.Parameter;
import org.esa.snap.core.gpf.annotations.SourceProducts;
import org.esa.snap.core.gpf.annotations.TargetProduct;
import org.esa.snap.core.jexp.Namespace;
import org.esa.snap.core.jexp.ParseException;
import org.esa.snap.core.jexp.Term;
import org.esa.snap.core.jexp.WritableNamespace;
import org.esa.snap.core.jexp.impl.ParserImpl;
import org.esa.snap.core.util.ProductUtils;
import org.esa.snap.core.util.SystemUtils;
import org.esa.snap.engine_utilities.datamodel.AbstractMetadata;
import org.esa.snap.engine_utilities.datamodel.OrbitStateVector;
import org.esa.snap.engine_utilities.gpf.InputProductValidator;
import org.esa.snap.engine_utilities.gpf.OperatorUtils;
import org.esa.snap.engine_utilities.gpf.ReaderUtils;
import org.esa.snap.engine_utilities.gpf.TileIndex;

@OperatorMetadata(alias="SliceAssembly", category="Radar/Sentinel-1 TOPS", authors="Jun Lu, Luis Veci", version="1.0", copyright="Copyright (C) 2014 by Array Systems Computing Inc.", description="Merges Sentinel-1 slice products")
public final class SliceAssemblyOp
extends Operator {
    @SourceProducts
    private Product[] sourceProducts;
    @TargetProduct
    private Product targetProduct;
    @Parameter(description="The list of polarisations", label="Polarisations")
    private String[] selectedPolarisations;
    private MetadataElement absRoot = null;
    private Product[] sliceProducts;
    private Map<Band, BandLines[]> bandLineMap = new HashMap<Band, BandLines[]>();
    private int targetWidth = 0;
    private int targetHeight = 0;
    private Map<String, int[]> swathAssembledImageDimMap = new HashMap<String, int[]>();
    private Map<Product, Map<String, int[]>> sliceSwathImageDimMap = new HashMap<Product, Map<String, int[]>>();
    private Map<String, TiePointGeoCoding> swathGeocodingMap = new HashMap<String, TiePointGeoCoding>();
    private static final String PRODUCT_SUFFIX = "_Asm";

    public void initialize() throws OperatorException {
        try {
            for (Product srcProduct : this.sourceProducts) {
                InputProductValidator validator = new InputProductValidator(srcProduct);
                validator.checkIfSARProduct();
                validator.checkIfSentinel1Product();
                validator.checkProductType(new String[]{"SLC", "GRD"});
                validator.checkAcquisitionMode(new String[]{"SM", "IW", "EW"});
            }
            this.sliceProducts = this.determineSliceProducts();
            this.absRoot = AbstractMetadata.getAbstractedMetadata((Product)this.sliceProducts[0]);
            if (this.selectedPolarisations == null || this.selectedPolarisations.length == 0) {
                Sentinel1Utils su = new Sentinel1Utils(this.sliceProducts[0]);
                this.selectedPolarisations = su.getPolarizations();
            }
            this.checkSlantRangeTimes();
            this.createTargetProduct();
            this.updateTargetProductMetadata();
            this.determineBandStartEndTimes();
        }
        catch (Throwable e) {
            OperatorUtils.catchOperatorException((String)this.getId(), (Throwable)e);
        }
    }

    private Product[] determineSliceProducts() throws Exception {
        if (this.sourceProducts.length < 2) {
            throw new Exception("Slice assembly requires at least two consecutive slice products");
        }
        TreeMap<Integer, Product> productSet = new TreeMap<Integer, Product>();
        for (Product srcProduct : this.sourceProducts) {
            MetadataElement origMetaRoot = AbstractMetadata.getOriginalProductMetadata((Product)srcProduct);
            MetadataElement generalProductInformation = SliceAssemblyOp.getGeneralProductInformation(origMetaRoot);
            if (!SliceAssemblyOp.isSliceProduct(generalProductInformation)) {
                throw new Exception(srcProduct.getName() + " is not a slice product");
            }
            int sliceNumber = generalProductInformation.getAttributeInt("sliceNumber");
            productSet.put(sliceNumber, srcProduct);
        }
        Integer prev = (Integer)productSet.firstKey();
        for (Integer i : productSet.keySet()) {
            if (i.equals(prev)) continue;
            if (!prev.equals(i - 1)) {
                throw new Exception("Products are not consecutive slices");
            }
            prev = i;
        }
        return productSet.values().toArray(new Product[productSet.size()]);
    }

    private static MetadataElement getGeneralProductInformation(MetadataElement origMetaRoot) {
        MetadataElement XFDU = origMetaRoot.getElement("XFDU");
        MetadataElement metadataSection = XFDU.getElement("metadataSection");
        MetadataElement metadataObject = SliceAssemblyOp.findElementByID(metadataSection, "ID", "generalProductInformation");
        MetadataElement metadataWrap = metadataObject.getElement("metadataWrap");
        MetadataElement xmlData = metadataWrap.getElement("xmlData");
        MetadataElement generalProductInformation = xmlData.getElement("generalProductInformation");
        if (generalProductInformation == null) {
            generalProductInformation = xmlData.getElement("standAloneProductInformation");
        }
        return generalProductInformation;
    }

    private static boolean isSliceProduct(MetadataElement generalProductInformation) {
        String sliceProductFlag = generalProductInformation.getAttributeString("sliceProductFlag");
        return sliceProductFlag.equals("true");
    }

    private static MetadataElement findElementByID(MetadataElement metadataSection, String tag, String id) {
        MetadataElement[] metadataObjectList;
        for (MetadataElement metadataObject : metadataObjectList = metadataSection.getElements()) {
            String attrib = metadataObject.getAttributeString(tag, null);
            if (!attrib.equals(id)) continue;
            return metadataObject;
        }
        return null;
    }

    private static String extractSwathIdentifier(String mdsName) {
        String swathID = mdsName.substring(4, 7);
        if (swathID.endsWith("-")) {
            swathID = swathID.substring(0, swathID.length() - 1);
        }
        return swathID;
    }

    private static double getSlantRangeTime(Product product, String sss) {
        MetadataElement origProdRoot = AbstractMetadata.getOriginalProductMetadata((Product)product);
        MetadataElement annotation = origProdRoot.getElement("annotation");
        MetadataElement[] annotationElems = annotation.getElements();
        double slantRangeTime = 0.0;
        for (MetadataElement e : annotationElems) {
            if (!SliceAssemblyOp.extractSwathIdentifier(e.getName()).equals(sss)) continue;
            MetadataElement prod = e.getElement("product");
            MetadataElement imgAnno = prod.getElement("imageAnnotation");
            MetadataElement imgInfo = imgAnno.getElement("imageInformation");
            slantRangeTime = imgInfo.getAttributeDouble("slantRangeTime");
            break;
        }
        return slantRangeTime;
    }

    private void checkSlantRangeTimes() {
        MetadataElement[] annotationElems;
        Product firstSliceProduct = this.sliceProducts[0];
        MetadataElement origProdRoot = AbstractMetadata.getOriginalProductMetadata((Product)firstSliceProduct);
        MetadataElement annotation = origProdRoot.getElement("annotation");
        for (MetadataElement e : annotationElems = annotation.getElements()) {
            String swathID = SliceAssemblyOp.extractSwathIdentifier(e.getName());
            double slantRangeTime = SliceAssemblyOp.getSlantRangeTime(firstSliceProduct, swathID);
            for (int i = 1; i < this.sliceProducts.length; ++i) {
                double srt = SliceAssemblyOp.getSlantRangeTime(this.sliceProducts[i], swathID);
                if (!(Math.abs(slantRangeTime - srt) > 1.0E-8)) continue;
                SystemUtils.LOG.warning("Slant range time don't agree: " + i + ' ' + swathID);
            }
        }
    }

    private static ArrayList<String> getSwaths(Product product) {
        MetadataElement[] annotationElems;
        ArrayList<String> swaths = new ArrayList<String>();
        MetadataElement origProdRoot = AbstractMetadata.getOriginalProductMetadata((Product)product);
        MetadataElement annotation = origProdRoot.getElement("annotation");
        for (MetadataElement e : annotationElems = annotation.getElements()) {
            String sss = SliceAssemblyOp.extractSwathIdentifier(e.getName()).toUpperCase();
            if (swaths.contains(sss)) continue;
            swaths.add(sss);
        }
        return swaths;
    }

    private static void getSwathDim(Product product, String swath, int[] dim) {
        Band[] bands;
        for (Band b : bands = product.getBands()) {
            if (!b.getName().contains(swath)) continue;
            dim[0] = b.getRasterHeight();
            dim[1] = b.getRasterWidth();
            break;
        }
    }

    private void computeTargetWidthAndHeight() {
        String productType = this.sliceProducts[0].getProductType();
        if (productType.equals("GRD")) {
            for (Product srcProduct : this.sliceProducts) {
                if (this.targetWidth < srcProduct.getSceneRasterWidth()) {
                    this.targetWidth = srcProduct.getSceneRasterWidth();
                }
                this.targetHeight += srcProduct.getSceneRasterHeight();
                HashMap<String, int[]> tmp = new HashMap<String, int[]>();
                tmp.put("", new int[]{srcProduct.getSceneRasterHeight(), srcProduct.getSceneRasterWidth()});
                this.sliceSwathImageDimMap.put(srcProduct, tmp);
            }
            this.swathAssembledImageDimMap.put("", new int[]{this.targetHeight, this.targetWidth});
        } else {
            ArrayList<String> swaths = SliceAssemblyOp.getSwaths(this.sliceProducts[0]);
            HashMap<String, Integer> swathHeight = new HashMap<String, Integer>();
            HashMap<String, Integer> swathWidth = new HashMap<String, Integer>();
            for (String swath : swaths) {
                swathHeight.put(swath, 0);
                swathWidth.put(swath, 0);
            }
            for (Product srcProduct : this.sliceProducts) {
                for (String swath : swaths) {
                    Map<Object, Object> tmp;
                    int[] dim = new int[2];
                    SliceAssemblyOp.getSwathDim(srcProduct, swath, dim);
                    if ((Integer)swathWidth.get(swath) < dim[1]) {
                        swathWidth.replace(swath, dim[1]);
                    }
                    swathHeight.replace(swath, (Integer)swathHeight.get(swath) + dim[0]);
                    if (this.sliceSwathImageDimMap.containsKey(srcProduct)) {
                        tmp = this.sliceSwathImageDimMap.get(srcProduct);
                        tmp.put(swath, dim);
                        continue;
                    }
                    tmp = new HashMap<String, int[]>();
                    tmp.put(swath, dim);
                    this.sliceSwathImageDimMap.put(srcProduct, tmp);
                }
            }
            for (String swath : swaths) {
                this.swathAssembledImageDimMap.put(swath, new int[]{(Integer)swathHeight.get(swath), (Integer)swathWidth.get(swath)});
                if (this.targetWidth < (Integer)swathWidth.get(swath)) {
                    this.targetWidth = (Integer)swathWidth.get(swath);
                }
                if (this.targetHeight >= (Integer)swathHeight.get(swath)) continue;
                this.targetHeight = (Integer)swathHeight.get(swath);
            }
        }
    }

    private Dimension computeTargetBandWidthAndHeight(String bandName) throws OperatorException {
        Dimension dim = new Dimension(0, 0);
        for (Product srcProduct : this.sliceProducts) {
            Band srcBand = srcProduct.getBand(bandName);
            if (srcBand == null) {
                throw new OperatorException(bandName + " not found in product " + srcProduct.getName());
            }
            dim.setSize(Math.max(dim.width, srcBand.getRasterWidth()), dim.height + srcBand.getRasterHeight());
        }
        return dim;
    }

    private void createTargetProduct() {
        Band[] sourceBands;
        this.computeTargetWidthAndHeight();
        Product firstSliceProduct = this.sliceProducts[0];
        Product lastSliceProduct = this.sliceProducts[this.sliceProducts.length - 1];
        String lastSliceStopDateAndTime = lastSliceProduct.getName().substring(33, 48);
        String newProductName = firstSliceProduct.getName().substring(0, 33) + lastSliceStopDateAndTime + firstSliceProduct.getName().substring(48) + PRODUCT_SUFFIX;
        this.targetProduct = new Product(newProductName, firstSliceProduct.getProductType(), this.targetWidth, this.targetHeight);
        for (Band srcBand : sourceBands = firstSliceProduct.getBands()) {
            boolean selectedPol = false;
            for (String pol : this.selectedPolarisations) {
                if (!srcBand.getName().contains(pol)) continue;
                selectedPol = true;
            }
            if (!selectedPol) continue;
            if (srcBand instanceof VirtualBand) {
                RasterDataSymbol[] refRasterDataSymbols;
                VirtualBand sourceBand = (VirtualBand)srcBand;
                int destWidth = 0;
                int destHeight = 0;
                Term term = SliceAssemblyOp.createTerm(sourceBand.getExpression(), this.sliceProducts);
                for (RasterDataSymbol symbol : refRasterDataSymbols = BandArithmetic.getRefRasterDataSymbols((Term[])new Term[]{term})) {
                    String name = symbol.getName();
                    Band trgBand = this.targetProduct.getBand(name);
                    if (trgBand == null) continue;
                    destWidth = trgBand.getRasterWidth();
                    destHeight = trgBand.getRasterHeight();
                    break;
                }
                VirtualBand targetBand = new VirtualBand(sourceBand.getName(), sourceBand.getDataType(), destWidth, destHeight, sourceBand.getExpression());
                ProductUtils.copyRasterDataNodeProperties((RasterDataNode)sourceBand, (RasterDataNode)targetBand);
                this.targetProduct.addBand((Band)targetBand);
                continue;
            }
            Dimension dim = this.computeTargetBandWidthAndHeight(srcBand.getName());
            Band newBand = new Band(srcBand.getName(), srcBand.getDataType(), dim.width, dim.height);
            ProductUtils.copyRasterDataNodeProperties((RasterDataNode)srcBand, (RasterDataNode)newBand);
            this.targetProduct.addBand(newBand);
        }
        ProductUtils.copyMetadata((Product)firstSliceProduct, (Product)this.targetProduct);
        ProductUtils.copyFlagCodings((Product)firstSliceProduct, (Product)this.targetProduct);
        ProductUtils.copyMasks((Product)firstSliceProduct, (Product)this.targetProduct);
        ProductUtils.copyVectorData((Product)firstSliceProduct, (Product)this.targetProduct);
        ProductUtils.copyIndexCodings((Product)firstSliceProduct, (Product)this.targetProduct);
        this.targetProduct.setStartTime(firstSliceProduct.getStartTime());
        this.targetProduct.setEndTime(lastSliceProduct.getEndTime());
        this.targetProduct.setDescription(firstSliceProduct.getDescription());
        String productType = this.absRoot.getAttributeString("PRODUCT_TYPE");
        if (productType.equals("GRD")) {
            this.createTiePointGrids("");
            this.addGeocoding();
        } else {
            ArrayList<String> swaths = SliceAssemblyOp.getSwaths(firstSliceProduct);
            for (String swath : swaths) {
                this.createTiePointGrids(swath);
            }
            this.createLatLonTiePointGridsForSLC();
        }
    }

    private static Term createTerm(String expression, Product[] availableProducts) {
        Term term;
        WritableNamespace namespace = BandArithmetic.createDefaultNamespace((Product[])availableProducts, (int)0);
        try {
            ParserImpl parser = new ParserImpl((Namespace)namespace, false);
            term = parser.parse(expression);
        }
        catch (ParseException e) {
            throw new OperatorException("Could not parse expression: " + expression, (Throwable)e);
        }
        return term;
    }

    private static MetadataElement[] getGeoGridForSwath(Product product, String sss) {
        MetadataElement origProdRoot = AbstractMetadata.getOriginalProductMetadata((Product)product);
        MetadataElement annotationElem = origProdRoot.getElement("annotation");
        MetadataElement[] images = annotationElem.getElements();
        MetadataElement imgElem = null;
        if (sss.isEmpty()) {
            imgElem = annotationElem.getElementAt(0);
        } else {
            for (MetadataElement e : images) {
                if (!SliceAssemblyOp.extractSwathIdentifier(e.getName()).equals(sss.toLowerCase())) continue;
                imgElem = e;
                break;
            }
        }
        if (imgElem == null) {
            throw new OperatorException("Cannot locate geolocation grid in metadata for " + sss);
        }
        MetadataElement productElem = imgElem.getElement("product");
        MetadataElement geolocationGrid = productElem.getElement("geolocationGrid");
        MetadataElement geolocationGridPointList = geolocationGrid.getElement("geolocationGridPointList");
        return geolocationGridPointList.getElements();
    }

    private void createTiePointGrids(String swath) {
        int geoGridLen = 0;
        ArrayList<MetadataElement[]> geoGrids = new ArrayList<MetadataElement[]>();
        int i = 0;
        for (Product product : this.sliceProducts) {
            MetadataElement[] geoGrid = SliceAssemblyOp.getGeoGridForSwath(product, swath);
            geoGridLen += geoGrid.length;
            geoGrids.add(i, geoGrid);
            ++i;
        }
        double[] latList = new double[geoGridLen];
        double[] lngList = new double[geoGridLen];
        double[] incidenceAngleList = new double[geoGridLen];
        double[] elevAngleList = new double[geoGridLen];
        double[] rangeTimeList = new double[geoGridLen];
        int[] x = new int[geoGridLen];
        int[] y = new int[geoGridLen];
        int[] gridWidths = new int[this.sliceProducts.length];
        int[] gridHeights = new int[this.sliceProducts.length];
        for (int j = 0; j < this.sliceProducts.length; ++j) {
            gridWidths[j] = 0;
            gridHeights[j] = 0;
        }
        int gridHeight = 0;
        i = 0;
        int ptsInPrvSlices = 0;
        int heightOffset = 0;
        for (int j = 0; j < this.sliceProducts.length; ++j) {
            MetadataElement[] metadataElementArray;
            if (j > 0) {
                heightOffset += this.sliceSwathImageDimMap.get(this.sliceProducts[j - 1]).get(swath)[0];
            }
            MetadataElement[] metadataElementArray2 = metadataElementArray = (MetadataElement[])geoGrids.get(j);
            int n = metadataElementArray2.length;
            for (int k = 0; k < n; ++k) {
                MetadataElement ggPoint = metadataElementArray2[k];
                latList[i] = ggPoint.getAttributeDouble("latitude", 0.0);
                lngList[i] = ggPoint.getAttributeDouble("longitude", 0.0);
                incidenceAngleList[i] = ggPoint.getAttributeDouble("incidenceAngle", 0.0);
                elevAngleList[i] = ggPoint.getAttributeDouble("elevationAngle", 0.0);
                rangeTimeList[i] = ggPoint.getAttributeDouble("slantRangeTime", 0.0) * 1.0E9;
                x[i] = (int)ggPoint.getAttributeDouble("pixel", 0.0);
                if (x[i] == 0) {
                    if (gridWidths[j] == 0) {
                        gridWidths[j] = i - ptsInPrvSlices;
                    }
                    int n2 = j;
                    gridHeights[n2] = gridHeights[n2] + 1;
                }
                y[i] = (int)ggPoint.getAttributeDouble("line", 0.0) + heightOffset;
                ++i;
            }
            ptsInPrvSlices = i;
            gridHeight += gridHeights[j];
        }
        int gridWidth = gridWidths[0];
        for (int w : gridWidths) {
            if (w == gridWidth) continue;
            throw new OperatorException("geolocation grids have different widths among slice products");
        }
        int n = gridWidth;
        int newGridHeight = gridHeight;
        if (geoGridLen != n * newGridHeight) {
            throw new OperatorException("wrong number of geolocation grid points");
        }
        float[] newLatList = new float[n * newGridHeight];
        float[] newLonList = new float[n * newGridHeight];
        float[] newIncList = new float[n * newGridHeight];
        float[] newElevList = new float[n * newGridHeight];
        float[] newslrtList = new float[n * newGridHeight];
        int[] dim = this.swathAssembledImageDimMap.get(swath);
        int sceneRasterWidth = dim[1];
        int sceneRasterHeight = dim[0];
        double subSamplingX = (double)sceneRasterWidth / (double)(n - 1);
        double subSamplingY = (double)sceneRasterHeight / (double)(newGridHeight - 1);
        Sentinel1Level1Directory.getListInEvenlySpacedGrid((int)sceneRasterWidth, (int)sceneRasterHeight, (int)gridWidth, (int)gridHeight, (int[])x, (int[])y, (double[])latList, (int)n, (int)newGridHeight, (double)subSamplingX, (double)subSamplingY, (float[])newLatList);
        Sentinel1Level1Directory.getListInEvenlySpacedGrid((int)sceneRasterWidth, (int)sceneRasterHeight, (int)gridWidth, (int)gridHeight, (int[])x, (int[])y, (double[])lngList, (int)n, (int)newGridHeight, (double)subSamplingX, (double)subSamplingY, (float[])newLonList);
        Sentinel1Level1Directory.getListInEvenlySpacedGrid((int)sceneRasterWidth, (int)sceneRasterHeight, (int)gridWidth, (int)gridHeight, (int[])x, (int[])y, (double[])incidenceAngleList, (int)n, (int)newGridHeight, (double)subSamplingX, (double)subSamplingY, (float[])newIncList);
        Sentinel1Level1Directory.getListInEvenlySpacedGrid((int)sceneRasterWidth, (int)sceneRasterHeight, (int)gridWidth, (int)gridHeight, (int[])x, (int[])y, (double[])elevAngleList, (int)n, (int)newGridHeight, (double)subSamplingX, (double)subSamplingY, (float[])newElevList);
        Sentinel1Level1Directory.getListInEvenlySpacedGrid((int)sceneRasterWidth, (int)sceneRasterHeight, (int)gridWidth, (int)gridHeight, (int[])x, (int[])y, (double[])rangeTimeList, (int)n, (int)newGridHeight, (double)subSamplingX, (double)subSamplingY, (float[])newslrtList);
        String prefix = swath.isEmpty() ? swath : swath + '_';
        TiePointGrid latGrid = new TiePointGrid(prefix + "latitude", n, newGridHeight, 0.5, 0.5, subSamplingX, subSamplingY, newLatList);
        latGrid.setUnit("deg");
        this.targetProduct.addTiePointGrid(latGrid);
        TiePointGrid lonGrid = new TiePointGrid(prefix + "longitude", n, newGridHeight, 0.5, 0.5, subSamplingX, subSamplingY, newLonList, TiePointGrid.DISCONT_AT_180);
        lonGrid.setUnit("deg");
        this.targetProduct.addTiePointGrid(lonGrid);
        TiePointGrid incidentAngleGrid = new TiePointGrid(prefix + "incident_angle", n, newGridHeight, 0.5, 0.5, subSamplingX, subSamplingY, newIncList);
        incidentAngleGrid.setUnit("deg");
        this.targetProduct.addTiePointGrid(incidentAngleGrid);
        TiePointGrid elevAngleGrid = new TiePointGrid(prefix + "elevation_angle", n, newGridHeight, 0.5, 0.5, subSamplingX, subSamplingY, newElevList);
        elevAngleGrid.setUnit("deg");
        this.targetProduct.addTiePointGrid(elevAngleGrid);
        TiePointGrid slantRangeGrid = new TiePointGrid(prefix + "slant_range_time", n, newGridHeight, 0.5, 0.5, subSamplingX, subSamplingY, newslrtList);
        slantRangeGrid.setUnit("ns");
        this.targetProduct.addTiePointGrid(slantRangeGrid);
        if (!swath.isEmpty()) {
            TiePointGeoCoding tpGeoCoding = new TiePointGeoCoding(latGrid, lonGrid);
            this.swathGeocodingMap.put(swath, tpGeoCoding);
        }
    }

    private void createLatLonTiePointGridsForSLC() {
        MetadataElement absRoot = AbstractMetadata.getAbstractedMetadata((Product)this.sliceProducts[0]);
        String acquisitionMode = absRoot.getAttributeString("ACQUISITION_MODE");
        int firstSwathNum = 9999;
        int lastSwathNum = 0;
        for (String key : this.swathAssembledImageDimMap.keySet()) {
            int subnum = Integer.parseInt(key.substring(2));
            if (subnum < firstSwathNum) {
                firstSwathNum = subnum;
            }
            if (subnum <= lastSwathNum) continue;
            lastSwathNum = subnum;
        }
        String firstSwath = acquisitionMode + firstSwathNum;
        String lastSwath = acquisitionMode + lastSwathNum;
        GeoCoding firstSwathGeoCoding = (GeoCoding)this.swathGeocodingMap.get(firstSwath);
        int firstSWBandHeight = this.swathAssembledImageDimMap.get(firstSwath)[0];
        GeoCoding lastSwathGeoCoding = (GeoCoding)this.swathGeocodingMap.get(lastSwath);
        int lastSWBandWidth = this.swathAssembledImageDimMap.get(lastSwath)[1];
        int lastSWBandHeight = this.swathAssembledImageDimMap.get(lastSwath)[0];
        PixelPos ulPix = new PixelPos(0.0, 0.0);
        PixelPos llPix = new PixelPos(0.0, (double)(firstSWBandHeight - 1));
        GeoPos ulGeo = new GeoPos();
        GeoPos llGeo = new GeoPos();
        firstSwathGeoCoding.getGeoPos(ulPix, ulGeo);
        firstSwathGeoCoding.getGeoPos(llPix, llGeo);
        PixelPos urPix = new PixelPos((double)(lastSWBandWidth - 1), 0.0);
        PixelPos lrPix = new PixelPos((double)(lastSWBandWidth - 1), (double)(lastSWBandHeight - 1));
        GeoPos urGeo = new GeoPos();
        GeoPos lrGeo = new GeoPos();
        lastSwathGeoCoding.getGeoPos(urPix, urGeo);
        lastSwathGeoCoding.getGeoPos(lrPix, lrGeo);
        float[] latCorners = new float[]{(float)ulGeo.getLat(), (float)urGeo.getLat(), (float)llGeo.getLat(), (float)lrGeo.getLat()};
        float[] lonCorners = new float[]{(float)ulGeo.getLon(), (float)urGeo.getLon(), (float)llGeo.getLon(), (float)lrGeo.getLon()};
        ReaderUtils.addGeoCoding((Product)this.targetProduct, (float[])latCorners, (float[])lonCorners);
        AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"first_near_lat", (double)ulGeo.getLat());
        AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"first_near_long", (double)ulGeo.getLon());
        AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"first_far_lat", (double)urGeo.getLat());
        AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"first_far_long", (double)urGeo.getLon());
        AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"last_near_lat", (double)llGeo.getLat());
        AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"last_near_long", (double)llGeo.getLon());
        AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"last_far_lat", (double)lrGeo.getLat());
        AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)"last_far_long", (double)lrGeo.getLon());
    }

    private void addGeocoding() {
        TiePointGrid latGrid = this.targetProduct.getTiePointGrid("latitude");
        TiePointGrid lonGrid = this.targetProduct.getTiePointGrid("longitude");
        TiePointGeoCoding tpGeoCoding = new TiePointGeoCoding(latGrid, lonGrid);
        this.targetProduct.setSceneGeoCoding((GeoCoding)tpGeoCoding);
    }

    private static String extractImageNumber(String filename) {
        int dotIdx = filename.indexOf(46);
        return filename.substring(dotIdx - 3, dotIdx);
    }

    private static ProductData getStopTime(Product product, String imageNum) {
        MetadataElement origProdRoot = AbstractMetadata.getOriginalProductMetadata((Product)product);
        MetadataElement calibration = origProdRoot.getElement("calibration");
        MetadataElement[] calibrationElems = calibration.getElements();
        ProductData data = null;
        for (MetadataElement e : calibrationElems) {
            if (!SliceAssemblyOp.extractImageNumber(e.getName()).equals(imageNum)) continue;
            MetadataElement calib = e.getElement("calibration");
            MetadataElement adsHeader = calib.getElement("adsHeader");
            MetadataAttribute stopTime = adsHeader.getAttribute("stopTime");
            data = stopTime.getData();
        }
        return data;
    }

    private MetadataElement[] getElementsToUpdate(MetadataElement root, String dataName) {
        MetadataElement data = root.getElement(dataName);
        MetadataElement[] dataElems = data.getElements();
        ArrayList<MetadataElement> elemsToRemove = new ArrayList<MetadataElement>();
        for (MetadataElement dataElem : dataElems) {
            boolean isSelected = false;
            for (String pol : this.selectedPolarisations) {
                if (!dataElem.getName().toUpperCase().contains(pol)) continue;
                isSelected = true;
                break;
            }
            if (isSelected) continue;
            elemsToRemove.add(dataElem);
        }
        for (MetadataElement dataElem : elemsToRemove) {
            data.removeElement(dataElem);
        }
        return data.getElements();
    }

    private static MetadataElement getCalibrationOrNoiseVectorList(Product product, String imageNum, String dataName) {
        MetadataElement origProdRoot = AbstractMetadata.getOriginalProductMetadata((Product)product);
        MetadataElement data = origProdRoot.getElement(dataName);
        MetadataElement[] elems = data.getElements();
        MetadataElement vectorList = null;
        for (MetadataElement e : elems) {
            if (!SliceAssemblyOp.extractImageNumber(e.getName()).equals(imageNum)) continue;
            MetadataElement dat = e.getElement(dataName);
            vectorList = dat.getElement(dataName + "VectorList");
        }
        return vectorList;
    }

    private static int getCalibrationOrNoisePixelSpacing(Product product, String imageNum, String dataName) {
        MetadataElement origProdRoot = AbstractMetadata.getOriginalProductMetadata((Product)product);
        MetadataElement data = origProdRoot.getElement(dataName);
        MetadataElement[] dataElems = data.getElements();
        int pixelSpacing = 0;
        for (MetadataElement e : dataElems) {
            MetadataAttribute pixels;
            String pixelsStr;
            String[] pixelsArrayOfStr;
            if (!SliceAssemblyOp.extractImageNumber(e.getName()).equals(imageNum)) continue;
            MetadataElement dat = e.getElement(dataName);
            MetadataElement vectorList = dat.getElement(dataName + "VectorList");
            MetadataElement firstVector = vectorList.getElementAt(0);
            MetadataElement pixel = firstVector.getElement("pixel");
            MetadataAttribute count = pixel.getAttribute("count");
            int pixelCount = Integer.parseInt(count.getData().getElemString());
            if (pixelCount != (pixelsArrayOfStr = (pixelsStr = (pixels = pixel.getAttribute("pixel")).getData().getElemString()).split(" ")).length) {
                throw new OperatorException("wrong pixel count " + product.getName() + ' ' + imageNum + ' ' + dataName + ' ' + pixelCount + ' ' + pixelsArrayOfStr.length);
            }
            if (pixelCount < 2) {
                throw new OperatorException("wrong pixel count " + product.getName() + ' ' + imageNum + ' ' + dataName + ' ' + pixelCount);
            }
            int pixel0 = Integer.parseInt(pixelsArrayOfStr[0]);
            int pixel1 = Integer.parseInt(pixelsArrayOfStr[1]);
            pixelSpacing = pixel1 - pixel0;
            break;
        }
        return pixelSpacing;
    }

    private static void concatenateVectors(MetadataElement targetVectorList, MetadataElement sliceVectorList, int startVectorIdx, int lineOffset) {
        int bottom1stLine;
        int idx = Integer.parseInt(targetVectorList.getAttribute("count").getData().getElemString());
        int numSliceLines = Integer.parseInt(sliceVectorList.getAttribute("count").getData().getElemString());
        int topLastLine = Integer.parseInt(targetVectorList.getElementAt(idx - 1).getAttributeString("line"));
        if (topLastLine >= (bottom1stLine = lineOffset + Integer.parseInt(sliceVectorList.getElementAt(startVectorIdx).getAttributeString("line")))) {
            throw new OperatorException("last vector line of stop slice = " + topLastLine + " >= first vector line of bottom slice = " + bottom1stLine);
        }
        for (int i = startVectorIdx; i < numSliceLines; ++i) {
            MetadataElement v = sliceVectorList.getElementAt(i);
            MetadataElement newV = v.createDeepClone();
            int newLine = Integer.parseInt(v.getAttributeString("line")) + lineOffset;
            newV.setAttributeString("line", Integer.toString(newLine));
            targetVectorList.addElementAt(newV, idx);
            ++idx;
        }
        targetVectorList.setAttributeString("count", Integer.toString(idx));
    }

    private static int[] getPixelSpacings(MetadataElement pixel, String msg) {
        String pixelsStr = pixel.getAttributeString("pixel");
        String[] pixelsArrayOfStr = pixelsStr.split(" ");
        int numPixels = pixelsArrayOfStr.length;
        if (numPixels < 2) {
            throw new OperatorException("Too few pixels " + numPixels + " for " + msg);
        }
        int pixelCount = Integer.parseInt(pixel.getAttributeString("count"));
        if (pixelCount != numPixels) {
            throw new OperatorException("wrong pixel count " + pixelCount + ' ' + numPixels + " for " + msg);
        }
        int[] pixelSpacings = new int[numPixels - 1];
        for (int i = 0; i < numPixels - 1; ++i) {
            int pixel0 = Integer.parseInt(pixelsArrayOfStr[i]);
            int pixel1 = Integer.parseInt(pixelsArrayOfStr[i + 1]);
            pixelSpacings[i] = pixel1 - pixel0;
        }
        return pixelSpacings;
    }

    private static void checkCalibrationOrNoisePixelSpacing(Product product, String dataName) {
        MetadataElement[] dataElems;
        MetadataElement origProdRoot = AbstractMetadata.getOriginalProductMetadata((Product)product);
        MetadataElement data = origProdRoot.getElement(dataName);
        for (MetadataElement e : dataElems = data.getElements()) {
            MetadataElement dat = e.getElement(dataName);
            MetadataElement vectorList = dat.getElement(dataName + "VectorList");
            MetadataElement firstVector = vectorList.getElementAt(0);
            MetadataElement firstVectorPixel = firstVector.getElement("pixel");
            int[] firstVectorPixelSpacings = SliceAssemblyOp.getPixelSpacings(firstVectorPixel, product.getName() + ' ' + e.getName() + ' ' + dataName);
            for (int i = 1; i < vectorList.getNumElements(); ++i) {
                MetadataElement vector = vectorList.getElementAt(i);
                MetadataElement metadataElement = vector.getElement("pixel");
            }
        }
    }

    private static int getLastPixel(MetadataElement vector) {
        MetadataElement pixel = vector.getElement("pixel");
        String pixelsStr = pixel.getAttributeString("pixel");
        String[] pixelsArrayOfStr = pixelsStr.split(" ");
        return Integer.parseInt(pixelsArrayOfStr[pixelsArrayOfStr.length - 1]);
    }

    private void updateCalibrationOrNoise(String dataName) {
        MetadataElement[] targetDataElems;
        Product lastSliceProduct = this.sliceProducts[this.sliceProducts.length - 1];
        String productType = this.sliceProducts[0].getProductType();
        MetadataElement targetOrigProdRoot = AbstractMetadata.getOriginalProductMetadata((Product)this.targetProduct);
        for (MetadataElement target : targetDataElems = this.getElementsToUpdate(targetOrigProdRoot, dataName)) {
            String swathID = SliceAssemblyOp.extractSwathIdentifier(target.getName());
            String imageNum = SliceAssemblyOp.extractImageNumber(target.getName());
            MetadataElement targetDat = target.getElement(dataName);
            MetadataElement targetADSHeader = targetDat.getElement("adsHeader");
            ProductData lastSliceStopTime = SliceAssemblyOp.getStopTime(lastSliceProduct, imageNum);
            AbstractMetadata.setAttribute((MetadataElement)targetADSHeader, (String)"stopTime", (String)lastSliceStopTime.getElemString());
            MetadataElement targetVectorList = targetDat.getElement(dataName + "VectorList");
            int numLines = Integer.parseInt(targetVectorList.getAttribute("count").getData().getElemString());
            int pixelSpacing = SliceAssemblyOp.getCalibrationOrNoisePixelSpacing(this.targetProduct, imageNum, dataName);
            int height = productType.equals("GRD") ? this.sliceProducts[0].getSceneRasterHeight() : this.sliceSwathImageDimMap.get(this.sliceProducts[0]).get(swathID.toUpperCase())[0];
            for (int i = 1; i < this.sliceProducts.length; ++i) {
                Product sliceProduct = this.sliceProducts[i];
                int slicePixelSpacing = SliceAssemblyOp.getCalibrationOrNoisePixelSpacing(sliceProduct, imageNum, dataName);
                if (pixelSpacing != slicePixelSpacing) {
                    throw new OperatorException("slice products have different pixel spacing in " + dataName + " vectors: " + i + ' ' + pixelSpacing + ' ' + slicePixelSpacing);
                }
                int targetLastVectorLine = Integer.parseInt(targetVectorList.getElementAt(targetVectorList.getNumElements() - 1).getAttributeString("line"));
                MetadataElement sliceVectorList = SliceAssemblyOp.getCalibrationOrNoiseVectorList(sliceProduct, imageNum, dataName);
                int sliceNumLines = Integer.parseInt(sliceVectorList.getAttribute("count").getData().getElemString());
                int sliceFirstVectorLine = Integer.parseInt(sliceVectorList.getElementAt(0).getAttributeString("line"));
                int numLinesRemoved = 0;
                if (targetLastVectorLine == sliceFirstVectorLine + height - 1) {
                    SliceAssemblyOp.concatenateVectors(targetVectorList, sliceVectorList, 0, height);
                } else {
                    int sliceLine;
                    Object targetCalibVector;
                    int targetCalibVectorLine;
                    int j;
                    int k;
                    for (k = 0; k < sliceNumLines && Integer.parseInt(sliceVectorList.getElementAt(k).getAttributeString("line")) <= 0; ++k) {
                    }
                    if (k == sliceNumLines - 1) {
                        throw new OperatorException("Only one " + dataName + " vector in slice " + i);
                    }
                    k = k == 0 ? k : k - 1;
                    int sliceTopVectorLine = Integer.parseInt(sliceVectorList.getElementAt(k).getAttributeString("line"));
                    int sliceTopVectorLastPixel = SliceAssemblyOp.getLastPixel(sliceVectorList.getElementAt(k));
                    ArrayList<Object> elemsToRemove = new ArrayList<Object>();
                    for (j = numLines - 1; j >= 0 && (targetCalibVectorLine = Integer.parseInt((targetCalibVector = targetVectorList.getElementAt(j)).getAttributeString("line"))) >= sliceTopVectorLine + height && (j > 0 && Integer.parseInt(targetVectorList.getElementAt(j - 1).getAttributeString("line")) >= height - 1 || SliceAssemblyOp.getLastPixel((MetadataElement)targetCalibVector) <= sliceTopVectorLastPixel); --j) {
                        elemsToRemove.add(targetCalibVector);
                    }
                    numLinesRemoved = elemsToRemove.size();
                    targetCalibVector = elemsToRemove.iterator();
                    while (targetCalibVector.hasNext()) {
                        MetadataElement e = (MetadataElement)targetCalibVector.next();
                        targetVectorList.removeElement(e);
                    }
                    targetVectorList.setAttributeString("count", Integer.toString(numLines - numLinesRemoved));
                    int lastTargetLine = Integer.parseInt(targetVectorList.getElementAt(numLines - numLinesRemoved - 1).getAttributeString("line"));
                    for (j = k; j < sliceNumLines; ++j) {
                        if (Integer.parseInt(sliceVectorList.getElementAt(j).getAttributeString("line")) + height <= lastTargetLine) continue;
                        k = j;
                        break;
                    }
                    for (j = k - 1; j >= 0 && (sliceLine = Integer.parseInt(sliceVectorList.getElementAt(j).getAttributeString("line"))) + height > lastTargetLine; --j) {
                    }
                    SliceAssemblyOp.concatenateVectors(targetVectorList, sliceVectorList, j + 1, height);
                    numLinesRemoved += j + 1;
                }
                if ((numLines += sliceNumLines - numLinesRemoved) != targetVectorList.getNumElements()) {
                    throw new OperatorException("numLines = " + numLines + " != numElems = " + targetVectorList.getNumElements());
                }
                targetVectorList.setAttributeString("count", Integer.toString(numLines));
                height += productType.equals("GRD") ? sliceProduct.getSceneRasterHeight() : this.sliceSwathImageDimMap.get(sliceProduct).get(swathID.toUpperCase())[0];
            }
        }
    }

    private static MetadataElement getAnnotationElement(Product product, String imageNum, String elemName) {
        MetadataElement targetOrigProdRoot = AbstractMetadata.getOriginalProductMetadata((Product)product);
        MetadataElement targetData = targetOrigProdRoot.getElement("annotation");
        MetadataElement[] targetDataElems = targetData.getElements();
        MetadataElement elem = null;
        for (MetadataElement target : targetDataElems) {
            if (!SliceAssemblyOp.extractImageNumber(target.getName()).equals(imageNum)) continue;
            MetadataElement productElem = target.getElement("product");
            elem = productElem.getElement(elemName);
            break;
        }
        return elem;
    }

    private static String getProductLastLineUtcTime(Product product, String imageNum) {
        MetadataElement imageAnnotationElem = SliceAssemblyOp.getAnnotationElement(product, imageNum, "imageAnnotation");
        if (imageAnnotationElem == null) {
            return "";
        }
        MetadataElement imageInformationElem = imageAnnotationElem.getElement("imageInformation");
        return imageInformationElem.getAttributeString("productLastLineUtcTime");
    }

    private void updateImageInformation() {
        MetadataElement[] targetDataElems;
        MetadataElement targetOrigProdRoot = AbstractMetadata.getOriginalProductMetadata((Product)this.targetProduct);
        for (MetadataElement target : targetDataElems = this.getElementsToUpdate(targetOrigProdRoot, "annotation")) {
            MetadataElement productElem = target.getElement("product");
            MetadataElement imageAnnotationElem = productElem.getElement("imageAnnotation");
            MetadataElement imageInformationElem = imageAnnotationElem.getElement("imageInformation");
            imageInformationElem.setAttributeString("productLastLineUtcTime", SliceAssemblyOp.getProductLastLineUtcTime(this.sliceProducts[this.sliceProducts.length - 1], SliceAssemblyOp.extractImageNumber(target.getName())));
            String swathID = this.sliceProducts[0].getProductType().equals("GRD") ? "" : SliceAssemblyOp.extractSwathIdentifier(target.getName());
            imageInformationElem.setAttributeString("numberOfSamples", Integer.toString(this.swathAssembledImageDimMap.get(swathID.toUpperCase())[1]));
            imageInformationElem.setAttributeString("numberOfLines", Integer.toString(this.swathAssembledImageDimMap.get(swathID.toUpperCase())[0]));
        }
    }

    private static long getByteIncrementPerBurst(MetadataElement burstList) {
        MetadataElement[] bursts = burstList.getElements();
        long increment = Long.parseLong(bursts[1].getAttributeString("byteOffset")) - Long.parseLong(bursts[0].getAttributeString("byteOffset"));
        for (int i = 2; i < bursts.length; ++i) {
            long incr = Long.parseLong(bursts[i].getAttributeString("byteOffset")) - Long.parseLong(bursts[i - 1].getAttributeString("byteOffset"));
            if (incr == increment) continue;
            throw new OperatorException("wrong burst byte increment");
        }
        return increment;
    }

    private void updateSwathTiming() {
        MetadataElement[] elements;
        MetadataElement targetOrigProdRoot = AbstractMetadata.getOriginalProductMetadata((Product)this.targetProduct);
        for (MetadataElement e : elements = this.getElementsToUpdate(targetOrigProdRoot, "annotation")) {
            String imageNum = SliceAssemblyOp.extractImageNumber(e.getName());
            MetadataElement targetSwathTiming = e.getElement("product").getElement("swathTiming");
            int linesPerBurst = Integer.parseInt(targetSwathTiming.getAttributeString("linesPerBurst"));
            int samplesPerBurst = Integer.parseInt(targetSwathTiming.getAttributeString("samplesPerBurst"));
            MetadataElement targetBurstList = targetSwathTiming.getElement("burstList");
            int count = Integer.parseInt(targetBurstList.getAttributeString("count"));
            long targetLastByteOffset = count > 0 ? Long.parseLong(targetBurstList.getElementAt(count - 1).getAttributeString("byteOffset")) : 0L;
            long targetByteIncr = count > 0 ? SliceAssemblyOp.getByteIncrementPerBurst(targetBurstList) : 0L;
            for (int i = 1; i < this.sliceProducts.length; ++i) {
                MetadataElement sliceBurstList;
                int sliceBurstListCount;
                MetadataElement sliceSwathTiming = SliceAssemblyOp.getAnnotationElement(this.sliceProducts[i], imageNum, "swathTiming");
                int sliceLinesPerBurst = Integer.parseInt(sliceSwathTiming.getAttributeString("linesPerBurst"));
                if (sliceLinesPerBurst != linesPerBurst) {
                    throw new OperatorException("slice " + i + " has different linesPerBurst " + sliceLinesPerBurst + " vs. " + linesPerBurst);
                }
                int sliceSamplesPerBurst = Integer.parseInt(sliceSwathTiming.getAttributeString("samplesPerBurst"));
                if (sliceSamplesPerBurst > samplesPerBurst) {
                    samplesPerBurst = sliceSamplesPerBurst;
                }
                if ((sliceBurstListCount = Integer.parseInt((sliceBurstList = sliceSwathTiming.getElement("burstList")).getAttributeString("count"))) < 1) continue;
                MetadataElement[] sliceBurstListElems = sliceBurstList.getElements();
                long newByteOffset = 0L;
                long sliceFirstByteOffset = Long.parseLong(sliceBurstListElems[0].getAttributeString("byteOffset"));
                for (MetadataElement b : sliceBurstListElems) {
                    MetadataElement newB = b.createDeepClone();
                    long sliceByteOffset = Long.parseLong(b.getAttributeString("byteOffset"));
                    newByteOffset = sliceByteOffset + targetLastByteOffset + targetByteIncr - sliceFirstByteOffset;
                    newB.setAttributeString("byteOffset", Long.toString(newByteOffset));
                    targetBurstList.addElementAt(newB, count);
                    ++count;
                }
                targetLastByteOffset = newByteOffset;
                targetByteIncr = SliceAssemblyOp.getByteIncrementPerBurst(sliceBurstList);
            }
            targetSwathTiming.setAttributeString("samplesPerBurst", Integer.toString(samplesPerBurst));
            targetBurstList.setAttributeString("count", Integer.toString(count));
        }
    }

    private void updateGeolocationGrid() {
        MetadataElement[] elements;
        MetadataElement targetOrigProdRoot = AbstractMetadata.getOriginalProductMetadata((Product)this.targetProduct);
        for (MetadataElement e : elements = this.getElementsToUpdate(targetOrigProdRoot, "annotation")) {
            String imageNum = SliceAssemblyOp.extractImageNumber(e.getName());
            MetadataElement targetGeolocationGrid = e.getElement("product").getElement("geolocationGrid");
            MetadataElement targetGeolocationGridPointList = targetGeolocationGrid.getElement("geolocationGridPointList");
            int count = Integer.parseInt(targetGeolocationGridPointList.getAttributeString("count"));
            MetadataElement sliceImageAnnotation = SliceAssemblyOp.getAnnotationElement(this.sliceProducts[0], imageNum, "imageAnnotation");
            MetadataElement sliceImageInformation = sliceImageAnnotation.getElement("imageInformation");
            int numberOfLines = Integer.parseInt(sliceImageInformation.getAttributeString("numberOfLines"));
            for (int i = 1; i < this.sliceProducts.length; ++i) {
                MetadataElement[] sliceGeolocationGridPoints;
                MetadataElement sliceGeolocationGrid = SliceAssemblyOp.getAnnotationElement(this.sliceProducts[i], imageNum, "geolocationGrid");
                MetadataElement sliceGeolocationGridPointList = sliceGeolocationGrid.getElement("geolocationGridPointList");
                int sliceCount = Integer.parseInt(sliceGeolocationGridPointList.getAttributeString("count"));
                if (sliceCount < 1) continue;
                for (MetadataElement p : sliceGeolocationGridPoints = sliceGeolocationGridPointList.getElements()) {
                    MetadataElement newP = p.createDeepClone();
                    long sliceLine = Long.parseLong(p.getAttributeString("line"));
                    newP.setAttributeString("line", Long.toString(sliceLine + (long)numberOfLines));
                    targetGeolocationGridPointList.addElementAt(newP, count++);
                }
                sliceImageAnnotation = SliceAssemblyOp.getAnnotationElement(this.sliceProducts[i], imageNum, "imageAnnotation");
                sliceImageInformation = sliceImageAnnotation.getElement("imageInformation");
                numberOfLines += Integer.parseInt(sliceImageInformation.getAttributeString("numberOfLines"));
            }
            targetGeolocationGridPointList.setAttributeString("count", Integer.toString(count));
        }
    }

    private void updateDopplerCentroid() {
        MetadataElement[] elements;
        MetadataElement targetOrigProdRoot = AbstractMetadata.getOriginalProductMetadata((Product)this.targetProduct);
        for (MetadataElement e : elements = this.getElementsToUpdate(targetOrigProdRoot, "annotation")) {
            String imageNum = SliceAssemblyOp.extractImageNumber(e.getName());
            MetadataElement targetDopplerCentroid = e.getElement("product").getElement("dopplerCentroid");
            MetadataElement targetDCEstimateList = targetDopplerCentroid.getElement("dcEstimateList");
            int count = Integer.parseInt(targetDCEstimateList.getAttributeString("count"));
            for (int i = 1; i < this.sliceProducts.length; ++i) {
                MetadataElement[] sliceDCEstimates;
                MetadataElement sliceDopplerCentroid = SliceAssemblyOp.getAnnotationElement(this.sliceProducts[i], imageNum, "dopplerCentroid");
                MetadataElement sliceDCEstimateList = sliceDopplerCentroid.getElement("dcEstimateList");
                int sliceCount = Integer.parseInt(sliceDCEstimateList.getAttributeString("count"));
                if (sliceCount < 1) continue;
                for (MetadataElement dc : sliceDCEstimates = sliceDCEstimateList.getElements()) {
                    targetDCEstimateList.addElementAt(dc.createDeepClone(), count++);
                }
            }
            targetDCEstimateList.setAttributeString("count", Integer.toString(count));
        }
    }

    private static MetadataElement getAzimuthFmRateList(Product product, String imageNum) {
        MetadataElement generalAnnotation = SliceAssemblyOp.getAnnotationElement(product, imageNum, "generalAnnotation");
        return generalAnnotation.getElement("azimuthFmRateList");
    }

    private void updateAzimuthFmRateList() {
        MetadataElement[] elements;
        MetadataElement targetOrigProdRoot = AbstractMetadata.getOriginalProductMetadata((Product)this.targetProduct);
        for (MetadataElement e : elements = this.getElementsToUpdate(targetOrigProdRoot, "annotation")) {
            String imageNum = SliceAssemblyOp.extractImageNumber(e.getName());
            MetadataElement targetAzimuthFmRateList = e.getElement("product").getElement("generalAnnotation").getElement("azimuthFmRateList");
            int targetNewCount = Integer.parseInt(targetAzimuthFmRateList.getAttributeString("count"));
            for (int i = 1; i < this.sliceProducts.length; ++i) {
                MetadataElement sliceAzimuthFmRateList = SliceAssemblyOp.getAzimuthFmRateList(this.sliceProducts[i], imageNum);
                int sliceCount = Integer.parseInt(sliceAzimuthFmRateList.getAttributeString("count"));
                for (int j = 0; j < sliceCount; ++j) {
                    MetadataElement azimuthFmRate = sliceAzimuthFmRateList.getElementAt(j).createDeepClone();
                    targetAzimuthFmRateList.addElementAt(azimuthFmRate, targetNewCount + j);
                }
                targetNewCount += sliceCount;
            }
            targetAzimuthFmRateList.setAttributeString("count", Integer.toString(targetNewCount));
        }
    }

    private static void concatenateOrbitStateVectors(List<OrbitStateVector> orbVectorList, OrbitStateVector[] orbs) {
        if (orbVectorList.isEmpty()) {
            orbVectorList.addAll(Arrays.asList(orbs));
        } else {
            int i;
            double lastTime = orbVectorList.get((int)(orbVectorList.size() - 1)).time_mjd;
            double firstTime = orbs[0].time_mjd;
            double midTime = (lastTime + firstTime) / 2.0;
            int firstVecToRemove = -1;
            for (i = 0; i < orbVectorList.size(); ++i) {
                if (!(orbVectorList.get((int)i).time_mjd > midTime)) continue;
                firstVecToRemove = i;
                break;
            }
            if (firstVecToRemove != -1) {
                for (i = orbVectorList.size() - 1; i >= firstVecToRemove; --i) {
                    orbVectorList.remove(i);
                }
            }
            for (OrbitStateVector orb : orbs) {
                if (!(orb.time_mjd > midTime)) continue;
                orbVectorList.add(orb);
            }
        }
    }

    private void updateTargetProductMetadata() throws Exception {
        MetadataElement absTgt = AbstractMetadata.getAbstractedMetadata((Product)this.targetProduct);
        Product firstSliceProduct = this.sliceProducts[0];
        Product lastSliceProduct = this.sliceProducts[this.sliceProducts.length - 1];
        MetadataElement absFirst = AbstractMetadata.getAbstractedMetadata((Product)firstSliceProduct);
        MetadataElement absLast = AbstractMetadata.getAbstractedMetadata((Product)lastSliceProduct);
        AbstractMetadata.setAttribute((MetadataElement)absTgt, (String)"first_line_time", (ProductData.UTC)absFirst.getAttributeUTC("first_line_time"));
        AbstractMetadata.setAttribute((MetadataElement)absTgt, (String)"last_line_time", (ProductData.UTC)absLast.getAttributeUTC("last_line_time"));
        AbstractMetadata.setAttribute((MetadataElement)absTgt, (String)"num_output_lines", (int)this.targetHeight);
        AbstractMetadata.setAttribute((MetadataElement)absTgt, (String)"num_samples_per_line", (int)this.targetWidth);
        for (Band band : this.targetProduct.getBands()) {
            MetadataElement bandMeta = AbstractMetadata.getBandAbsMetadata((MetadataElement)absTgt, (Band)band);
            if (bandMeta == null) continue;
            AbstractMetadata.setAttribute((MetadataElement)bandMeta, (String)"first_line_time", (ProductData.UTC)absFirst.getAttributeUTC("first_line_time"));
            AbstractMetadata.setAttribute((MetadataElement)bandMeta, (String)"last_line_time", (ProductData.UTC)absLast.getAttributeUTC("last_line_time"));
            AbstractMetadata.setAttribute((MetadataElement)bandMeta, (String)"num_output_lines", (int)band.getRasterHeight());
            AbstractMetadata.setAttribute((MetadataElement)bandMeta, (String)"num_samples_per_line", (int)band.getRasterWidth());
        }
        ArrayList<MetadataElement> bandMetaToRemove = new ArrayList<MetadataElement>();
        MetadataElement[] absTgtElems = absTgt.getElements();
        for (MetadataElement e : absTgtElems) {
            String elemName = e.getName();
            if (!elemName.contains("Band")) continue;
            for (String pol : this.selectedPolarisations) {
                if (elemName.contains(pol)) continue;
                bandMetaToRemove.add(e);
            }
        }
        for (MetadataElement e : bandMetaToRemove) {
            absTgt.removeElement(e);
        }
        ArrayList<OrbitStateVector> orbVectorList = new ArrayList<OrbitStateVector>();
        ArrayList<AbstractMetadata.SRGRCoefficientList> srgrList = new ArrayList<AbstractMetadata.SRGRCoefficientList>();
        ArrayList<AbstractMetadata.DopplerCentroidCoefficientList> dopList = new ArrayList<AbstractMetadata.DopplerCentroidCoefficientList>();
        for (Product srcProduct : this.sliceProducts) {
            MetadataElement absSrc = AbstractMetadata.getAbstractedMetadata((Product)srcProduct);
            OrbitStateVector[] orbs = AbstractMetadata.getOrbitStateVectors((MetadataElement)absSrc);
            SliceAssemblyOp.concatenateOrbitStateVectors(orbVectorList, orbs);
            AbstractMetadata.SRGRCoefficientList[] srgr = AbstractMetadata.getSRGRCoefficients((MetadataElement)absSrc);
            srgrList.addAll(Arrays.asList(srgr));
            AbstractMetadata.DopplerCentroidCoefficientList[] dop = AbstractMetadata.getDopplerCentroidCoefficients((MetadataElement)absSrc);
            dopList.addAll(Arrays.asList(dop));
        }
        AbstractMetadata.setOrbitStateVectors((MetadataElement)absTgt, (OrbitStateVector[])orbVectorList.toArray(new OrbitStateVector[orbVectorList.size()]));
        AbstractMetadata.setSRGRCoefficients((MetadataElement)absTgt, (AbstractMetadata.SRGRCoefficientList[])srgrList.toArray(new AbstractMetadata.SRGRCoefficientList[srgrList.size()]));
        AbstractMetadata.setDopplerCentroidCoefficients((MetadataElement)absTgt, (AbstractMetadata.DopplerCentroidCoefficientList[])dopList.toArray(new AbstractMetadata.DopplerCentroidCoefficientList[dopList.size()]));
        this.updateCalibrationOrNoise("calibration");
        this.updateCalibrationOrNoise("noise");
        this.updateImageInformation();
        this.updateSwathTiming();
        this.updateGeolocationGrid();
        this.updateDopplerCentroid();
        this.updateAzimuthFmRateList();
    }

    private void determineBandStartEndTimes() {
        for (Band targetBand : this.targetProduct.getBands()) {
            ArrayList<BandLines> bandLineList = new ArrayList<BandLines>(this.sliceProducts.length);
            int height = 0;
            for (Product srcProduct : this.sliceProducts) {
                Band srcBand = srcProduct.getBand(targetBand.getName());
                int start = height;
                int end = height += srcBand.getRasterHeight();
                bandLineList.add(new BandLines(srcBand, start, end));
            }
            BandLines[] lines = bandLineList.toArray(new BandLines[bandLineList.size()]);
            this.bandLineMap.put(targetBand, lines);
        }
    }

    public void computeTile(Band targetBand, Tile targetTile, ProgressMonitor pm) throws OperatorException {
        try {
            Rectangle targetTileRectangle = targetTile.getRectangle();
            int tx0 = targetTileRectangle.x;
            int ty0 = targetTileRectangle.y;
            int maxY = ty0 + targetTileRectangle.height;
            int maxX = tx0 + targetTileRectangle.width;
            if (targetTileRectangle.width < 2) {
                return;
            }
            BandLines[] lines = this.bandLineMap.get(targetBand);
            ProductData trgData = targetTile.getDataBuffer();
            TileIndex trgIndex = new TileIndex(targetTile);
            Rectangle srcRect = new Rectangle();
            BandLines line = lines[0];
            for (int y = ty0; y < maxY; ++y) {
                for (BandLines l : lines) {
                    if (y < l.start || y >= l.end) continue;
                    line = l;
                    break;
                }
                int yy = y - line.start;
                srcRect.setBounds(targetTileRectangle.x, yy, targetTileRectangle.width, 1);
                Tile sourceRaster = this.getSourceTile((RasterDataNode)line.band, srcRect);
                ProductData srcData = sourceRaster.getDataBuffer();
                TileIndex srcIndex = new TileIndex(sourceRaster);
                trgIndex.calculateStride(y);
                srcIndex.calculateStride(yy);
                for (int x = tx0; x < maxX; ++x) {
                    trgData.setElemDoubleAt(trgIndex.getIndex(x), srcData.getElemDoubleAt(srcIndex.getIndex(x)));
                }
            }
        }
        catch (Throwable e) {
            throw new OperatorException(e.getMessage());
        }
    }

    public static class Spi
    extends OperatorSpi {
        public Spi() {
            super(SliceAssemblyOp.class);
        }
    }

    private static class BandLines {
        final int start;
        final int end;
        final Band band;

        BandLines(Band band, int s, int e) {
            this.band = band;
            this.start = s;
            this.end = e;
        }
    }
}

