/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s1tbx.sentinel1.gpf;

import com.bc.ceres.core.ProgressMonitor;
import edu.emory.mathcs.jtransforms.fft.DoubleFFT_1D;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.math3.util.FastMath;
import org.esa.s1tbx.insar.gpf.support.Sentinel1Utils;
import org.esa.s1tbx.sentinel1.gpf.BackGeocodingOp;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.MetadataAttribute;
import org.esa.snap.core.datamodel.MetadataElement;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.datamodel.VirtualBand;
import org.esa.snap.core.dataop.downloadable.StatusProgressMonitor;
import org.esa.snap.core.gpf.Operator;
import org.esa.snap.core.gpf.OperatorException;
import org.esa.snap.core.gpf.OperatorSpi;
import org.esa.snap.core.gpf.Tile;
import org.esa.snap.core.gpf.annotations.OperatorMetadata;
import org.esa.snap.core.gpf.annotations.Parameter;
import org.esa.snap.core.gpf.annotations.SourceProduct;
import org.esa.snap.core.gpf.annotations.TargetProduct;
import org.esa.snap.core.util.ProductUtils;
import org.esa.snap.core.util.SystemUtils;
import org.esa.snap.engine_utilities.datamodel.AbstractMetadata;
import org.esa.snap.engine_utilities.gpf.InputProductValidator;
import org.esa.snap.engine_utilities.gpf.OperatorUtils;
import org.esa.snap.engine_utilities.gpf.ReaderUtils;
import org.esa.snap.engine_utilities.gpf.ThreadManager;
import org.esa.snap.engine_utilities.gpf.TileIndex;

@OperatorMetadata(alias="Azimuth-Shift", category="Radar/Coregistration/S-1 TOPS Coregistration", authors="Jun Lu, Luis Veci", version="1.0", copyright="Copyright (C) 2014 by Array Systems Computing Inc.", description="Estimate global azimuth offset for the whole image")
public class AzimuthShiftOp
extends Operator {
    @SourceProduct(alias="source")
    private Product sourceProduct;
    @TargetProduct(description="The target product which will use the master's grid.")
    private Product targetProduct = null;
    @Parameter(description="The coherence threshold for outlier removal", interval="(0, 1]", defaultValue="0.15", label="Coherence Threshold for Outlier Removal")
    private double cohThreshold = 0.15;
    @Parameter(description="The number of windows per overlap for ESD", interval="[1, 20]", defaultValue="10", label="Number of Windows Per Overlap for ESD")
    private int numBlocksPerOverlap = 10;
    private boolean isAzimuthOffsetAvailable = false;
    private double azOffset = 0.0;
    private Sentinel1Utils.SubSwathInfo[] subSwath = null;
    private int subSwathIndex = 0;
    private String swathIndexStr = null;
    private String[] subSwathNames = null;
    private String[] polarizations = null;
    private static final int cohWin = 5;
    private static final String DerampDemodPhase = "derampDemodPhase";

    public void initialize() throws OperatorException {
        try {
            InputProductValidator validator = new InputProductValidator(this.sourceProduct);
            validator.checkIfSARProduct();
            validator.checkIfSentinel1Product();
            this.checkDerampDemodPhaseBand();
            Sentinel1Utils su = new Sentinel1Utils(this.sourceProduct);
            su.computeDopplerRate();
            this.subSwath = su.getSubSwath();
            this.subSwathNames = su.getSubSwathNames();
            if (this.subSwathNames.length != 1) {
                throw new OperatorException("Split product is expected.");
            }
            this.subSwathIndex = 1;
            this.swathIndexStr = this.subSwathNames[0].substring(2);
            this.polarizations = su.getPolarizations();
            this.createTargetProduct();
        }
        catch (Throwable e) {
            OperatorUtils.catchOperatorException((String)this.getId(), (Throwable)e);
        }
    }

    private void checkDerampDemodPhaseBand() {
        Band[] sourceBands;
        boolean hasDerampDemodPhaseBand = false;
        for (Band band : sourceBands = this.sourceProduct.getBands()) {
            if (!band.getName().contains(DerampDemodPhase)) continue;
            hasDerampDemodPhaseBand = true;
            break;
        }
        if (!hasDerampDemodPhaseBand) {
            throw new OperatorException("Cannot find derampDemodPhase band in source product. Please run Backgeocoding and select \"Output Deramp and Demod Phase\".");
        }
    }

    private void createTargetProduct() {
        String[] bandNames;
        this.targetProduct = new Product(this.sourceProduct.getName(), this.sourceProduct.getProductType(), this.sourceProduct.getSceneRasterWidth(), this.sourceProduct.getSceneRasterHeight());
        ProductUtils.copyProductNodes((Product)this.sourceProduct, (Product)this.targetProduct);
        for (String srcBandName : bandNames = this.sourceProduct.getBandNames()) {
            Band targetBand;
            Band band = this.sourceProduct.getBand(srcBandName);
            if (band instanceof VirtualBand) continue;
            if (srcBandName.contains("_mst") || srcBandName.contains("derampDemod")) {
                targetBand = ProductUtils.copyBand((String)srcBandName, (Product)this.sourceProduct, (String)srcBandName, (Product)this.targetProduct, (boolean)true);
            } else {
                if (srcBandName.contains("azOffset") || srcBandName.contains("rgOffset")) continue;
                targetBand = new Band(srcBandName, band.getDataType(), band.getRasterWidth(), band.getRasterHeight());
                targetBand.setUnit(band.getUnit());
                this.targetProduct.addBand(targetBand);
            }
            if (targetBand == null || !srcBandName.startsWith("q_")) continue;
            String suffix = srcBandName.substring(1);
            ReaderUtils.createVirtualIntensityBand((Product)this.targetProduct, (Band)this.targetProduct.getBand("i" + suffix), (Band)targetBand, (String)suffix);
        }
        this.targetProduct.setPreferredTileSize(512, this.subSwath[this.subSwathIndex - 1].linesPerBurst);
        this.updateTargetMetadata();
    }

    private void updateTargetMetadata() {
        MetadataElement swathElem;
        MetadataElement OverallRgAzShiftElem;
        MetadataElement absTgt = AbstractMetadata.getAbstractedMetadata((Product)this.targetProduct);
        if (absTgt == null) {
            return;
        }
        MetadataElement ESDMeasurement = absTgt.getElement("ESD Measurement");
        if (ESDMeasurement == null) {
            absTgt.addElement(new MetadataElement("ESD Measurement"));
        }
        if ((OverallRgAzShiftElem = (ESDMeasurement = absTgt.getElement("ESD Measurement")).getElement("Overall_Range_Azimuth_Shift")) == null) {
            ESDMeasurement.addElement(new MetadataElement("Overall_Range_Azimuth_Shift"));
        }
        if ((swathElem = (OverallRgAzShiftElem = ESDMeasurement.getElement("Overall_Range_Azimuth_Shift")).getElement(this.subSwathNames[0])) == null) {
            OverallRgAzShiftElem.addElement(new MetadataElement(this.subSwathNames[0]));
        }
        MetadataElement AzShiftPerOverlapElem = new MetadataElement("Azimuth_Shift_Per_Overlap");
        AzShiftPerOverlapElem.addElement(new MetadataElement(this.subSwathNames[0]));
        ESDMeasurement.addElement(AzShiftPerOverlapElem);
        MetadataElement AzShiftPerBlockElem = new MetadataElement("Azimuth_Shift_Per_Block");
        AzShiftPerBlockElem.addElement(new MetadataElement(this.subSwathNames[0]));
        ESDMeasurement.addElement(AzShiftPerBlockElem);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void computeTileStack(Map<Band, Tile> targetTileMap, Rectangle targetRectangle, ProgressMonitor pm) throws OperatorException {
        int x0 = targetRectangle.x;
        int y0 = targetRectangle.y;
        int w = targetRectangle.width;
        int h = targetRectangle.height;
        int xMax = x0 + w;
        int yMax = y0 + h;
        try {
            Band[] sourceBands;
            if (!this.isAzimuthOffsetAvailable) {
                this.estimateAzimuthOffset();
            }
            Band slvBandI = null;
            Band slvBandQ = null;
            Band tgtBandI = null;
            Band tgtBandQ = null;
            Band derampDemodPhaseBand = null;
            for (Band band : sourceBands = this.sourceProduct.getBands()) {
                String bandName = band.getName();
                if (bandName.contains("i_") && bandName.contains("_slv")) {
                    slvBandI = band;
                    tgtBandI = this.targetProduct.getBand(bandName);
                }
                if (bandName.contains("q_") && bandName.contains("_slv")) {
                    slvBandQ = band;
                    tgtBandQ = this.targetProduct.getBand(bandName);
                }
                if (!bandName.contains(DerampDemodPhase)) continue;
                derampDemodPhaseBand = band;
            }
            Tile derampDemodPhaseTile = this.getSourceTile((RasterDataNode)derampDemodPhaseBand, targetRectangle);
            ProductData derampDemodPhaseData = derampDemodPhaseTile.getDataBuffer();
            TileIndex index = new TileIndex(derampDemodPhaseTile);
            double[][] derampDemodPhase = new double[h][w];
            for (int y = y0; y < yMax; ++y) {
                index.calculateStride(y);
                int yy = y - y0;
                for (int x = x0; x < xMax; ++x) {
                    int idx = index.getIndex(x);
                    derampDemodPhase[yy][x - x0] = derampDemodPhaseData.getElemDoubleAt(idx);
                }
            }
            Tile slvTileI = this.getSourceTile((RasterDataNode)slvBandI, targetRectangle);
            Tile slvTileQ = this.getSourceTile((RasterDataNode)slvBandQ, targetRectangle);
            double[][] derampDemodI = new double[h][w];
            double[][] derampDemodQ = new double[h][w];
            BackGeocodingOp.performDerampDemod(slvTileI, slvTileQ, targetRectangle, derampDemodPhase, derampDemodI, derampDemodQ);
            double[] phase = new double[2 * h];
            AzimuthShiftOp.computeShiftPhaseArray(this.azOffset, h, phase);
            Tile tgtTileI = targetTileMap.get(tgtBandI);
            Tile tgtTileQ = targetTileMap.get(tgtBandQ);
            ProductData tgtDataI = tgtTileI.getDataBuffer();
            ProductData tgtDataQ = tgtTileQ.getDataBuffer();
            double[] col1 = new double[2 * h];
            double[] col2 = new double[2 * h];
            DoubleFFT_1D col_fft = new DoubleFFT_1D(h);
            for (int c = 0; c < w; ++c) {
                int r;
                int x = x0 + c;
                for (r = 0; r < h; ++r) {
                    col1[2 * r] = derampDemodI[r][c];
                    col1[2 * r + 1] = derampDemodQ[r][c];
                    col2[2 * r] = derampDemodPhase[r][c];
                    col2[2 * r + 1] = 0.0;
                }
                col_fft.complexForward(col1);
                col_fft.complexForward(col2);
                AzimuthShiftOp.multiplySpectrumByShiftFactor(col1, phase);
                AzimuthShiftOp.multiplySpectrumByShiftFactor(col2, phase);
                col_fft.complexInverse(col1, true);
                col_fft.complexInverse(col2, true);
                for (r = 0; r < h; ++r) {
                    int y = y0 + r;
                    double cosPhase = FastMath.cos((double)col2[2 * r]);
                    double sinPhase = FastMath.sin((double)col2[2 * r]);
                    int idx = tgtTileI.getDataBufferIndex(x, y);
                    tgtDataI.setElemDoubleAt(idx, (double)((float)(col1[2 * r] * cosPhase + col1[2 * r + 1] * sinPhase)));
                    tgtDataQ.setElemDoubleAt(idx, (double)((float)(-col1[2 * r] * sinPhase + col1[2 * r + 1] * cosPhase)));
                }
            }
        }
        catch (Throwable e) {
            OperatorUtils.catchOperatorException((String)this.getId(), (Throwable)e);
        }
        finally {
            pm.done();
        }
    }

    private synchronized void estimateAzimuthOffset() {
        if (this.isAzimuthOffsetAvailable) {
            return;
        }
        int numOverlaps = this.subSwath[this.subSwathIndex - 1].numOfBursts - 1;
        int numShifts = numOverlaps * this.numBlocksPerOverlap;
        StatusProgressMonitor status = new StatusProgressMonitor(StatusProgressMonitor.TYPE.SUBTASK);
        status.beginTask("Estimating azimuth offset... ", numShifts);
        ThreadManager threadManager = new ThreadManager();
        try {
            final Band mBandI = this.getBand("_mst", "i_", this.swathIndexStr, this.polarizations[0]);
            final Band mBandQ = this.getBand("_mst", "q_", this.swathIndexStr, this.polarizations[0]);
            final Band sBandI = this.getBand("_slv", "i_", this.swathIndexStr, this.polarizations[0]);
            final Band sBandQ = this.getBand("_slv", "q_", this.swathIndexStr, this.polarizations[0]);
            final double spectralSeparation = this.computeSpectralSeparation();
            final ArrayList<AzimuthShiftData> azShiftArray = new ArrayList<AzimuthShiftData>(numShifts);
            for (int i = 0; i < numOverlaps; ++i) {
                Rectangle overlapInBurstOneRectangle = new Rectangle();
                Rectangle overlapInBurstTwoRectangle = new Rectangle();
                this.getOverlappedRectangles(i, overlapInBurstOneRectangle, overlapInBurstTwoRectangle);
                final double[][] coherence = this.computeCoherence(overlapInBurstOneRectangle, mBandI, mBandQ, sBandI, sBandQ, 5);
                final int w = overlapInBurstOneRectangle.width / this.numBlocksPerOverlap;
                final int h = overlapInBurstOneRectangle.height;
                int x0BurstOne = overlapInBurstOneRectangle.x;
                final int y0BurstOne = overlapInBurstOneRectangle.y;
                final int y0BurstTwo = overlapInBurstTwoRectangle.y;
                final int overlapIndex = i;
                int j = 0;
                while (j < this.numBlocksPerOverlap) {
                    this.checkForCancellation();
                    final int x0 = x0BurstOne + j * w;
                    final int blockIndex = j++;
                    Thread worker = new Thread(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            try {
                                Rectangle blockInBurstOneRectangle = new Rectangle(x0, y0BurstOne, w, h);
                                Rectangle blockInBurstTwoRectangle = new Rectangle(x0, y0BurstTwo, w, h);
                                double[] blockCoherence = AzimuthShiftOp.this.getBlockCoherence(blockIndex, w, h, coherence);
                                double azShift = AzimuthShiftOp.this.estimateAzOffsets(mBandI, mBandQ, sBandI, sBandQ, blockCoherence, blockInBurstTwoRectangle, blockInBurstOneRectangle, spectralSeparation);
                                List list = azShiftArray;
                                synchronized (list) {
                                    azShiftArray.add(new AzimuthShiftData(overlapIndex, blockIndex, azShift));
                                }
                            }
                            catch (Throwable e) {
                                OperatorUtils.catchOperatorException((String)"estimateOffset", (Throwable)e);
                            }
                        }
                    };
                    threadManager.add(worker);
                    status.worked(1);
                }
            }
            status.done();
            threadManager.finish();
            double[] averagedAzShiftArray = new double[numOverlaps];
            double totalOffset = 0.0;
            for (int i = 0; i < numOverlaps; ++i) {
                double sumAzOffset = 0.0;
                for (int j = 0; j < numShifts; ++j) {
                    if (((AzimuthShiftData)azShiftArray.get((int)j)).overlapIndex != i) continue;
                    sumAzOffset += ((AzimuthShiftData)azShiftArray.get((int)j)).shift;
                }
                averagedAzShiftArray[i] = sumAzOffset / (double)this.numBlocksPerOverlap;
                totalOffset += sumAzOffset;
            }
            this.azOffset = -totalOffset / (double)numShifts;
            SystemUtils.LOG.info("AzimuthShiftOp: Overall azimuth shift = " + this.azOffset);
            this.saveOverallAzimuthShift(this.azOffset);
            this.saveAzimuthShiftPerOverlap(averagedAzShiftArray);
            this.saveAzimuthShiftPerBlock(azShiftArray);
        }
        catch (Throwable e) {
            OperatorUtils.catchOperatorException((String)"estimateAzimuthOffset", (Throwable)e);
        }
        this.isAzimuthOffsetAvailable = true;
    }

    private double computeSpectralSeparation() {
        double tCycle = (double)this.subSwath[this.subSwathIndex - 1].linesPerBurst * this.subSwath[this.subSwathIndex - 1].azimuthTimeInterval;
        double sumSpectralSeparation = 0.0;
        for (int b = 0; b < this.subSwath[this.subSwathIndex - 1].numOfBursts; ++b) {
            for (int p = 0; p < this.subSwath[this.subSwathIndex - 1].samplesPerBurst; ++p) {
                sumSpectralSeparation += this.subSwath[this.subSwathIndex - 1].dopplerRate[b][p] * tCycle;
            }
        }
        return sumSpectralSeparation / (double)(this.subSwath[this.subSwathIndex - 1].numOfBursts * this.subSwath[this.subSwathIndex - 1].samplesPerBurst);
    }

    private void getOverlappedRectangles(int overlapIndex, Rectangle overlapInBurstOneRectangle, Rectangle overlapInBurstTwoRectangle) {
        int firstValidPixelOfBurstOne = this.getBurstFirstValidPixel(overlapIndex);
        int lastValidPixelOfBurstOne = this.getBurstLastValidPixel(overlapIndex);
        int firstValidPixelOfBurstTwo = this.getBurstFirstValidPixel(overlapIndex + 1);
        int lastValidPixelOfBurstTwo = this.getBurstLastValidPixel(overlapIndex + 1);
        int firstValidPixel = Math.max(firstValidPixelOfBurstOne, firstValidPixelOfBurstTwo);
        int lastValidPixel = Math.min(lastValidPixelOfBurstOne, lastValidPixelOfBurstTwo);
        int x0 = firstValidPixel;
        int w = lastValidPixel - firstValidPixel + 1;
        int numOfInvalidLinesInBurstOne = this.subSwath[this.subSwathIndex - 1].linesPerBurst - this.subSwath[this.subSwathIndex - 1].lastValidLine[overlapIndex] - 1;
        int numOfInvalidLinesInBurstTwo = this.subSwath[this.subSwathIndex - 1].firstValidLine[overlapIndex + 1];
        int numOverlappedLines = this.computeBurstOverlapSize(overlapIndex);
        int h = numOverlappedLines - numOfInvalidLinesInBurstOne - numOfInvalidLinesInBurstTwo;
        int y0BurstOne = this.subSwath[this.subSwathIndex - 1].linesPerBurst * (overlapIndex + 1) - numOfInvalidLinesInBurstOne - h;
        int y0BurstTwo = this.subSwath[this.subSwathIndex - 1].linesPerBurst * (overlapIndex + 1) + numOfInvalidLinesInBurstTwo;
        overlapInBurstOneRectangle.setBounds(x0, y0BurstOne, w, h);
        overlapInBurstTwoRectangle.setBounds(x0, y0BurstTwo, w, h);
    }

    private int getBurstFirstValidPixel(int burstIndex) {
        for (int lineIdx = 0; lineIdx < this.subSwath[this.subSwathIndex - 1].firstValidSample[burstIndex].length; ++lineIdx) {
            if (this.subSwath[this.subSwathIndex - 1].firstValidSample[burstIndex][lineIdx] == -1) continue;
            return this.subSwath[this.subSwathIndex - 1].firstValidSample[burstIndex][lineIdx];
        }
        return -1;
    }

    private int getBurstLastValidPixel(int burstIndex) {
        for (int lineIdx = 0; lineIdx < this.subSwath[this.subSwathIndex - 1].lastValidSample[burstIndex].length; ++lineIdx) {
            if (this.subSwath[this.subSwathIndex - 1].lastValidSample[burstIndex][lineIdx] == -1) continue;
            return this.subSwath[this.subSwathIndex - 1].lastValidSample[burstIndex][lineIdx];
        }
        return -1;
    }

    private double[] getBlockCoherence(int blockIndex, int blockWidth, int blockHeight, double[][] coherence) {
        double[] blockCoherence = new double[blockWidth * blockHeight];
        for (int i = 0; i < blockCoherence.length; ++i) {
            int r = i / blockWidth;
            int c = blockIndex * blockWidth + i - r * blockWidth;
            blockCoherence[i] = coherence[r][c];
        }
        return blockCoherence;
    }

    private void saveOverallAzimuthShift(double azimuthShift) {
        MetadataElement absTgt = AbstractMetadata.getAbstractedMetadata((Product)this.targetProduct);
        if (absTgt == null) {
            return;
        }
        MetadataElement ESDMeasurement = absTgt.getElement("ESD Measurement");
        MetadataElement OverallRgAzShiftElem = ESDMeasurement.getElement("Overall_Range_Azimuth_Shift");
        MetadataElement swathElem = OverallRgAzShiftElem.getElement(this.subSwathNames[0]);
        MetadataAttribute azimuthShiftAttr = new MetadataAttribute("azimuthShift", 30);
        azimuthShiftAttr.setUnit("pixel");
        swathElem.addAttribute(azimuthShiftAttr);
        swathElem.setAttributeDouble("azimuthShift", azimuthShift);
    }

    private void saveAzimuthShiftPerOverlap(double[] averagedAzShiftArray) {
        MetadataElement absTgt = AbstractMetadata.getAbstractedMetadata((Product)this.targetProduct);
        if (absTgt == null) {
            return;
        }
        MetadataElement ESDMeasurement = absTgt.getElement("ESD Measurement");
        MetadataElement AzShiftPerOverlapElem = ESDMeasurement.getElement("Azimuth_Shift_Per_Overlap");
        MetadataElement swathElem = AzShiftPerOverlapElem.getElement(this.subSwathNames[0]);
        swathElem.addAttribute(new MetadataAttribute("count", 11));
        swathElem.setAttributeInt("count", averagedAzShiftArray.length);
        for (int i = 0; i < averagedAzShiftArray.length; ++i) {
            MetadataElement overlapListElem = new MetadataElement("AzimuthShiftList." + i);
            MetadataAttribute azimuthShiftAttr = new MetadataAttribute("azimuthShift", 30);
            azimuthShiftAttr.setUnit("pixel");
            overlapListElem.addAttribute(azimuthShiftAttr);
            overlapListElem.setAttributeDouble("azimuthShift", averagedAzShiftArray[i]);
            overlapListElem.addAttribute(new MetadataAttribute("overlapIndex", 11));
            overlapListElem.setAttributeInt("overlapIndex", i);
            swathElem.addElement(overlapListElem);
        }
    }

    private void saveAzimuthShiftPerBlock(List<AzimuthShiftData> azShiftArray) {
        MetadataElement absTgt = AbstractMetadata.getAbstractedMetadata((Product)this.targetProduct);
        if (absTgt == null) {
            return;
        }
        MetadataElement ESDMeasurement = absTgt.getElement("ESD Measurement");
        MetadataElement AzShiftPerBlockElem = ESDMeasurement.getElement("Azimuth_Shift_Per_Block");
        MetadataElement swathElem = AzShiftPerBlockElem.getElement(this.subSwathNames[0]);
        swathElem.addAttribute(new MetadataAttribute("count", 11));
        swathElem.setAttributeInt("count", azShiftArray.size());
        for (int i = 0; i < azShiftArray.size(); ++i) {
            MetadataElement overlapListElem = new MetadataElement("AzimuthShiftList." + i);
            MetadataAttribute azimuthShiftAttr = new MetadataAttribute("azimuthShift", 30);
            azimuthShiftAttr.setUnit("pixel");
            overlapListElem.addAttribute(azimuthShiftAttr);
            overlapListElem.setAttributeDouble("azimuthShift", azShiftArray.get((int)i).shift);
            overlapListElem.addAttribute(new MetadataAttribute("overlapIndex", 11));
            overlapListElem.setAttributeInt("overlapIndex", azShiftArray.get((int)i).overlapIndex);
            overlapListElem.addAttribute(new MetadataAttribute("blockIndex", 11));
            overlapListElem.setAttributeInt("blockIndex", azShiftArray.get((int)i).blockIndex);
            swathElem.addElement(overlapListElem);
        }
    }

    private int computeBurstOverlapSize(int overlapIndex) {
        double endTime = this.subSwath[this.subSwathIndex - 1].burstLastLineTime[overlapIndex];
        double startTime = this.subSwath[this.subSwathIndex - 1].burstFirstLineTime[overlapIndex + 1];
        return (int)((endTime - startTime) / this.subSwath[this.subSwathIndex - 1].azimuthTimeInterval);
    }

    private double estimateAzOffsets(Band mBandI, Band mBandQ, Band sBandI, Band sBandQ, double[] blockCoherence, Rectangle backwardRectangle, Rectangle forwardRectangle, double spectralSeparation) {
        double[] sQForArray;
        double[] sIForArray;
        double[] mQForArray;
        double[] mIForArray;
        double[] sQBackArray;
        double[] sIBackArray;
        double[] mQBackArray;
        double[] mIBackArray;
        int mDataType = mBandI.getDataType();
        int sDataType = sBandI.getDataType();
        Tile mTileIBack = this.getSourceTile((RasterDataNode)mBandI, backwardRectangle);
        Tile mTileQBack = this.getSourceTile((RasterDataNode)mBandQ, backwardRectangle);
        Tile sTileIBack = this.getSourceTile((RasterDataNode)sBandI, backwardRectangle);
        Tile sTileQBack = this.getSourceTile((RasterDataNode)sBandQ, backwardRectangle);
        if (mDataType == 11) {
            short[] mIBackArrayShort = (short[])mTileIBack.getDataBuffer().getElems();
            short[] mQBackArrayShort = (short[])mTileQBack.getDataBuffer().getElems();
            mIBackArray = new double[mIBackArrayShort.length];
            mQBackArray = new double[mQBackArrayShort.length];
            for (int i = 0; i < mIBackArrayShort.length; ++i) {
                mIBackArray[i] = mIBackArrayShort[i];
                mQBackArray[i] = mQBackArrayShort[i];
            }
        } else {
            mIBackArray = (double[])mTileIBack.getDataBuffer().getElems();
            mQBackArray = (double[])mTileQBack.getDataBuffer().getElems();
        }
        if (sDataType == 30) {
            float[] sIBackArrayFloat = (float[])sTileIBack.getDataBuffer().getElems();
            float[] sQBackArrayFloat = (float[])sTileQBack.getDataBuffer().getElems();
            sIBackArray = new double[sIBackArrayFloat.length];
            sQBackArray = new double[sQBackArrayFloat.length];
            for (int i = 0; i < sIBackArrayFloat.length; ++i) {
                sIBackArray[i] = sIBackArrayFloat[i];
                sQBackArray[i] = sQBackArrayFloat[i];
            }
        } else {
            sIBackArray = (double[])sTileIBack.getDataBuffer().getElems();
            sQBackArray = (double[])sTileQBack.getDataBuffer().getElems();
        }
        Tile mTileIFor = this.getSourceTile((RasterDataNode)mBandI, forwardRectangle);
        Tile mTileQFor = this.getSourceTile((RasterDataNode)mBandQ, forwardRectangle);
        Tile sTileIFor = this.getSourceTile((RasterDataNode)sBandI, forwardRectangle);
        Tile sTileQFor = this.getSourceTile((RasterDataNode)sBandQ, forwardRectangle);
        if (mDataType == 11) {
            short[] mIForArrayShort = (short[])mTileIFor.getDataBuffer().getElems();
            short[] mQForArrayShort = (short[])mTileQFor.getDataBuffer().getElems();
            mIForArray = new double[mIForArrayShort.length];
            mQForArray = new double[mQForArrayShort.length];
            for (int i = 0; i < mIForArrayShort.length; ++i) {
                mIForArray[i] = mIForArrayShort[i];
                mQForArray[i] = mQForArrayShort[i];
            }
        } else {
            mIForArray = (double[])mTileIFor.getDataBuffer().getElems();
            mQForArray = (double[])mTileQFor.getDataBuffer().getElems();
        }
        if (sDataType == 30) {
            float[] sIForArrayFloat = (float[])sTileIFor.getDataBuffer().getElems();
            float[] sQForArrayFloat = (float[])sTileQFor.getDataBuffer().getElems();
            sIForArray = new double[sIForArrayFloat.length];
            sQForArray = new double[sQForArrayFloat.length];
            for (int i = 0; i < sIForArrayFloat.length; ++i) {
                sIForArray[i] = sIForArrayFloat[i];
                sQForArray[i] = sQForArrayFloat[i];
            }
        } else {
            sIForArray = (double[])sTileIFor.getDataBuffer().getElems();
            sQForArray = (double[])sTileQFor.getDataBuffer().getElems();
        }
        int arrayLength = mIBackArray.length;
        double[] backIntReal = new double[arrayLength];
        double[] backIntImag = new double[arrayLength];
        AzimuthShiftOp.complexArrayMultiplication(mIBackArray, mQBackArray, sIBackArray, sQBackArray, backIntReal, backIntImag);
        double[] forIntReal = new double[arrayLength];
        double[] forIntImag = new double[arrayLength];
        AzimuthShiftOp.complexArrayMultiplication(mIForArray, mQForArray, sIForArray, sQForArray, forIntReal, forIntImag);
        double[] diffIntReal = new double[arrayLength];
        double[] diffIntImag = new double[arrayLength];
        AzimuthShiftOp.complexArrayMultiplication(forIntReal, forIntImag, backIntReal, backIntImag, diffIntReal, diffIntImag);
        double sumReal = 0.0;
        double sumImag = 0.0;
        for (int i = 0; i < arrayLength; ++i) {
            if (!(blockCoherence[i] > this.cohThreshold)) continue;
            double theta = Math.atan2(diffIntImag[i], diffIntReal[i]);
            sumReal += FastMath.cos((double)theta);
            sumImag += FastMath.sin((double)theta);
        }
        double phase = Math.atan2(sumImag, sumReal);
        return phase / (Math.PI * 2 * spectralSeparation * this.subSwath[this.subSwathIndex - 1].azimuthTimeInterval);
    }

    private static void complexArrayMultiplication(double[] realArray1, double[] imagArray1, double[] realArray2, double[] imagArray2, double[] realOutput, double[] imagOutput) {
        int arrayLength = realArray1.length;
        if (imagArray1.length != arrayLength || realArray2.length != arrayLength || imagArray2.length != arrayLength || realOutput.length != arrayLength || imagOutput.length != arrayLength) {
            throw new OperatorException("Arrays of the same length are expected.");
        }
        for (int i = 0; i < arrayLength; ++i) {
            realOutput[i] = realArray1[i] * realArray2[i] + imagArray1[i] * imagArray2[i];
            imagOutput[i] = imagArray1[i] * realArray2[i] - realArray1[i] * imagArray2[i];
        }
    }

    private Band getBand(String suffix, String prefix, String swathIndexStr, String polarization) {
        String[] bandNames;
        for (String bandName : bandNames = this.sourceProduct.getBandNames()) {
            if (!bandName.contains(suffix) || !bandName.contains(prefix) || !bandName.contains(swathIndexStr) || !bandName.contains(polarization)) continue;
            return this.sourceProduct.getBand(bandName);
        }
        return null;
    }

    private static void computeShiftPhaseArray(double shift, int signalLength, double[] phaseArray) {
        double phase = Math.PI * -2 * shift / (double)signalLength;
        int halfSignalLength = (int)((double)signalLength * 0.5 + 0.5);
        for (int k = 0; k < signalLength; ++k) {
            double phaseK = k < halfSignalLength ? phase * (double)k : phase * (double)(k - signalLength);
            int k2 = k * 2;
            phaseArray[k2] = FastMath.cos((double)phaseK);
            phaseArray[k2 + 1] = FastMath.sin((double)phaseK);
        }
    }

    private static void multiplySpectrumByShiftFactor(double[] array, double[] phaseArray) {
        int signalLength = array.length / 2;
        for (int k = 0; k < signalLength; ++k) {
            int k2 = k * 2;
            double c = phaseArray[k2];
            double s = phaseArray[k2 + 1];
            double real = array[k2];
            double imag = array[k2 + 1];
            array[k2] = real * c - imag * s;
            array[k2 + 1] = real * s + imag * c;
        }
    }

    private double[][] computeCoherence(Rectangle rectangle, Band mBandI, Band mBandQ, Band sBandI, Band sBandQ, int cohWin) {
        int x;
        int yy;
        int y;
        int x0 = rectangle.x;
        int y0 = rectangle.y;
        int w = rectangle.width;
        int h = rectangle.height;
        int xMax = x0 + w;
        int yMax = y0 + h;
        int halfWindowSize = cohWin / 2;
        double[][] coherence = new double[h][w];
        Tile mstTileI = this.getSourceTile((RasterDataNode)mBandI, rectangle);
        Tile mstTileQ = this.getSourceTile((RasterDataNode)mBandQ, rectangle);
        ProductData mstDataBufferI = mstTileI.getDataBuffer();
        ProductData mstDataBufferQ = mstTileQ.getDataBuffer();
        Tile slvTileI = this.getSourceTile((RasterDataNode)sBandI, rectangle);
        Tile slvTileQ = this.getSourceTile((RasterDataNode)sBandQ, rectangle);
        ProductData slvDataBufferI = slvTileI.getDataBuffer();
        ProductData slvDataBufferQ = slvTileQ.getDataBuffer();
        TileIndex srcIndex = new TileIndex(mstTileI);
        double[][] cohReal = new double[h][w];
        double[][] cohImag = new double[h][w];
        double[][] mstPower = new double[h][w];
        double[][] slvPower = new double[h][w];
        for (y = y0; y < yMax; ++y) {
            srcIndex.calculateStride(y);
            yy = y - y0;
            for (x = x0; x < xMax; ++x) {
                int srcIdx = srcIndex.getIndex(x);
                int xx = x - x0;
                float mI = mstDataBufferI.getElemFloatAt(srcIdx);
                float mQ = mstDataBufferQ.getElemFloatAt(srcIdx);
                float sI = slvDataBufferI.getElemFloatAt(srcIdx);
                float sQ = slvDataBufferQ.getElemFloatAt(srcIdx);
                cohReal[yy][xx] = mI * sI + mQ * sQ;
                cohImag[yy][xx] = mQ * sI - mI * sQ;
                mstPower[yy][xx] = mI * mI + mQ * mQ;
                slvPower[yy][xx] = sI * sI + sQ * sQ;
            }
        }
        for (y = y0; y < yMax; ++y) {
            yy = y - y0;
            for (x = x0; x < xMax; ++x) {
                int xx = x - x0;
                int rowSt = Math.max(yy - halfWindowSize, 0);
                int rowEd = Math.min(yy + halfWindowSize, h - 1);
                int colSt = Math.max(xx - halfWindowSize, 0);
                int colEd = Math.min(xx + halfWindowSize, w - 1);
                float cohRealSum = 0.0f;
                float cohImagSum = 0.0f;
                float mstPowerSum = 0.0f;
                float slvPowerSum = 0.0f;
                int count = 0;
                for (int r = rowSt; r <= rowEd; ++r) {
                    for (int c = colSt; c <= colEd; ++c) {
                        cohRealSum = (float)((double)cohRealSum + cohReal[r][c]);
                        cohImagSum = (float)((double)cohImagSum + cohImag[r][c]);
                        mstPowerSum = (float)((double)mstPowerSum + mstPower[r][c]);
                        slvPowerSum = (float)((double)slvPowerSum + slvPower[r][c]);
                        ++count;
                    }
                }
                if (count <= 0 || (double)mstPowerSum == 0.0 || (double)slvPowerSum == 0.0) continue;
                double cohRealMean = cohRealSum / (float)count;
                double cohImagMean = cohImagSum / (float)count;
                double mstPowerMean = mstPowerSum / (float)count;
                double slvPowerMean = slvPowerSum / (float)count;
                coherence[yy][xx] = Math.sqrt((cohRealMean * cohRealMean + cohImagMean * cohImagMean) / (mstPowerMean * slvPowerMean));
            }
        }
        return coherence;
    }

    public static class Spi
    extends OperatorSpi {
        public Spi() {
            super(AzimuthShiftOp.class);
        }
    }

    private static class AzimuthShiftData {
        int overlapIndex;
        int blockIndex;
        double shift;

        public AzimuthShiftData(int overlapIndex, int blockIndex, double shift) {
            this.overlapIndex = overlapIndex;
            this.blockIndex = blockIndex;
            this.shift = shift;
        }
    }
}

