/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s1tbx.sentinel1.rcp.layers.topsbursts;

import com.bc.ceres.binding.PropertySet;
import com.bc.ceres.glayer.Layer;
import com.bc.ceres.glayer.LayerType;
import com.bc.ceres.grender.Rendering;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import org.esa.s1tbx.commons.graphics.GraphicText;
import org.esa.s1tbx.dat.layers.LayerSelection;
import org.esa.s1tbx.dat.layers.ScreenPixelConverter;
import org.esa.snap.core.datamodel.GeoCoding;
import org.esa.snap.core.datamodel.GeoPos;
import org.esa.snap.core.datamodel.MetadataElement;
import org.esa.snap.core.datamodel.PixelPos;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.util.SystemUtils;
import org.esa.snap.engine_utilities.datamodel.AbstractMetadata;

public class TOPSBurstsLayer
extends Layer
implements LayerSelection {
    private final Product product;
    private final RasterDataNode raster;
    private final List<Swath> swathList = new ArrayList<Swath>(5);
    private static final BasicStroke thickStroke = new BasicStroke(4.0f, 2, 0, 10.0f, new float[]{5.0f}, 0.0f);
    private static final BasicStroke thinStroke = new BasicStroke(2.0f);

    public TOPSBurstsLayer(LayerType layerType, PropertySet configuration) {
        super(layerType, configuration);
        MetadataElement burstBoundaryElem;
        this.setName("TOPS Burst Boundaries");
        this.raster = (RasterDataNode)configuration.getValue("raster");
        this.product = this.raster.getProduct();
        MetadataElement absRoot = AbstractMetadata.getAbstractedMetadata((Product)this.product);
        if (absRoot != null && (burstBoundaryElem = absRoot.getElement("BurstBoundary")) != null) {
            MetadataElement[] swathElems;
            for (MetadataElement swathElem : swathElems = burstBoundaryElem.getElements()) {
                this.swathList.add(new Swath(swathElem, this.product));
            }
        }
        this.regenerate();
    }

    public void regenerate() {
    }

    protected void renderLayer(Rendering rendering) {
        GeoCoding geoCoding = this.product.getSceneGeoCoding();
        if (geoCoding == null) {
            return;
        }
        ScreenPixelConverter screenPixel = new ScreenPixelConverter(rendering.getViewport(), this.raster);
        if (!screenPixel.withInBounds()) {
            return;
        }
        Graphics2D g = rendering.getGraphics();
        for (Swath swath : this.swathList) {
            swath.render(g, screenPixel);
        }
    }

    public void selectRectangle(Rectangle rect) {
    }

    public void selectPoint(int x, int y) {
    }

    private static class Burst {
        private final String name;
        private final Product product;
        private final List<PixelPos> firstLinePosList = new ArrayList<PixelPos>(6);
        private final List<PixelPos> lastLinePosList = new ArrayList<PixelPos>(6);

        public Burst(MetadataElement burstElem, Product product) {
            this.name = burstElem.getName();
            this.product = product;
            this.getBoundaryPoints(burstElem.getElement("FirstLineBoundaryPoints"), this.firstLinePosList);
            this.getBoundaryPoints(burstElem.getElement("LastLineBoundaryPoints"), this.lastLinePosList);
        }

        private void getBoundaryPoints(MetadataElement lineBoundaryPoints, List<PixelPos> posList) {
            MetadataElement[] boundaryPoints;
            if (lineBoundaryPoints == null) {
                return;
            }
            GeoCoding geoCoding = this.product.getSceneGeoCoding();
            GeoPos pos0 = geoCoding.getGeoPos(new PixelPos(0.0, 0.0), null);
            GeoPos posH = geoCoding.getGeoPos(new PixelPos(0.0, (double)this.product.getSceneRasterHeight()), null);
            double minLon = Math.min(pos0.getLon(), posH.getLon());
            for (MetadataElement boundaryPoint : boundaryPoints = lineBoundaryPoints.getElements()) {
                double lon;
                double lat = boundaryPoint.getAttributeDouble("lat");
                PixelPos pixelPos = geoCoding.getPixelPos(new GeoPos(lat, lon = boundaryPoint.getAttributeDouble("lon")), null);
                if (!pixelPos.isValid() && !(pixelPos = geoCoding.getPixelPos(new GeoPos(lat, lon = Math.max(minLon, lon)), null)).isValid()) {
                    SystemUtils.LOG.severe("oops " + lat + ", " + lon);
                    pixelPos = geoCoding.getPixelPos(new GeoPos(lat, lon), null);
                }
                posList.add(pixelPos);
            }
        }

        public PixelPos getFirstPoint() {
            return this.firstLinePosList.get(0);
        }

        public void render(Graphics2D g, ScreenPixelConverter screenPixel) {
            int i;
            Path2D.Float path = new Path2D.Float();
            Point2D.Double p = screenPixel.pixelToScreen(this.firstLinePosList.get((int)0).x, this.firstLinePosList.get((int)0).y);
            path.moveTo(p.x, p.y);
            for (i = 1; i < this.firstLinePosList.size(); ++i) {
                p = screenPixel.pixelToScreen(this.firstLinePosList.get((int)i).x, this.firstLinePosList.get((int)i).y);
                path.lineTo(p.x, p.y);
            }
            for (i = this.lastLinePosList.size() - 1; i >= 0; --i) {
                p = screenPixel.pixelToScreen(this.lastLinePosList.get((int)i).x, this.lastLinePosList.get((int)i).y);
                path.lineTo(p.x, p.y);
            }
            p = screenPixel.pixelToScreen(this.firstLinePosList.get((int)0).x, this.firstLinePosList.get((int)0).y);
            path.lineTo(p.x, p.y);
            g.setColor(Color.CYAN);
            g.setStroke(thinStroke);
            g.draw(path);
        }
    }

    private static class Swath {
        private final List<Burst> burstList = new ArrayList<Burst>(10);
        private final String name;

        public Swath(MetadataElement swathElem, Product product) {
            MetadataElement[] burstElems;
            this.name = swathElem.getName();
            for (MetadataElement burstElem : burstElems = swathElem.getElements()) {
                this.burstList.add(new Burst(burstElem, product));
            }
        }

        public void render(Graphics2D g, ScreenPixelConverter screenPixel) {
            for (Burst burst : this.burstList) {
                burst.render(g, screenPixel);
            }
            PixelPos pos = this.burstList.get(0).getFirstPoint();
            Point2D.Double p = screenPixel.pixelToScreen(pos.x, pos.y);
            GraphicText.highlightText((Graphics2D)g, (Color)Color.CYAN, (String)this.name, (int)((int)p.x + 10), (int)((int)p.y + 20), (Color)Color.BLUE);
        }
    }
}

