/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s1tbx.sentinel1.gpf.ui;

import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.esa.s1tbx.commons.Sentinel1Utils;
import org.esa.snap.core.datamodel.GeoPos;
import org.esa.snap.core.datamodel.MetadataElement;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.engine_utilities.datamodel.AbstractMetadata;
import org.esa.snap.graphbuilder.gpf.ui.BaseOperatorUI;
import org.esa.snap.graphbuilder.gpf.ui.OperatorUIUtils;
import org.esa.snap.graphbuilder.gpf.ui.UIValidation;
import org.esa.snap.graphbuilder.gpf.ui.worldmap.NestWorldMapPane;
import org.esa.snap.graphbuilder.gpf.ui.worldmap.WorldMapUI;
import org.esa.snap.graphbuilder.rcp.utils.DialogUtils;
import org.esa.snap.ui.AppContext;
import prefuse.util.ui.JRangeSlider;

public class TOPSARSplitOpUI
extends BaseOperatorUI {
    private final JComboBox<String> subswathCombo = new JComboBox();
    private final JList<String> polList = new JList();
    private final JLabel burstLabel = new JLabel("");
    private final JRangeSlider burstRange = new JRangeSlider(0, 0, 0, 0, 1);
    private final Map<String, Integer> swathBurstsMap = new HashMap<String, Integer>();
    private final WorldMapUI worldMapUI = new WorldMapUI();
    private Sentinel1Utils su = null;

    public JComponent CreateOpTab(String operatorName, Map<String, Object> parameterMap, AppContext appContext) {
        this.initializeOperatorUI(operatorName, parameterMap);
        this.subswathCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                Integer max = (Integer)TOPSARSplitOpUI.this.swathBurstsMap.get(TOPSARSplitOpUI.this.subswathCombo.getSelectedItem());
                if (max != null) {
                    TOPSARSplitOpUI.this.burstRange.setMaximum(max.intValue());
                }
                if (TOPSARSplitOpUI.this.su != null) {
                    TOPSARSplitOpUI.this.burstLabel.setText(TOPSARSplitOpUI.this.burstRange.getLowValue() + " to " + TOPSARSplitOpUI.this.burstRange.getHighValue() + " (max number of bursts: " + TOPSARSplitOpUI.this.burstRange.getMaximum() + ")");
                    TOPSARSplitOpUI.this.worldMapUI.getModel().setAdditionalGeoBoundaries(TOPSARSplitOpUI.this.getSelectedBoundaries());
                }
            }
        });
        this.burstRange.setMinimum(1);
        this.burstRange.setMaximum(9999);
        this.burstRange.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                TOPSARSplitOpUI.this.burstLabel.setText(TOPSARSplitOpUI.this.burstRange.getLowValue() + " to " + TOPSARSplitOpUI.this.burstRange.getHighValue() + " (max number of bursts: " + TOPSARSplitOpUI.this.burstRange.getMaximum() + ")");
                if (TOPSARSplitOpUI.this.su != null) {
                    TOPSARSplitOpUI.this.worldMapUI.getModel().setAdditionalGeoBoundaries(TOPSARSplitOpUI.this.getSelectedBoundaries());
                }
            }
        });
        JComponent panel = this.createPanel();
        this.initParameters();
        return new JScrollPane(panel);
    }

    public void initParameters() {
        if (this.sourceProducts != null && this.sourceProducts.length > 0) {
            MetadataElement absRoot = AbstractMetadata.getAbstractedMetadata((Product)this.sourceProducts[0]);
            String acquisitionMode = absRoot.getAttributeString("ACQUISITION_MODE");
            this.subswathCombo.removeAllItems();
            if (acquisitionMode.equals("IW")) {
                this.subswathCombo.addItem("IW1");
                this.subswathCombo.addItem("IW2");
                this.subswathCombo.addItem("IW3");
            } else if (acquisitionMode.equals("EW")) {
                this.subswathCombo.addItem("EW1");
                this.subswathCombo.addItem("EW2");
                this.subswathCombo.addItem("EW3");
                this.subswathCombo.addItem("EW4");
                this.subswathCombo.addItem("EW5");
            }
            String subswath = (String)this.paramMap.get("subswath");
            if (subswath == null) {
                subswath = acquisitionMode + '1';
            }
            this.subswathCombo.setSelectedItem(subswath);
            OperatorUIUtils.initParamList(this.polList, (String[])Sentinel1Utils.getProductPolarizations((MetadataElement)absRoot), (Object[])((String[])this.paramMap.get("selectedPolarisations")));
            try {
                this.su = new Sentinel1Utils(this.sourceProducts[0]);
                for (int ss = 0; ss < this.subswathCombo.getItemCount(); ++ss) {
                    String swath = this.subswathCombo.getItemAt(ss);
                    this.swathBurstsMap.put(swath, this.su.getNumOfBursts(swath));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.burstRange.setMaximum(this.swathBurstsMap.get(subswath).intValue());
            this.worldMapUI.getModel().setAutoZoomEnabled(true);
            this.worldMapUI.getModel().setProducts(this.sourceProducts);
            this.worldMapUI.getModel().setSelectedProduct(this.sourceProducts[0]);
            this.worldMapUI.getWorlMapPane().zoomToProduct(this.sourceProducts[0]);
            this.worldMapUI.getWorlMapPane().revalidate();
        }
        this.burstRange.setLowValue(((Integer)this.paramMap.get("firstBurstIndex")).intValue());
        this.burstRange.setHighValue(((Integer)this.paramMap.get("lastBurstIndex")).intValue());
        if (this.burstRange.getHighValue() > this.burstRange.getMaximum()) {
            this.burstRange.setHighValue(this.burstRange.getMaximum());
        }
    }

    public UIValidation validateParameters() {
        return new UIValidation(UIValidation.State.OK, "");
    }

    public void updateParameters() {
        String subswathValue = (String)this.subswathCombo.getSelectedItem();
        if (subswathValue != null) {
            this.paramMap.put("subswath", subswathValue);
        }
        OperatorUIUtils.updateParamList(this.polList, (Map)this.paramMap, (String)"selectedPolarisations");
        this.paramMap.put("firstBurstIndex", this.burstRange.getLowValue());
        this.paramMap.put("lastBurstIndex", this.burstRange.getHighValue());
    }

    private JComponent createPanel() {
        JPanel contentPane = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = DialogUtils.createGridBagConstraints();
        DialogUtils.addComponent((JPanel)contentPane, (GridBagConstraints)gbc, (String)"Subswath:", this.subswathCombo);
        ++gbc.gridy;
        DialogUtils.addComponent((JPanel)contentPane, (GridBagConstraints)gbc, (String)"Polarisations:", this.polList);
        ++gbc.gridy;
        DialogUtils.addComponent((JPanel)contentPane, (GridBagConstraints)gbc, (String)"Bursts:", (JComponent)this.burstLabel);
        ++gbc.gridy;
        DialogUtils.addComponent((JPanel)contentPane, (GridBagConstraints)gbc, (String)"", (JComponent)this.burstRange);
        NestWorldMapPane worldPane = this.worldMapUI.getWorlMapPane();
        worldPane.setPreferredSize(new Dimension(500, 130));
        ++gbc.gridy;
        DialogUtils.addComponent((JPanel)contentPane, (GridBagConstraints)gbc, (String)"", (JComponent)worldPane);
        DialogUtils.fillPanel((JPanel)contentPane, (GridBagConstraints)gbc);
        return contentPane;
    }

    private GeoPos[][] getSelectedBoundaries() {
        Sentinel1Utils.SubSwathInfo[] subswaths = this.su.getSubSwath();
        String subswath = (String)this.subswathCombo.getSelectedItem();
        if (subswath == null) {
            return null;
        }
        for (Sentinel1Utils.SubSwathInfo swath : subswaths) {
            if (!swath.subSwathName.contains(subswath)) continue;
            int numBursts = this.burstRange.getHighValue() - this.burstRange.getLowValue() + 1;
            GeoPos[][] geoBound = new GeoPos[numBursts][4];
            for (int i = 0; i < numBursts; ++i) {
                geoBound[i] = this.getBox(this.burstRange.getLowValue() - 1 + i, swath);
            }
            return geoBound;
        }
        return null;
    }

    private GeoPos[] getBox(int i, Sentinel1Utils.SubSwathInfo swath) {
        int numPoints = swath.latitude[0].length - 1;
        GeoPos[] geoBound = new GeoPos[]{new GeoPos(swath.latitude[i][0], swath.longitude[i][0]), new GeoPos(swath.latitude[i][numPoints], swath.longitude[i][numPoints]), new GeoPos(swath.latitude[i + 1][numPoints], swath.longitude[i + 1][numPoints]), new GeoPos(swath.latitude[i + 1][0], swath.longitude[i + 1][0]), new GeoPos(swath.latitude[i][0], swath.longitude[i][0])};
        return geoBound;
    }
}

