/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s1tbx.sentinel1.rcp;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.prefs.Preferences;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.filechooser.FileFilter;
import org.esa.s1tbx.sentinel1.rcp.Bundle;
import org.esa.snap.core.util.SystemUtils;
import org.esa.snap.core.util.io.SnapFileFilter;
import org.esa.snap.rcp.SnapApp;
import org.esa.snap.rcp.actions.AbstractSnapAction;
import org.esa.snap.rcp.util.Dialogs;
import org.esa.snap.ui.ModalDialog;
import org.esa.snap.ui.SnapFileChooser;

public class ViewS1AuxFileAction
extends AbstractSnapAction {
    private static final String auxDirPreferenceKey = "s1tbx.last_aux_file_dir";

    public ViewS1AuxFileAction() {
        this.putValue("Name", Bundle.CTL_ViewS1AuxFileActionText());
        this.putValue("ShortDescription", Bundle.CTL_ViewS1AuxFileActionDescription());
    }

    public void actionPerformed(ActionEvent event) {
        try {
            File file;
            SnapFileFilter filter = new SnapFileFilter("S-1 Aux data file", new String[]{".zip", ".EOF"}, "S-1 Aux data file");
            Preferences preferences = SnapApp.getDefault().getPreferences();
            File currentDir = new File(preferences.get(auxDirPreferenceKey, SystemUtils.getUserHomeDir().getPath()));
            SnapFileChooser fileChooser = new SnapFileChooser();
            fileChooser.setDialogTitle(Bundle.CTL_ViewS1AuxFileActionDescription());
            fileChooser.setFileFilter((FileFilter)filter);
            fileChooser.setAcceptAllFileFilterUsed(false);
            fileChooser.setCurrentDirectory(currentDir);
            int result = fileChooser.showOpenDialog((Component)SnapApp.getDefault().getMainFrame());
            if (result == 0 && (file = fileChooser.getSelectedFile()) != null) {
                File parentFolder = file.getAbsoluteFile().getParentFile();
                if (parentFolder != null) {
                    preferences.put(auxDirPreferenceKey, parentFolder.getPath());
                }
                String content = this.readFile(file);
                TextPaneDialog dlg = new TextPaneDialog(SnapApp.getDefault().getMainFrame(), file.getName(), content);
                dlg.show();
            }
        }
        catch (Exception e) {
            Dialogs.showError((String)("Unable to import aux data file:" + e.getMessage()));
        }
    }

    private String readFile(File file) throws IOException {
        StringBuilder str = new StringBuilder();
        if (file.getName().toLowerCase().endsWith(".zip")) {
            ZipFile productZip = new ZipFile(file, 1);
            Enumeration<? extends ZipEntry> entries = productZip.entries();
            ZipEntry zipEntry = entries.nextElement();
            try (InputStream fis = productZip.getInputStream(zipEntry);){
                int content;
                while ((content = fis.read()) != -1) {
                    str.append((char)content);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            try (FileInputStream fis = new FileInputStream(file);){
                int content;
                while ((content = fis.read()) != -1) {
                    str.append((char)content);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return str.toString();
    }

    private class TextPaneDialog
    extends ModalDialog {
        public TextPaneDialog(Window parent, String title, String content) {
            super(parent, title, 16, null);
            JPanel contentPanel = new JPanel(new BorderLayout(2, 2));
            JTextPane textPane = new JTextPane();
            textPane.setText(content);
            JScrollPane scrollPane = new JScrollPane(textPane);
            scrollPane.setPreferredSize(new Dimension(600, 800));
            contentPanel.add((Component)scrollPane, "Center");
            this.setContent(contentPanel);
        }
    }
}

