/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s1tbx.sar.gpf.ui.geometric;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Map;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import org.esa.s1tbx.sar.gpf.ui.geometric.RangeDopplerGeocodingOpUI;
import org.esa.snap.graphbuilder.rcp.utils.DialogUtils;
import org.esa.snap.ui.AppContext;

public class SARSimTerrainCorrectionOpUI
extends RangeDopplerGeocodingOpUI {
    private final JTextField rmsThreshold = new JTextField("");
    private final JTextField warpPolynomialOrder = new JTextField("");
    private final JCheckBox openShiftsFileCheckBox = new JCheckBox("Show Range and Azimuth Shifts");
    private boolean openShiftsFile = false;
    private final JCheckBox openResidualsFileCheckBox = new JCheckBox("Show Residuals");
    private boolean openResidualsFile = false;

    @Override
    public JComponent CreateOpTab(String operatorName, Map<String, Object> parameterMap, AppContext appContext) {
        JComponent pane = super.CreateOpTab(operatorName, parameterMap, appContext);
        this.openShiftsFileCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                SARSimTerrainCorrectionOpUI.this.openShiftsFile = e.getStateChange() == 1;
            }
        });
        this.openResidualsFileCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                SARSimTerrainCorrectionOpUI.this.openResidualsFile = e.getStateChange() == 1;
            }
        });
        return new JScrollPane(pane);
    }

    @Override
    public void initParameters() {
        super.initParameters();
        float threshold = ((Float)this.paramMap.get("rmsThreshold")).floatValue();
        this.rmsThreshold.setText(String.valueOf(threshold));
        int order = (Integer)this.paramMap.get("warpPolynomialOrder");
        this.warpPolynomialOrder.setText(String.valueOf(order));
        Boolean openShiftFileValue = (Boolean)this.paramMap.get("openShiftsFile");
        if (openShiftFileValue != null) {
            this.openShiftsFile = openShiftFileValue;
        }
        this.openShiftsFileCheckBox.setSelected(this.openShiftsFile);
        Boolean openResFileValue = (Boolean)this.paramMap.get("openResidualsFile");
        if (openResFileValue != null) {
            this.openResidualsFile = openResFileValue;
        }
        this.openResidualsFileCheckBox.setSelected(this.openResidualsFile);
    }

    @Override
    public void updateParameters() {
        super.updateParameters();
        this.paramMap.put("rmsThreshold", Float.valueOf(Float.parseFloat(this.rmsThreshold.getText())));
        this.paramMap.put("warpPolynomialOrder", Integer.parseInt(this.warpPolynomialOrder.getText()));
        this.paramMap.put("openShiftsFile", this.openShiftsFile);
        this.paramMap.put("openResidualsFile", this.openResidualsFile);
    }

    @Override
    protected JComponent createPanel() {
        JPanel contentPane = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = DialogUtils.createGridBagConstraints();
        gbc.gridx = 1;
        gbc.fill = 2;
        gbc.gridx = 0;
        ++gbc.gridy;
        DialogUtils.addComponent((JPanel)contentPane, (GridBagConstraints)gbc, (String)"RMS Threshold (pixel accuracy):", (JComponent)this.rmsThreshold);
        ++gbc.gridy;
        DialogUtils.addComponent((JPanel)contentPane, (GridBagConstraints)gbc, (String)"WARP Polynomial Order:", (JComponent)this.warpPolynomialOrder);
        ++gbc.gridy;
        DialogUtils.addComponent((JPanel)contentPane, (GridBagConstraints)gbc, (String)"Image Resampling Method:", (JComponent)this.imgResamplingMethod);
        ++gbc.gridy;
        DialogUtils.addComponent((JPanel)contentPane, (GridBagConstraints)gbc, (JLabel)this.sourcePixelSpacingsLabelPart1, (JComponent)this.sourcePixelSpacingsLabelPart2);
        ++gbc.gridy;
        DialogUtils.addComponent((JPanel)contentPane, (GridBagConstraints)gbc, (String)"Pixel Spacing (m):", (JComponent)this.pixelSpacingInMeter);
        ++gbc.gridy;
        DialogUtils.addComponent((JPanel)contentPane, (GridBagConstraints)gbc, (String)"Pixel Spacing (deg):", (JComponent)this.pixelSpacingInDegree);
        this.pixelSpacingInMeter.addFocusListener(new RangeDopplerGeocodingOpUI.PixelSpacingMeterListener(this));
        this.pixelSpacingInDegree.addFocusListener(new RangeDopplerGeocodingOpUI.PixelSpacingDegreeListener(this));
        ++gbc.gridy;
        DialogUtils.addComponent((JPanel)contentPane, (GridBagConstraints)gbc, (String)"Map Projection:", (JComponent)this.crsButton);
        gbc.gridx = 0;
        ++gbc.gridy;
        contentPane.add((Component)this.saveLocalIncidenceAngleCheckBox, gbc);
        gbc.gridx = 1;
        contentPane.add((Component)this.saveProjectedLocalIncidenceAngleCheckBox, gbc);
        gbc.gridx = 0;
        ++gbc.gridy;
        contentPane.add((Component)this.saveSelectedSourceBandCheckBox, gbc);
        gbc.gridx = 1;
        contentPane.add((Component)this.saveDEMCheckBox, gbc);
        gbc.gridx = 0;
        ++gbc.gridy;
        contentPane.add((Component)this.saveLatLonCheckBox, gbc);
        ++gbc.gridy;
        contentPane.add((Component)this.applyRadiometricNormalizationCheckBox, gbc);
        ++gbc.gridy;
        gbc.insets.left = 20;
        contentPane.add((Component)this.saveSigmaNoughtCheckBox, gbc);
        gbc.gridx = 1;
        gbc.insets.left = 1;
        contentPane.add((Component)this.incidenceAngleForSigma0, gbc);
        gbc.gridx = 0;
        ++gbc.gridy;
        gbc.insets.left = 20;
        contentPane.add((Component)this.saveGammaNoughtCheckBox, gbc);
        gbc.gridx = 1;
        gbc.insets.left = 1;
        contentPane.add((Component)this.incidenceAngleForGamma0, gbc);
        gbc.gridx = 0;
        ++gbc.gridy;
        gbc.insets.left = 20;
        contentPane.add((Component)this.saveBetaNoughtCheckBox, gbc);
        ++gbc.gridy;
        gbc.gridx = 0;
        gbc.insets.left = 20;
        DialogUtils.addComponent((JPanel)contentPane, (GridBagConstraints)gbc, (JLabel)this.auxFileLabel, (JComponent)this.auxFile);
        ++gbc.gridy;
        DialogUtils.addComponent((JPanel)contentPane, (GridBagConstraints)gbc, (JLabel)this.externalAuxFileLabel, (JComponent)this.externalAuxFile);
        gbc.gridx = 2;
        contentPane.add((Component)this.externalAuxFileBrowseButton, gbc);
        ++gbc.gridy;
        gbc.gridx = 0;
        gbc.insets.left = 1;
        contentPane.add((Component)this.openShiftsFileCheckBox, gbc);
        ++gbc.gridy;
        contentPane.add((Component)this.openResidualsFileCheckBox, gbc);
        return contentPane;
    }
}

