/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s1tbx.insar.rcp.toolviews.insar_statistics;

import java.awt.Component;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import org.esa.s1tbx.insar.rcp.toolviews.InSARStatisticsTopComponent;
import org.esa.s1tbx.insar.rcp.toolviews.insar_statistics.InSARStatistic;
import org.esa.snap.core.datamodel.MetadataElement;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.util.SystemUtils;
import org.esa.snap.engine_utilities.datamodel.AbstractMetadata;
import org.esa.snap.engine_utilities.gpf.StackUtils;
import org.esa.snap.rcp.SnapApp;

public class StatInSARInfo
implements InSARStatistic {
    private JTextPane textarea;
    private final InSARStatisticsTopComponent parent;

    public StatInSARInfo(InSARStatisticsTopComponent parent) {
        this.parent = parent;
    }

    @Override
    public String getName() {
        return "Stack Information";
    }

    @Override
    public Component createPanel() {
        this.textarea = new JTextPane();
        this.textarea.setContentType("text/html");
        return new JScrollPane(this.textarea);
    }

    @Override
    public void update(Product product) {
        try {
            if (!InSARStatistic.isValidProduct(product)) {
                this.textarea.setText("This tool window requires a coregistered stack product to be selected");
            } else {
                MetadataElement absRoot = AbstractMetadata.getAbstractedMetadata((Product)product);
                String mstName = absRoot.getAttributeString("PRODUCT");
                String mode = absRoot.getAttributeString("ACQUISITION_MODE");
                String orbitFile = absRoot.getAttributeString("orbit_state_vector_file");
                int relOrbit = absRoot.getAttributeInt("REL_ORBIT");
                String[] slaveProductNames = StackUtils.getSlaveProductNames((Product)product);
                ProductData.UTC[] times = StackUtils.getProductTimes((Product)product);
                String mstTime = times[0].format();
                StringBuilder slaveNames = new StringBuilder(255);
                int i = 1;
                for (String slaveName : slaveProductNames) {
                    slaveNames.append("<b>Slave Product " + i + ": </b>");
                    slaveNames.append(slaveName.substring(0, slaveName.lastIndexOf(95)));
                    slaveNames.append(" [" + times[i].format() + ']');
                    slaveNames.append("<br>");
                    ++i;
                }
                String track = "";
                if (relOrbit != 99999) {
                    track = "<b>Track: </b>" + relOrbit + "<br>";
                }
                String esdStats = StatInSARInfo.getESDStats(absRoot);
                StringBuilder content = new StringBuilder(255);
                content.append("<html>");
                content.append("<b>Product: </b>" + product.getProductRefString() + ' ' + product.getName() + "<br>");
                content.append("<b>Master Product: </b>" + mstName + " [" + mstTime + ']' + "<br>");
                content.append(slaveNames.toString() + "<br>");
                content.append("<b>Mode: </b>" + mode + "<br>");
                content.append("<b>Orbit: </b>" + orbitFile + "<br>");
                content.append(track);
                if (!esdStats.isEmpty()) {
                    content.append(esdStats);
                }
                content.append("</html>");
                this.textarea.setText(content.toString());
            }
        }
        catch (Exception e) {
            SnapApp.getDefault().handleError("Unable to update product", (Throwable)e);
        }
    }

    private static String getESDStats(MetadataElement absRoot) {
        MetadataElement burstElem;
        MetadataElement overallShiftElem;
        String esdStat = "";
        MetadataElement esdElem = absRoot.getElement("ESD Measurement");
        if (esdElem != null && (overallShiftElem = esdElem.getElement("Overall_Range_Azimuth_Shift")) != null && (burstElem = overallShiftElem.getElementAt(0)) != null) {
            double rangeShift = burstElem.getAttributeDouble("rangeShift", 0.0);
            double azimuthShift = burstElem.getAttributeDouble("azimuthShift", 0.0);
            esdStat = "<br><b>ESD Range Shift: </b>" + rangeShift + "<br>";
            esdStat = esdStat + "<b>ESD Azimuth Shift: </b>" + azimuthShift + "<br>";
        }
        return esdStat;
    }

    @Override
    public void copyToClipboard() {
        SystemUtils.copyToClipboard((String)this.textarea.getText());
    }

    @Override
    public void saveToFile() {
        this.saveToFile(this.textarea.getText());
    }

    @Override
    public String getHelpId() {
        return "StatInSARInfo";
    }
}

