/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s1tbx.insar.rcp.toolviews.insar_statistics;

import java.awt.Component;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import org.esa.s1tbx.insar.gpf.InSARStackOverview;
import org.esa.s1tbx.insar.rcp.toolviews.InSARStatisticsTopComponent;
import org.esa.s1tbx.insar.rcp.toolviews.insar_statistics.InSARStatistic;
import org.esa.snap.core.datamodel.MetadataElement;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.util.SystemUtils;

public class StatBaselines
implements InSARStatistic {
    private BaselineTableModel tableModel;
    private JTable table;
    private final InSARStatisticsTopComponent parent;
    private CachedBaseline[] cachedBaselines;
    private Product cachedProduct;
    private static final DecimalFormat df = new DecimalFormat("0.00");
    private static final String sep = ", ";

    public StatBaselines(InSARStatisticsTopComponent parent) {
        this.parent = parent;
    }

    @Override
    public String getName() {
        return "Baselines";
    }

    @Override
    public Component createPanel() {
        this.tableModel = new BaselineTableModel();
        this.table = new JTable(this.tableModel);
        return new JScrollPane(this.table);
    }

    public CachedBaseline[] getBaselines(Product product) {
        if (this.cachedBaselines == null || this.cachedProduct != product) {
            try {
                InSARStackOverview.IfgPair[] slaves;
                ArrayList<CachedBaseline> baselines = new ArrayList<CachedBaseline>(50);
                InSARStackOverview.IfgStack[] stackOverview = InSARStackOverview.calculateInSAROverview((Product)product);
                if (stackOverview == null) {
                    return null;
                }
                for (InSARStackOverview.IfgPair slave : slaves = stackOverview[0].getMasterSlave()) {
                    baselines.add(new CachedBaseline(slave));
                }
                this.cachedProduct = product;
                this.cachedBaselines = baselines.toArray(new CachedBaseline[baselines.size()]);
            }
            catch (Exception e) {
                SystemUtils.LOG.severe("Error getting baselines: " + e.getMessage());
            }
        }
        return this.cachedBaselines;
    }

    @Override
    public void update(Product product) {
        if (InSARStatistic.isValidProduct(product)) {
            this.tableModel.clear();
            CachedBaseline[] baselines = this.getBaselines(product);
            if (baselines != null) {
                for (CachedBaseline baseline : baselines) {
                    this.tableModel.addRow(baseline);
                }
            }
            this.table.repaint();
        } else {
            this.tableModel.clear();
            this.table.repaint();
        }
    }

    @Override
    public void copyToClipboard() {
        SystemUtils.copyToClipboard((String)this.getText());
    }

    @Override
    public void saveToFile() {
        this.saveToFile(this.getText());
    }

    @Override
    public String getHelpId() {
        return "StatBaselines";
    }

    private String getText() {
        StringBuilder str = new StringBuilder(300);
        for (int i = 0; i < this.tableModel.getColumnCount(); ++i) {
            str.append(this.tableModel.getColumnName(i));
            str.append(sep);
        }
        str.append('\n');
        for (CachedBaseline baseline : this.tableModel.data) {
            str.append(baseline.toString());
            str.append('\n');
        }
        return str.toString();
    }

    public static class CachedBaseline {
        private final String productName;
        private final String perpendicularBaseline;
        private final String temporalBaseline;
        private final String coherence;
        private final String hoa;
        private final String dopplerDifference;
        private final InSARStackOverview.IfgPair slave;

        public CachedBaseline(InSARStackOverview.IfgPair slave) {
            this.slave = slave;
            this.perpendicularBaseline = df.format(slave.getPerpendicularBaseline());
            this.temporalBaseline = df.format(slave.getTemporalBaseline());
            this.coherence = df.format(slave.getCoherence());
            this.hoa = df.format(slave.getHeightAmb());
            this.dopplerDifference = df.format(slave.getDopplerDifference());
            MetadataElement absRoot = slave.getSlaveMetadata().getAbstractedMetadata();
            this.productName = absRoot.getAttributeString("PRODUCT");
        }

        public String toString() {
            return this.productName + StatBaselines.sep + this.perpendicularBaseline + StatBaselines.sep + this.temporalBaseline + StatBaselines.sep + this.coherence + StatBaselines.sep + this.hoa + StatBaselines.sep + this.dopplerDifference;
        }

        public InSARStackOverview.IfgPair getIfgPair() {
            return this.slave;
        }
    }

    private static class BaselineTableModel
    extends AbstractTableModel {
        private static final String[] COLUMN_NAMES = new String[]{"Product", "Perp Baseline [m]", "Temp Baseline [days]", "Coherence", "Height of Ambiguity [m]", "Doppler Diff [Hz]"};
        private static final Class[] COLUMN_CLASSES = new Class[]{String.class, String.class, String.class, String.class, String.class, String.class};
        private final List<CachedBaseline> data = new ArrayList<CachedBaseline>(50);

        private BaselineTableModel() {
        }

        @Override
        public int getRowCount() {
            return this.data.size();
        }

        @Override
        public int getColumnCount() {
            return COLUMN_NAMES.length;
        }

        @Override
        public String getColumnName(int columnIndex) {
            return COLUMN_NAMES[columnIndex];
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return COLUMN_CLASSES[columnIndex];
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        @Override
        public Object getValueAt(int row, int column) {
            CachedBaseline baseline = this.data.get(row);
            switch (column) {
                case 0: {
                    return baseline.productName;
                }
                case 1: {
                    return baseline.perpendicularBaseline;
                }
                case 2: {
                    return baseline.temporalBaseline;
                }
                case 3: {
                    return baseline.coherence;
                }
                case 4: {
                    return baseline.hoa;
                }
                case 5: {
                    return baseline.dopplerDifference;
                }
            }
            return null;
        }

        public void clear() {
            this.data.clear();
        }

        public void addRow(CachedBaseline baseline) {
            this.data.add(baseline);
        }
    }
}

