/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s1tbx.insar.rcp.actions;

import com.bc.ceres.core.ProgressMonitor;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import org.esa.snap.graphbuilder.rcp.utils.DialogUtils;
import org.esa.snap.productlibrary.db.ProductEntry;
import org.esa.snap.productlibrary.rcp.toolviews.ProductLibraryActions;
import org.esa.snap.productlibrary.rcp.toolviews.extensions.ProductLibraryActionExt;
import org.esa.snap.ui.UIUtils;

public class FindSlicesActionExt
implements ProductLibraryActionExt {
    private static final ImageIcon findSlicesIcon = UIUtils.loadImageIcon((String)"/org/esa/s1tbx/insar/icons/slices24.png", FindSlicesActionExt.class);
    private JButton button = null;
    private ProductLibraryActions actionHandler;

    public void setActionHandler(ProductLibraryActions actionHandler) {
        this.actionHandler = actionHandler;
    }

    public JButton getButton(JPanel panel) {
        if (this.button == null) {
            this.button = DialogUtils.createButton((String)"findSlicesButton", (String)"Find related slices", (ImageIcon)findSlicesIcon, (JPanel)panel, (DialogUtils.ButtonStyle)DialogUtils.ButtonStyle.Icon);
        }
        return this.button;
    }

    public void selectionChanged(ProductEntry[] selections) {
        this.button.setEnabled(selections.length == 1 && ProductLibraryActions.allProductsExist((ProductEntry[])selections));
    }

    public void performAction(ProgressMonitor pm) {
        ProductEntry entry = this.actionHandler.getSelectedProductEntries()[0];
        int dataTakeId = entry.getMetadata().getAttributeInt("data_take_id", 99999);
        if (dataTakeId != 99999) {
            this.actionHandler.getToolView().findSlices(dataTakeId);
        }
    }
}

