/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s1tbx.insar.gpf.ui;

import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Map;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import org.esa.snap.graphbuilder.gpf.ui.BaseOperatorUI;
import org.esa.snap.graphbuilder.gpf.ui.UIValidation;
import org.esa.snap.graphbuilder.rcp.utils.DialogUtils;
import org.esa.snap.rcp.SnapApp;
import org.esa.snap.rcp.util.Dialogs;
import org.esa.snap.ui.AppContext;

public class StampsExportOpUI
extends BaseOperatorUI {
    private final JTextField targetFolder = new JTextField("");
    private final JButton targetFolderBrowseButton = new JButton("...");
    private final JRadioButton psiFormatBtn = new JRadioButton("PSI");
    private final JRadioButton sbasFormatBtn = new JRadioButton("SBAS");
    private static final String STAMPS_TARGET_DIR_KEY = "s1tbx.stampsTargetFolder";

    public JComponent CreateOpTab(String operatorName, Map<String, Object> parameterMap, AppContext appContext) {
        this.initializeOperatorUI(operatorName, parameterMap);
        JComponent panel = this.createPanel();
        this.initParameters();
        this.targetFolderBrowseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                File file = Dialogs.requestFileForSave((String)"Target Folder", (boolean)true, null, null, null, null, (String)StampsExportOpUI.STAMPS_TARGET_DIR_KEY);
                if (file != null) {
                    StampsExportOpUI.this.targetFolder.setText(file.getAbsolutePath());
                }
            }
        });
        return new JScrollPane(panel);
    }

    public void initParameters() {
        File targetFolderFile = (File)this.paramMap.get("targetFolder");
        if (targetFolderFile != null) {
            this.targetFolder.setText(targetFolderFile.getAbsolutePath());
        } else {
            this.targetFolder.setText(SnapApp.getDefault().getPreferences().get(STAMPS_TARGET_DIR_KEY, ""));
        }
        Boolean psiFormat = (Boolean)this.paramMap.get("psiFormat");
        if (psiFormat != null && !psiFormat.booleanValue()) {
            this.sbasFormatBtn.setSelected(true);
        } else {
            this.psiFormatBtn.setSelected(true);
        }
    }

    public UIValidation validateParameters() {
        return new UIValidation(UIValidation.State.OK, "");
    }

    public void updateParameters() {
        String extFileStr = this.targetFolder.getText();
        if (!extFileStr.isEmpty()) {
            this.paramMap.put("targetFolder", new File(extFileStr));
        }
        this.paramMap.put("psiFormat", this.psiFormatBtn.isSelected());
    }

    private JComponent createPanel() {
        JPanel contentPane = new JPanel();
        contentPane.setLayout(new GridBagLayout());
        GridBagConstraints gbc = DialogUtils.createGridBagConstraints();
        ++gbc.gridy;
        DialogUtils.addComponent((JPanel)contentPane, (GridBagConstraints)gbc, (String)"Target Folder: ", (JComponent)this.targetFolder);
        gbc.gridx = 2;
        contentPane.add((Component)this.targetFolderBrowseButton, gbc);
        ++gbc.gridy;
        JPanel buttonPanel = new JPanel(new FlowLayout(0));
        buttonPanel.add(this.psiFormatBtn);
        buttonPanel.add(this.sbasFormatBtn);
        ButtonGroup group = new ButtonGroup();
        group.add(this.psiFormatBtn);
        group.add(this.sbasFormatBtn);
        gbc.gridx = 0;
        contentPane.add((Component)new JLabel("Format: "), gbc);
        gbc.gridx = 1;
        contentPane.add((Component)buttonPanel, gbc);
        DialogUtils.fillPanel((JPanel)contentPane, (GridBagConstraints)gbc);
        return contentPane;
    }
}

