/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s1tbx.insar.gpf.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyListener;
import java.io.File;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;
import org.esa.s1tbx.insar.gpf.CoherenceOp;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.dataop.dem.ElevationModelDescriptor;
import org.esa.snap.core.dataop.dem.ElevationModelRegistry;
import org.esa.snap.dem.dataio.DEMFactory;
import org.esa.snap.engine_utilities.datamodel.AbstractMetadata;
import org.esa.snap.graphbuilder.gpf.ui.BaseOperatorUI;
import org.esa.snap.graphbuilder.gpf.ui.OperatorUIUtils;
import org.esa.snap.graphbuilder.gpf.ui.UIValidation;
import org.esa.snap.graphbuilder.rcp.utils.DialogUtils;
import org.esa.snap.rcp.util.Dialogs;
import org.esa.snap.ui.AppContext;

public class CoherenceOpUI
extends BaseOperatorUI {
    private final JCheckBox squarePixelCheckBox = new JCheckBox("Square Pixel");
    private final JCheckBox independentWindowSizeCheckBox = new JCheckBox("Independent Window Sizes");
    private final JCheckBox subtractFlatEarthPhaseCheckBox = new JCheckBox("Subtract flat-earth phase");
    private final JCheckBox subtractTopographicPhaseCheckBox = new JCheckBox("Subtract topographic phase");
    private final JTextField cohWinAz = new JTextField("");
    private final JTextField cohWinRg = new JTextField("");
    private final JComboBox<Integer> srpPolynomialDegreeStr = new JComboBox<Integer>(new Integer[]{1, 2, 3, 4, 5, 6, 7, 8});
    private final JComboBox<Integer> srpNumberPointsStr = new JComboBox<Integer>(new Integer[]{301, 401, 501, 601, 701, 801, 901, 1001});
    private final JComboBox<Integer> orbitDegreeStr = new JComboBox<Integer>(new Integer[]{1, 2, 3, 4, 5});
    private static final JLabel cohWinAzLabel = new JLabel("Coherence Azimuth Window Size");
    private static final JLabel cohWinRgLabel = new JLabel("Coherence Range Window Size");
    private static final JLabel srpPolynomialDegreeStrLabel = new JLabel("Degree of \"Flat Earth\" polynomial");
    private static final JLabel srpNumberPointsStrLabel = new JLabel("Number of \"Flat Earth\" estimation points");
    private static final JLabel orbitDegreeStrLabel = new JLabel("Orbit interpolation degree");
    private Boolean squarePixel = true;
    private Boolean subtractFlatEarthPhase = false;
    private final CoherenceOp.DerivedParams param = new CoherenceOp.DerivedParams();
    private Boolean subtractTopographicPhase = false;
    private static final String[] demValueSet = DEMFactory.getDEMNameList();
    private final JComboBox<String> demName = new JComboBox<String>(demValueSet);
    private static final String externalDEMStr = "External DEM";
    private final JTextField externalDEMFile = new JTextField("");
    private final JTextField externalDEMNoDataValue = new JTextField("");
    private final JButton externalDEMBrowseButton = new JButton("...");
    private final JLabel externalDEMFileLabel = new JLabel("External DEM:");
    private final JLabel externalDEMNoDataValueLabel = new JLabel("DEM No Data Value:");
    private final JCheckBox externalDEMApplyEGMCheckBox = new JCheckBox("Apply Earth Gravitational Model");
    private final DialogUtils.TextAreaKeyListener textAreaKeyListener = new DialogUtils.TextAreaKeyListener();
    private final JComboBox<String> tileExtensionPercent = new JComboBox<String>(new String[]{"20", "40", "60", "80", "100", "150", "200"});
    private Double extNoDataValue = 0.0;
    private Boolean externalDEMApplyEGM = true;

    public JComponent CreateOpTab(String operatorName, Map<String, Object> parameterMap, AppContext appContext) {
        this.initializeOperatorUI(operatorName, parameterMap);
        JScrollPane panel = new JScrollPane(this.createPanel());
        this.initParameters();
        this.subtractFlatEarthPhaseCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                CoherenceOpUI.this.subtractFlatEarthPhase = e.getStateChange() == 1;
                CoherenceOpUI.this.enableSubtractFlatEarthPhaseParameters(CoherenceOpUI.this.subtractFlatEarthPhase);
            }
        });
        this.squarePixelCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                CoherenceOpUI.this.squarePixel = e.getStateChange() == 1;
                CoherenceOpUI.this.independentWindowSizeCheckBox.setSelected(CoherenceOpUI.this.squarePixel == false);
                if (CoherenceOpUI.this.squarePixel.booleanValue()) {
                    CoherenceOpUI.this.cohWinAz.setText("2");
                    CoherenceOpUI.this.cohWinAz.setEditable(false);
                }
                CoherenceOpUI.this.setCohWinAz();
                CoherenceOpUI.this.setCohWinRg();
            }
        });
        this.independentWindowSizeCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                CoherenceOpUI.this.squarePixel = e.getStateChange() != 1;
                CoherenceOpUI.this.squarePixelCheckBox.setSelected(CoherenceOpUI.this.squarePixel);
                if (!CoherenceOpUI.this.squarePixel.booleanValue()) {
                    CoherenceOpUI.this.cohWinAz.setEditable(true);
                }
                CoherenceOpUI.this.setCohWinAz();
                CoherenceOpUI.this.setCohWinRg();
            }
        });
        this.subtractTopographicPhaseCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                CoherenceOpUI.this.subtractTopographicPhase = e.getStateChange() == 1;
                CoherenceOpUI.this.enableSubtractTopographicPhaseParameters(CoherenceOpUI.this.subtractTopographicPhase);
            }
        });
        this.demName.addItem(externalDEMStr);
        this.demName.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent event) {
                String item = ((String)CoherenceOpUI.this.demName.getSelectedItem()).replace(" (Auto Download)", "");
                if (item.equals(CoherenceOpUI.externalDEMStr)) {
                    CoherenceOpUI.this.enableExternalDEM(true);
                } else {
                    CoherenceOpUI.this.externalDEMFile.setText("");
                    CoherenceOpUI.this.enableExternalDEM(false);
                }
            }
        });
        this.externalDEMFile.setColumns(30);
        this.enableExternalDEM(((String)this.demName.getSelectedItem()).startsWith(externalDEMStr));
        this.externalDEMBrowseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                File file = Dialogs.requestFileForOpen((String)"External DEM File", (boolean)false, null, (String)"snap.externalDEMDir");
                if (file != null) {
                    CoherenceOpUI.this.externalDEMFile.setText(file.getAbsolutePath());
                    CoherenceOpUI.this.extNoDataValue = OperatorUIUtils.getNoDataValue((File)file);
                }
                CoherenceOpUI.this.externalDEMNoDataValue.setText(String.valueOf(CoherenceOpUI.this.extNoDataValue));
            }
        });
        this.externalDEMApplyEGMCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                CoherenceOpUI.this.externalDEMApplyEGM = e.getStateChange() == 1;
            }
        });
        this.externalDEMNoDataValue.addKeyListener((KeyListener)this.textAreaKeyListener);
        return panel;
    }

    public void initParameters() {
        File extFile;
        String demNameParam;
        Boolean paramVal = (Boolean)this.paramMap.get("subtractFlatEarthPhase");
        if (paramVal != null) {
            this.subtractFlatEarthPhase = paramVal;
            this.subtractFlatEarthPhaseCheckBox.setSelected(this.subtractFlatEarthPhase);
            this.enableSubtractFlatEarthPhaseParameters(this.subtractFlatEarthPhase);
        }
        this.srpPolynomialDegreeStr.setSelectedItem(this.paramMap.get("srpPolynomialDegree"));
        this.srpNumberPointsStr.setSelectedItem(this.paramMap.get("srpNumberPoints"));
        this.orbitDegreeStr.setSelectedItem(this.paramMap.get("orbitDegree"));
        if (this.sourceProducts != null && this.sourceProducts.length > 0) {
            boolean isComplex = AbstractMetadata.getAbstractedMetadata((Product)this.sourceProducts[0]).getAttributeString("SAMPLE_TYPE").contains("COMPLEX");
            this.enableControls(isComplex);
        }
        if ((paramVal = (Boolean)this.paramMap.get("subtractTopographicPhase")) != null) {
            this.subtractTopographicPhase = paramVal;
            this.subtractTopographicPhaseCheckBox.setSelected(this.subtractTopographicPhase);
            this.enableSubtractTopographicPhaseParameters(this.subtractTopographicPhase);
        }
        if ((demNameParam = (String)this.paramMap.get("demName")) != null) {
            ElevationModelDescriptor descriptor = ElevationModelRegistry.getInstance().getDescriptor(demNameParam);
            if (descriptor != null) {
                this.demName.setSelectedItem(DEMFactory.getDEMDisplayName((ElevationModelDescriptor)descriptor));
            } else {
                this.demName.setSelectedItem(demNameParam);
            }
        }
        if ((extFile = (File)this.paramMap.get("externalDEMFile")) != null) {
            this.externalDEMFile.setText(extFile.getAbsolutePath());
            this.extNoDataValue = (Double)this.paramMap.get("externalDEMNoDataValue");
            if (this.extNoDataValue != null && !this.textAreaKeyListener.isChangedByUser()) {
                this.externalDEMNoDataValue.setText(String.valueOf(this.extNoDataValue));
            }
            if ((paramVal = (Boolean)this.paramMap.get("externalDEMApplyEGM")) != null) {
                this.externalDEMApplyEGM = paramVal;
                this.externalDEMApplyEGMCheckBox.setSelected(this.externalDEMApplyEGM);
            }
        }
        this.tileExtensionPercent.setSelectedItem(this.paramMap.get("tileExtensionPercent"));
        this.cohWinAz.setText(String.valueOf(this.paramMap.get("cohWinAz")));
        this.cohWinRg.setText(String.valueOf(this.paramMap.get("cohWinRg")));
        this.squarePixel = (Boolean)this.paramMap.get("squarePixel");
        if (this.squarePixel != null) {
            this.squarePixelCheckBox.setSelected(this.squarePixel);
            this.independentWindowSizeCheckBox.setSelected(this.squarePixel == false);
            if (this.squarePixel.booleanValue()) {
                this.cohWinAz.setText("2");
                this.cohWinAz.setEditable(false);
            } else {
                this.cohWinAz.setEditable(true);
            }
        }
        this.setCohWinAz();
        this.setCohWinRg();
    }

    public UIValidation validateParameters() {
        return new UIValidation(UIValidation.State.OK, "");
    }

    public void updateParameters() {
        this.paramMap.put("subtractFlatEarthPhase", this.subtractFlatEarthPhase);
        if (this.subtractFlatEarthPhase.booleanValue()) {
            this.paramMap.put("srpPolynomialDegree", this.srpPolynomialDegreeStr.getSelectedItem());
            this.paramMap.put("srpNumberPoints", this.srpNumberPointsStr.getSelectedItem());
            this.paramMap.put("orbitDegree", this.orbitDegreeStr.getSelectedItem());
        }
        this.paramMap.put("subtractTopographicPhase", this.subtractTopographicPhase);
        if (this.subtractTopographicPhase.booleanValue()) {
            String properDEMName = DEMFactory.getProperDEMName((String)((String)this.demName.getSelectedItem()));
            this.paramMap.put("demName", DEMFactory.getProperDEMName((String)((String)this.demName.getSelectedItem())));
            if (properDEMName.equals(externalDEMStr)) {
                String extFileStr = this.externalDEMFile.getText();
                this.paramMap.put("externalDEMFile", new File(extFileStr));
                this.paramMap.put("externalDEMNoDataValue", Double.parseDouble(this.externalDEMNoDataValue.getText()));
                this.paramMap.put("externalDEMApplyEGM", this.externalDEMApplyEGM);
            }
            this.paramMap.put("tileExtensionPercent", this.tileExtensionPercent.getSelectedItem());
        }
        String cohWinRgStr = this.cohWinRg.getText();
        String cohWinAzStr = this.cohWinAz.getText();
        if (cohWinRgStr != null && !cohWinRgStr.isEmpty()) {
            this.paramMap.put("cohWinRg", Integer.parseInt(this.cohWinRg.getText()));
        }
        if (cohWinAzStr != null && !cohWinAzStr.isEmpty()) {
            this.paramMap.put("cohWinAz", Integer.parseInt(this.cohWinAz.getText()));
        }
        this.paramMap.put("squarePixel", this.squarePixel);
    }

    JComponent createPanel() {
        JPanel contentPane = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = DialogUtils.createGridBagConstraints();
        contentPane.add((Component)this.subtractFlatEarthPhaseCheckBox, gbc);
        ++gbc.gridy;
        DialogUtils.addComponent((JPanel)contentPane, (GridBagConstraints)gbc, (JLabel)srpPolynomialDegreeStrLabel, this.srpPolynomialDegreeStr);
        ++gbc.gridy;
        DialogUtils.addComponent((JPanel)contentPane, (GridBagConstraints)gbc, (JLabel)srpNumberPointsStrLabel, this.srpNumberPointsStr);
        ++gbc.gridy;
        DialogUtils.addComponent((JPanel)contentPane, (GridBagConstraints)gbc, (JLabel)orbitDegreeStrLabel, this.orbitDegreeStr);
        this.srpPolynomialDegreeStr.setEnabled(false);
        this.srpNumberPointsStr.setEnabled(false);
        this.orbitDegreeStr.setEnabled(false);
        ++gbc.gridy;
        contentPane.add((Component)this.subtractTopographicPhaseCheckBox, gbc);
        ++gbc.gridy;
        DialogUtils.addComponent((JPanel)contentPane, (GridBagConstraints)gbc, (String)"Digital Elevation Model:", this.demName);
        ++gbc.gridy;
        DialogUtils.addInnerPanel((JPanel)contentPane, (GridBagConstraints)gbc, (JLabel)this.externalDEMFileLabel, (JComponent)this.externalDEMFile, (JComponent)this.externalDEMBrowseButton);
        ++gbc.gridy;
        DialogUtils.addComponent((JPanel)contentPane, (GridBagConstraints)gbc, (JLabel)this.externalDEMNoDataValueLabel, (JComponent)this.externalDEMNoDataValue);
        ++gbc.gridy;
        gbc.gridx = 1;
        contentPane.add((Component)this.externalDEMApplyEGMCheckBox, gbc);
        gbc.gridx = 0;
        gbc.gridy += 10;
        DialogUtils.addComponent((JPanel)contentPane, (GridBagConstraints)gbc, (String)"Tile Extension [%]", this.tileExtensionPercent);
        gbc.gridx = 0;
        ++gbc.gridy;
        contentPane.add((Component)this.squarePixelCheckBox, gbc);
        gbc.gridx = 1;
        contentPane.add((Component)this.independentWindowSizeCheckBox, gbc);
        ++gbc.gridy;
        DialogUtils.addComponent((JPanel)contentPane, (GridBagConstraints)gbc, (JLabel)cohWinRgLabel, (JComponent)this.cohWinRg);
        ++gbc.gridy;
        DialogUtils.addComponent((JPanel)contentPane, (GridBagConstraints)gbc, (JLabel)cohWinAzLabel, (JComponent)this.cohWinAz);
        this.cohWinAz.setEditable(false);
        this.cohWinRg.setDocument(new CohWinRgDocument());
        this.demName.setEnabled(false);
        this.tileExtensionPercent.setEnabled(false);
        DialogUtils.fillPanel((JPanel)contentPane, (GridBagConstraints)gbc);
        return contentPane;
    }

    private void enableControls(boolean flag) {
        this.subtractFlatEarthPhaseCheckBox.setEnabled(flag);
        this.subtractTopographicPhaseCheckBox.setEnabled(flag);
    }

    private synchronized void setCohWinAz() {
        if (this.sourceProducts != null && this.sourceProducts.length > 0) {
            try {
                if (this.squarePixelCheckBox.isSelected()) {
                    this.param.cohWinRg = Integer.parseInt(this.cohWinRg.getText());
                    CoherenceOp.getDerivedParameters((Product)this.sourceProducts[0], (CoherenceOp.DerivedParams)this.param);
                    this.cohWinAz.setText(String.valueOf(this.param.cohWinAz));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void setCohWinRg() {
        if (this.sourceProducts != null && this.sourceProducts.length > 0 && this.squarePixelCheckBox.isSelected()) {
            this.cohWinRg.setText(String.valueOf(this.param.cohWinRg));
        }
    }

    private void enableExternalDEM(boolean flag) {
        DialogUtils.enableComponents((JComponent)this.externalDEMFileLabel, (JComponent)this.externalDEMFile, (boolean)flag);
        DialogUtils.enableComponents((JComponent)this.externalDEMNoDataValueLabel, (JComponent)this.externalDEMNoDataValue, (boolean)flag);
        if (!flag) {
            this.externalDEMFile.setText("");
        }
        this.externalDEMBrowseButton.setVisible(flag);
        this.externalDEMApplyEGMCheckBox.setVisible(flag);
    }

    private void enableSubtractFlatEarthPhaseParameters(boolean flag) {
        this.srpPolynomialDegreeStr.setEnabled(flag);
        this.srpNumberPointsStr.setEnabled(flag);
        this.orbitDegreeStr.setEnabled(flag);
    }

    private void enableSubtractTopographicPhaseParameters(boolean flag) {
        this.demName.setEnabled(flag);
        this.tileExtensionPercent.setEnabled(flag);
    }

    private class CohWinRgDocument
    extends PlainDocument {
        private CohWinRgDocument() {
        }

        @Override
        public void replace(int offset, int length, String text, AttributeSet attrs) throws BadLocationException {
            super.replace(offset, length, text, attrs);
            CoherenceOpUI.this.setCohWinAz();
        }
    }
}

