/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s1tbx.fex.gpf.urban;

import com.bc.ceres.core.ProgressMonitor;
import java.awt.Color;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.HashMap;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.Mask;
import org.esa.snap.core.datamodel.MetadataElement;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.datamodel.ProductNode;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.gpf.Operator;
import org.esa.snap.core.gpf.OperatorException;
import org.esa.snap.core.gpf.OperatorSpi;
import org.esa.snap.core.gpf.Tile;
import org.esa.snap.core.gpf.annotations.OperatorMetadata;
import org.esa.snap.core.gpf.annotations.Parameter;
import org.esa.snap.core.gpf.annotations.SourceProduct;
import org.esa.snap.core.gpf.annotations.TargetProduct;
import org.esa.snap.core.util.ProductUtils;
import org.esa.snap.engine_utilities.datamodel.AbstractMetadata;
import org.esa.snap.engine_utilities.datamodel.Unit;
import org.esa.snap.engine_utilities.gpf.FilterWindow;
import org.esa.snap.engine_utilities.gpf.InputProductValidator;
import org.esa.snap.engine_utilities.gpf.OperatorUtils;
import org.esa.snap.engine_utilities.gpf.TileIndex;
import org.esa.snap.raster.gpf.masks.TerrainMaskOp;

@OperatorMetadata(alias="Speckle-Divergence", category="Radar/SAR Applications/Urban Areas", authors="Jun Lu, Luis Veci", version="1.0", copyright="Copyright (C) 2015 by Array Systems Computing Inc.", description="Detect urban area.")
public class SpeckleDivergenceOp
extends Operator {
    @SourceProduct(alias="source")
    private Product sourceProduct;
    @TargetProduct
    private Product targetProduct = null;
    @Parameter(description="The list of source bands.", alias="sourceBands", label="Source Bands")
    private String[] sourceBands = null;
    @Parameter(valueSet={"3x3", "5x5", "7x7", "9x9", "11x11", "13x13", "15x15", "17x17"}, defaultValue="15x15", label="Window Size")
    private String windowSizeStr = "15x15";
    private MetadataElement absRoot = null;
    private int sourceImageWidth = 0;
    private int sourceImageHeight = 0;
    private FilterWindow window;
    private double c = 0.0;
    private final HashMap<String, String> targetBandNameToSourceBandName = new HashMap();
    public static final String SPECKLE_DIVERGENCE_MASK_NAME = "_speckle_divergence";
    public static final String PRODUCT_SUFFIX = "_SpkDiv";

    public void initialize() throws OperatorException {
        try {
            InputProductValidator validator = new InputProductValidator(this.sourceProduct);
            validator.checkIfSARProduct();
            this.absRoot = AbstractMetadata.getAbstractedMetadata((Product)this.sourceProduct);
            this.sourceImageWidth = this.sourceProduct.getSceneRasterWidth();
            this.sourceImageHeight = this.sourceProduct.getSceneRasterHeight();
            this.window = new FilterWindow(this.windowSizeStr);
            this.computeTheoreticalCoefficientOfVariance();
            this.createTargetProduct();
        }
        catch (Throwable e) {
            OperatorUtils.catchOperatorException((String)this.getId(), (Throwable)e);
        }
    }

    private void computeTheoreticalCoefficientOfVariance() {
        int azimuthLooks = this.absRoot.getAttributeInt("azimuth_looks");
        int rangeLooks = this.absRoot.getAttributeInt("range_looks");
        this.c = 1.0 / (double)(azimuthLooks + rangeLooks);
    }

    private void createTargetProduct() throws Exception {
        this.targetProduct = new Product(this.sourceProduct.getName() + PRODUCT_SUFFIX, this.sourceProduct.getProductType(), this.sourceImageWidth, this.sourceImageHeight);
        ProductUtils.copyProductNodes((Product)this.sourceProduct, (Product)this.targetProduct);
        this.addSelectedBands();
    }

    private void addSelectedBands() throws OperatorException {
        if (this.sourceBands != null) {
            for (String srcBandName : this.sourceBands) {
                if (this.sourceProduct.getBand(srcBandName) != null) continue;
                this.sourceBands = null;
                break;
            }
        }
        if (this.sourceBands == null || this.sourceBands.length == 0) {
            Band[] bands;
            ArrayList<String> srcBandNameList = new ArrayList<String>();
            for (Band band : bands = this.sourceProduct.getBands()) {
                if (band.getUnit() == null || !band.getUnit().contains("intensity")) continue;
                srcBandNameList.add(band.getName());
            }
            this.sourceBands = srcBandNameList.toArray(new String[srcBandNameList.size()]);
        }
        Band[] srcBands = new Band[this.sourceBands.length];
        for (int i = 0; i < this.sourceBands.length; ++i) {
            String sourceBandName = this.sourceBands[i];
            Band sourceBand = this.sourceProduct.getBand(sourceBandName);
            if (sourceBand == null) {
                throw new OperatorException("Source band not found: " + sourceBandName);
            }
            srcBands[i] = sourceBand;
        }
        if (srcBands.length == 0) {
            throw new OperatorException("No intensity bands found");
        }
        for (Band srcBand : srcBands) {
            String srcBandNames = srcBand.getName();
            String unit = srcBand.getUnit();
            if (unit == null) {
                throw new OperatorException("band " + srcBandNames + " requires a unit");
            }
            if (unit.contains("imaginary") || unit.contains("real") || unit.contains("phase")) {
                throw new OperatorException("Please select amplitude or intensity band");
            }
            String targetBandName = srcBandNames + SPECKLE_DIVERGENCE_MASK_NAME;
            this.targetBandNameToSourceBandName.put(targetBandName, srcBandNames);
            Band targetBand = ProductUtils.copyBand((String)srcBandNames, (Product)this.sourceProduct, (Product)this.targetProduct, (boolean)false);
            targetBand.setSourceImage(srcBand.getSourceImage());
            Band targetBandMask = new Band(targetBandName, 30, this.sourceImageWidth, this.sourceImageHeight);
            targetBandMask.setNoDataValue(srcBand.getNoDataValue());
            targetBandMask.setNoDataValueUsed(true);
            targetBandMask.setUnit("speckle_divergence");
            this.targetProduct.addBand(targetBandMask);
            String expression = targetBandMask.getName() + " > 0.2";
            Mask mask = new Mask(targetBandMask.getName() + "_mask", this.targetProduct.getSceneRasterWidth(), this.targetProduct.getSceneRasterHeight(), (Mask.ImageType)Mask.BandMathsType.INSTANCE);
            mask.setDescription("Urban Area");
            mask.getImageConfig().setValue("color", (Object)Color.MAGENTA);
            mask.getImageConfig().setValue("transparency", (Object)0.7);
            mask.getImageConfig().setValue("expression", (Object)expression);
            mask.setNoDataValue(0.0);
            mask.setNoDataValueUsed(true);
            this.targetProduct.getMaskGroup().add((ProductNode)mask);
        }
    }

    public void computeTile(Band targetBand, Tile targetTile, ProgressMonitor pm) throws OperatorException {
        try {
            Rectangle targetTileRectangle = targetTile.getRectangle();
            int tx0 = targetTileRectangle.x;
            int ty0 = targetTileRectangle.y;
            int tw = targetTileRectangle.width;
            int th = targetTileRectangle.height;
            ProductData trgData = targetTile.getDataBuffer();
            Rectangle sourceTileRectangle = this.window.getSourceTileRectangle(tx0, ty0, tw, th, this.sourceImageWidth, this.sourceImageHeight);
            String srcBandName = this.targetBandNameToSourceBandName.get(targetBand.getName());
            Band sourceBand = this.sourceProduct.getBand(srcBandName);
            Tile sourceTile = this.getSourceTile((RasterDataNode)sourceBand, sourceTileRectangle);
            ProductData srcData = sourceTile.getDataBuffer();
            Double noDataValue = sourceBand.getNoDataValue();
            Unit.UnitType bandUnit = Unit.getUnitType((Band)sourceBand);
            Band maskBand = this.sourceProduct.getBand(TerrainMaskOp.TERRAIN_MASK_NAME);
            Tile maskTile = null;
            ProductData maskData = null;
            if (maskBand != null) {
                maskTile = this.getSourceTile((RasterDataNode)maskBand, targetTileRectangle);
                maskData = maskTile.getDataBuffer();
            }
            TileIndex trgIndex = new TileIndex(targetTile);
            TileIndex srcIndex = new TileIndex(sourceTile);
            int maxy = ty0 + th;
            int maxx = tx0 + tw;
            int windowSize = this.window.getWindowSize();
            for (int ty = ty0; ty < maxy; ++ty) {
                trgIndex.calculateStride(ty);
                srcIndex.calculateStride(ty);
                for (int tx = tx0; tx < maxx; ++tx) {
                    int idx = trgIndex.getIndex(tx);
                    double v = srcData.getElemDoubleAt(srcIndex.getIndex(tx));
                    if (noDataValue.equals(v) || maskBand != null && maskData.getElemIntAt(idx) == 1) {
                        trgData.setElemFloatAt(idx, noDataValue.floatValue());
                        continue;
                    }
                    double cv = this.computeCoefficientOfVariance(tx, ty, windowSize, sourceTile, srcData, bandUnit, noDataValue);
                    double speckleDivergence = cv - this.c;
                    trgData.setElemFloatAt(idx, (float)speckleDivergence);
                }
            }
        }
        catch (Throwable e) {
            OperatorUtils.catchOperatorException((String)this.getId(), (Throwable)e);
        }
    }

    private double computeCoefficientOfVariance(int tx, int ty, int windowSize, Tile sourceTile, ProductData srcData, Unit.UnitType bandUnit, double noDataValue) {
        double[] samples = new double[windowSize * windowSize];
        int numSamples = this.getSamples(tx, ty, bandUnit, noDataValue, windowSize / 2, sourceTile, srcData, samples);
        if (numSamples == 0) {
            return noDataValue;
        }
        double mean = SpeckleDivergenceOp.getMeanValue(samples, numSamples);
        double variance = SpeckleDivergenceOp.getVarianceValue(samples, numSamples, mean);
        return Math.sqrt(variance) / mean;
    }

    private int getSamples(int tx, int ty, Unit.UnitType bandUnit, double noDataValue, int halfWindowSize, Tile sourceTile, ProductData srcData, double[] samples) {
        int x0 = Math.max(tx - halfWindowSize, 0);
        int y0 = Math.max(ty - halfWindowSize, 0);
        int w = Math.min(tx + halfWindowSize, this.sourceImageWidth - 1) - x0 + 1;
        int h = Math.min(ty + halfWindowSize, this.sourceImageHeight - 1) - y0 + 1;
        TileIndex tileIndex = new TileIndex(sourceTile);
        int numSamples = 0;
        int maxy = Math.min(y0 + h, sourceTile.getMaxY() - 1);
        int maxx = Math.min(x0 + w, sourceTile.getMaxX() - 1);
        if (bandUnit == Unit.UnitType.INTENSITY) {
            for (int y = y0; y < maxy; ++y) {
                tileIndex.calculateStride(y);
                for (int x = x0; x < maxx; ++x) {
                    double v = srcData.getElemDoubleAt(tileIndex.getIndex(x));
                    if (v == noDataValue || !(v > 0.4)) continue;
                    samples[numSamples++] = v;
                }
            }
        } else {
            for (int y = y0; y < maxy; ++y) {
                tileIndex.calculateStride(y);
                for (int x = x0; x < maxx; ++x) {
                    double v = srcData.getElemDoubleAt(tileIndex.getIndex(x));
                    if (!(v != noDataValue & v * v > 0.4)) continue;
                    samples[numSamples++] = v * v;
                }
            }
        }
        return numSamples;
    }

    private static double getMeanValue(double[] samples, int numSamples) {
        double mean = 0.0;
        for (int i = 0; i < numSamples; ++i) {
            mean += samples[i];
        }
        return mean /= (double)numSamples;
    }

    private static double getVarianceValue(double[] samples, int numSamples, double mean) {
        double var = 0.0;
        if (numSamples > 1) {
            for (int i = 0; i < numSamples; ++i) {
                double diff = samples[i] - mean;
                var += diff * diff;
            }
            var /= (double)(numSamples - 1);
        }
        return var;
    }

    public static class Spi
    extends OperatorSpi {
        public Spi() {
            super(SpeckleDivergenceOp.class);
        }
    }
}

