/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s1tbx.fex.gpf.oceantools;

import com.bc.ceres.core.ProgressMonitor;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.GeometryFactory;
import java.awt.Rectangle;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.GeoCoding;
import org.esa.snap.core.datamodel.GeoPos;
import org.esa.snap.core.datamodel.MetadataElement;
import org.esa.snap.core.datamodel.PixelPos;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.datamodel.ProductNode;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.datamodel.VectorDataNode;
import org.esa.snap.core.datamodel.VirtualBand;
import org.esa.snap.core.dataop.downloadable.XMLSupport;
import org.esa.snap.core.gpf.Operator;
import org.esa.snap.core.gpf.OperatorException;
import org.esa.snap.core.gpf.OperatorSpi;
import org.esa.snap.core.gpf.Tile;
import org.esa.snap.core.gpf.annotations.OperatorMetadata;
import org.esa.snap.core.gpf.annotations.Parameter;
import org.esa.snap.core.gpf.annotations.SourceProduct;
import org.esa.snap.core.gpf.annotations.TargetProduct;
import org.esa.snap.core.util.ProductUtils;
import org.esa.snap.core.util.StringUtils;
import org.esa.snap.core.util.SystemUtils;
import org.esa.snap.engine_utilities.datamodel.AbstractMetadata;
import org.esa.snap.engine_utilities.gpf.OperatorUtils;
import org.esa.snap.engine_utilities.gpf.TileIndex;
import org.esa.snap.engine_utilities.util.ResourceUtils;
import org.esa.snap.engine_utilities.util.VectorUtils;
import org.geotools.feature.DefaultFeatureCollection;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.type.AttributeDescriptorImpl;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;

@OperatorMetadata(alias="Object-Discrimination", category="Radar/SAR Applications/Ocean Applications/Object Detection", authors="Jun Lu, Luis Veci", version="1.0", copyright="Copyright (C) 2015 by Array Systems Computing Inc.", description="Remove false alarms from the detected objects.")
public class ObjectDiscriminationOp
extends Operator {
    @SourceProduct(alias="source")
    private Product sourceProduct;
    @TargetProduct
    private Product targetProduct = null;
    @Parameter(description="Minimum target size", defaultValue="50.0", label="Minimum Target Size (m)")
    private double minTargetSizeInMeter = 50.0;
    @Parameter(description="Maximum target size", defaultValue="600.0", label="Maximum Target Size (m)")
    private double maxTargetSizeInMeter = 600.0;
    private boolean clusteringPerformed = false;
    private int sourceImageWidth = 0;
    private int sourceImageHeight = 0;
    private double rangeSpacing = 0.0;
    private double azimuthSpacing = 0.0;
    private final Map<String, List<ShipRecord>> bandClusterLists = new HashMap<String, List<ShipRecord>>();
    private File targetReportFile = null;
    private SimpleFeatureType shipFeatureType;
    public static final String VECTOR_NODE_NAME = "ShipDetections";
    private static final String STYLE_FORMAT = "fill:#ff0000; fill-opacity:0.2; stroke:#ff0000; stroke-opacity:1.0; stroke-width:1.0; symbol:circle";
    public static final String ATTRIB_DETECTED_X = "Detected_x";
    public static final String ATTRIB_DETECTED_Y = "Detected_y";
    public static final String ATTRIB_DETECTED_LAT = "Detected_lat";
    public static final String ATTRIB_DETECTED_LON = "Detected_lon";
    public static final String ATTRIB_DETECTED_WIDTH = "Detected_width";
    public static final String ATTRIB_DETECTED_LENGTH = "Detected_length";
    public static final String ATTRIB_CORR_SHIP_LAT = "Corr_ship_lat";
    public static final String ATTRIB_CORR_SHIP_LON = "Corr_ship_lon";
    public static final String ATTRIB_AIS_MMSI = "AIS_MMSI";
    public static final String ATTRIB_AIS_SHIP_NAME = "AIS_shipname";
    public static final String ATTRIB_STYLE_CSS = "style_css";
    private static final String PRODUCT_SUFFIX = "_SHP";

    public void initialize() throws OperatorException {
        try {
            MetadataElement absRoot = AbstractMetadata.getAbstractedMetadata((Product)this.sourceProduct);
            this.rangeSpacing = AbstractMetadata.getAttributeDouble((MetadataElement)absRoot, (String)"range_spacing");
            this.azimuthSpacing = AbstractMetadata.getAttributeDouble((MetadataElement)absRoot, (String)"azimuth_spacing");
            this.sourceImageWidth = this.sourceProduct.getSceneRasterWidth();
            this.sourceImageHeight = this.sourceProduct.getSceneRasterHeight();
            this.setTargetReportFilePath();
            this.createTargetProduct();
            this.shipFeatureType = this.createFeatureType();
        }
        catch (Throwable e) {
            OperatorUtils.catchOperatorException((String)this.getId(), (Throwable)e);
        }
    }

    private void setTargetReportFilePath() {
        String fileName = this.sourceProduct.getName() + "_object_detection_report.xml";
        this.targetReportFile = new File(ResourceUtils.getReportFolder(), fileName);
    }

    private void createTargetProduct() {
        this.targetProduct = new Product(this.sourceProduct.getName() + PRODUCT_SUFFIX, this.sourceProduct.getProductType(), this.sourceImageWidth, this.sourceImageHeight);
        ProductUtils.copyProductNodes((Product)this.sourceProduct, (Product)this.targetProduct);
        this.addSelectedBands();
        this.updateTargetProductMetadata();
    }

    private void addSelectedBands() throws OperatorException {
        Band[] bands;
        for (Band srcBand : bands = this.sourceProduct.getBands()) {
            boolean copySourceImage;
            String srcBandName = srcBand.getName();
            boolean bl = copySourceImage = !srcBandName.contains("_ship_bit_msk");
            if (srcBand instanceof VirtualBand) {
                ProductUtils.copyVirtualBand((Product)this.targetProduct, (VirtualBand)((VirtualBand)srcBand), (String)srcBand.getName());
                continue;
            }
            ProductUtils.copyBand((String)srcBand.getName(), (Product)this.sourceProduct, (Product)this.targetProduct, (boolean)copySourceImage);
        }
    }

    private void updateTargetProductMetadata() {
        MetadataElement absTgt = AbstractMetadata.getAbstractedMetadata((Product)this.targetProduct);
        absTgt.setAttributeString("target_report_file", this.targetReportFile.getAbsolutePath());
    }

    public void computeTile(Band targetBand, Tile targetTile, ProgressMonitor pm) throws OperatorException {
        try {
            List<ShipRecord> shipRecordList;
            Rectangle targetTileRectangle = targetTile.getRectangle();
            int tx0 = targetTileRectangle.x;
            int ty0 = targetTileRectangle.y;
            int tw = targetTileRectangle.width;
            int th = targetTileRectangle.height;
            int x0 = Math.max(tx0 - 10, 0);
            int y0 = Math.max(ty0 - 10, 0);
            int w = Math.min(tw + 20, this.sourceImageWidth);
            int h = Math.min(th + 20, this.sourceImageHeight);
            Rectangle sourceTileRectangle = new Rectangle(x0, y0, w, h);
            Band sourceBand = this.sourceProduct.getBand(targetBand.getName());
            int[][] pixelsScanned = new int[h][w];
            ArrayList<ShipRecord> clusterList = new ArrayList<ShipRecord>();
            Tile bitMaskTile = this.getSourceTile((RasterDataNode)sourceBand, sourceTileRectangle);
            ProductData bitMaskData = bitMaskTile.getDataBuffer();
            TileIndex srcIndex = new TileIndex(bitMaskTile);
            int maxy = ty0 + th;
            int maxx = tx0 + tw;
            for (int ty = ty0; ty < maxy; ++ty) {
                srcIndex.calculateStride(ty);
                for (int tx = tx0; tx < maxx; ++tx) {
                    if (pixelsScanned[ty - y0][tx - x0] != 0 || bitMaskData.getElemIntAt(srcIndex.getIndex(tx)) != 1) continue;
                    ArrayList<PixelPos> clusterPixels = new ArrayList<PixelPos>();
                    ObjectDiscriminationOp.clustering(tx, ty, x0, y0, w, h, bitMaskData, bitMaskTile, pixelsScanned, clusterPixels);
                    ShipRecord record = this.generateRecord(x0, y0, w, h, clusterPixels);
                    double size = Math.sqrt(record.length * record.length + record.width * record.width);
                    if (!(size >= this.minTargetSizeInMeter) || !(size <= this.maxTargetSizeInMeter)) continue;
                    clusterList.add(record);
                }
            }
            if (!clusterList.isEmpty()) {
                this.AddShipRecordsAsVectors(clusterList);
            }
            if ((shipRecordList = this.bandClusterLists.get(targetBand.getName())) == null) {
                shipRecordList = new ArrayList<ShipRecord>();
                this.bandClusterLists.put(targetBand.getName(), shipRecordList);
            }
            shipRecordList.addAll(clusterList);
            targetTile.setRawSamples(this.getSourceTile((RasterDataNode)sourceBand, targetTileRectangle).getRawSamples());
            this.clusteringPerformed = true;
        }
        catch (Throwable e) {
            OperatorUtils.catchOperatorException((String)this.getId(), (Throwable)e);
        }
    }

    private static void clustering(int xc, int yc, int x0, int y0, int w, int h, ProductData bitMaskData, Tile bitMaskTile, int[][] pixelsScanned, List<PixelPos> clusterPixels) {
        pixelsScanned[yc - y0][xc - x0] = 1;
        clusterPixels.add(new PixelPos((double)xc, (double)yc));
        int[] x = new int[]{xc - 1, xc, xc + 1, xc - 1, xc + 1, xc - 1, xc, xc + 1};
        int[] y = new int[]{yc - 1, yc - 1, yc - 1, yc, yc, yc + 1, yc + 1, yc + 1};
        for (int i = 0; i < 8; ++i) {
            if (x[i] < x0 || x[i] >= x0 + w || y[i] < y0 || y[i] >= y0 + h || pixelsScanned[y[i] - y0][x[i] - x0] != 0 || bitMaskData.getElemIntAt(bitMaskTile.getDataBufferIndex(x[i], y[i])) != 1) continue;
            ObjectDiscriminationOp.clustering(x[i], y[i], x0, y0, w, h, bitMaskData, bitMaskTile, pixelsScanned, clusterPixels);
        }
    }

    private ShipRecord generateRecord(int x0, int y0, int w, int h, List<PixelPos> clusterPixels) {
        int xMin = x0 + w - 1;
        int xMax = x0;
        int yMin = y0 + h - 1;
        int yMax = y0;
        for (PixelPos pixel : clusterPixels) {
            if (pixel.x < (double)xMin) {
                xMin = (int)pixel.x;
            }
            if (pixel.x > (double)xMax) {
                xMax = (int)pixel.x;
            }
            if (pixel.y < (double)yMin) {
                yMin = (int)pixel.y;
            }
            if (!(pixel.y > (double)yMax)) continue;
            yMax = (int)pixel.y;
        }
        double xMid = (double)(xMin + xMax) / 2.0;
        double yMid = (double)(yMin + yMax) / 2.0;
        GeoPos geoPos = this.targetProduct.getSceneGeoCoding().getGeoPos(new PixelPos(xMid, yMid), null);
        double width = (double)(xMax - xMin + 1) * this.rangeSpacing;
        double length = (double)(yMax - yMin + 1) * this.azimuthSpacing;
        return new ShipRecord((int)xMid, (int)yMid, geoPos.lat, geoPos.lon, width, length);
    }

    public void dispose() {
        if (!this.clusteringPerformed) {
            return;
        }
        this.writeBandClusterListsToFile();
    }

    private void writeBandClusterListsToFile() throws OperatorException {
        try {
            Element root = new Element("Detection");
            Document doc = new Document(root);
            for (String bandName : this.bandClusterLists.keySet()) {
                Element elem = new Element("targetsDetected");
                elem.setAttribute("bandName", bandName);
                List<ShipRecord> clusterList = this.bandClusterLists.get(bandName);
                for (ShipRecord rec : clusterList) {
                    Element subElem = new Element("target");
                    subElem.setAttribute(ATTRIB_DETECTED_X, String.valueOf(rec.x));
                    subElem.setAttribute(ATTRIB_DETECTED_Y, String.valueOf(rec.y));
                    subElem.setAttribute(ATTRIB_DETECTED_LAT, String.valueOf(rec.lat));
                    subElem.setAttribute(ATTRIB_DETECTED_LON, String.valueOf(rec.lon));
                    subElem.setAttribute(ATTRIB_DETECTED_WIDTH, String.valueOf(rec.width));
                    subElem.setAttribute(ATTRIB_DETECTED_LENGTH, String.valueOf(rec.length));
                    elem.addContent((Content)subElem);
                }
                root.addContent((Content)elem);
            }
            XMLSupport.SaveXML((Document)doc, (String)this.targetReportFile.getAbsolutePath());
        }
        catch (IOException e) {
            SystemUtils.LOG.warning("Unable to save target report " + e.getMessage());
        }
    }

    private SimpleFeatureType createFeatureType() {
        ArrayList<AttributeDescriptorImpl> attributeDescriptors = new ArrayList<AttributeDescriptorImpl>();
        attributeDescriptors.add(VectorUtils.createAttribute((String)ATTRIB_DETECTED_X, Integer.class));
        attributeDescriptors.add(VectorUtils.createAttribute((String)ATTRIB_DETECTED_Y, Integer.class));
        attributeDescriptors.add(VectorUtils.createAttribute((String)ATTRIB_DETECTED_LAT, Double.class));
        attributeDescriptors.add(VectorUtils.createAttribute((String)ATTRIB_DETECTED_LON, Double.class));
        attributeDescriptors.add(VectorUtils.createAttribute((String)ATTRIB_DETECTED_WIDTH, Double.class));
        attributeDescriptors.add(VectorUtils.createAttribute((String)ATTRIB_DETECTED_LENGTH, Double.class));
        attributeDescriptors.add(VectorUtils.createAttribute((String)ATTRIB_STYLE_CSS, String.class));
        return VectorUtils.createFeatureType((GeoCoding)this.targetProduct.getSceneGeoCoding(), (String)VECTOR_NODE_NAME, attributeDescriptors);
    }

    private synchronized void AddShipRecordsAsVectors(List<ShipRecord> clusterList) {
        VectorDataNode vectorDataNode = (VectorDataNode)this.targetProduct.getVectorDataGroup().get(VECTOR_NODE_NAME);
        if (vectorDataNode == null) {
            vectorDataNode = new VectorDataNode(VECTOR_NODE_NAME, this.shipFeatureType);
            this.targetProduct.getVectorDataGroup().add((ProductNode)vectorDataNode);
        }
        DefaultFeatureCollection collection = vectorDataNode.getFeatureCollection();
        GeometryFactory geometryFactory = new GeometryFactory();
        int c = collection.size();
        for (ShipRecord rec : clusterList) {
            String name = "target_" + StringUtils.padNum((int)c, (int)3, (char)'0');
            SimpleFeatureBuilder fb = new SimpleFeatureBuilder(this.shipFeatureType);
            fb.add((Object)geometryFactory.createPoint(new Coordinate((double)rec.x, (double)rec.y)));
            fb.add((Object)rec.x);
            fb.add((Object)rec.y);
            fb.add((Object)rec.lat);
            fb.add((Object)rec.lon);
            fb.add((Object)rec.width);
            fb.add((Object)rec.length);
            fb.add((Object)STYLE_FORMAT);
            SimpleFeature feature = fb.buildFeature(name);
            collection.add(feature);
            ++c;
        }
    }

    public static class Spi
    extends OperatorSpi {
        public Spi() {
            super(ObjectDiscriminationOp.class);
        }
    }

    public static class AttributeInfo {
        public final String attributeName;
        public final Class attributeClass;

        public AttributeInfo(String attributeName, Class attributeClass) {
            this.attributeName = attributeName;
            this.attributeClass = attributeClass;
        }
    }

    public static class ShipRecord {
        public final int x;
        public final int y;
        public final double lat;
        public final double lon;
        public final double width;
        public final double length;
        public double corr_lat;
        public double corr_lon;
        public int mmsi;
        public String shipName;

        public ShipRecord(int x, int y, double lat, double lon, double width, double length) {
            this.x = x;
            this.y = y;
            this.lat = lat;
            this.lon = lon;
            this.width = width;
            this.length = length;
            this.corr_lat = 0.0;
            this.corr_lon = 0.0;
        }
    }
}

