/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s1tbx.fex.gpf.forest;

import Jama.Matrix;
import com.bc.ceres.core.ProgressMonitor;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.dataop.downloadable.StatusProgressMonitor;
import org.esa.snap.core.gpf.Operator;
import org.esa.snap.core.gpf.OperatorException;
import org.esa.snap.core.gpf.OperatorSpi;
import org.esa.snap.core.gpf.Tile;
import org.esa.snap.core.gpf.annotations.OperatorMetadata;
import org.esa.snap.core.gpf.annotations.Parameter;
import org.esa.snap.core.gpf.annotations.SourceProduct;
import org.esa.snap.core.gpf.annotations.TargetProduct;
import org.esa.snap.core.util.ProductUtils;
import org.esa.snap.engine_utilities.gpf.OperatorUtils;
import org.esa.snap.engine_utilities.gpf.ThreadManager;
import org.esa.snap.engine_utilities.gpf.TileIndex;

@OperatorMetadata(alias="Forest-Area-Classification", category="Radar/SAR Applications", authors="Jun Lu, Luis Veci", copyright="Copyright (C) 2016 by Array Systems Computing Inc.", version="1.0", description="Detect forest area", internal=true)
public final class ForestAreaClassificationOp
extends Operator {
    @SourceProduct(alias="source")
    private Product sourceProduct;
    @TargetProduct
    private Product targetProduct;
    @Parameter(description="The list of source bands.", alias="sourceBands", rasterDataNodeType=Band.class, label="Source Bands")
    private String[] sourceBandNames = null;
    @Parameter(description="The number of classes", interval="[3, 20]", defaultValue="3", label="Number of Classes")
    private int numClasses = 3;
    @Parameter(description="The maximum number of iterations", interval="[1, 100]", defaultValue="10", label="Maximum Number of Iterations")
    private int maxIterations = 10;
    @Parameter(description="The convergence threshold", interval="[1, 100]", defaultValue="95", label="Convergence Threshold (%)")
    private int convergenceThreshold = 95;
    private int srcWidth = 0;
    private int srcHeight = 0;
    private boolean clusterCentersComputed = false;
    private byte[][] mask = null;
    private double T_Ratio_Low = 3.76;
    private double T_Ratio_High = 6.55;
    private String[] srcBandNames = null;

    public void initialize() throws OperatorException {
        try {
            this.createTargetProduct();
        }
        catch (Throwable e) {
            OperatorUtils.catchOperatorException((String)this.getId(), (Throwable)e);
        }
    }

    private void createTargetProduct() {
        this.srcWidth = this.sourceProduct.getSceneRasterWidth();
        this.srcHeight = this.sourceProduct.getSceneRasterHeight();
        this.targetProduct = new Product(this.sourceProduct.getName(), this.sourceProduct.getProductType(), this.srcWidth, this.srcHeight);
        this.addSelectedBands();
        ProductUtils.copyProductNodes((Product)this.sourceProduct, (Product)this.targetProduct);
    }

    private void addSelectedBands() throws OperatorException {
        boolean hasRatio = false;
        this.srcBandNames = new String[this.sourceBandNames.length];
        int k = 1;
        for (String bandName : this.sourceBandNames) {
            if (!hasRatio && bandName.contains("ratio")) {
                this.srcBandNames[0] = bandName;
                hasRatio = true;
                continue;
            }
            this.srcBandNames[k++] = bandName;
        }
        if (!hasRatio) {
            throw new OperatorException("Please select ratio and feature bands.");
        }
        for (String bandName : this.sourceBandNames) {
            ProductUtils.copyBand((String)bandName, (Product)this.sourceProduct, (String)bandName, (Product)this.targetProduct, (boolean)true);
        }
        Band targetBand = new Band("land_cover_classes", 20, this.targetProduct.getSceneRasterWidth(), this.targetProduct.getSceneRasterHeight());
        targetBand.setUnit("class_index");
        targetBand.setNoDataValue(255.0);
        targetBand.setNoDataValueUsed(true);
        this.targetProduct.addBand(targetBand);
    }

    public void computeTile(Band targetBand, Tile targetTile, ProgressMonitor pm) throws OperatorException {
        if (!this.clusterCentersComputed) {
            this.performClustering();
        }
        Rectangle targetRectangle = targetTile.getRectangle();
        int tx0 = targetRectangle.x;
        int ty0 = targetRectangle.y;
        int tw = targetRectangle.width;
        int th = targetRectangle.height;
        int maxY = ty0 + th;
        int maxX = tx0 + tw;
        ProductData targetData = targetTile.getDataBuffer();
        TileIndex trgIndex = new TileIndex(targetTile);
        for (int y = ty0; y < maxY; ++y) {
            trgIndex.calculateStride(y);
            for (int x = tx0; x < maxX; ++x) {
                targetData.setElemIntAt(trgIndex.getIndex(x), (int)this.mask[y][x]);
            }
        }
    }

    private synchronized void performClustering() {
        if (this.clusterCentersComputed) {
            return;
        }
        ArrayList<ClusterInfo> clusterList = new ArrayList<ClusterInfo>(this.numClasses);
        this.mask = new byte[this.srcHeight][this.srcWidth];
        Dimension tileSize = new Dimension(256, 256);
        Rectangle[] tileRectangles = OperatorUtils.getAllTileRectangles((Product)this.sourceProduct, (Dimension)tileSize, (int)0);
        this.computeInitialClusterCenters(clusterList, tileRectangles);
        this.computeClusterCovarianceMatrices(clusterList, tileRectangles);
        this.computeFinalClusterCenters(clusterList, tileRectangles);
        this.clusterCentersComputed = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void computeInitialClusterCenters(final List<ClusterInfo> clusterList, Rectangle[] tileRectangles) {
        this.setInitialClusterBoundaries(clusterList);
        StatusProgressMonitor status = new StatusProgressMonitor(StatusProgressMonitor.TYPE.SUBTASK);
        status.beginTask("Creating Initial Clusters... ", tileRectangles.length);
        final int numSrcBands = this.srcBandNames.length;
        final int[] counter = new int[this.numClasses];
        ThreadManager threadManager = new ThreadManager();
        final double[][] clusterSum = new double[this.numClasses][numSrcBands - 1];
        try {
            for (final Rectangle rectangle : tileRectangles) {
                this.checkForCancellation();
                Thread worker = new Thread(){
                    final Tile[] sourceTiles;
                    final ProductData[] dataBuffers;
                    final double[] u;
                    {
                        this.sourceTiles = new Tile[numSrcBands];
                        this.dataBuffers = new ProductData[numSrcBands];
                        this.u = new double[numSrcBands - 1];
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     * Enabled aggressive block sorting
                     * Enabled unnecessary exception pruning
                     * Enabled aggressive exception aggregation
                     * Converted monitor instructions to comments
                     * Lifted jumps to return sites
                     */
                    @Override
                    public void run() {
                        int x0 = rectangle.x;
                        int y0 = rectangle.y;
                        int w = rectangle.width;
                        int h = rectangle.height;
                        int xMax = x0 + w;
                        int yMax = y0 + h;
                        for (int i = 0; i < numSrcBands; ++i) {
                            this.sourceTiles[i] = ForestAreaClassificationOp.this.getSourceTile((RasterDataNode)ForestAreaClassificationOp.this.sourceProduct.getBand(ForestAreaClassificationOp.this.srcBandNames[i]), rectangle);
                            this.dataBuffers[i] = this.sourceTiles[i].getDataBuffer();
                        }
                        TileIndex srcIndex = new TileIndex(this.sourceTiles[0]);
                        int y = y0;
                        block3: while (y < yMax) {
                            srcIndex.calculateStride(y);
                            int x = x0;
                            while (true) {
                                block7: {
                                    double ratio;
                                    block8: {
                                        block6: {
                                            if (x >= xMax) break block6;
                                            int idx = srcIndex.getIndex(x);
                                            ratio = this.dataBuffers[0].getElemDoubleAt(idx);
                                            ForestAreaClassificationOp.this.getCurrentPoint(idx, this.dataBuffers, this.u);
                                            int[] nArray = counter;
                                            // MONITORENTER : counter
                                            if (Double.isNaN(ratio)) break block7;
                                            break block8;
                                        }
                                        ++y;
                                        continue block3;
                                    }
                                    for (int i = 0; i < ForestAreaClassificationOp.this.numClasses; ++i) {
                                        if (!(ratio >= ((ClusterInfo)clusterList.get((int)i)).initLowBound) || !(ratio < ((ClusterInfo)clusterList.get((int)i)).initHighBound)) continue;
                                        ((ForestAreaClassificationOp)ForestAreaClassificationOp.this).mask[y][x] = (byte)i;
                                        ForestAreaClassificationOp.this.addClusterSum(i, clusterSum, this.u);
                                        int n = i;
                                        counter[n] = counter[n] + 1;
                                        break;
                                    }
                                }
                                // MONITOREXIT : nArray
                                ++x;
                            }
                            break;
                        }
                        return;
                    }
                };
                threadManager.add(worker);
                status.worked(1);
            }
            threadManager.finish();
        }
        catch (Throwable e) {
            OperatorUtils.catchOperatorException((String)(this.getId() + " computeInitialClusterCenters "), (Throwable)e);
        }
        finally {
            status.done();
        }
        double[] center = new double[numSrcBands - 1];
        for (int i = 0; i < this.numClasses; ++i) {
            for (int j = 0; j < numSrcBands - 1; ++j) {
                center[j] = clusterSum[i][j] / (double)counter[i];
            }
            clusterList.get(i).setClusterCenter(center, counter[i]);
        }
    }

    private void setInitialClusterBoundaries(List<ClusterInfo> clusterList) {
        Band ratio = this.sourceProduct.getBand(this.srcBandNames[0]);
        double bandMin = ratio.getStx(true, ProgressMonitor.NULL).getMinimum();
        double bandMax = ratio.getStx(true, ProgressMonitor.NULL).getMaximum();
        int numLowerClasses = Math.max(1, (int)Math.round((this.T_Ratio_Low - bandMin) / (bandMax - bandMin - this.T_Ratio_High + this.T_Ratio_Low) * (double)(this.numClasses - 1)));
        int numHighClasses = this.numClasses - 1 - numLowerClasses;
        double dl = (this.T_Ratio_Low - bandMin) / (double)numLowerClasses;
        double dh = (bandMax - this.T_Ratio_High) / (double)numHighClasses;
        for (int i = 0; i < this.numClasses; ++i) {
            ClusterInfo cluster = new ClusterInfo(i);
            if (i == 0) {
                cluster.setInitialClusterBounds(this.T_Ratio_Low, this.T_Ratio_High);
            } else if (i <= numLowerClasses) {
                cluster.setInitialClusterBounds(bandMin + (double)(i - 1) * dl, bandMin + (double)i * dl);
            } else {
                cluster.setInitialClusterBounds(this.T_Ratio_High + (double)(i - numLowerClasses - 1) * dh, this.T_Ratio_High + (double)(i - numLowerClasses) * dh);
            }
            clusterList.add(cluster);
        }
    }

    private void getCurrentPoint(int idx, ProductData[] dataBuffers, double[] u) {
        for (int i = 1; i < dataBuffers.length; ++i) {
            u[i - 1] = dataBuffers[i].getElemDoubleAt(idx);
        }
    }

    private void addClusterSum(int classIdx, double[][] clusterSum, double[] u) {
        for (int j = 0; j < u.length; ++j) {
            double[] dArray = clusterSum[classIdx];
            int n = j;
            dArray[n] = dArray[n] + u[j];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void computeClusterCovarianceMatrices(final List<ClusterInfo> clusterList, Rectangle[] tileRectangles) {
        StatusProgressMonitor status = new StatusProgressMonitor(StatusProgressMonitor.TYPE.SUBTASK);
        status.beginTask("Computing Cluster Covariance Matrices... ", tileRectangles.length);
        final int numSrcBands = this.srcBandNames.length;
        ThreadManager threadManager = new ThreadManager();
        final double[][][] clusterCov = new double[this.numClasses][numSrcBands - 1][numSrcBands - 1];
        try {
            for (final Rectangle rectangle : tileRectangles) {
                this.checkForCancellation();
                Thread worker = new Thread(){
                    final Tile[] sourceTiles;
                    final ProductData[] dataBuffers;
                    final double[][] C;
                    final double[] u;
                    {
                        this.sourceTiles = new Tile[numSrcBands];
                        this.dataBuffers = new ProductData[numSrcBands];
                        this.C = new double[numSrcBands - 1][numSrcBands - 1];
                        this.u = new double[numSrcBands - 1];
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     * Enabled aggressive block sorting
                     * Enabled unnecessary exception pruning
                     * Enabled aggressive exception aggregation
                     * Converted monitor instructions to comments
                     * Lifted jumps to return sites
                     */
                    @Override
                    public void run() {
                        int x0 = rectangle.x;
                        int y0 = rectangle.y;
                        int w = rectangle.width;
                        int h = rectangle.height;
                        int xMax = x0 + w;
                        int yMax = y0 + h;
                        for (int i = 0; i < numSrcBands; ++i) {
                            this.sourceTiles[i] = ForestAreaClassificationOp.this.getSourceTile((RasterDataNode)ForestAreaClassificationOp.this.sourceProduct.getBand(ForestAreaClassificationOp.this.srcBandNames[i]), rectangle);
                            this.dataBuffers[i] = this.sourceTiles[i].getDataBuffer();
                        }
                        TileIndex srcIndex = new TileIndex(this.sourceTiles[0]);
                        int y = y0;
                        block3: while (y < yMax) {
                            srcIndex.calculateStride(y);
                            int x = x0;
                            while (true) {
                                byte classIdx;
                                if (x < xMax) {
                                    int idx = srcIndex.getIndex(x);
                                    ForestAreaClassificationOp.this.getCurrentPoint(idx, this.dataBuffers, this.u);
                                    classIdx = ForestAreaClassificationOp.this.mask[y][x];
                                    ForestAreaClassificationOp.this.computeCovarianceMatrix(((ClusterInfo)clusterList.get((int)classIdx)).center, this.u, this.C);
                                    double[][][] dArray = clusterCov;
                                    // MONITORENTER : clusterCov
                                } else {
                                    ++y;
                                    continue block3;
                                }
                                for (int i = 0; i < numSrcBands - 1; ++i) {
                                    for (int j = 0; j < numSrcBands - 1; ++j) {
                                        double[] dArray = clusterCov[classIdx][i];
                                        int n = j;
                                        dArray[n] = dArray[n] + this.C[i][j];
                                    }
                                }
                                // MONITOREXIT : dArray
                                ++x;
                            }
                            break;
                        }
                        return;
                    }
                };
                threadManager.add(worker);
                status.worked(1);
            }
            threadManager.finish();
        }
        catch (Throwable e) {
            OperatorUtils.catchOperatorException((String)(this.getId() + " computeClusterCovarianceMatrices "), (Throwable)e);
        }
        finally {
            status.done();
        }
        for (int c = 0; c < this.numClasses; ++c) {
            for (int i = 0; i < numSrcBands - 1; ++i) {
                int j = 0;
                while (j < numSrcBands - 1) {
                    double[] dArray = clusterCov[c][i];
                    int n = j++;
                    dArray[n] = dArray[n] / (double)clusterList.get((int)c).size;
                }
            }
            clusterList.get(c).setClusterCovarianceMatrix(clusterCov[c]);
        }
    }

    private void computeCovarianceMatrix(double[] center, double[] u, double[][] C) {
        for (int i = 0; i < u.length; ++i) {
            for (int j = 0; j < u.length; ++j) {
                C[i][j] = (u[i] - center[i]) * (u[j] - center[j]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void computeFinalClusterCenters(final List<ClusterInfo> clusterList, Rectangle[] tileRectangles) {
        StatusProgressMonitor status = new StatusProgressMonitor(StatusProgressMonitor.TYPE.SUBTASK);
        status.beginTask("Computing Final Cluster Centres... ", tileRectangles.length * this.maxIterations);
        final int numSrcBands = this.srcBandNames.length;
        final int[] clusterCounter = new int[this.numClasses];
        final int[] clusterPixelChangeCounter = new int[this.numClasses];
        final double[][] clusterSum = new double[this.numClasses][numSrcBands - 1];
        ThreadManager threadManager = new ThreadManager();
        try {
            for (int it = 0; it < this.maxIterations; ++it) {
                Arrays.fill(clusterCounter, 0);
                Arrays.fill(clusterPixelChangeCounter, 0);
                for (double[] row : clusterSum) {
                    Arrays.fill(row, 0.0);
                }
                for (final Rectangle rectangle : tileRectangles) {
                    Thread worker = new Thread(){
                        final Tile[] sourceTiles;
                        final ProductData[] dataBuffers;
                        final double[] u;
                        {
                            this.sourceTiles = new Tile[numSrcBands];
                            this.dataBuffers = new ProductData[numSrcBands];
                            this.u = new double[numSrcBands - 1];
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         * Enabled aggressive block sorting
                         * Enabled unnecessary exception pruning
                         * Enabled aggressive exception aggregation
                         * Converted monitor instructions to comments
                         * Lifted jumps to return sites
                         */
                        @Override
                        public void run() {
                            ForestAreaClassificationOp.this.checkForCancellation();
                            int x0 = rectangle.x;
                            int y0 = rectangle.y;
                            int w = rectangle.width;
                            int h = rectangle.height;
                            int xMax = x0 + w;
                            int yMax = y0 + h;
                            for (int i = 0; i < numSrcBands; ++i) {
                                this.sourceTiles[i] = ForestAreaClassificationOp.this.getSourceTile((RasterDataNode)ForestAreaClassificationOp.this.sourceProduct.getBand(ForestAreaClassificationOp.this.srcBandNames[i]), rectangle);
                                this.dataBuffers[i] = this.sourceTiles[i].getDataBuffer();
                            }
                            TileIndex srcIndex = new TileIndex(this.sourceTiles[0]);
                            int y = y0;
                            while (y < yMax) {
                                srcIndex.calculateStride(y);
                                for (int x = x0; x < xMax; ++x) {
                                    int idx = srcIndex.getIndex(x);
                                    ForestAreaClassificationOp.this.getCurrentPoint(idx, this.dataBuffers, this.u);
                                    int clusterIdx = ForestAreaClassificationOp.this.findClosestCluster(this.u, clusterList);
                                    int[] nArray = clusterCounter;
                                    // MONITORENTER : clusterCounter
                                    if (ForestAreaClassificationOp.this.mask[y][x] != clusterIdx) {
                                        byte by = ForestAreaClassificationOp.this.mask[y][x];
                                        clusterPixelChangeCounter[by] = clusterPixelChangeCounter[by] + 1;
                                        ((ForestAreaClassificationOp)ForestAreaClassificationOp.this).mask[y][x] = (byte)clusterIdx;
                                    }
                                    ForestAreaClassificationOp.this.addClusterSum(clusterIdx, clusterSum, this.u);
                                    int n = clusterIdx;
                                    clusterCounter[n] = clusterCounter[n] + 1;
                                    // MONITOREXIT : nArray
                                }
                                ++y;
                            }
                        }
                    };
                    threadManager.add(worker);
                    status.worked(1);
                }
                threadManager.finish();
                if (this.isConvergent(clusterList, clusterPixelChangeCounter)) {
                    break;
                }
                ForestAreaClassificationOp.updateClusterCenter(clusterList, clusterCounter, clusterSum);
                this.computeClusterCovarianceMatrices(clusterList, tileRectangles);
            }
        }
        catch (Throwable e) {
            OperatorUtils.catchOperatorException((String)(this.getId() + " computeFinalClusterCenters "), (Throwable)e);
        }
        finally {
            status.done();
        }
    }

    private int findClosestCluster(double[] u, List<ClusterInfo> clusterList) {
        double minDistance = Double.MAX_VALUE;
        int clusterIndex = -1;
        for (int c = 0; c < clusterList.size(); ++c) {
            double d = this.computeMLD(u, clusterList.get(c));
            if (!(minDistance > d)) continue;
            minDistance = d;
            clusterIndex = c;
        }
        return clusterIndex;
    }

    private double computeMLD(double[] u, ClusterInfo cluster) {
        Matrix uMat = new Matrix(u, u.length);
        Matrix uMatNew = uMat.minus(new Matrix(cluster.center, cluster.center.length));
        return uMatNew.transpose().times(cluster.invCov).times(uMatNew).get(0, 0) + cluster.logDet;
    }

    private boolean isConvergent(List<ClusterInfo> clusterList, int[] clusterPixelChangeCounter) {
        for (int c = 0; c < this.numClasses; ++c) {
            double unchangedPercentage = 100.0 * (1.0 - (double)clusterPixelChangeCounter[c] / (double)clusterList.get((int)c).size);
            if (!(unchangedPercentage < (double)this.convergenceThreshold)) continue;
            return false;
        }
        return true;
    }

    private static void updateClusterCenter(List<ClusterInfo> clusterList, int[] clusterCounter, double[][] clusterSum) {
        for (int c = 0; c < clusterList.size(); ++c) {
            double[] center = new double[clusterList.get((int)c).center.length];
            for (int i = 0; i < center.length; ++i) {
                center[i] = clusterSum[c][i] / (double)clusterCounter[c];
            }
            clusterList.get(c).setClusterCenter(center, clusterCounter[c]);
        }
    }

    public static class Spi
    extends OperatorSpi {
        public Spi() {
            super(ForestAreaClassificationOp.class);
        }
    }

    public static class ClusterInfo {
        int classIndex;
        int size;
        double initLowBound;
        double initHighBound;
        double[] center = null;
        double logDet;
        Matrix invCov = null;

        public ClusterInfo(int classIdx) {
            this.classIndex = classIdx;
        }

        public void setInitialClusterBounds(double lowBound, double highBound) {
            this.initLowBound = lowBound;
            this.initHighBound = highBound;
        }

        public void setClusterCenter(double[] center, int size) {
            this.size = size;
            this.center = new double[center.length];
            System.arraycopy(center, 0, this.center, 0, center.length);
        }

        public void setClusterCovarianceMatrix(double[][] Cov) {
            Matrix CMat = new Matrix(Cov);
            this.logDet = Math.log(Math.max(Math.abs(CMat.det()), 1.0E-15));
            this.invCov = CMat.inverse();
        }
    }
}

