/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s1tbx.calibration.gpf.support;

import Jama.Matrix;
import org.esa.snap.core.datamodel.TiePointGrid;
import org.esa.snap.engine_utilities.util.Maths;

class QuadInterpolator {
    private final double subSamplinX;
    private final double subSamplinY;
    private final double[][] warpPolynomialCoef;
    private static final int warpPolynomialOrder = 2;

    public QuadInterpolator(TiePointGrid tpg) {
        int imageWidth = tpg.getRasterWidth();
        this.subSamplinX = tpg.getSubSamplingX();
        this.subSamplinY = tpg.getSubSamplingY();
        int width = tpg.getGridWidth();
        int height = tpg.getGridHeight();
        float[] tiePoints = tpg.getTiePoints();
        String tiePointGridName = tpg.getName();
        boolean imageFlipped = false;
        if ((tiePointGridName.equals("incident_angle") || tiePointGridName.equals("slant_range_time")) && tiePoints[0] > tiePoints[width - 1]) {
            imageFlipped = true;
        }
        double[] sampleIndexArray = new double[width];
        for (int c = 0; c < width; ++c) {
            if (imageFlipped) {
                sampleIndexArray[width - 1 - c] = imageWidth - 1 - Math.min(c * ((int)this.subSamplinX - 1), imageWidth - 1);
                continue;
            }
            sampleIndexArray[c] = Math.min(c * ((int)this.subSamplinX - 1), imageWidth - 1);
        }
        Matrix A = Maths.createVandermondeMatrix((double[])sampleIndexArray, (int)2);
        double[] tiePointArray = new double[width];
        this.warpPolynomialCoef = new double[height][3];
        for (int r = 0; r < height; ++r) {
            for (int c = 0; c < width; ++c) {
                tiePointArray[c] = tiePoints[r * width + c];
            }
            Matrix b = new Matrix(tiePointArray, width);
            Matrix x = A.solve(b);
            this.warpPolynomialCoef[r] = x.getColumnPackedCopy();
        }
    }

    public double[] getPixelDouble(int x0, int y0, int w, int h, double[] pixels) {
        int k = 0;
        for (int y = y0; y < y0 + h; ++y) {
            int r = (int)((double)y / this.subSamplinY);
            double a0 = this.warpPolynomialCoef[r][0];
            double a1 = this.warpPolynomialCoef[r][1];
            double a2 = this.warpPolynomialCoef[r][2];
            for (int x = x0; x < x0 + w; ++x) {
                pixels[k++] = a0 + a1 * (double)x + a2 * (double)x * (double)x;
            }
        }
        return pixels;
    }
}

