/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s1tbx.calibration.gpf.calibrators;

import com.bc.ceres.core.ProgressMonitor;
import java.awt.Rectangle;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.math3.util.FastMath;
import org.esa.s1tbx.calibration.gpf.Sentinel1RemoveThermalNoiseOp;
import org.esa.s1tbx.calibration.gpf.support.BaseCalibrator;
import org.esa.s1tbx.calibration.gpf.support.Calibrator;
import org.esa.s1tbx.commons.Sentinel1Utils;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.MetadataElement;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.gpf.Operator;
import org.esa.snap.core.gpf.OperatorException;
import org.esa.snap.core.gpf.Tile;
import org.esa.snap.core.util.ProductUtils;
import org.esa.snap.core.util.SystemUtils;
import org.esa.snap.engine_utilities.datamodel.AbstractMetadata;
import org.esa.snap.engine_utilities.datamodel.Unit;
import org.esa.snap.engine_utilities.gpf.InputProductValidator;
import org.esa.snap.engine_utilities.gpf.OperatorUtils;
import org.esa.snap.engine_utilities.gpf.ReaderUtils;
import org.esa.snap.engine_utilities.gpf.TileIndex;

public final class Sentinel1Calibrator
extends BaseCalibrator
implements Calibrator {
    private CalibrationInfo[] calibration = null;
    private boolean isMultiSwath = false;
    private boolean priorToIPFV234 = false;
    protected final HashMap<String, CalibrationInfo> targetBandToCalInfo = new HashMap(2);
    private List<String> selectedPolList = null;
    private boolean outputSigmaBand = false;
    private boolean outputGammaBand = false;
    private boolean outputBetaBand = false;
    private boolean outputDNBand = false;
    private CALTYPE dataType = null;
    private int subsetOffsetX = 0;
    private int subsetOffsetY = 0;

    @Override
    public void setExternalAuxFile(File file) throws OperatorException {
        if (file != null) {
            throw new OperatorException("No external auxiliary file should be selected for Sentinel1 product");
        }
    }

    @Override
    public void setAuxFileFlag(String file) {
    }

    public void setUserSelections(Product sourceProduct, String[] selectedPolarisations, boolean outputSigmaBand, boolean outputGammaBand, boolean outputBetaBand, boolean outputDNBand) {
        this.outputSigmaBand = outputSigmaBand;
        this.outputGammaBand = outputGammaBand;
        this.outputBetaBand = outputBetaBand;
        this.outputDNBand = outputDNBand;
        String[] selectedPols = selectedPolarisations;
        if (selectedPols == null || selectedPols.length == 0) {
            MetadataElement absRoot = AbstractMetadata.getAbstractedMetadata((Product)sourceProduct);
            selectedPols = Sentinel1Utils.getProductPolarizations((MetadataElement)absRoot);
        }
        this.selectedPolList = new ArrayList<String>(4);
        for (String pol : selectedPols) {
            this.selectedPolList.add(pol.toUpperCase());
        }
        if (!(outputSigmaBand || outputGammaBand || outputBetaBand || outputDNBand)) {
            this.outputSigmaBand = true;
        }
    }

    private void validate(Product sourceProduct) throws OperatorException {
        InputProductValidator validator = new InputProductValidator(sourceProduct);
        validator.checkIfSentinel1Product();
        validator.checkAcquisitionMode(new String[]{"IW", "EW", "SM"});
        validator.checkProductType(new String[]{"SLC", "GRD"});
        if (validator.isComplex() && validator.isTOPSARProduct() && validator.isDebursted()) {
            throw new OperatorException("Calibration should be applied before deburst");
        }
        this.isMultiSwath = validator.isMultiSwath();
    }

    @Override
    public void initialize(Operator op, Product srcProduct, Product tgtProduct, boolean mustPerformRetroCalibration, boolean mustUpdateMetadata) throws OperatorException {
        try {
            this.calibrationOp = op;
            this.sourceProduct = srcProduct;
            this.targetProduct = tgtProduct;
            this.validate(this.sourceProduct);
            this.absRoot = AbstractMetadata.getAbstractedMetadata((Product)this.sourceProduct);
            this.priorToIPFV234 = this.priorToIPFV234();
            if (this.priorToIPFV234) {
                SystemUtils.LOG.warning("The calibration LUT for this product could be incorrect and therefore the calibration result may not be reliable.");
            }
            this.getSampleType();
            if (this.absRoot.getAttribute("abs_calibration_flag").getData().getElemBoolean()) {
                this.dataType = Sentinel1Calibrator.getCalibrationType(this.sourceProduct.getBandAt(0).getName());
            }
            this.getSubsetOffset();
            this.getVectors();
            this.createTargetBandToCalInfoMap();
            if (mustUpdateMetadata) {
                this.updateTargetProductMetadata();
            }
        }
        catch (Exception e) {
            throw new OperatorException((Throwable)e);
        }
    }

    private boolean priorToIPFV234() throws OperatorException {
        String procSysId = this.absRoot.getAttributeString("Processing_system_identifier");
        float version = Float.valueOf(procSysId.substring(procSysId.lastIndexOf(" "))).floatValue();
        return version < 2.34f;
    }

    private void getSubsetOffset() {
        this.subsetOffsetX = this.absRoot.getAttributeInt("subset_offset_x");
        this.subsetOffsetY = this.absRoot.getAttributeInt("subset_offset_y");
    }

    private void getVectors() throws IOException {
        boolean getSigmaLUT = this.outputSigmaBand;
        boolean getBetaLUT = this.outputBetaBand;
        boolean getGammaLUT = this.outputGammaBand;
        boolean getDNLUT = this.outputDNBand;
        if (this.dataType != null) {
            if (this.dataType.equals((Object)CALTYPE.SIGMA0)) {
                getSigmaLUT = true;
            } else if (this.dataType.equals((Object)CALTYPE.BETA0)) {
                getBetaLUT = true;
            } else if (this.dataType.equals((Object)CALTYPE.GAMMA)) {
                getGammaLUT = true;
            } else {
                getDNLUT = true;
            }
        }
        this.calibration = Sentinel1Calibrator.getCalibrationVectors(this.sourceProduct, this.selectedPolList, getSigmaLUT, getBetaLUT, getGammaLUT, getDNLUT);
    }

    public static CalibrationInfo[] getCalibrationVectors(Product sourceProduct, List<String> selectedPolList, boolean getSigmaLUT, boolean getBetaLUT, boolean getGammaLUT, boolean getDNLUT) throws IOException {
        MetadataElement[] calibrationDataSetListElem;
        ArrayList<CalibrationInfo> calibrationInfoList = new ArrayList<CalibrationInfo>();
        MetadataElement origProdRoot = AbstractMetadata.getOriginalProductMetadata((Product)sourceProduct);
        if (origProdRoot == null) {
            throw new IOException("Unable to find original product metadata");
        }
        MetadataElement calibrationElem = origProdRoot.getElement("calibration");
        if (calibrationElem == null) {
            throw new IOException("Unable to find calibration element in original product metadata");
        }
        for (MetadataElement dataSetListElem : calibrationDataSetListElem = calibrationElem.getElements()) {
            MetadataElement calElem = dataSetListElem.getElement("calibration");
            MetadataElement adsHeaderElem = calElem.getElement("adsHeader");
            String pol = adsHeaderElem.getAttributeString("polarisation");
            if (!selectedPolList.contains(pol)) continue;
            MetadataElement calVecListElem = calElem.getElement("calibrationVectorList");
            String subSwath = adsHeaderElem.getAttributeString("swath");
            double firstLineTime = Sentinel1Utils.getTime((MetadataElement)adsHeaderElem, (String)"startTime").getMJD();
            double lastLineTime = Sentinel1Utils.getTime((MetadataElement)adsHeaderElem, (String)"stopTime").getMJD();
            int numOfLines = Sentinel1Calibrator.getNumOfLines(origProdRoot, pol, subSwath);
            int count = calVecListElem.getAttributeInt("count");
            Sentinel1Utils.CalibrationVector[] calibrationVectorList = Sentinel1Utils.getCalibrationVector((MetadataElement)calVecListElem, (boolean)getSigmaLUT, (boolean)getBetaLUT, (boolean)getGammaLUT, (boolean)getDNLUT);
            calibrationInfoList.add(new CalibrationInfo(subSwath, pol, firstLineTime, lastLineTime, numOfLines, count, calibrationVectorList));
        }
        return calibrationInfoList.toArray(new CalibrationInfo[calibrationInfoList.size()]);
    }

    private void createTargetBandToCalInfoMap() {
        String[] targetBandNames = this.targetProduct.getBandNames();
        for (CalibrationInfo cal : this.calibration) {
            String pol = cal.polarization;
            String ss = cal.subSwath;
            for (String bandName : targetBandNames) {
                if (this.isMultiSwath) {
                    if (!bandName.contains(pol) || !bandName.contains(ss)) continue;
                    this.targetBandToCalInfo.put(bandName, cal);
                    continue;
                }
                if (!bandName.contains(pol)) continue;
                this.targetBandToCalInfo.put(bandName, cal);
            }
        }
    }

    public static int getNumOfLines(MetadataElement origProdRoot, String polarization, String swath) {
        MetadataElement[] annotationDataSetListElem;
        MetadataElement annotationElem = origProdRoot.getElement("annotation");
        for (MetadataElement dataSetListElem : annotationDataSetListElem = annotationElem.getElements()) {
            String elemName = dataSetListElem.getName();
            if (!elemName.contains(swath.toLowerCase()) || !elemName.contains(polarization.toLowerCase())) continue;
            MetadataElement productElem = dataSetListElem.getElement("product");
            MetadataElement imageAnnotationElem = productElem.getElement("imageAnnotation");
            MetadataElement imageInformationElem = imageAnnotationElem.getElement("imageInformation");
            return imageInformationElem.getAttributeInt("numberOfLines");
        }
        return -1;
    }

    private void updateTargetProductMetadata() {
        MetadataElement[] bandMetadataList;
        MetadataElement absRoot = AbstractMetadata.getAbstractedMetadata((Product)this.targetProduct);
        absRoot.getAttribute("abs_calibration_flag").getData().setElemBoolean(true);
        String[] targetBandNames = this.targetProduct.getBandNames();
        Sentinel1Utils.updateBandNames((MetadataElement)absRoot, this.selectedPolList, (String[])targetBandNames);
        for (MetadataElement bandMeta : bandMetadataList = AbstractMetadata.getBandAbsMetadataList((MetadataElement)absRoot)) {
            boolean polFound = false;
            for (String pol : this.selectedPolList) {
                if (!bandMeta.getName().contains(pol)) continue;
                polFound = true;
                break;
            }
            if (polFound) continue;
            absRoot.removeElement(bandMeta);
        }
    }

    @Override
    public Product createTargetProduct(Product sourceProduct, String[] sourceBandNames) {
        this.validate(sourceProduct);
        this.targetProduct = new Product(sourceProduct.getName() + "_Cal", sourceProduct.getProductType(), sourceProduct.getSceneRasterWidth(), sourceProduct.getSceneRasterHeight());
        this.addSelectedBands(sourceProduct, sourceBandNames);
        ProductUtils.copyProductNodes((Product)sourceProduct, (Product)this.targetProduct);
        return this.targetProduct;
    }

    private void addSelectedBands(Product sourceProduct, String[] sourceBandNames) {
        if (this.outputImageInComplex) {
            this.outputInComplex(sourceProduct, sourceBandNames);
        } else {
            this.outputInIntensity(sourceProduct, sourceBandNames);
        }
    }

    private void outputInComplex(Product sourceProduct, String[] sourceBandNames) {
        Band[] sourceBands = OperatorUtils.getSourceBands((Product)sourceProduct, (String[])sourceBandNames, (boolean)false);
        for (int i = 0; i < sourceBands.length; i += 2) {
            Band srcBandI = sourceBands[i];
            String unit = srcBandI.getUnit();
            String nextUnit = null;
            if (unit == null) {
                throw new OperatorException("band " + srcBandI.getName() + " requires a unit");
            }
            if (unit.contains("db")) {
                throw new OperatorException("Calibration of bands in dB is not supported");
            }
            if (unit.contains("imaginary")) {
                throw new OperatorException("I and Q bands should be selected in pairs");
            }
            if (unit.contains("real")) {
                if (i + 1 >= sourceBands.length) {
                    throw new OperatorException("I and Q bands should be selected in pairs");
                }
                nextUnit = sourceBands[i + 1].getUnit();
                if (nextUnit == null || !nextUnit.contains("imaginary")) {
                    throw new OperatorException("I and Q bands should be selected in pairs");
                }
            } else {
                throw new OperatorException("Please select I and Q bands in pairs only");
            }
            String pol = srcBandI.getName().substring(srcBandI.getName().lastIndexOf("_") + 1);
            if (!this.selectedPolList.contains(pol)) continue;
            Band srcBandQ = sourceBands[i + 1];
            String[] srcBandNames = new String[]{srcBandI.getName(), srcBandQ.getName()};
            this.targetBandNameToSourceBandName.put(srcBandNames[0], srcBandNames);
            Band targetBandI = new Band(srcBandNames[0], 30, srcBandI.getRasterWidth(), srcBandI.getRasterHeight());
            targetBandI.setUnit(unit);
            targetBandI.setNoDataValueUsed(true);
            targetBandI.setNoDataValue(srcBandI.getNoDataValue());
            this.targetProduct.addBand(targetBandI);
            this.targetBandNameToSourceBandName.put(srcBandNames[1], srcBandNames);
            Band targetBandQ = new Band(srcBandNames[1], 30, srcBandQ.getRasterWidth(), srcBandQ.getRasterHeight());
            targetBandQ.setUnit(nextUnit);
            targetBandQ.setNoDataValueUsed(true);
            targetBandQ.setNoDataValue(srcBandQ.getNoDataValue());
            this.targetProduct.addBand(targetBandQ);
            String suffix = "_" + OperatorUtils.getSuffixFromBandName((String)srcBandI.getName());
            ReaderUtils.createVirtualIntensityBand((Product)this.targetProduct, (Band)targetBandI, (Band)targetBandQ, (String)suffix);
        }
    }

    private void outputInIntensity(Product sourceProduct, String[] sourceBandNames) {
        Band[] sourceBands = OperatorUtils.getSourceBands((Product)sourceProduct, (String[])sourceBandNames, (boolean)false);
        for (int i = 0; i < sourceBands.length; ++i) {
            String[] targetBandNames;
            String[] srcBandNames;
            Band srcBand = sourceBands[i];
            String unit = srcBand.getUnit();
            if (unit == null) {
                throw new OperatorException("band " + srcBand.getName() + " requires a unit");
            }
            if (!unit.contains("real") && !unit.contains("amplitude") && !unit.contains("intensity")) continue;
            if (unit.contains("real")) {
                if (i + 1 >= sourceBands.length) {
                    throw new OperatorException("Real and imaginary bands are not in pairs");
                }
                String nextUnit = sourceBands[i + 1].getUnit();
                if (nextUnit == null || !nextUnit.contains("imaginary")) {
                    throw new OperatorException("Real and imaginary bands are not in pairs");
                }
                srcBandNames = new String[]{srcBand.getName(), sourceBands[i + 1].getName()};
                ++i;
            } else {
                srcBandNames = new String[]{srcBand.getName()};
            }
            String pol = srcBandNames[0].substring(srcBandNames[0].lastIndexOf("_") + 1);
            if (!this.selectedPolList.contains(pol)) continue;
            for (String tgtBandName : targetBandNames = this.createTargetBandNames(srcBandNames[0])) {
                if (this.targetProduct.getBand(tgtBandName) != null) continue;
                this.targetBandNameToSourceBandName.put(tgtBandName, srcBandNames);
                Band targetBand = new Band(tgtBandName, 30, srcBand.getRasterWidth(), srcBand.getRasterHeight());
                targetBand.setUnit("intensity");
                targetBand.setDescription(srcBand.getDescription());
                targetBand.setNoDataValue(srcBand.getNoDataValue());
                targetBand.setNoDataValueUsed(srcBand.isNoDataValueUsed());
                this.targetProduct.addBand(targetBand);
            }
        }
    }

    private String[] createTargetBandNames(String srcBandName) {
        int cnt = (this.outputSigmaBand ? 1 : 0) + (this.outputGammaBand ? 1 : 0) + (this.outputBetaBand ? 1 : 0) + (this.outputDNBand ? 1 : 0);
        String[] targetBandNames = new String[cnt];
        String pol = srcBandName.substring(srcBandName.indexOf("_"));
        int k = 0;
        if (this.outputSigmaBand) {
            targetBandNames[k++] = "Sigma0" + pol;
        }
        if (this.outputGammaBand) {
            targetBandNames[k++] = "Gamma0" + pol;
        }
        if (this.outputBetaBand) {
            targetBandNames[k++] = "Beta0" + pol;
        }
        if (this.outputDNBand) {
            targetBandNames[k] = "DN" + pol;
        }
        return targetBandNames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void computeTile(Band targetBand, Tile targetTile, ProgressMonitor pm) throws OperatorException {
        Rectangle targetTileRectangle = targetTile.getRectangle();
        int x0 = targetTileRectangle.x;
        int y0 = targetTileRectangle.y;
        int w = targetTileRectangle.width;
        int h = targetTileRectangle.height;
        try {
            Tile sourceRaster1 = null;
            ProductData srcData1 = null;
            ProductData srcData2 = null;
            Band sourceBand1 = null;
            String targetBandName = targetBand.getName();
            String[] srcBandNames = (String[])this.targetBandNameToSourceBandName.get(targetBandName);
            if (srcBandNames.length == 1) {
                sourceBand1 = this.sourceProduct.getBand(srcBandNames[0]);
                sourceRaster1 = this.calibrationOp.getSourceTile((RasterDataNode)sourceBand1, targetTileRectangle);
                srcData1 = sourceRaster1.getDataBuffer();
            } else {
                sourceBand1 = this.sourceProduct.getBand(srcBandNames[0]);
                Band sourceBand2 = this.sourceProduct.getBand(srcBandNames[1]);
                sourceRaster1 = this.calibrationOp.getSourceTile((RasterDataNode)sourceBand1, targetTileRectangle);
                Tile sourceRaster2 = this.calibrationOp.getSourceTile((RasterDataNode)sourceBand2, targetTileRectangle);
                srcData1 = sourceRaster1.getDataBuffer();
                srcData2 = sourceRaster2.getDataBuffer();
            }
            Double noDataValue = sourceBand1.getNoDataValue();
            Unit.UnitType tgtBandUnit = Unit.getUnitType((Band)targetBand);
            Unit.UnitType srcBandUnit = Unit.getUnitType((Band)sourceBand1);
            ProductData tgtData = targetTile.getDataBuffer();
            TileIndex srcIndex = new TileIndex(sourceRaster1);
            TileIndex trgIndex = new TileIndex(targetTile);
            int maxY = y0 + h;
            int maxX = x0 + w;
            CalibrationInfo calInfo = this.targetBandToCalInfo.get(targetBandName);
            if (calInfo == null) {
                throw new OperatorException("Calibration information not found.");
            }
            CALTYPE calType = Sentinel1Calibrator.getCalibrationType(targetBandName);
            double dn = 0.0;
            double retroLutVal = 1.0;
            double phaseTerm = 0.0;
            for (int y = y0; y < maxY; ++y) {
                srcIndex.calculateStride(y);
                trgIndex.calculateStride(y);
                int calVecIdx = calInfo.getCalibrationVectorIndex(this.subsetOffsetY + y);
                Sentinel1Utils.CalibrationVector vec0 = calInfo.getCalibrationVector(calVecIdx);
                Sentinel1Utils.CalibrationVector vec1 = calInfo.getCalibrationVector(calVecIdx + 1);
                float[] vec0LUT = Sentinel1Calibrator.getVector(calType, vec0);
                float[] vec1LUT = Sentinel1Calibrator.getVector(calType, vec1);
                float[] retroVec0LUT = null;
                float[] retroVec1LUT = null;
                if (this.dataType != null) {
                    retroVec0LUT = Sentinel1Calibrator.getVector(this.dataType, vec0);
                    retroVec1LUT = Sentinel1Calibrator.getVector(this.dataType, vec1);
                }
                double azTime = calInfo.firstLineTime + (double)(this.subsetOffsetY + y) * calInfo.lineTimeInterval;
                double muY = (azTime - vec0.timeMJD) / (vec1.timeMJD - vec0.timeMJD);
                int[] vec0Pixels = vec0.pixels;
                Sentinel1Utils.CalibrationVector calVec = calInfo.calibrationVectorList[calVecIdx];
                float trgFloorValue = Sentinel1RemoveThermalNoiseOp.trgFloorValue;
                for (int x = x0; x < maxX; ++x) {
                    int srcIdx = srcIndex.getIndex(x);
                    dn = srcData1.getElemDoubleAt(srcIdx);
                    int pixelIdx = calVec.getPixelIndex(this.subsetOffsetX + x);
                    double muX = (double)(this.subsetOffsetX + x - vec0Pixels[pixelIdx]) / (double)(vec0Pixels[pixelIdx + 1] - vec0Pixels[pixelIdx]);
                    double lutVal = (1.0 - muY) * ((1.0 - muX) * (double)vec0LUT[pixelIdx] + muX * (double)vec0LUT[pixelIdx + 1]) + muY * ((1.0 - muX) * (double)vec1LUT[pixelIdx] + muX * (double)vec1LUT[pixelIdx + 1]);
                    double calibrationFactor = 1.0 / (lutVal * lutVal);
                    if (srcBandUnit == Unit.UnitType.AMPLITUDE) {
                        dn *= dn;
                    } else if (srcBandUnit == Unit.UnitType.INTENSITY) {
                        if (this.dataType != null) {
                            retroLutVal = (1.0 - muY) * ((1.0 - muX) * (double)retroVec0LUT[pixelIdx] + muX * (double)retroVec0LUT[pixelIdx + 1]) + muY * ((1.0 - muX) * (double)retroVec1LUT[pixelIdx] + muX * (double)retroVec1LUT[pixelIdx + 1]);
                        }
                        calibrationFactor *= retroLutVal;
                    } else if (srcBandUnit == Unit.UnitType.REAL) {
                        double i = dn;
                        double q = srcData2.getElemDoubleAt(srcIdx);
                        if ((dn = i * i + q * q) > 0.0) {
                            if (tgtBandUnit == Unit.UnitType.REAL) {
                                phaseTerm = i / Math.sqrt(dn);
                            } else if (tgtBandUnit == Unit.UnitType.IMAGINARY) {
                                phaseTerm = q / Math.sqrt(dn);
                            }
                        } else {
                            phaseTerm = 0.0;
                        }
                    } else if (srcBandUnit == Unit.UnitType.INTENSITY_DB) {
                        dn = FastMath.pow((double)10.0, (double)(dn / 10.0));
                    } else {
                        throw new OperatorException("Sentinel-1 Calibration: unhandled unit");
                    }
                    double calValue = dn * calibrationFactor;
                    if (dn == (double)trgFloorValue) {
                        while ((double)((float)calValue) < 1.0E-5) {
                            calValue = (dn *= 2.0) * calibrationFactor;
                        }
                    }
                    if (this.isComplex && this.outputImageInComplex) {
                        calValue = Math.sqrt(calValue) * phaseTerm;
                    }
                    tgtData.setElemDoubleAt(trgIndex.getIndex(x), calValue);
                }
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        finally {
            pm.done();
        }
    }

    public static CALTYPE getCalibrationType(String bandName) {
        CALTYPE calType = bandName.contains("Beta") ? CALTYPE.BETA0 : (bandName.contains("Gamma") ? CALTYPE.GAMMA : (bandName.contains("DN") ? CALTYPE.DN : CALTYPE.SIGMA0));
        return calType;
    }

    public static float[] getVector(CALTYPE calType, Sentinel1Utils.CalibrationVector vec) {
        if (calType == null) {
            return null;
        }
        if (calType.equals((Object)CALTYPE.SIGMA0)) {
            return vec.sigmaNought;
        }
        if (calType.equals((Object)CALTYPE.BETA0)) {
            return vec.betaNought;
        }
        if (calType.equals((Object)CALTYPE.GAMMA)) {
            return vec.gamma;
        }
        return vec.dn;
    }

    @Override
    public double applyCalibration(double v, double rangeIndex, double azimuthIndex, double slantRange, double satelliteHeight, double sceneToEarthCentre, double localIncidenceAngle, String bandName, String bandPolar, Unit.UnitType bandUnit, int[] subSwathIndex) {
        CalibrationInfo calInfo = this.targetBandToCalInfo.get(bandName);
        int calVecIdx = calInfo.getCalibrationVectorIndex((int)azimuthIndex);
        Sentinel1Utils.CalibrationVector vec0 = calInfo.getCalibrationVector(calVecIdx);
        Sentinel1Utils.CalibrationVector vec1 = calInfo.getCalibrationVector(calVecIdx + 1);
        CALTYPE calType = Sentinel1Calibrator.getCalibrationType(bandName);
        float[] vec0LUT = Sentinel1Calibrator.getVector(calType, vec0);
        float[] vec1LUT = Sentinel1Calibrator.getVector(calType, vec1);
        Sentinel1Utils.CalibrationVector calVec = calInfo.calibrationVectorList[calVecIdx];
        int pixelIdx = calVec.getPixelIndex((int)rangeIndex);
        double azTime = calInfo.firstLineTime + azimuthIndex * calInfo.lineTimeInterval;
        double muY = (azTime - vec0.timeMJD) / (vec1.timeMJD - vec0.timeMJD);
        double muX = (rangeIndex - (double)vec0.pixels[pixelIdx]) / (double)(vec0.pixels[pixelIdx + 1] - vec0.pixels[pixelIdx]);
        double lutVal = (1.0 - muY) * ((1.0 - muX) * (double)vec0LUT[pixelIdx] + muX * (double)vec0LUT[pixelIdx + 1]) + muY * ((1.0 - muX) * (double)vec1LUT[pixelIdx] + muX * (double)vec1LUT[pixelIdx + 1]);
        double sigma = 0.0;
        if (bandUnit == Unit.UnitType.AMPLITUDE) {
            sigma = v * v / (lutVal * lutVal);
        } else if (bandUnit == Unit.UnitType.INTENSITY) {
            sigma = v / (lutVal * lutVal);
        } else if (bandUnit == Unit.UnitType.INTENSITY_DB) {
            sigma = FastMath.pow((double)10.0, (double)(v / 10.0)) / (lutVal * lutVal);
        } else if (bandUnit == Unit.UnitType.REAL || bandUnit == Unit.UnitType.IMAGINARY) {
            sigma = v / lutVal;
        } else {
            throw new OperatorException("Unknown band unit");
        }
        return sigma;
    }

    @Override
    public double applyRetroCalibration(int x, int y, double v, String bandPolar, Unit.UnitType bandUnit, int[] subSwathIndex) {
        return v;
    }

    @Override
    public void removeFactorsForCurrentTile(Band targetBand, Tile targetTile, String srcBandName) throws OperatorException {
        Band sourceBand = this.sourceProduct.getBand(targetBand.getName());
        Tile sourceTile = this.calibrationOp.getSourceTile((RasterDataNode)sourceBand, targetTile.getRectangle());
        targetTile.setRawSamples(sourceTile.getRawSamples());
    }

    public static final class CalibrationInfo {
        public final String subSwath;
        public final String polarization;
        public final double firstLineTime;
        public final double lastLineTime;
        public final int numOfLines;
        public final int count;
        public final Sentinel1Utils.CalibrationVector[] calibrationVectorList;
        public final double lineTimeInterval;

        CalibrationInfo(String subSwath, String polarization, double firstLineTime, double lastLineTime, int numOfLines, int count, Sentinel1Utils.CalibrationVector[] calibrationVectorList) {
            this.subSwath = subSwath;
            this.polarization = polarization;
            this.firstLineTime = firstLineTime;
            this.lastLineTime = lastLineTime;
            this.numOfLines = numOfLines;
            this.count = count;
            this.calibrationVectorList = calibrationVectorList;
            this.lineTimeInterval = (lastLineTime - firstLineTime) / (double)(numOfLines - 1);
        }

        public int getCalibrationVectorIndex(int y) {
            for (int i = 1; i < this.count; ++i) {
                if (y >= this.calibrationVectorList[i].line) continue;
                return i - 1;
            }
            return -1;
        }

        public Sentinel1Utils.CalibrationVector getCalibrationVector(int calVecIdx) {
            return this.calibrationVectorList[calVecIdx];
        }
    }

    public static enum CALTYPE {
        SIGMA0,
        BETA0,
        GAMMA,
        DN;

    }
}

