/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s1tbx.calibration.gpf.calibrators;

import com.bc.ceres.core.ProgressMonitor;
import java.awt.Rectangle;
import java.io.File;
import org.apache.commons.math3.util.FastMath;
import org.esa.s1tbx.calibration.gpf.support.BaseCalibrator;
import org.esa.s1tbx.calibration.gpf.support.Calibrator;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.MetadataAttribute;
import org.esa.snap.core.datamodel.MetadataElement;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.datamodel.TiePointGrid;
import org.esa.snap.core.gpf.Operator;
import org.esa.snap.core.gpf.OperatorException;
import org.esa.snap.core.gpf.Tile;
import org.esa.snap.engine_utilities.datamodel.AbstractMetadata;
import org.esa.snap.engine_utilities.datamodel.Unit;
import org.esa.snap.engine_utilities.gpf.OperatorUtils;
import org.esa.snap.engine_utilities.gpf.TileIndex;

public class Radarsat2Calibrator
extends BaseCalibrator
implements Calibrator {
    private static final String lutsigma = "lutSigma";
    private static final String lutgamma = "lutGamma";
    private static final String lutbeta = "lutBeta";
    private static final String USE_INCIDENCE_ANGLE_FROM_DEM = "Use projected local incidence angle from DEM";
    private TiePointGrid incidenceAngle = null;
    private double offset = 0.0;
    private double[] gains = null;
    private int subsetOffsetX = 0;
    private int subsetOffsetY = 0;
    private boolean isSLC = false;

    @Override
    public void setExternalAuxFile(File file) throws OperatorException {
        if (file != null) {
            throw new OperatorException("No external auxiliary file should be selected for Radarsat2 product");
        }
    }

    @Override
    public void setAuxFileFlag(String file) {
    }

    @Override
    public void initialize(Operator op, Product srcProduct, Product tgtProduct, boolean mustPerformRetroCalibration, boolean mustUpdateMetadata) throws OperatorException {
        try {
            this.calibrationOp = op;
            this.sourceProduct = srcProduct;
            this.targetProduct = tgtProduct;
            this.absRoot = AbstractMetadata.getAbstractedMetadata((Product)this.sourceProduct);
            this.getMission();
            this.getCalibrationFlag();
            this.isSLC = this.sourceProduct.getProductType().toLowerCase().contains("slc");
            this.getSubsetOffset();
            this.getLUT();
            this.getTiePointGridData(this.sourceProduct);
            if (mustUpdateMetadata) {
                this.updateTargetProductMetadata();
            }
        }
        catch (Exception e) {
            throw new OperatorException((Throwable)e);
        }
    }

    private void getMission() {
        String mission = this.absRoot.getAttributeString("MISSION");
        if (!mission.equals("RS2")) {
            throw new OperatorException(mission + " is not a valid mission for Radarsat2 Calibration");
        }
    }

    private void getSubsetOffset() {
        this.subsetOffsetX = this.absRoot.getAttributeInt("subset_offset_x");
        this.subsetOffsetY = this.absRoot.getAttributeInt("subset_offset_y");
    }

    private void getLUT() {
        MetadataElement origProdRoot = AbstractMetadata.getOriginalProductMetadata((Product)this.sourceProduct);
        MetadataElement lutSigmaElem = origProdRoot.getElement(lutsigma);
        if (lutSigmaElem != null) {
            this.offset = lutSigmaElem.getAttributeDouble("offset", 0.0);
            MetadataAttribute gainsAttrib = lutSigmaElem.getAttribute("gains");
            if (gainsAttrib != null) {
                this.gains = (double[])gainsAttrib.getData().getElems();
            }
        } else {
            throw new OperatorException("lutSigma not found. Please ensure the look up table lutSigma.xml is in the same folder as the original product");
        }
        if (this.gains.length < this.sourceProduct.getSceneRasterWidth()) {
            throw new OperatorException("Calibration LUT is smaller than source product width");
        }
    }

    private void getTiePointGridData(Product sourceProduct) {
        this.incidenceAngle = OperatorUtils.getIncidenceAngle((Product)sourceProduct);
    }

    private void updateTargetProductMetadata() {
        MetadataElement abs = AbstractMetadata.getAbstractedMetadata((Product)this.targetProduct);
        abs.getAttribute("abs_calibration_flag").getData().setElemBoolean(true);
        MetadataElement origProdRoot = AbstractMetadata.getOriginalProductMetadata((Product)this.targetProduct);
        origProdRoot.removeElement(origProdRoot.getElement(lutsigma));
        origProdRoot.removeElement(origProdRoot.getElement(lutgamma));
        origProdRoot.removeElement(origProdRoot.getElement(lutbeta));
    }

    @Override
    public void computeTile(Band targetBand, Tile targetTile, ProgressMonitor pm) throws OperatorException {
        Rectangle targetTileRectangle = targetTile.getRectangle();
        int x0 = targetTileRectangle.x;
        int y0 = targetTileRectangle.y;
        int w = targetTileRectangle.width;
        int h = targetTileRectangle.height;
        Tile sourceRaster1 = null;
        ProductData srcData1 = null;
        ProductData srcData2 = null;
        Band sourceBand1 = null;
        String[] srcBandNames = (String[])this.targetBandNameToSourceBandName.get(targetBand.getName());
        if (srcBandNames.length == 1) {
            sourceBand1 = this.sourceProduct.getBand(srcBandNames[0]);
            sourceRaster1 = this.calibrationOp.getSourceTile((RasterDataNode)sourceBand1, targetTileRectangle);
            srcData1 = sourceRaster1.getDataBuffer();
        } else {
            sourceBand1 = this.sourceProduct.getBand(srcBandNames[0]);
            Band sourceBand2 = this.sourceProduct.getBand(srcBandNames[1]);
            sourceRaster1 = this.calibrationOp.getSourceTile((RasterDataNode)sourceBand1, targetTileRectangle);
            Tile sourceRaster2 = this.calibrationOp.getSourceTile((RasterDataNode)sourceBand2, targetTileRectangle);
            srcData1 = sourceRaster1.getDataBuffer();
            srcData2 = sourceRaster2.getDataBuffer();
        }
        Unit.UnitType tgtBandUnit = Unit.getUnitType((Band)targetBand);
        Unit.UnitType srcBandUnit = Unit.getUnitType((Band)sourceBand1);
        ProductData trgData = targetTile.getDataBuffer();
        TileIndex srcIndex = new TileIndex(sourceRaster1);
        TileIndex tgtIndex = new TileIndex(targetTile);
        int maxY = y0 + h;
        int maxX = x0 + w;
        double sigma = 0.0;
        double phaseTerm = 0.0;
        Double noDataValue = targetBand.getNoDataValue();
        for (int y = y0; y < maxY; ++y) {
            srcIndex.calculateStride(y);
            tgtIndex.calculateStride(y);
            for (int x = x0; x < maxX; ++x) {
                int srcIdx = srcIndex.getIndex(x);
                int tgtIdx = tgtIndex.getIndex(x);
                double dn = srcData1.getElemDoubleAt(srcIdx);
                if (srcBandUnit == Unit.UnitType.AMPLITUDE) {
                    dn *= dn;
                } else if (srcBandUnit != Unit.UnitType.INTENSITY) {
                    if (srcBandUnit == Unit.UnitType.REAL) {
                        double i = dn;
                        double q = srcData2.getElemDoubleAt(srcIdx);
                        if ((dn = i * i + q * q) > 0.0) {
                            if (tgtBandUnit == Unit.UnitType.REAL) {
                                phaseTerm = i / Math.sqrt(dn);
                            } else if (tgtBandUnit == Unit.UnitType.IMAGINARY) {
                                phaseTerm = q / Math.sqrt(dn);
                            }
                        } else {
                            phaseTerm = 0.0;
                        }
                    } else if (srcBandUnit == Unit.UnitType.INTENSITY_DB) {
                        dn = FastMath.pow((double)10.0, (double)(dn / 10.0));
                    } else {
                        throw new OperatorException("RadarSat2 Calibration: unhandled unit");
                    }
                }
                if (this.isSLC) {
                    if (this.gains != null) {
                        sigma = dn / (this.gains[x + this.subsetOffsetX] * this.gains[x + this.subsetOffsetX]);
                        if (this.outputImageInComplex) {
                            sigma = Math.sqrt(sigma) * phaseTerm;
                        }
                    }
                } else {
                    sigma = dn + this.offset;
                    if (this.gains != null) {
                        sigma /= this.gains[x + this.subsetOffsetX];
                    }
                }
                if (this.outputImageScaleInDb) {
                    sigma = sigma < 1.0E-30 ? -1.0E-30 : 10.0 * Math.log10(sigma);
                }
                trgData.setElemDoubleAt(tgtIdx, sigma);
            }
        }
    }

    @Override
    public double applyCalibration(double v, double rangeIndex, double azimuthIndex, double slantRange, double satelliteHeight, double sceneToEarthCentre, double localIncidenceAngle, String bandName, String bandPolar, Unit.UnitType bandUnit, int[] subSwathIndex) {
        double sigma = 0.0;
        if (bandUnit == Unit.UnitType.AMPLITUDE) {
            sigma = v * v;
        } else if (bandUnit == Unit.UnitType.INTENSITY || bandUnit == Unit.UnitType.REAL || bandUnit == Unit.UnitType.IMAGINARY) {
            sigma = v;
        } else if (bandUnit == Unit.UnitType.INTENSITY_DB) {
            sigma = FastMath.pow((double)10.0, (double)(v / 10.0));
        } else {
            throw new OperatorException("Unknown band unit");
        }
        if (this.isSLC) {
            if (this.gains != null) {
                sigma /= this.gains[(int)rangeIndex] * this.gains[(int)rangeIndex];
            }
        } else {
            sigma += this.offset;
            if (this.gains != null) {
                sigma /= this.gains[(int)rangeIndex];
            }
        }
        if (this.incidenceAngleSelection.contains(USE_INCIDENCE_ANGLE_FROM_DEM)) {
            return sigma * FastMath.sin((double)(localIncidenceAngle * (Math.PI / 180)));
        }
        return sigma;
    }

    @Override
    public double applyRetroCalibration(int x, int y, double v, String bandPolar, Unit.UnitType bandUnit, int[] subSwathIndex) {
        if (this.incidenceAngleSelection.contains(USE_INCIDENCE_ANGLE_FROM_DEM)) {
            return v / FastMath.sin((double)(this.incidenceAngle.getPixelDouble(x, y) * (Math.PI / 180)));
        }
        return v;
    }

    @Override
    public void removeFactorsForCurrentTile(Band targetBand, Tile targetTile, String srcBandName) throws OperatorException {
        Band sourceBand = this.sourceProduct.getBand(targetBand.getName());
        Tile sourceTile = this.calibrationOp.getSourceTile((RasterDataNode)sourceBand, targetTile.getRectangle());
        targetTile.setRawSamples(sourceTile.getRawSamples());
    }
}

