/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s1tbx.calibration.gpf.calibrators;

import com.bc.ceres.core.ProgressMonitor;
import java.awt.Rectangle;
import java.io.File;
import org.apache.commons.math3.util.FastMath;
import org.esa.s1tbx.calibration.gpf.support.BaseCalibrator;
import org.esa.s1tbx.calibration.gpf.support.Calibrator;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.MetadataElement;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.gpf.Operator;
import org.esa.snap.core.gpf.OperatorException;
import org.esa.snap.core.gpf.Tile;
import org.esa.snap.engine_utilities.datamodel.AbstractMetadata;
import org.esa.snap.engine_utilities.datamodel.Unit;
import org.esa.snap.engine_utilities.gpf.TileIndex;

public class Kompsat5Calibrator
extends BaseCalibrator
implements Calibrator {
    private String acquisitionMode = null;
    private double referenceIncidenceAngle = 0.0;
    private double rescalingFactor = 0.0;
    private double calibrationConstant = 0.0;
    private double calibrationFactor = 0.0;
    private double pixelArea = 0.0;
    private int windowSize = 0;
    private int halfWindowSize = 0;
    private int sourceImageWidth = 0;
    private int sourceImageHeight = 0;
    private boolean highResolutionMode = false;

    @Override
    public void setExternalAuxFile(File file) throws OperatorException {
        if (file != null) {
            throw new OperatorException("No external auxiliary file should be selected for Kompsat-5 product");
        }
    }

    @Override
    public void setAuxFileFlag(String file) {
    }

    public void setUserSelections(int windowSize) {
        this.windowSize = windowSize;
    }

    @Override
    public void initialize(Operator op, Product srcProduct, Product tgtProduct, boolean mustPerformRetroCalibration, boolean mustUpdateMetadata) throws OperatorException {
        try {
            this.calibrationOp = op;
            this.sourceProduct = srcProduct;
            this.targetProduct = tgtProduct;
            this.absRoot = AbstractMetadata.getAbstractedMetadata((Product)this.sourceProduct);
            this.origMetadataRoot = AbstractMetadata.getOriginalProductMetadata((Product)this.sourceProduct);
            String mission = this.absRoot.getAttributeString("MISSION");
            if (!mission.startsWith("Kompsat5")) {
                throw new OperatorException(mission + " is not a valid mission for Kompsat-5 Calibration");
            }
            String productType = this.absRoot.getAttributeString("PRODUCT_TYPE");
            if (!(productType.equals("SCS_B") || productType.equals("SCS_U") || productType.equals("SCS_A") || productType.equals("SCS_W"))) {
                throw new OperatorException(productType + " product is not supported");
            }
            if (this.absRoot.getAttribute("abs_calibration_flag").getData().getElemBoolean()) {
                throw new OperatorException("Absolute radiometric calibration has already been applied to the product");
            }
            switch (this.acquisitionMode = this.absRoot.getAttributeString("ACQUISITION_MODE")) {
                case "HIGH RESOLUTION": {
                    double rs = AbstractMetadata.getAttributeDouble((MetadataElement)this.absRoot, (String)"range_spacing");
                    double as = AbstractMetadata.getAttributeDouble((MetadataElement)this.absRoot, (String)"azimuth_spacing");
                    this.pixelArea = rs * as;
                    this.highResolutionMode = true;
                    break;
                }
                case "STANDARD": {
                    this.highResolutionMode = false;
                    break;
                }
                default: {
                    throw new OperatorException("Only High Resolution and Standard modes are currently supported");
                }
            }
            this.referenceIncidenceAngle = this.absRoot.getAttributeDouble("ref_inc_angle") * Math.PI / 180.0;
            this.rescalingFactor = this.absRoot.getAttributeDouble("rescaling_factor");
            if (this.rescalingFactor == 0.0) {
                throw new OperatorException("Cannot calibrate the product because rescaling factor is 0");
            }
            this.getCalibrationConstant();
            this.calibrationFactor = this.rescalingFactor / this.calibrationConstant * FastMath.sin((double)this.referenceIncidenceAngle);
            this.windowSize = 9;
            this.halfWindowSize = this.windowSize / 2;
            this.sourceImageWidth = this.sourceProduct.getSceneRasterWidth();
            this.sourceImageHeight = this.sourceProduct.getSceneRasterHeight();
            this.getSampleType();
            if (mustUpdateMetadata) {
                this.updateTargetProductMetadata();
            }
        }
        catch (Exception e) {
            throw new OperatorException((Throwable)e);
        }
    }

    private void updateTargetProductMetadata() {
        MetadataElement abs = AbstractMetadata.getAbstractedMetadata((Product)this.targetProduct);
        if (abs != null) {
            abs.getAttribute("abs_calibration_flag").getData().setElemBoolean(true);
        }
    }

    private void getCalibrationConstant() {
        MetadataElement auxElem = this.origMetadataRoot.getElement("Auxiliary");
        MetadataElement rootElem = auxElem.getElement("Root");
        MetadataElement subSwathsElem = rootElem.getElement("SubSwaths");
        MetadataElement subSwathElem = subSwathsElem.getElement("SubSwath");
        this.calibrationConstant = subSwathElem.getAttributeDouble("CalibrationConstant");
    }

    @Override
    public double applyCalibration(double v, double rangeIndex, double azimuthIndex, double slantRange, double satelliteHeight, double sceneToEarthCentre, double localIncidenceAngle, String bandName, String bandPolar, Unit.UnitType bandUnit, int[] subSwathIndex) {
        double sigma;
        if (bandUnit == Unit.UnitType.AMPLITUDE) {
            sigma = v * v;
        } else if (bandUnit == Unit.UnitType.INTENSITY || bandUnit == Unit.UnitType.REAL || bandUnit == Unit.UnitType.IMAGINARY) {
            sigma = v;
        } else if (bandUnit == Unit.UnitType.INTENSITY_DB) {
            sigma = FastMath.pow((double)10.0, (double)(v / 10.0));
        } else {
            throw new OperatorException("Unknown band unit");
        }
        sigma *= this.calibrationFactor;
        if (this.highResolutionMode) {
            sigma /= this.pixelArea;
        }
        if (this.outputImageScaleInDb) {
            sigma = sigma < 1.0E-30 ? -1.0E-30 : 10.0 * Math.log10(sigma);
        }
        return sigma;
    }

    @Override
    public double applyRetroCalibration(int x, int y, double v, String bandPolar, Unit.UnitType bandUnit, int[] subSwathIndex) {
        return v;
    }

    @Override
    public void computeTile(Band targetBand, Tile targetTile, ProgressMonitor pm) throws OperatorException {
        Rectangle targetTileRectangle = targetTile.getRectangle();
        int x0 = targetTileRectangle.x;
        int y0 = targetTileRectangle.y;
        int w = targetTileRectangle.width;
        int h = targetTileRectangle.height;
        int maxY = y0 + h;
        int maxX = x0 + w;
        Rectangle sourceRectangle = this.getSourceTileRectangle(x0, y0, w, h, this.halfWindowSize, this.halfWindowSize, this.sourceImageWidth, this.sourceImageHeight);
        Tile sourceRaster1 = null;
        Tile sourceRaster2 = null;
        ProductData srcData1 = null;
        ProductData srcData2 = null;
        Band sourceBand1 = null;
        Band sourceBand2 = null;
        String[] srcBandNames = (String[])this.targetBandNameToSourceBandName.get(targetBand.getName());
        if (srcBandNames.length == 1) {
            sourceBand1 = this.sourceProduct.getBand(srcBandNames[0]);
            sourceRaster1 = this.calibrationOp.getSourceTile((RasterDataNode)sourceBand1, sourceRectangle);
            srcData1 = sourceRaster1.getDataBuffer();
        } else {
            sourceBand1 = this.sourceProduct.getBand(srcBandNames[0]);
            sourceBand2 = this.sourceProduct.getBand(srcBandNames[1]);
            sourceRaster1 = this.calibrationOp.getSourceTile((RasterDataNode)sourceBand1, sourceRectangle);
            sourceRaster2 = this.calibrationOp.getSourceTile((RasterDataNode)sourceBand2, sourceRectangle);
            srcData1 = sourceRaster1.getDataBuffer();
            srcData2 = sourceRaster2.getDataBuffer();
        }
        Unit.UnitType tgtBandUnit = Unit.getUnitType((Band)targetBand);
        Unit.UnitType srcBandUnit = Unit.getUnitType((Band)sourceBand1);
        if (tgtBandUnit == Unit.UnitType.PHASE) {
            targetTile.setRawSamples(sourceRaster1.getRawSamples());
            return;
        }
        ProductData tgtData = targetTile.getDataBuffer();
        TileIndex srcIndex = new TileIndex(sourceRaster1);
        TileIndex tgtIndex = new TileIndex(targetTile);
        Double noDataValue = targetBand.getNoDataValue();
        for (int y = y0; y < maxY; ++y) {
            srcIndex.calculateStride(y);
            tgtIndex.calculateStride(y);
            for (int x = x0; x < maxX; ++x) {
                int srcIdx = srcIndex.getIndex(x);
                int tgtIdx = tgtIndex.getIndex(x);
                double dn2Mean = this.getMeanDN2(x, y, srcData1, srcData2, srcIndex, srcBandUnit, noDataValue);
                if (noDataValue.equals(dn2Mean)) {
                    tgtData.setElemDoubleAt(tgtIdx, noDataValue.doubleValue());
                    continue;
                }
                double sigma = dn2Mean * this.calibrationFactor;
                if (this.highResolutionMode) {
                    sigma /= this.pixelArea;
                }
                if (this.isComplex && this.outputImageInComplex && srcBandUnit == Unit.UnitType.REAL) {
                    double i = srcData1.getElemDoubleAt(srcIdx);
                    double q = srcData2.getElemDoubleAt(srcIdx);
                    double dn2 = i * i + q * q;
                    double phaseTerm = 0.0;
                    if (dn2 > 0.0) {
                        if (tgtBandUnit == Unit.UnitType.REAL) {
                            phaseTerm = i / Math.sqrt(dn2);
                        } else if (tgtBandUnit == Unit.UnitType.IMAGINARY) {
                            phaseTerm = q / Math.sqrt(dn2);
                        }
                    }
                    sigma = Math.sqrt(sigma) * phaseTerm;
                }
                if (this.outputImageScaleInDb) {
                    sigma = sigma < 1.0E-30 ? -1.0E-30 : 10.0 * Math.log10(sigma);
                }
                tgtData.setElemDoubleAt(tgtIdx, sigma);
            }
        }
    }

    private Rectangle getSourceTileRectangle(int x0, int y0, int w, int h, int halfSizeX, int halfSizeY, int sourceImageWidth, int sourceImageHeight) {
        int sx0 = Math.max(0, x0 - halfSizeX);
        int sy0 = Math.max(0, y0 - halfSizeY);
        int sw = Math.min(x0 + w + halfSizeX, sourceImageWidth) - sx0;
        int sh = Math.min(y0 + h + halfSizeY, sourceImageHeight) - sy0;
        return new Rectangle(sx0, sy0, sw, sh);
    }

    private double getMeanDN2(int x, int y, ProductData srcData1, ProductData srcData2, TileIndex srcIndex, Unit.UnitType srcBandUnit, double noDataValue) {
        int xMin = Math.max(0, x - this.halfWindowSize);
        int yMin = Math.max(0, y - this.halfWindowSize);
        int xMax = Math.min(x + this.halfWindowSize, this.sourceImageWidth - 1);
        int yMax = Math.min(y + this.halfWindowSize, this.sourceImageHeight - 1);
        int count = 0;
        double dn = 0.0;
        double dn2 = 0.0;
        double i = 0.0;
        double q = 0.0;
        double dn2Sum = 0.0;
        for (int yy = yMin; yy <= yMax; ++yy) {
            srcIndex.calculateStride(yy);
            for (int xx = xMin; xx <= xMax; ++xx) {
                int srcIdx = srcIndex.getIndex(x);
                if (srcBandUnit == Unit.UnitType.AMPLITUDE) {
                    dn = srcData1.getElemDoubleAt(srcIdx);
                    dn2 = dn * dn;
                } else if (srcBandUnit == Unit.UnitType.INTENSITY) {
                    dn2 = srcData1.getElemDoubleAt(srcIdx);
                } else if (srcBandUnit == Unit.UnitType.REAL) {
                    i = srcData1.getElemDoubleAt(srcIdx);
                    q = srcData2.getElemDoubleAt(srcIdx);
                    dn2 = i * i + q * q;
                } else if (srcBandUnit == Unit.UnitType.INTENSITY_DB) {
                    dn2 = FastMath.pow((double)10.0, (double)(srcData1.getElemDoubleAt(srcIdx) / 10.0));
                }
                dn2Sum += dn2;
                ++count;
            }
        }
        if (count > 0) {
            return dn2Sum / (double)count;
        }
        return noDataValue;
    }

    @Override
    public void removeFactorsForCurrentTile(Band targetBand, Tile targetTile, String srcBandName) throws OperatorException {
        Band sourceBand = this.sourceProduct.getBand(targetBand.getName());
        Tile sourceTile = this.calibrationOp.getSourceTile((RasterDataNode)sourceBand, targetTile.getRectangle());
        targetTile.setRawSamples(sourceTile.getRawSamples());
    }
}

