/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s1tbx.calibration.gpf.calibrators;

import com.bc.ceres.core.ProgressMonitor;
import java.awt.Rectangle;
import java.io.File;
import java.util.HashMap;
import org.apache.commons.math3.util.FastMath;
import org.esa.s1tbx.calibration.gpf.support.BaseCalibrator;
import org.esa.s1tbx.calibration.gpf.support.Calibrator;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.MetadataElement;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.gpf.Operator;
import org.esa.snap.core.gpf.OperatorException;
import org.esa.snap.core.gpf.Tile;
import org.esa.snap.engine_utilities.datamodel.AbstractMetadata;
import org.esa.snap.engine_utilities.datamodel.Unit;
import org.esa.snap.engine_utilities.gpf.OperatorUtils;
import org.esa.snap.engine_utilities.gpf.TileIndex;

public class CosmoSkymedCalibrator
extends BaseCalibrator
implements Calibrator {
    private double referenceSlantRange = 0.0;
    private double referenceSlantRangeExp = 0.0;
    private double referenceIncidenceAngle = 0.0;
    private double rescalingFactor = 0.0;
    private final HashMap<String, Double> calibrationFactor = new HashMap(2);
    private boolean applyRangeSpreadingLossCorrection = false;
    private boolean applyIncidenceAngleCorrection = false;
    private boolean applyConstantCorrection = false;

    @Override
    public void setExternalAuxFile(File file) throws OperatorException {
        if (file != null) {
            throw new OperatorException("No external auxiliary file should be selected for Cosmo-Skymed product");
        }
    }

    @Override
    public void setAuxFileFlag(String file) {
    }

    @Override
    public void initialize(Operator op, Product srcProduct, Product tgtProduct, boolean mustPerformRetroCalibration, boolean mustUpdateMetadata) throws OperatorException {
        try {
            this.calibrationOp = op;
            this.sourceProduct = srcProduct;
            this.targetProduct = tgtProduct;
            this.absRoot = AbstractMetadata.getAbstractedMetadata((Product)this.sourceProduct);
            this.origMetadataRoot = AbstractMetadata.getOriginalProductMetadata((Product)this.sourceProduct);
            String mission = this.absRoot.getAttributeString("MISSION");
            if (!mission.startsWith("CSK")) {
                throw new OperatorException(mission + " is not a valid mission for Cosmo-Skymed Calibration");
            }
            String productType = this.absRoot.getAttributeString("PRODUCT_TYPE");
            if (productType.equals("SCS_U")) {
                throw new OperatorException(productType + " calibration is not supported");
            }
            if (this.absRoot.getAttribute("abs_calibration_flag").getData().getElemBoolean()) {
                throw new OperatorException("Absolute radiometric calibration has already been applied to the product");
            }
            this.getCalibrationFlags();
            this.getCalibrationFactors();
            this.getSampleType();
            if (mustUpdateMetadata) {
                this.updateTargetProductMetadata();
            }
        }
        catch (Exception e) {
            throw new OperatorException((Throwable)e);
        }
    }

    private void updateTargetProductMetadata() {
        MetadataElement abs = AbstractMetadata.getAbstractedMetadata((Product)this.targetProduct);
        if (abs != null) {
            abs.getAttribute("abs_calibration_flag").getData().setElemBoolean(true);
        }
    }

    private void getCalibrationFlags() throws Exception {
        MetadataElement globalElem;
        boolean constantCompFlag;
        boolean rangeSpreadCompFlag;
        if (this.absRoot.getAttribute("abs_calibration_flag").getData().getElemBoolean()) {
            throw new OperatorException("The product has already been calibrated");
        }
        boolean incAngleCompFlag = AbstractMetadata.getAttributeBoolean((MetadataElement)this.absRoot, (String)"inc_angle_comp_flag");
        if (incAngleCompFlag) {
            this.applyIncidenceAngleCorrection = true;
        }
        if (rangeSpreadCompFlag = AbstractMetadata.getAttributeBoolean((MetadataElement)this.absRoot, (String)"range_spread_comp_flag")) {
            this.applyRangeSpreadingLossCorrection = true;
        }
        if (!(constantCompFlag = AbstractMetadata.getAttributeBoolean((MetadataElement)(globalElem = this.origMetadataRoot.getElement("Global_Attributes")), (String)"Calibration_Constant_Compensation_Flag"))) {
            this.applyConstantCorrection = true;
        }
    }

    private void getCalibrationFactors() {
        double factor;
        String pol;
        MetadataElement globalElem = this.origMetadataRoot.getElement("Global_Attributes");
        MetadataElement s01Elem = globalElem.getElement("S01");
        if (s01Elem != null) {
            pol = s01Elem.getAttributeString("Polarisation").toUpperCase();
            factor = s01Elem.getAttributeDouble("Calibration_Constant");
            this.calibrationFactor.put(pol, factor);
        } else {
            pol = globalElem.getAttributeString("S01_Polarisation", "").toUpperCase();
            if (!pol.isEmpty()) {
                factor = globalElem.getAttributeDouble("S01_Calibration_Constant");
                this.calibrationFactor.put(pol, factor);
            }
        }
        MetadataElement s02Elem = globalElem.getElement("S02");
        if (s02Elem != null) {
            pol = s02Elem.getAttributeString("Polarisation").toUpperCase();
            factor = s02Elem.getAttributeDouble("Calibration_Constant");
            this.calibrationFactor.put(pol, factor);
        } else {
            pol = globalElem.getAttributeString("S02_Polarisation", "").toUpperCase();
            if (!pol.isEmpty()) {
                factor = globalElem.getAttributeDouble("S02_Calibration_Constant");
                this.calibrationFactor.put(pol, factor);
            }
        }
        this.referenceSlantRange = this.absRoot.getAttributeDouble("ref_slant_range");
        this.referenceSlantRangeExp = this.absRoot.getAttributeDouble("ref_slant_range_exp");
        this.referenceIncidenceAngle = this.absRoot.getAttributeDouble("ref_inc_angle") * Math.PI / 180.0;
        this.rescalingFactor = this.absRoot.getAttributeDouble("rescaling_factor");
    }

    @Override
    public double applyCalibration(double v, double rangeIndex, double azimuthIndex, double slantRange, double satelliteHeight, double sceneToEarthCentre, double localIncidenceAngle, String bandName, String bandPolar, Unit.UnitType bandUnit, int[] subSwathIndex) {
        double sigma;
        double Ks = 1.0;
        if (this.applyConstantCorrection) {
            Ks = this.calibrationFactor.get(bandPolar.toUpperCase());
        }
        if (bandUnit == Unit.UnitType.AMPLITUDE) {
            sigma = v * v;
        } else if (bandUnit == Unit.UnitType.INTENSITY || bandUnit == Unit.UnitType.REAL || bandUnit == Unit.UnitType.IMAGINARY) {
            sigma = v;
        } else if (bandUnit == Unit.UnitType.INTENSITY_DB) {
            sigma = FastMath.pow((double)10.0, (double)(v / 10.0));
        } else {
            throw new OperatorException("Unknown band unit");
        }
        if (this.applyRangeSpreadingLossCorrection) {
            sigma *= FastMath.pow((double)this.referenceSlantRange, (double)(2.0 * this.referenceSlantRangeExp));
        }
        if (this.applyIncidenceAngleCorrection) {
            sigma *= FastMath.sin((double)this.referenceIncidenceAngle);
        }
        sigma /= this.rescalingFactor * this.rescalingFactor * Ks;
        if (this.outputImageScaleInDb) {
            sigma = sigma < 1.0E-30 ? -1.0E-30 : 10.0 * Math.log10(sigma);
        }
        return sigma;
    }

    @Override
    public double applyRetroCalibration(int x, int y, double v, String bandPolar, Unit.UnitType bandUnit, int[] subSwathIndex) {
        return v;
    }

    @Override
    public void computeTile(Band targetBand, Tile targetTile, ProgressMonitor pm) throws OperatorException {
        ProductData srcData1;
        Tile sourceRaster1;
        Band sourceBand1;
        Rectangle targetTileRectangle = targetTile.getRectangle();
        int x0 = targetTileRectangle.x;
        int y0 = targetTileRectangle.y;
        int w = targetTileRectangle.width;
        int h = targetTileRectangle.height;
        ProductData srcData2 = null;
        String[] srcBandNames = (String[])this.targetBandNameToSourceBandName.get(targetBand.getName());
        if (srcBandNames.length == 1) {
            sourceBand1 = this.sourceProduct.getBand(srcBandNames[0]);
            sourceRaster1 = this.calibrationOp.getSourceTile((RasterDataNode)sourceBand1, targetTileRectangle);
            srcData1 = sourceRaster1.getDataBuffer();
        } else {
            sourceBand1 = this.sourceProduct.getBand(srcBandNames[0]);
            Band sourceBand2 = this.sourceProduct.getBand(srcBandNames[1]);
            sourceRaster1 = this.calibrationOp.getSourceTile((RasterDataNode)sourceBand1, targetTileRectangle);
            Tile sourceRaster2 = this.calibrationOp.getSourceTile((RasterDataNode)sourceBand2, targetTileRectangle);
            srcData1 = sourceRaster1.getDataBuffer();
            srcData2 = sourceRaster2.getDataBuffer();
        }
        Unit.UnitType tgtBandUnit = Unit.getUnitType((Band)targetBand);
        Unit.UnitType srcBandUnit = Unit.getUnitType((Band)sourceBand1);
        if (tgtBandUnit == Unit.UnitType.PHASE) {
            targetTile.setRawSamples(sourceRaster1.getRawSamples());
            return;
        }
        String pol = OperatorUtils.getBandPolarization((String)srcBandNames[0], (MetadataElement)this.absRoot).toUpperCase();
        double Ks = 1.0;
        if (pol != null && !pol.isEmpty() && this.applyConstantCorrection) {
            Ks = this.calibrationFactor.get(pol);
        }
        ProductData trgData = targetTile.getDataBuffer();
        TileIndex srcIndex = new TileIndex(sourceRaster1);
        TileIndex tgtIndex = new TileIndex(targetTile);
        int maxY = y0 + h;
        int maxX = x0 + w;
        double phaseTerm = 0.0;
        double powFactor = FastMath.pow((double)this.referenceSlantRange, (double)(2.0 * this.referenceSlantRangeExp));
        double sinRefIncidenceAngle = FastMath.sin((double)this.referenceIncidenceAngle);
        double rescaleCalFactor = this.rescalingFactor * this.rescalingFactor * Ks;
        Double noDataValue = targetBand.getNoDataValue();
        for (int y = y0; y < maxY; ++y) {
            srcIndex.calculateStride(y);
            tgtIndex.calculateStride(y);
            for (int x = x0; x < maxX; ++x) {
                int srcIdx = srcIndex.getIndex(x);
                int tgtIdx = tgtIndex.getIndex(x);
                double dn = srcData1.getElemDoubleAt(srcIdx);
                if (srcBandUnit == Unit.UnitType.AMPLITUDE) {
                    dn *= dn;
                } else if (srcBandUnit != Unit.UnitType.INTENSITY) {
                    if (srcBandUnit == Unit.UnitType.REAL) {
                        double i = dn;
                        double q = srcData2.getElemDoubleAt(srcIdx);
                        if ((dn = i * i + q * q) > 0.0) {
                            if (tgtBandUnit == Unit.UnitType.REAL) {
                                phaseTerm = i / Math.sqrt(dn);
                            } else if (tgtBandUnit == Unit.UnitType.IMAGINARY) {
                                phaseTerm = q / Math.sqrt(dn);
                            }
                        } else {
                            phaseTerm = 0.0;
                        }
                    } else if (srcBandUnit == Unit.UnitType.INTENSITY_DB) {
                        dn = FastMath.pow((double)10.0, (double)(dn / 10.0));
                    } else {
                        throw new OperatorException("CosmoSkymed Calibration: unhandled unit");
                    }
                }
                double calFactor = 1.0;
                if (this.applyRangeSpreadingLossCorrection) {
                    calFactor *= powFactor;
                }
                if (this.applyIncidenceAngleCorrection) {
                    calFactor *= sinRefIncidenceAngle;
                }
                double sigma = dn * (calFactor /= rescaleCalFactor);
                if (this.isComplex && this.outputImageInComplex) {
                    sigma = Math.sqrt(sigma) * phaseTerm;
                }
                if (this.outputImageScaleInDb) {
                    sigma = sigma < 1.0E-30 ? -1.0E-30 : 10.0 * Math.log10(sigma);
                }
                trgData.setElemDoubleAt(tgtIdx, sigma);
            }
        }
    }

    @Override
    public void removeFactorsForCurrentTile(Band targetBand, Tile targetTile, String srcBandName) throws OperatorException {
        Band sourceBand = this.sourceProduct.getBand(targetBand.getName());
        Tile sourceTile = this.calibrationOp.getSourceTile((RasterDataNode)sourceBand, targetTile.getRectangle());
        targetTile.setRawSamples(sourceTile.getRawSamples());
    }
}

