/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s1tbx.calibration.gpf;

import com.bc.ceres.core.ProgressMonitor;
import java.awt.Rectangle;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.esa.s1tbx.calibration.gpf.calibrators.Sentinel1Calibrator;
import org.esa.s1tbx.commons.Sentinel1Utils;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.MetadataAttribute;
import org.esa.snap.core.datamodel.MetadataElement;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.datamodel.VirtualBand;
import org.esa.snap.core.gpf.Operator;
import org.esa.snap.core.gpf.OperatorException;
import org.esa.snap.core.gpf.OperatorSpi;
import org.esa.snap.core.gpf.Tile;
import org.esa.snap.core.gpf.annotations.OperatorMetadata;
import org.esa.snap.core.gpf.annotations.Parameter;
import org.esa.snap.core.gpf.annotations.SourceProduct;
import org.esa.snap.core.gpf.annotations.TargetProduct;
import org.esa.snap.core.util.ProductUtils;
import org.esa.snap.core.util.SystemUtils;
import org.esa.snap.engine_utilities.datamodel.AbstractMetadata;
import org.esa.snap.engine_utilities.datamodel.Unit;
import org.esa.snap.engine_utilities.gpf.InputProductValidator;
import org.esa.snap.engine_utilities.gpf.OperatorUtils;
import org.esa.snap.engine_utilities.gpf.TileIndex;
import org.esa.snap.engine_utilities.util.Maths;

@OperatorMetadata(alias="ThermalNoiseRemoval", category="Radar/Radiometric", authors="Cecilia Wong, Jun Lu, Luis Veci", copyright="Copyright (C) 2014 by Array Systems Computing Inc.", version="1.0", description="Removes thermal noise from products")
public final class Sentinel1RemoveThermalNoiseOp
extends Operator {
    @SourceProduct
    private Product sourceProduct;
    @TargetProduct
    private Product targetProduct;
    @Parameter(description="The list of polarisations", label="Polarisations")
    private String[] selectedPolarisations;
    @Parameter(description="Remove thermal noise", defaultValue="true", label="Remove Thermal Noise")
    private Boolean removeThermalNoise = true;
    @Parameter(description="Re-introduce thermal noise", defaultValue="false", label="Re-Introduce Thermal Noise")
    private Boolean reIntroduceThermalNoise = false;
    private MetadataElement absRoot = null;
    private MetadataElement origMetadataRoot = null;
    private boolean thermalNoiseCorrectionPerformed = false;
    private boolean absoluteCalibrationPerformed = false;
    private boolean isComplex = false;
    private boolean inputSigmaBand = false;
    private boolean inputBetaBand = false;
    private boolean inputGammaBand = false;
    private boolean inputDNBand = false;
    private boolean isTOPSARSLC = false;
    private String productType = null;
    private int numOfSubSwath = 1;
    private ThermalNoiseInfo[] noise = null;
    private Sentinel1Calibrator.CalibrationInfo[] calibration = null;
    private List<String> selectedPolList = null;
    private final HashMap<String, String[]> targetBandNameToSourceBandName = new HashMap(2);
    private double version = 0.0;
    private boolean isTOPS = false;
    private boolean isGRD = false;
    private HashMap<String, Double> t0Map = new HashMap();
    private HashMap<String, Double> deltaTsMap = new HashMap();
    private HashMap<String, NoiseAzimuthBlock[]> noiseAzimuthBlockMap = new HashMap();
    private HashMap<String, double[]> swathStartEndTimesMap = new HashMap();
    private HashMap<String, BurstBlock[]> burstBlockMap = new HashMap();
    public static float trgFloorValue = 0.012345679f;
    private static final String PRODUCT_SUFFIX = "_NR";

    public void initialize() throws OperatorException {
        try {
            InputProductValidator validator = new InputProductValidator(this.sourceProduct);
            validator.checkIfSentinel1Product();
            validator.checkAcquisitionMode(new String[]{"IW", "EW", "SM"});
            validator.checkProductType(new String[]{"SLC", "GRD"});
            this.absRoot = AbstractMetadata.getAbstractedMetadata((Product)this.sourceProduct);
            this.origMetadataRoot = AbstractMetadata.getOriginalProductMetadata((Product)this.sourceProduct);
            this.getIPFVersion();
            this.getProductType();
            this.getAcquisitionMode();
            this.getThermalNoiseCorrectionFlag();
            this.setSelectedPolarisations();
            if (this.version < 2.9 || !this.isTOPS) {
                this.noise = Sentinel1RemoveThermalNoiseOp.getThermalNoiseVectors(this.origMetadataRoot, this.selectedPolList, this.numOfSubSwath);
            }
            this.getSampleType();
            this.getCalibrationFlag();
            if (this.absoluteCalibrationPerformed) {
                this.getCalibrationVectors();
            }
            this.createTargetProduct();
            this.updateTargetProductMetadata();
        }
        catch (Throwable e) {
            OperatorUtils.catchOperatorException((String)this.getId(), (Throwable)e);
        }
    }

    private void getProductType() {
        this.productType = this.absRoot.getAttributeString("PRODUCT_TYPE");
        String mode = this.absRoot.getAttributeString("ACQUISITION_MODE");
        this.isTOPSARSLC = this.productType.contains("SLC") && (mode.contains("IW") || mode.contains("EW"));
        MetadataElement annotationElem = this.origMetadataRoot.getElement("annotation");
        MetadataElement[] annotationDataSetListElem = annotationElem.getElements();
        String imageName = annotationDataSetListElem[0].getName();
        this.isTOPS = mode.contains("IW") || mode.contains("EW");
        this.isGRD = this.productType.contains("GRD");
    }

    private void getAcquisitionMode() {
        String acquisitionMode = this.absRoot.getAttributeString("ACQUISITION_MODE");
        if (this.productType.equals("SLC")) {
            if (acquisitionMode.equals("IW")) {
                this.numOfSubSwath = 3;
            } else if (acquisitionMode.equals("EW")) {
                this.numOfSubSwath = 5;
            }
        }
    }

    private void getThermalNoiseCorrectionFlag() {
        MetadataElement annotationElem = this.origMetadataRoot.getElement("annotation");
        MetadataElement[] annotationDataSetListElem = annotationElem.getElements();
        MetadataElement productElem = annotationDataSetListElem[0].getElement("product");
        MetadataElement imageAnnotationElem = productElem.getElement("imageAnnotation");
        MetadataElement processingInformationElem = imageAnnotationElem.getElement("processingInformation");
        this.thermalNoiseCorrectionPerformed = Boolean.parseBoolean(processingInformationElem.getAttribute("thermalNoiseCorrectionPerformed").getData().getElemString());
        if (this.removeThermalNoise.booleanValue() && this.thermalNoiseCorrectionPerformed) {
            throw new OperatorException("Thermal noise correction has already been performed for the product");
        }
        if (this.reIntroduceThermalNoise.booleanValue() && !this.thermalNoiseCorrectionPerformed) {
            throw new OperatorException("Thermal noise correction has never been performed for the product");
        }
    }

    public static ThermalNoiseInfo[] getThermalNoiseVectors(MetadataElement origMetadataRoot, List<String> selectedPolList, int numOfSubSwath) throws IOException {
        ThermalNoiseInfo[] noise = new ThermalNoiseInfo[numOfSubSwath * selectedPolList.size()];
        if (origMetadataRoot == null) {
            throw new IOException("Unable to find original product metadata");
        }
        MetadataElement noiseElem = origMetadataRoot.getElement("noise");
        if (noiseElem == null) {
            throw new IOException("Unable to find noise element in original product metadata");
        }
        MetadataElement[] noiseDataSetListElem = noiseElem.getElements();
        int dataSetIndex = 0;
        for (MetadataElement dataSetListElem : noiseDataSetListElem) {
            MetadataElement noiElem = dataSetListElem.getElement("noise");
            MetadataElement adsHeaderElem = noiElem.getElement("adsHeader");
            String pol = adsHeaderElem.getAttributeString("polarisation");
            if (!selectedPolList.contains(pol)) continue;
            MetadataElement noiseVectorListElem = noiElem.getElement("noiseVectorList");
            if (noiseVectorListElem == null) {
                noiseVectorListElem = noiElem.getElement("noiseRangeVectorList");
            }
            String subSwath = adsHeaderElem.getAttributeString("swath");
            noise[dataSetIndex] = new ThermalNoiseInfo(pol, subSwath, Sentinel1Utils.getTime((MetadataElement)adsHeaderElem, (String)"startTime").getMJD(), Sentinel1Utils.getTime((MetadataElement)adsHeaderElem, (String)"stopTime").getMJD(), Sentinel1Calibrator.getNumOfLines(origMetadataRoot, pol, subSwath), Integer.parseInt(noiseVectorListElem.getAttributeString("count")), Sentinel1Utils.getNoiseVector((MetadataElement)noiseVectorListElem));
            ++dataSetIndex;
        }
        return noise;
    }

    private void getSampleType() {
        String sampleType = this.absRoot.getAttributeString("SAMPLE_TYPE");
        if (sampleType.equals("COMPLEX")) {
            this.isComplex = true;
        }
    }

    private void getCalibrationFlag() {
        this.absoluteCalibrationPerformed = this.absRoot.getAttribute("abs_calibration_flag").getData().getElemBoolean();
        if (this.absoluteCalibrationPerformed) {
            if (this.isComplex) {
                this.inputSigmaBand = true;
            } else {
                String[] sourceBandNames;
                for (String bandName : sourceBandNames = this.sourceProduct.getBandNames()) {
                    if (bandName.contains("Sigma0")) {
                        this.inputSigmaBand = true;
                        continue;
                    }
                    if (bandName.contains("Gamma0")) {
                        this.inputGammaBand = true;
                        continue;
                    }
                    if (bandName.contains("Beta0")) {
                        this.inputBetaBand = true;
                        continue;
                    }
                    if (!bandName.contains("DN")) continue;
                    this.inputDNBand = true;
                }
                if (!(this.inputSigmaBand || this.inputGammaBand || this.inputBetaBand || this.inputDNBand)) {
                    throw new OperatorException("For calibrated product, Sigma0 or Gamma0 or Beta0 or DN band is expected");
                }
            }
        }
    }

    private void getCalibrationVectors() throws IOException {
        this.calibration = Sentinel1Calibrator.getCalibrationVectors(this.sourceProduct, this.selectedPolList, this.inputSigmaBand, this.inputBetaBand, this.inputGammaBand, this.inputDNBand);
    }

    private void setSelectedPolarisations() {
        String[] selectedPols = this.selectedPolarisations;
        if (selectedPols == null || selectedPols.length == 0) {
            selectedPols = Sentinel1Utils.getProductPolarizations((MetadataElement)this.absRoot);
        }
        this.selectedPolList = Arrays.asList(selectedPols);
    }

    private void createTargetProduct() {
        this.targetProduct = new Product(this.sourceProduct.getName() + PRODUCT_SUFFIX, this.sourceProduct.getProductType(), this.sourceProduct.getSceneRasterWidth(), this.sourceProduct.getSceneRasterHeight());
        this.addSelectedBands();
        ProductUtils.copyProductNodes((Product)this.sourceProduct, (Product)this.targetProduct);
    }

    private void addSelectedBands() {
        Band[] sourceBands = this.sourceProduct.getBands();
        for (int i = 0; i < sourceBands.length; ++i) {
            String targetBandName;
            String[] srcBandNames;
            Band srcBand = sourceBands[i];
            if (srcBand instanceof VirtualBand) continue;
            String unit = srcBand.getUnit();
            if (unit == null) {
                throw new OperatorException("band " + srcBand.getName() + " requires a unit");
            }
            if (!unit.contains("real") && !unit.contains("amplitude") && !unit.contains("intensity")) continue;
            if (unit.contains("real")) {
                if (i + 1 >= sourceBands.length) {
                    throw new OperatorException("Real and imaginary bands are not in pairs");
                }
                String nextUnit = sourceBands[i + 1].getUnit();
                if (nextUnit == null || !nextUnit.contains("imaginary")) {
                    throw new OperatorException("Real and imaginary bands are not in pairs");
                }
                srcBandNames = new String[]{srcBand.getName(), sourceBands[i + 1].getName()};
                ++i;
            } else {
                srcBandNames = new String[]{srcBand.getName()};
            }
            String pol = srcBandNames[0].substring(srcBandNames[0].lastIndexOf("_") + 1);
            if (!this.selectedPolList.contains(pol) || this.targetProduct.getBand(targetBandName = this.createTargetBandName(srcBandNames[0])) != null) continue;
            this.targetBandNameToSourceBandName.put(targetBandName, srcBandNames);
            Band targetBand = new Band(targetBandName, 30, srcBand.getRasterWidth(), srcBand.getRasterHeight());
            targetBand.setUnit("intensity");
            targetBand.setDescription(srcBand.getDescription());
            targetBand.setNoDataValue(srcBand.getNoDataValue());
            targetBand.setNoDataValueUsed(true);
            this.targetProduct.addBand(targetBand);
        }
    }

    private String createTargetBandName(String sourceBandName) {
        String pol = sourceBandName.substring(sourceBandName.indexOf(95));
        if (this.absoluteCalibrationPerformed) {
            if (this.isComplex) {
                return "Sigma0" + pol;
            }
            return sourceBandName;
        }
        return "Intensity" + pol;
    }

    private void updateTargetProductMetadata() {
        MetadataElement[] annotationDataSetListElem;
        MetadataElement abs = AbstractMetadata.getAbstractedMetadata((Product)this.targetProduct);
        String[] targetBandNames = this.targetProduct.getBandNames();
        Sentinel1Utils.updateBandNames((MetadataElement)abs, this.selectedPolList, (String[])targetBandNames);
        MetadataElement origMetadataRoot = AbstractMetadata.getOriginalProductMetadata((Product)this.targetProduct);
        MetadataElement annotationElem = origMetadataRoot.getElement("annotation");
        for (MetadataElement elem : annotationDataSetListElem = annotationElem.getElements()) {
            MetadataElement productElem = elem.getElement("product");
            MetadataElement imageAnnotationElem = productElem.getElement("imageAnnotation");
            MetadataElement processingInformationElem = imageAnnotationElem.getElement("processingInformation");
            if (this.removeThermalNoise.booleanValue()) {
                processingInformationElem.getAttribute("thermalNoiseCorrectionPerformed").getData().setElems((Object)"true");
            }
            if (!this.reIntroduceThermalNoise.booleanValue()) continue;
            processingInformationElem.getAttribute("thermalNoiseCorrectionPerformed").getData().setElems((Object)"false");
        }
    }

    private double[][] populateNoiseAzimuthBlock(int x0, int y0, int w, int h, String targetBandName) {
        if (this.version >= 2.9) {
            if (this.isTOPS && this.isGRD) {
                return this.buildNoiseLUTForTOPSGRD(x0, y0, w, h, targetBandName);
            }
            if (this.isTOPSARSLC) {
                return this.buildNoiseLUTForTOPSSLC(x0, y0, w, h, targetBandName);
            }
        }
        return null;
    }

    public void computeTile(Band targetBand, Tile targetTile, ProgressMonitor pm) throws OperatorException {
        Rectangle targetTileRectangle = targetTile.getRectangle();
        int x0 = targetTileRectangle.x;
        int y0 = targetTileRectangle.y;
        int w = targetTileRectangle.width;
        int h = targetTileRectangle.height;
        try {
            String targetBandName = targetBand.getName();
            double[][] noiseBlock = null;
            if (this.version >= 2.9) {
                noiseBlock = this.populateNoiseAzimuthBlock(x0, y0, w, h, targetBandName);
            }
            Tile sourceRaster1 = null;
            ProductData srcData1 = null;
            ProductData srcData2 = null;
            Band sourceBand1 = null;
            String[] srcBandNames = this.targetBandNameToSourceBandName.get(targetBandName);
            if (srcBandNames.length == 1) {
                sourceBand1 = this.sourceProduct.getBand(srcBandNames[0]);
                sourceRaster1 = this.getSourceTile((RasterDataNode)sourceBand1, targetTileRectangle);
                srcData1 = sourceRaster1.getDataBuffer();
            } else {
                sourceBand1 = this.sourceProduct.getBand(srcBandNames[0]);
                Band sourceBand2 = this.sourceProduct.getBand(srcBandNames[1]);
                sourceRaster1 = this.getSourceTile((RasterDataNode)sourceBand1, targetTileRectangle);
                Tile sourceRaster2 = this.getSourceTile((RasterDataNode)sourceBand2, targetTileRectangle);
                srcData1 = sourceRaster1.getDataBuffer();
                srcData2 = sourceRaster2.getDataBuffer();
            }
            double srcNoDataValue = sourceBand1.getNoDataValue();
            Unit.UnitType bandUnit = Unit.getUnitType((Band)sourceBand1);
            ProductData trgData = targetTile.getDataBuffer();
            TileIndex srcIndex = new TileIndex(sourceRaster1);
            TileIndex tgtIndex = new TileIndex(targetTile);
            int maxY = y0 + h;
            int maxX = x0 + w;
            boolean complexData = bandUnit == Unit.UnitType.REAL || bandUnit == Unit.UnitType.IMAGINARY;
            String key = "";
            if (this.version >= 2.9 && this.isTOPS) {
                key = complexData ? targetBandName.substring(10).toLowerCase() : this.getBandPol(targetBandName);
            }
            Sentinel1Calibrator.CalibrationInfo calInfo = null;
            Sentinel1Calibrator.CALTYPE calType = null;
            if (this.absoluteCalibrationPerformed) {
                calInfo = this.getCalInfo(targetBandName);
                calType = Sentinel1Calibrator.getCalibrationType(targetBandName);
            }
            for (int y = y0; y < maxY; ++y) {
                srcIndex.calculateStride(y);
                tgtIndex.calculateStride(y);
                double[] lut = new double[w];
                if (this.absoluteCalibrationPerformed) {
                    int calVecIdx = calInfo.getCalibrationVectorIndex(y);
                    Sentinel1Utils.CalibrationVector vec0 = calInfo.getCalibrationVector(calVecIdx);
                    Sentinel1Utils.CalibrationVector vec1 = calInfo.getCalibrationVector(calVecIdx + 1);
                    float[] vec0LUT = Sentinel1Calibrator.getVector(calType, vec0);
                    float[] vec1LUT = Sentinel1Calibrator.getVector(calType, vec1);
                    Sentinel1Utils.CalibrationVector calVec = calInfo.calibrationVectorList[calVecIdx];
                    int pixelIdx0 = calVec.getPixelIndex(x0);
                    if (this.version < 2.9) {
                        ThermalNoiseInfo noiseInfo = this.getNoiseInfo(targetBandName);
                        this.computeTileScaledNoiseLUT(y, x0, w, noiseInfo, calInfo, vec0.timeMJD, vec1.timeMJD, vec0LUT, vec1LUT, vec0.pixels, pixelIdx0, lut);
                    } else {
                        this.computeTileScaledNoiseLUT(y, x0, y0, w, noiseBlock, calInfo, vec0.timeMJD, vec1.timeMJD, vec0LUT, vec1LUT, vec0.pixels, pixelIdx0, lut);
                    }
                } else if (this.version < 2.9) {
                    ThermalNoiseInfo noiseInfo = this.getNoiseInfo(targetBandName);
                    Sentinel1RemoveThermalNoiseOp.computeTileNoiseLUT(y, x0, w, noiseInfo, lut);
                } else {
                    Sentinel1RemoveThermalNoiseOp.computeTileNoiseLUT(y - y0, x0, w, noiseBlock, lut);
                }
                for (int x = x0; x < maxX; ++x) {
                    double dn2;
                    int xx = x - x0;
                    int srcIdx = srcIndex.getIndex(x);
                    int tgtIdx = tgtIndex.getIndex(x);
                    if (bandUnit == Unit.UnitType.AMPLITUDE) {
                        double dn = srcData1.getElemDoubleAt(srcIdx);
                        dn2 = dn * dn;
                    } else if (complexData) {
                        double i = srcData1.getElemDoubleAt(srcIdx);
                        double q = srcData2.getElemDoubleAt(srcIdx);
                        dn2 = i * i + q * q;
                    } else if (bandUnit == Unit.UnitType.INTENSITY) {
                        dn2 = srcData1.getElemDoubleAt(srcIdx);
                    } else {
                        throw new OperatorException("Unhandled unit");
                    }
                    if (dn2 == srcNoDataValue) {
                        trgData.setElemDoubleAt(tgtIdx, srcNoDataValue);
                        continue;
                    }
                    double value = dn2 - lut[xx];
                    if (value < 0.0) {
                        value = dn2 == 0.0 ? (double)trgFloorValue : dn2;
                    }
                    trgData.setElemDoubleAt(tgtIdx, value);
                }
            }
        }
        catch (Throwable e) {
            throw new OperatorException(e.getMessage());
        }
    }

    private ThermalNoiseInfo getNoiseInfo(String targetBandName) throws OperatorException {
        for (ThermalNoiseInfo noiseInfo : this.noise) {
            if (!(this.isTOPSARSLC ? targetBandName.contains(noiseInfo.polarization) && targetBandName.contains(noiseInfo.subSwath) : targetBandName.contains(noiseInfo.polarization))) continue;
            return noiseInfo;
        }
        throw new OperatorException("NoiseInfo not found for " + targetBandName);
    }

    private Sentinel1Calibrator.CalibrationInfo getCalInfo(String targetBandName) {
        for (Sentinel1Calibrator.CalibrationInfo cal : this.calibration) {
            String pol = cal.polarization;
            String ss = cal.subSwath;
            if (!(this.isTOPSARSLC ? targetBandName.contains(pol) && targetBandName.contains(ss) : targetBandName.contains(pol))) continue;
            return cal;
        }
        return null;
    }

    private void computeTileScaledNoiseLUT(int y, int x0, int w, ThermalNoiseInfo noiseInfo, Sentinel1Calibrator.CalibrationInfo calInfo, double azT0, double azT1, float[] vec0LUT, float[] vec1LUT, int[] vec0Pixels, int pixelIdx0, double[] lut) {
        double[] noiseLut = new double[w];
        Sentinel1RemoveThermalNoiseOp.computeTileNoiseLUT(y, x0, w, noiseInfo, noiseLut);
        double[] calLut = new double[w];
        Sentinel1RemoveThermalNoiseOp.computeTileCalibrationLUTs(y, x0, w, calInfo, azT0, azT1, vec0LUT, vec1LUT, vec0Pixels, pixelIdx0, calLut);
        if (this.removeThermalNoise.booleanValue()) {
            for (int i = 0; i < w; ++i) {
                lut[i] = noiseLut[i] / (calLut[i] * calLut[i]);
            }
        } else {
            for (int i = 0; i < w; ++i) {
                lut[i] = -noiseLut[i] / (calLut[i] * calLut[i]);
            }
        }
    }

    private void computeTileScaledNoiseLUT(int y, int x0, int y0, int w, double[][] noiseBlock, Sentinel1Calibrator.CalibrationInfo calInfo, double azT0, double azT1, float[] vec0LUT, float[] vec1LUT, int[] vec0Pixels, int pixelIdx0, double[] lut) {
        double[] calLut = new double[w];
        Sentinel1RemoveThermalNoiseOp.computeTileCalibrationLUTs(y, x0, w, calInfo, azT0, azT1, vec0LUT, vec1LUT, vec0Pixels, pixelIdx0, calLut);
        int yy = y - y0;
        if (this.removeThermalNoise.booleanValue()) {
            for (int i = 0; i < w; ++i) {
                lut[i] = noiseBlock[yy][i] / (calLut[i] * calLut[i]);
            }
        } else {
            for (int i = 0; i < w; ++i) {
                lut[i] = -noiseBlock[yy][i] / (calLut[i] * calLut[i]);
            }
        }
    }

    public static void computeTileCalibrationLUTs(int y, int x0, int w, Sentinel1Calibrator.CalibrationInfo calInfo, double azT0, double azT1, float[] vec0LUT, float[] vec1LUT, int[] vec0Pixels, int pixelIdx0, double[] lut) {
        double azTime = calInfo.firstLineTime + (double)y * calInfo.lineTimeInterval;
        double muY = (azTime - azT0) / (azT1 - azT0);
        int pixelIdx = pixelIdx0;
        int maxX = x0 + w;
        for (int x = x0; x < maxX; ++x) {
            if (x > vec0Pixels[pixelIdx + 1]) {
                ++pixelIdx;
            }
            double muX = (double)(x - vec0Pixels[pixelIdx]) / (double)(vec0Pixels[pixelIdx + 1] - vec0Pixels[pixelIdx]);
            lut[x - x0] = Maths.interpolationBiLinear((double)vec0LUT[pixelIdx], (double)vec0LUT[pixelIdx + 1], (double)vec1LUT[pixelIdx], (double)vec1LUT[pixelIdx + 1], (double)muX, (double)muY);
        }
    }

    private static void computeTileNoiseLUT(int y, int x0, int w, ThermalNoiseInfo noiseInfo, double[] lut) {
        try {
            int noiseVecIdx = Sentinel1RemoveThermalNoiseOp.getNoiseVectorIndex(y, noiseInfo);
            Sentinel1Utils.NoiseVector noiseVector0 = noiseInfo.noiseVectorList[noiseVecIdx];
            Sentinel1Utils.NoiseVector noiseVector1 = noiseInfo.noiseVectorList[noiseVecIdx + 1];
            double azTime = noiseInfo.firstLineTime + (double)y * noiseInfo.lineTimeInterval;
            double azT0 = noiseVector0.timeMJD;
            double azT1 = noiseVector1.timeMJD;
            double muY = (azTime - azT0) / (azT1 - azT0);
            int pixelIdx0 = Sentinel1RemoveThermalNoiseOp.getPixelIndex(x0, noiseVector0);
            int pixelIdx1 = Sentinel1RemoveThermalNoiseOp.getPixelIndex(x0, noiseVector1);
            int maxLength0 = noiseVector0.pixels.length - 2;
            int maxLength1 = noiseVector1.pixels.length - 2;
            int maxX = x0 + w;
            for (int x = x0; x < maxX; ++x) {
                if (x > noiseVector0.pixels[pixelIdx0 + 1] && pixelIdx0 < maxLength0) {
                    ++pixelIdx0;
                }
                int x00 = noiseVector0.pixels[pixelIdx0];
                int x01 = noiseVector0.pixels[pixelIdx0 + 1];
                double muX0 = (double)(x - x00) / (double)(x01 - x00);
                double noise0 = Maths.interpolationLinear((double)noiseVector0.noiseLUT[pixelIdx0], (double)noiseVector0.noiseLUT[pixelIdx0 + 1], (double)muX0);
                if (x > noiseVector1.pixels[pixelIdx1 + 1] && pixelIdx1 < maxLength1) {
                    ++pixelIdx1;
                }
                int x10 = noiseVector1.pixels[pixelIdx1];
                int x11 = noiseVector1.pixels[pixelIdx1 + 1];
                double muX1 = (double)(x - x10) / (double)(x11 - x10);
                double noise1 = Maths.interpolationLinear((double)noiseVector1.noiseLUT[pixelIdx1], (double)noiseVector1.noiseLUT[pixelIdx1 + 1], (double)muX1);
                lut[x - x0] = Maths.interpolationLinear((double)noise0, (double)noise1, (double)muY);
            }
        }
        catch (Throwable e) {
            OperatorUtils.catchOperatorException((String)"computeTileNoiseLUT", (Throwable)e);
        }
    }

    private static void computeTileNoiseLUT(int yy, int x0, int w, double[][] noiseBlock, double[] lut) {
        try {
            int maxX = x0 + w;
            for (int x = x0; x < maxX; ++x) {
                int xx = x - x0;
                lut[xx] = noiseBlock[yy][xx];
            }
        }
        catch (Throwable e) {
            OperatorUtils.catchOperatorException((String)"computeTileNoiseLUT", (Throwable)e);
        }
    }

    private static int getNoiseVectorIndex(int y, ThermalNoiseInfo noiseInfo) {
        for (int i = 1; i < noiseInfo.count; ++i) {
            if (y >= noiseInfo.noiseVectorList[i].line) continue;
            return i - 1;
        }
        return noiseInfo.count - 2;
    }

    private static int getPixelIndex(int x, Sentinel1Utils.NoiseVector noiseVector) {
        for (int i = 0; i < noiseVector.pixels.length; ++i) {
            if (x >= noiseVector.pixels[i]) continue;
            return i - 1;
        }
        return noiseVector.pixels.length - 2;
    }

    private void getIPFVersion() {
        String procSysId = this.absRoot.getAttributeString("Processing_system_identifier");
        this.version = Double.valueOf(procSysId.substring(procSysId.lastIndexOf(" ")));
    }

    private double[][] buildNoiseLUTForTOPSSLC(int x0, int y0, int w, int h, String targetBandName) {
        String targetBandPol = this.getBandPol(targetBandName).toLowerCase();
        String targetBandSwath = this.getBandSwath(targetBandName).toLowerCase();
        MetadataElement noiseElem = this.origMetadataRoot.getElement("noise");
        MetadataElement[] noiseDataSetListElem = noiseElem.getElements();
        Sentinel1Utils.NoiseAzimuthVector[] noiseAzimuthVectors = null;
        Sentinel1Utils.NoiseVector[] noiseRangeVectors = null;
        for (MetadataElement dataSetListElem : noiseDataSetListElem) {
            MetadataElement[] imageName = dataSetListElem.getName();
            if (!imageName.toLowerCase().contains(targetBandPol) || !imageName.toLowerCase().contains(targetBandSwath)) continue;
            this.getT0andDeltaTS((String)imageName);
            MetadataElement noiElem = dataSetListElem.getElement("noise");
            MetadataElement noiseAzimuthVectorListElem = noiElem.getElement("noiseAzimuthVectorList");
            noiseAzimuthVectors = Sentinel1Utils.getAzimuthNoiseVector((MetadataElement)noiseAzimuthVectorListElem);
            MetadataElement noiseRangeVectorListElem = noiElem.getElement("noiseRangeVectorList");
            noiseRangeVectors = Sentinel1Utils.getNoiseVector((MetadataElement)noiseRangeVectorListElem);
        }
        MetadataElement annotationElem = this.origMetadataRoot.getElement("annotation");
        MetadataElement[] annotationDataSetListElem = annotationElem.getElements();
        HashMap<String, Sentinel1Utils.NoiseVector> burstToRangeVectorMap = new HashMap<String, Sentinel1Utils.NoiseVector>();
        int linesPerBurst = 0;
        for (MetadataElement elem : annotationDataSetListElem) {
            String imageName = elem.getName();
            if (!imageName.toLowerCase().contains(targetBandPol) || !imageName.toLowerCase().contains(targetBandSwath)) continue;
            MetadataElement productElem = elem.getElement("product");
            MetadataElement swathTimingElem = productElem.getElement("swathTiming");
            linesPerBurst = swathTimingElem.getAttributeInt("linesPerBurst");
            MetadataElement burstListElem = swathTimingElem.getElement("burstList");
            MetadataElement[] burstListArray = burstListElem.getElements();
            for (int i = 0; i < burstListArray.length; ++i) {
                int burstCenterLine = i * linesPerBurst + linesPerBurst / 2;
                burstToRangeVectorMap.put("burst_" + i, this.getBurstRangeVector(burstCenterLine, noiseRangeVectors));
            }
        }
        double[][] noiseMatrix = new double[h][w];
        this.populateNoiseMatrixForTOPSSLC(noiseAzimuthVectors[0], burstToRangeVectorMap, linesPerBurst, x0, y0, w, h, noiseMatrix);
        return noiseMatrix;
    }

    private Sentinel1Utils.NoiseVector getBurstRangeVector(int burstCenterLine, Sentinel1Utils.NoiseVector[] noiseRangeVectors) {
        int closest = 0;
        for (int j = 1; j < noiseRangeVectors.length; ++j) {
            if (Math.abs(burstCenterLine - noiseRangeVectors[j].line) >= Math.abs(burstCenterLine - noiseRangeVectors[closest].line)) continue;
            closest = j;
        }
        return noiseRangeVectors[closest];
    }

    private void populateNoiseMatrixForTOPSSLC(Sentinel1Utils.NoiseAzimuthVector noiseAzimuthVector, HashMap<String, Sentinel1Utils.NoiseVector> burstToRangeVectorMap, int linesPerBurst, int x0, int y0, int w, int h, double[][] noiseMatrix) {
        int xMax = x0 + w - 1;
        int yMax = y0 + h - 1;
        double[] interpolatedAzimuthVector = new double[h];
        this.interpolNoiseAzimuthVector(noiseAzimuthVector, y0, yMax, interpolatedAzimuthVector);
        int currentNoiseVectorLine = Integer.MAX_VALUE;
        double[] interpolatedRangeVector = new double[w];
        for (int y = y0; y <= yMax; ++y) {
            int yy = y - y0;
            int burstIdx = y / linesPerBurst;
            Sentinel1Utils.NoiseVector noiseRangeVector = burstToRangeVectorMap.get("burst_" + burstIdx);
            if (noiseRangeVector.line != currentNoiseVectorLine) {
                currentNoiseVectorLine = noiseRangeVector.line;
                this.interpolNoiseRangeVector(noiseRangeVector, x0, xMax, interpolatedRangeVector);
            }
            for (int x = x0; x <= xMax; ++x) {
                int xx = x - x0;
                noiseMatrix[yy][xx] = interpolatedAzimuthVector[yy] * interpolatedRangeVector[xx];
            }
        }
    }

    private double[][] buildNoiseLUTForTOPSGRD(int x0, int y0, int w, int h, String targetBandName) {
        MetadataElement[] noiseDataSetListElem;
        int xMax = x0 + w - 1;
        int yMax = y0 + h - 1;
        String targetBandPol = this.getBandPol(targetBandName);
        MetadataElement noiseElem = this.origMetadataRoot.getElement("noise");
        for (MetadataElement dataSetListElem : noiseDataSetListElem = noiseElem.getElements()) {
            MetadataElement noiElem = dataSetListElem.getElement("noise");
            MetadataElement adsHeaderElem = noiElem.getElement("adsHeader");
            String pol = adsHeaderElem.getAttributeString("polarisation");
            if (!pol.equals(targetBandPol)) continue;
            String imageName = dataSetListElem.getName();
            MetadataElement noiseAzimuthVectorListElem = noiElem.getElement("noiseAzimuthVectorList");
            MetadataElement firstVector = noiseAzimuthVectorListElem.getElementAt(0);
            if (firstVector.getAttributeString("slice", null) != null) {
                throw new OperatorException("Noise removal should be applied prior to slice assembly");
            }
            Sentinel1Utils.NoiseAzimuthVector[] noiseAzimuthVectors = Sentinel1Utils.getAzimuthNoiseVector((MetadataElement)noiseAzimuthVectorListElem);
            MetadataElement noiseRangeVectorListElem = noiElem.getElement("noiseRangeVectorList");
            Sentinel1Utils.NoiseVector[] noiseRangeVectors = Sentinel1Utils.getNoiseVector((MetadataElement)noiseRangeVectorListElem);
            double[][] noiseMatrix = new double[h][w];
            for (Sentinel1Utils.NoiseAzimuthVector noiseAzimuthVector : noiseAzimuthVectors) {
                int nx0 = Math.max(x0, noiseAzimuthVector.firstRangeSample);
                int nxMax = Math.min(xMax, noiseAzimuthVector.lastRangeSample);
                int ny0 = Math.max(y0, noiseAzimuthVector.firstAzimuthLine);
                int nyMax = Math.min(yMax, noiseAzimuthVector.lastAzimuthLine);
                if (nx0 >= nxMax || ny0 >= nyMax) continue;
                this.populateNoiseMatrixForTOPSGRD(pol, imageName, noiseAzimuthVector, noiseRangeVectors, x0, y0, nx0, nxMax, ny0, nyMax, noiseMatrix);
            }
            return noiseMatrix;
        }
        return null;
    }

    private void populateNoiseMatrixForTOPSGRD(String pol, String imageName, Sentinel1Utils.NoiseAzimuthVector noiseAzimuthVector, Sentinel1Utils.NoiseVector[] noiseRangeVectors, int x0, int y0, int nx0, int nxMax, int ny0, int nyMax, double[][] noiseMatrix) {
        this.getT0andDeltaTS(imageName);
        double firstLineTime = this.t0Map.get(imageName);
        double lineTimeInterval = this.deltaTsMap.get(imageName);
        double startAzimTime = firstLineTime + (double)noiseAzimuthVector.firstAzimuthLine * lineTimeInterval;
        double endAzimTime = firstLineTime + (double)noiseAzimuthVector.lastAzimuthLine * lineTimeInterval;
        String swath = noiseAzimuthVector.swath;
        int[] noiseRangeVecIndices = this.getNoiseRangeVectorIndices(pol, swath, startAzimTime, endAzimTime, noiseRangeVectors, noiseAzimuthVector.firstAzimuthLine, noiseAzimuthVector.lastAzimuthLine);
        if (noiseRangeVecIndices != null && noiseRangeVecIndices.length > 0) {
            double[][] interpolatedRangeVectors = new double[noiseRangeVecIndices.length][nxMax - nx0 + 1];
            int[] noiseRangeVectorLine = new int[noiseRangeVecIndices.length];
            for (int j = 0; j < noiseRangeVecIndices.length; ++j) {
                noiseRangeVectorLine[j] = noiseRangeVectors[noiseRangeVecIndices[j]].line;
                this.interpolNoiseRangeVector(noiseRangeVectors[noiseRangeVecIndices[j]], nx0, nxMax, interpolatedRangeVectors[j]);
            }
            double[] interpolatedAzimuthVector = new double[nyMax - ny0 + 1];
            this.interpolNoiseAzimuthVector(noiseAzimuthVector, ny0, nyMax, interpolatedAzimuthVector);
            this.computeNoiseMatrix(x0, y0, nx0, nxMax, ny0, nyMax, noiseRangeVectorLine, interpolatedRangeVectors, interpolatedAzimuthVector, noiseMatrix);
        } else {
            for (int y = ny0; y <= nyMax; ++y) {
                for (int x = nx0; x <= nxMax; ++x) {
                    noiseMatrix[y - y0][x - x0] = 1.0;
                }
            }
        }
    }

    private void interpolNoiseRangeVector(Sentinel1Utils.NoiseVector noiseRangeVector, int firstRangeSample, int lastRangeSample, double[] result) {
        if (noiseRangeVector.pixels.length < 2) {
            SystemUtils.LOG.warning("######### noise range vector has length 1");
            for (int sample = 0; sample < result.length; ++sample) {
                result[sample] = noiseRangeVector.pixels[0];
            }
        } else {
            int i = 0;
            int sampleIdx = Sentinel1RemoveThermalNoiseOp.getSampleIndex(firstRangeSample, noiseRangeVector);
            for (int sample = firstRangeSample; sample <= lastRangeSample; ++sample) {
                if (sample > noiseRangeVector.pixels[sampleIdx + 1] && sampleIdx < noiseRangeVector.pixels.length - 2) {
                    ++sampleIdx;
                }
                result[i++] = Sentinel1RemoveThermalNoiseOp.interpol(noiseRangeVector.pixels[sampleIdx], noiseRangeVector.pixels[sampleIdx + 1], noiseRangeVector.noiseLUT[sampleIdx], noiseRangeVector.noiseLUT[sampleIdx + 1], sample);
            }
        }
    }

    private void interpolNoiseAzimuthVector(Sentinel1Utils.NoiseAzimuthVector noiseAzimuthVector, int firstAzimuthLine, int lastAzimuthLine, double[] interpNoiseAzimVec) {
        if (noiseAzimuthVector.lines.length < 2) {
            for (int line = firstAzimuthLine; line <= lastAzimuthLine; ++line) {
                interpNoiseAzimVec[line - firstAzimuthLine] = noiseAzimuthVector.noiseAzimuthLUT[0];
            }
        } else {
            int lineIdx = Sentinel1RemoveThermalNoiseOp.getLineIndex(firstAzimuthLine, noiseAzimuthVector.lines);
            for (int line = firstAzimuthLine; line <= lastAzimuthLine; ++line) {
                if (line > noiseAzimuthVector.lines[lineIdx + 1] && lineIdx < noiseAzimuthVector.lines.length - 2) {
                    ++lineIdx;
                }
                interpNoiseAzimVec[line - firstAzimuthLine] = Sentinel1RemoveThermalNoiseOp.interpol(noiseAzimuthVector.lines[lineIdx], noiseAzimuthVector.lines[lineIdx + 1], noiseAzimuthVector.noiseAzimuthLUT[lineIdx], noiseAzimuthVector.noiseAzimuthLUT[lineIdx + 1], line);
            }
        }
    }

    private void computeNoiseMatrix(int x0, int y0, int nx0, int nxMax, int ny0, int nyMax, int[] noiseRangeVectorLine, double[][] interpolatedRangeVectors, double[] interpolatedAzimuthVector, double[][] noiseMatrix) {
        if (noiseRangeVectorLine.length == 1) {
            for (int x = nx0; x <= nxMax; ++x) {
                int xx = x - nx0;
                for (int y = ny0; y <= nyMax; ++y) {
                    noiseMatrix[y - y0][x - x0] = interpolatedAzimuthVector[y - ny0] * interpolatedRangeVectors[0][xx];
                }
            }
        } else {
            int line0Idx = Sentinel1RemoveThermalNoiseOp.getLineIndex(ny0, noiseRangeVectorLine);
            for (int x = nx0; x <= nxMax; ++x) {
                int xx = x - nx0;
                int lineIdx = line0Idx;
                for (int y = ny0; y <= nyMax; ++y) {
                    if (y > noiseRangeVectorLine[lineIdx + 1] && lineIdx < noiseRangeVectorLine.length - 2) {
                        ++lineIdx;
                    }
                    noiseMatrix[y - y0][x - x0] = interpolatedAzimuthVector[y - ny0] * Sentinel1RemoveThermalNoiseOp.interpol(noiseRangeVectorLine[lineIdx], noiseRangeVectorLine[lineIdx + 1], interpolatedRangeVectors[lineIdx][xx], interpolatedRangeVectors[lineIdx + 1][xx], y);
                }
            }
        }
    }

    private static double interpol(int x1, int x2, double y1, double y2, int x) {
        if (x1 == x2) {
            SystemUtils.LOG.warning("######### noise vector duplicate indices: x1 == x2  = " + x1);
            return 0.0;
        }
        return y1 + (double)(x - x1) / (double)(x2 - x1) * (y2 - y1);
    }

    private int[] getNoiseRangeVectorIndices(String pol, String swath, double startAzimTime, double endAzimTime, Sentinel1Utils.NoiseVector[] noiseRangeVectors, int startAzimLine, int endAzimLine) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (int i = 0; i < noiseRangeVectors.length; ++i) {
            double azimTime = noiseRangeVectors[i].timeMJD;
            if (!(azimTime >= startAzimTime) || !(azimTime <= endAzimTime)) continue;
            list.add(i);
        }
        if (list.size() == 0) {
            int idx = -1;
            double[] startEndTimes = new double[2];
            this.getSwathStartEndTimes(pol, swath, startEndTimes);
            double blockCentreTime = (startAzimTime + endAzimTime) / 2.0;
            for (int i = 0; i < noiseRangeVectors.length; ++i) {
                double azimTime = noiseRangeVectors[i].timeMJD;
                if (!(azimTime >= startEndTimes[0]) || !(azimTime <= startEndTimes[1])) continue;
                if (idx < 0) {
                    idx = i;
                    continue;
                }
                if (!(Math.abs(blockCentreTime - noiseRangeVectors[i].timeMJD) < Math.abs(blockCentreTime - noiseRangeVectors[idx].timeMJD))) continue;
                idx = i;
            }
            if (idx < 0) {
                SystemUtils.LOG.warning("######### No valid range vector found for startAzimTime = " + startAzimTime + " endAzimTime = " + endAzimTime + " swath = " + swath);
                return null;
            }
            list.add(idx);
        }
        int[] indices = new int[list.size()];
        for (int i = 0; i < indices.length; ++i) {
            indices[i] = (Integer)list.get(i);
        }
        return indices;
    }

    private void getSwathStartEndTimes(String pol, String swath, double[] startEndtimes) {
        MetadataElement[] annotationDataSetListElem;
        String key = pol + "+" + swath;
        startEndtimes[0] = 0.0;
        startEndtimes[1] = 0.0;
        if (this.swathStartEndTimesMap.containsKey(key)) {
            double[] times = this.swathStartEndTimesMap.get(key);
            startEndtimes[0] = times[0];
            startEndtimes[1] = times[1];
            return;
        }
        MetadataElement annotationElem = this.origMetadataRoot.getElement("annotation");
        for (MetadataElement elem : annotationDataSetListElem = annotationElem.getElements()) {
            MetadataElement[] swathMergeArray;
            String imageName = elem.getName();
            if (!imageName.toLowerCase().contains(pol.toLowerCase())) continue;
            MetadataElement productElem = elem.getElement("product");
            MetadataElement swathMergingElem = productElem.getElement("swathMerging");
            MetadataElement swathMergeListElem = swathMergingElem.getElement("swathMergeList");
            for (MetadataElement aSwathMergeArray : swathMergeArray = swathMergeListElem.getElements()) {
                String curSwath = aSwathMergeArray.getAttributeString("swath");
                if (!curSwath.equals(swath)) continue;
                MetadataElement swathBoundsListElem = aSwathMergeArray.getElement("swathBoundsList");
                MetadataElement[] swathBoundList = swathBoundsListElem.getElements();
                int startLine = swathBoundList[0].getAttributeInt("firstAzimuthLine");
                int lastIdx = swathBoundList.length - 1;
                int endLine = swathBoundList[lastIdx].getAttributeInt("lastAzimuthLine");
                if (this.t0Map.containsKey(imageName) && this.deltaTsMap.containsKey(imageName)) {
                    double t0 = this.t0Map.get(imageName);
                    double deltaTs = this.deltaTsMap.get(imageName);
                    startEndtimes[0] = t0 + (double)startLine * deltaTs;
                    startEndtimes[1] = t0 + (double)endLine * deltaTs;
                    this.swathStartEndTimesMap.put(key, startEndtimes);
                } else {
                    SystemUtils.LOG.warning("######### fail to find swath start and end times for " + pol + " " + swath);
                }
                return;
            }
        }
    }

    private static int getLineIndex(int line, int[] lines) {
        for (int i = 0; i < lines.length; ++i) {
            if (line >= lines[i]) continue;
            return i > 0 ? i - 1 : 0;
        }
        return lines.length - 2;
    }

    private static int getSampleIndex(int sample, Sentinel1Utils.NoiseVector noiseRangeVector) {
        for (int i = 0; i < noiseRangeVector.pixels.length; ++i) {
            if (sample >= noiseRangeVector.pixels[i]) continue;
            return i > 0 ? i - 1 : 0;
        }
        return noiseRangeVector.pixels.length - 2;
    }

    private void getT0andDeltaTS(String imageName) {
        MetadataElement[] annotationDataSetListElem;
        MetadataElement annotationElem = this.origMetadataRoot.getElement("annotation");
        for (MetadataElement dataSetListElem : annotationDataSetListElem = annotationElem.getElements()) {
            if (!dataSetListElem.getName().equals(imageName)) continue;
            MetadataElement productElem = dataSetListElem.getElement("product");
            MetadataElement imageAnnotationElem = productElem.getElement("imageAnnotation");
            MetadataElement imageInformationElem = imageAnnotationElem.getElement("imageInformation");
            double t01 = this.absRoot.getAttributeUTC("first_line_time").getMJD();
            double t0 = Sentinel1Utils.getTime((MetadataElement)imageInformationElem, (String)"productFirstLineUtcTime").getMJD();
            this.t0Map.put(imageName, t0);
            double deltaTS1 = this.absRoot.getAttributeDouble("line_time_interval") / 86400.0;
            double deltaTS = imageInformationElem.getAttributeDouble("azimuthTimeInterval") / 86400.0;
            this.deltaTsMap.put(imageName, deltaTS);
            break;
        }
    }

    private String getBandPol(String bandName) {
        if (bandName.contains("HH")) {
            return "HH";
        }
        if (bandName.contains("HV")) {
            return "HV";
        }
        if (bandName.contains("VV")) {
            return "VV";
        }
        if (bandName.contains("VH")) {
            return "VH";
        }
        return "";
    }

    private String getBandSwath(String bandName) {
        if (bandName.contains("IW1")) {
            return "IW1";
        }
        if (bandName.contains("IW2")) {
            return "IW2";
        }
        if (bandName.contains("IW3")) {
            return "IW3";
        }
        if (bandName.contains("EW1")) {
            return "EW1";
        }
        if (bandName.contains("EW2")) {
            return "EW2";
        }
        if (bandName.contains("EW3")) {
            return "EW3";
        }
        if (bandName.contains("EW4")) {
            return "EW4";
        }
        if (bandName.contains("EW5")) {
            return "EW5";
        }
        return "";
    }

    private double getNoiseValue(int x, int y, NoiseAzimuthBlock[] noiseAzimuthBlocks) {
        for (NoiseAzimuthBlock noiseAzimuthBlock : noiseAzimuthBlocks) {
            int firstAzimuthLine = noiseAzimuthBlock.firstAzimuthLine;
            int lastAzimuthLine = noiseAzimuthBlock.lastAzimuthLine;
            int firstRangeSample = noiseAzimuthBlock.firstRangeSample;
            int lastRangeSample = noiseAzimuthBlock.lastRangeSample;
            if (this.isTOPS) {
                if (x < firstRangeSample || x > lastRangeSample || y < firstAzimuthLine || y > lastAzimuthLine) continue;
                double val = noiseAzimuthBlock.noiseMatrix[y - firstAzimuthLine][x - firstRangeSample];
                if (this.removeThermalNoise.booleanValue()) {
                    return val;
                }
                return -val;
            }
            if (x < firstRangeSample || x > lastRangeSample) continue;
            double val = noiseAzimuthBlock.noiseMatrix[0][x - firstRangeSample];
            if (this.removeThermalNoise.booleanValue()) {
                return val;
            }
            return -val;
        }
        return 0.0;
    }

    private double getNoiseValue(int x, int y, BurstBlock[] burstBlocks) {
        for (int i = 0; i < burstBlocks.length; ++i) {
            int firstLine = burstBlocks[i].firstLine;
            int lastLine = burstBlocks[i].lastLine;
            if (y < firstLine || y > lastLine) continue;
            int firstValidSample = burstBlocks[i].firstValidSample[y - firstLine];
            int lastValidSample = burstBlocks[i].lastValidSample[y - firstLine];
            if (x < firstValidSample || x > lastValidSample) continue;
            if (y > burstBlocks[i].azimuthNoise.length - 1) {
                System.out.println("Sentinel1RemoveThermalNoiseOp: ERROR: i = " + i + " y = " + y + " burstBlocks[i].azimuthNoise.length = " + burstBlocks[i].azimuthNoise.length);
            }
            double azimuthNoise = burstBlocks[i].azimuthNoise[y];
            if (x > burstBlocks[i].rangeNoise.length - 1) {
                System.out.println("Sentinel1RemoveThermalNoiseOp: ERROR: i = " + i + " x = " + x + " burstBlocks[i].rangeNoise.length = " + burstBlocks[i].rangeNoise.length);
            }
            double rangeNoise = burstBlocks[i].rangeNoise[x];
            double val = azimuthNoise * rangeNoise;
            if (this.removeThermalNoise.booleanValue()) {
                return val;
            }
            return -val;
        }
        return 0.0;
    }

    private static int getIndex(String s, char c, int n) {
        int cnt = 0;
        for (int i = 0; i < s.length(); ++i) {
            if (s.charAt(i) != c || ++cnt != n) continue;
            return i;
        }
        return -1;
    }

    private static String getKey(String imageName) {
        int idx1 = Sentinel1RemoveThermalNoiseOp.getIndex(imageName, '-', 1);
        int idx2 = Sentinel1RemoveThermalNoiseOp.getIndex(imageName, '-', 2);
        int idx3 = Sentinel1RemoveThermalNoiseOp.getIndex(imageName, '-', 3);
        int idx4 = Sentinel1RemoveThermalNoiseOp.getIndex(imageName, '-', 4);
        String s = imageName.substring(idx1 + 1, idx2) + imageName.substring(idx3, idx4);
        return s.replace('-', '_');
    }

    private int getLineFromTime(String imageName, double azimTime) {
        double t0 = this.t0Map.get(imageName);
        double lineTimeInterval = this.deltaTsMap.get(imageName);
        return (int)((azimTime - t0) / lineTimeInterval);
    }

    private static int[] getIntArray(MetadataElement elem, String tag) {
        MetadataAttribute attribute = elem.getAttribute(tag);
        if (attribute == null) {
            throw new OperatorException(tag + " attribute not found");
        }
        int[] array = null;
        if (attribute.getDataType() == 41) {
            String dataStr = attribute.getData().getElemString();
            String[] items = dataStr.split(" ");
            array = new int[items.length];
            for (int i = 0; i < items.length; ++i) {
                try {
                    array[i] = Integer.parseInt(items[i]);
                    continue;
                }
                catch (NumberFormatException e) {
                    throw new OperatorException("Failed in getting" + tag + " array");
                }
            }
        }
        return array;
    }

    public static class Spi
    extends OperatorSpi {
        public Spi() {
            super(Sentinel1RemoveThermalNoiseOp.class);
        }
    }

    private final class BurstBlock {
        final int linesPerBurst;
        final int samplesPerBurst;
        final double firstLineTime;
        final int[] firstValidSample;
        final int[] lastValidSample;
        final int firstLine;
        final int lastLine;
        final double[] rangeNoise;
        final double[] azimuthNoise;

        BurstBlock(int linesPerBurst, int samplesPerBurst, double firstLineTime, int[] firstValidSample, int[] lastValidSample, int firstLine, int lastLine, double[] rangeNoise, double[] azimuthNoise) {
            this.linesPerBurst = linesPerBurst;
            this.samplesPerBurst = samplesPerBurst;
            this.firstLineTime = firstLineTime;
            this.firstValidSample = firstValidSample;
            this.lastValidSample = lastValidSample;
            this.firstLine = firstLine;
            this.lastLine = lastLine;
            this.rangeNoise = rangeNoise;
            this.azimuthNoise = azimuthNoise;
        }
    }

    private static final class NoiseAzimuthBlock {
        final int firstAzimuthLine;
        final int firstRangeSample;
        final int lastAzimuthLine;
        final int lastRangeSample;
        final double[][] noiseMatrix;

        NoiseAzimuthBlock(int firstAzimuthLine, int firstRangeSample, int lastAzimuthLine, int lastRangeSample, double[][] noiseMatrix) {
            this.firstAzimuthLine = firstAzimuthLine;
            this.firstRangeSample = firstRangeSample;
            this.lastAzimuthLine = lastAzimuthLine;
            this.lastRangeSample = lastRangeSample;
            this.noiseMatrix = noiseMatrix;
        }
    }

    public static class ThermalNoiseInfo {
        public String polarization;
        public String subSwath;
        public double firstLineTime;
        public double lastLineTime;
        public int numOfLines;
        public int count;
        public Sentinel1Utils.NoiseVector[] noiseVectorList;
        final double lineTimeInterval;

        ThermalNoiseInfo(String pol, String subSwath, double firstLineTime, double lastLineTime, int numOfLines, int count, Sentinel1Utils.NoiseVector[] noiseVectorList) {
            this.polarization = pol;
            this.subSwath = subSwath;
            this.firstLineTime = firstLineTime;
            this.lastLineTime = lastLineTime;
            this.numOfLines = numOfLines;
            this.count = count;
            this.noiseVectorList = noiseVectorList;
            this.lineTimeInterval = (lastLineTime - firstLineTime) / (double)(numOfLines - 1);
        }
    }
}

