/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s1tbx.analysis.rcp.toolviews.timeseries.graphs;

import com.bc.ceres.core.ProgressMonitor;
import com.bc.ceres.glayer.support.ImageLayer;
import java.awt.image.Raster;
import javax.media.jai.PlanarImage;
import org.esa.s1tbx.analysis.rcp.toolviews.timeseries.TimeSeriesGraph;
import org.esa.s1tbx.analysis.rcp.toolviews.timeseries.TimeSeriesTimes;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.GeoCoding;
import org.esa.snap.core.datamodel.GeoPos;
import org.esa.snap.core.datamodel.PixelPos;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.datamodel.VectorDataNode;
import org.esa.snap.core.image.ImageManager;
import org.esa.snap.core.util.math.IndexValidator;
import org.esa.snap.core.util.math.Range;
import org.geotools.geometry.jts.ReferencedEnvelope;

public class VectorGraph
extends TimeSeriesGraph {
    private VectorDataNode vectorNode;
    private final TYPE type;
    private boolean dataComputed = false;

    public VectorGraph(VectorDataNode vectorNode, TYPE type) {
        this.vectorNode = vectorNode;
        this.type = type;
    }

    @Override
    public String getXName() {
        return "Time";
    }

    @Override
    public String getYName() {
        return this.vectorNode.getName();
    }

    @Override
    public void setBands(TimeSeriesTimes tsTimes, Band[] selBands) {
        super.setBands(tsTimes, selBands);
        this.dataComputed = false;
    }

    private void computeData() {
        this.resetData();
        for (Band band : this.selectedBands) {
            int index = this.getTimeIndex(band);
            if (index < 0) continue;
            this.dataPoints[index] = this.processVector(band);
            if (this.dataPoints[index] != band.getNoDataValue()) continue;
            this.dataPoints[index] = Double.NaN;
        }
        this.dataComputed = true;
    }

    @Override
    public void readValues(ImageLayer imageLayer, GeoPos geoPos, int level) {
        if (!this.dataComputed) {
            this.computeData();
        }
        Range.computeRangeDouble((double[])this.dataPoints, (IndexValidator)IndexValidator.TRUE, (Range)this.dataPointRange, (ProgressMonitor)ProgressMonitor.NULL);
    }

    private double processVector(Band band) {
        PixelPos bottomRight;
        PixelPos topLeft;
        GeoCoding bandGC = band.getGeoCoding();
        ReferencedEnvelope env = this.vectorNode.getEnvelope();
        String envCode = env.getCoordinateReferenceSystem().getName().getCode();
        if (envCode.startsWith("Image CS based on")) {
            topLeft = new PixelPos((double)((float)env.getMinX()), (double)((float)env.getMinY()));
            bottomRight = new PixelPos((double)((float)env.getMaxX()), (double)((float)env.getMaxY()));
        } else {
            GeoPos geo1 = new GeoPos((double)((float)env.getMinY()), (double)((float)env.getMinX()));
            GeoPos geo2 = new GeoPos((double)((float)env.getMaxY()), (double)((float)env.getMaxX()));
            topLeft = bandGC.getPixelPos(geo1, null);
            bottomRight = bandGC.getPixelPos(geo2, null);
        }
        int minX = (int)Math.min(topLeft.getX(), bottomRight.getX());
        int maxX = (int)Math.max(topLeft.getX(), bottomRight.getX());
        int minY = (int)Math.min(topLeft.getY(), bottomRight.getY());
        int maxY = (int)Math.max(topLeft.getY(), bottomRight.getY());
        double noDataValue = band.getNoDataValue();
        PlanarImage image = ImageManager.getInstance().getSourceImage((RasterDataNode)band, 0);
        boolean isStdDev = false;
        double[] samples = null;
        if (this.type == TYPE.STD_DEV) {
            isStdDev = true;
            samples = new double[Math.max(1, (maxX + 1 - minX) * (maxY + 1 - minY))];
        }
        double sum = 0.0;
        int cnt = 0;
        for (int x = minX; x <= maxX; ++x) {
            int tileX = image.XToTileX(x);
            for (int y = minY; y <= maxY; ++y) {
                double sample;
                int tileY = image.YToTileY(y);
                Raster data = image.getTile(tileX, tileY);
                if (data == null || Double.isNaN(sample = band.getDataType() == 10 ? (double)((byte)data.getSample(x, y, 0)) : (band.getDataType() == 22 ? (double)((long)data.getSample(x, y, 0) & 0xFFFFFFFFL) : data.getSampleDouble(x, y, 0))) || sample == noDataValue) continue;
                sum += sample;
                if (isStdDev) {
                    samples[cnt] = sample;
                }
                ++cnt;
            }
        }
        double mean = sum / (double)cnt;
        if (isStdDev) {
            double sqrSum = 0.0;
            for (double sample : samples) {
                double delta = sample - mean;
                sqrSum += delta * delta;
            }
            return Math.sqrt(sqrSum / (double)cnt);
        }
        return mean;
    }

    @Override
    public void dispose() {
        this.vectorNode = null;
        super.dispose();
    }

    public static enum TYPE {
        AVERAGE,
        STD_DEV;

    }
}

