/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s1tbx.analysis.rcp.toolviews.timeseries.graphs;

import com.bc.ceres.core.ProgressMonitor;
import com.bc.ceres.glayer.support.ImageLayer;
import java.io.IOException;
import org.esa.s1tbx.analysis.rcp.toolviews.timeseries.TimeSeriesGraph;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.GeoPos;
import org.esa.snap.core.datamodel.PixelPos;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.util.math.IndexValidator;
import org.esa.snap.core.util.math.Range;

public class CursorGraph
extends TimeSeriesGraph {
    @Override
    public String getYName() {
        return "Cursor";
    }

    @Override
    public void readValues(ImageLayer imageLayer, GeoPos geoPos, int level) {
        this.resetData();
        for (Band band : this.selectedBands) {
            int index = this.getTimeIndex(band);
            if (index < 0) continue;
            PixelPos pix = band.getGeoCoding().getPixelPos(geoPos, null);
            this.dataPoints[index] = CursorGraph.getPixelDouble((RasterDataNode)band, (int)pix.getX(), (int)pix.getY());
            if (this.dataPoints[index] != band.getNoDataValue()) continue;
            this.dataPoints[index] = Double.NaN;
        }
        Range.computeRangeDouble((double[])this.dataPoints, (IndexValidator)IndexValidator.TRUE, (Range)this.dataPointRange, (ProgressMonitor)ProgressMonitor.NULL);
    }

    public static double getPixelDouble(RasterDataNode raster, int x, int y) {
        if (raster.hasRasterData()) {
            if (raster.isPixelValid(x, y)) {
                if (raster.isFloatingPointType()) {
                    return raster.getPixelDouble(x, y);
                }
                return raster.getPixelInt(x, y);
            }
            return Double.NaN;
        }
        try {
            boolean pixelValid = raster.readValidMask(x, y, 1, 1, new boolean[1])[0];
            if (pixelValid) {
                if (raster.isFloatingPointType()) {
                    float[] pixel = raster.readPixels(x, y, 1, 1, new float[1], ProgressMonitor.NULL);
                    return pixel[0];
                }
                int[] pixel = raster.readPixels(x, y, 1, 1, new int[1], ProgressMonitor.NULL);
                return pixel[0];
            }
            return Double.NaN;
        }
        catch (IOException e) {
            return Double.NaN;
        }
    }
}

