/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s1tbx.analysis.rcp.toolviews.timeseries;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.esa.s1tbx.analysis.rcp.toolviews.timeseries.GraphData;
import org.esa.s1tbx.analysis.rcp.toolviews.timeseries.GraphProductSetPanel;
import org.esa.s1tbx.analysis.rcp.toolviews.timeseries.TimeSeriesSettings;
import org.esa.s1tbx.analysis.rcp.toolviews.timeseries.TimeSeriesToolView;
import org.esa.snap.graphbuilder.rcp.utils.DialogUtils;
import org.esa.snap.rcp.SnapApp;
import org.esa.snap.ui.ModalDialog;

public class TimeSeriesSettingsDlg
extends ModalDialog {
    private final JCheckBox showGridCB = new JCheckBox("Show Grid");
    private final JCheckBox showLegendCB = new JCheckBox("Show Legend");
    private final GridBagConstraints glGbc = DialogUtils.createGridBagConstraints();
    private final JPanel graphListPanel = new JPanel(new GridBagLayout());
    private final List<GraphProductSetPanel> graphList = new ArrayList<GraphProductSetPanel>(2);
    private final TimeSeriesToolView view;
    final TimeSeriesSettings settings;

    public TimeSeriesSettingsDlg(Window parent, String title, String helpID, TimeSeriesSettings settings, TimeSeriesToolView view) {
        super(parent, title, 24, helpID);
        this.settings = settings;
        this.view = view;
        this.getJDialog().setResizable(false);
        List<GraphData> graphDataLists = settings.getGraphDataList();
        int cnt = 1;
        for (GraphData graphData : graphDataLists) {
            boolean addDeleteButton = cnt > 1;
            GraphProductSetPanel productListPanel = new GraphProductSetPanel(SnapApp.getDefault().getAppContext(), this, graphData, addDeleteButton);
            productListPanel.setProductFileList(graphData.getFileList());
            this.graphList.add(productListPanel);
            ++cnt;
        }
        this.initUI();
        this.showGridCB.setSelected(settings.isShowingGrid());
        this.showLegendCB.setSelected(settings.isShowingLegend());
    }

    private void initUI() {
        JPanel content = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = DialogUtils.createGridBagConstraints();
        JPanel optionsPanel = new JPanel();
        optionsPanel.add(this.showGridCB);
        optionsPanel.add(this.showLegendCB);
        DialogUtils.addComponent((JPanel)content, (GridBagConstraints)gbc, (String)"", (JComponent)optionsPanel);
        ++gbc.gridy;
        JButton addGraphBtn = DialogUtils.createButton((String)"addGraphBtn", (String)"Add Graph", null, (JPanel)content, (DialogUtils.ButtonStyle)DialogUtils.ButtonStyle.Text);
        final TimeSeriesSettingsDlg settingsDlg = this;
        addGraphBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int cnt = TimeSeriesSettingsDlg.this.graphList.size() + 1;
                GraphProductSetPanel productListPanel = new GraphProductSetPanel(SnapApp.getDefault().getAppContext(), settingsDlg, new GraphData("Graph " + cnt), true);
                TimeSeriesSettingsDlg.this.graphList.add(productListPanel);
                TimeSeriesSettingsDlg.this.graphListPanel.add((Component)((Object)productListPanel), TimeSeriesSettingsDlg.this.glGbc);
                ++((TimeSeriesSettingsDlg)TimeSeriesSettingsDlg.this).glGbc.gridy;
                TimeSeriesSettingsDlg.this.graphListPanel.revalidate();
            }
        });
        gbc.gridx = 0;
        content.add((Component)addGraphBtn, gbc);
        JScrollPane scrollPane = new JScrollPane(this.graphListPanel);
        scrollPane.setPreferredSize(new Dimension(680, 300));
        DialogUtils.addComponent((JPanel)content, (GridBagConstraints)gbc, (String)"", (JComponent)scrollPane);
        for (GraphProductSetPanel productListPanel : this.graphList) {
            this.graphListPanel.add((Component)((Object)productListPanel), this.glGbc);
            ++this.glGbc.gridy;
        }
        this.setContent(content);
    }

    public void removeGraphPanel(GraphProductSetPanel productListPanel) {
        this.graphList.remove((Object)productListPanel);
        this.graphListPanel.remove((Component)((Object)productListPanel));
        this.graphListPanel.revalidate();
    }

    public List<GraphData> getProductLists() {
        ArrayList<GraphData> graphDataList = new ArrayList<GraphData>(this.graphList.size());
        for (GraphProductSetPanel panel : this.graphList) {
            graphDataList.add(new GraphData(panel.getTitle(), panel.getFileList(), panel.getColor()));
        }
        return graphDataList;
    }

    public void onApply() {
        this.settings.setGridShown(this.showGridCB.isSelected());
        this.settings.setLegendShown(this.showLegendCB.isSelected());
        this.settings.setGraphDataList(this.getProductLists());
        this.view.refresh();
    }

    public void onClose() {
        this.onApply();
        super.onClose();
    }
}

