/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s1tbx.analysis.rcp.toolviews.timeseries;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.Rectangle2D;
import java.util.List;
import org.esa.s1tbx.analysis.rcp.toolviews.timeseries.GraphData;
import org.esa.s1tbx.analysis.rcp.toolviews.timeseries.TimeSeriesDiagram;
import org.esa.s1tbx.analysis.rcp.toolviews.timeseries.TimeSeriesSettings;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.ui.diagram.DiagramCanvas;

public class TimeSeriesCanvas
extends DiagramCanvas {
    private final TimeSeriesSettings settings;

    public TimeSeriesCanvas(TimeSeriesSettings settings) {
        this.settings = settings;
    }

    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (!(g instanceof Graphics2D)) {
            return;
        }
        Graphics2D g2d = (Graphics2D)g;
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (this.settings.isShowingLegend() && this.getDiagram() != null) {
            this.drawLegend(g2d);
        }
    }

    private void drawLegend(Graphics2D g2d) {
        Rectangle graphArea = this.getDiagram().getGraphArea();
        int x0 = graphArea.x + 10;
        int y0 = 20;
        g2d.setStroke(new BasicStroke(2.0f));
        List<GraphData> graphDataList = this.settings.getGraphDataList();
        for (GraphData graphData : graphDataList) {
            if (graphData.getProducts() == null) continue;
            Rectangle2D rect = this.getTextBox(g2d, graphData.getTitle(), x0, y0);
            TimeSeriesCanvas.drawTextBox(g2d, rect, graphData.getTitle(), x0, y0, graphData.getColor());
            x0 = (int)rect.getMaxX() + 10;
            if (x0 <= this.getWidth() - 50) continue;
            x0 = graphArea.x + 10;
            y0 += 20;
        }
    }

    private Rectangle2D getTextBox(Graphics2D g2d, String text, int x0, int y0) {
        FontMetrics fontMetrics = g2d.getFontMetrics();
        Rectangle2D textBounds = fontMetrics.getStringBounds(text, g2d);
        Rectangle2D.Double r = new Rectangle2D.Double((double)x0 + textBounds.getX() - 2.0, (double)y0 + textBounds.getY() - 2.0, textBounds.getWidth() + 4.0, textBounds.getHeight() + 4.0);
        if (r.getMaxX() > (double)this.getWidth()) {
            r.setRect((double)this.getWidth() - r.getWidth(), r.getY(), r.getWidth(), r.getHeight());
        }
        if (r.getMinX() < 0.0) {
            r.setRect(0.0, r.getY(), r.getWidth(), r.getHeight());
        }
        if (r.getMaxY() > (double)this.getHeight()) {
            r.setRect(r.getX(), (double)this.getHeight() - r.getHeight(), r.getWidth(), r.getHeight());
        }
        if (r.getMinY() < 0.0) {
            r.setRect(r.getX(), 0.0, r.getWidth(), r.getHeight());
        }
        return r;
    }

    private static void drawTextBox(Graphics2D g2d, Rectangle2D r, String text, int x0, int y0, Color color) {
        g2d.setColor(color);
        g2d.drawLine((int)r.getMinX(), (int)r.getMaxY(), (int)r.getMaxX(), (int)r.getMaxY());
        g2d.setColor(Color.black);
        g2d.drawString(text, x0, y0);
    }

    public boolean contains(int x, int y) {
        TimeSeriesDiagram diagram = (TimeSeriesDiagram)this.getDiagram();
        String text = "";
        this.setToolTipText(text);
        return super.contains(x, y);
    }

    private static Band findBand(Band[] bands, String refStr) {
        for (Band b : bands) {
            if (!b.getProduct().getProductRefString().equals(refStr)) continue;
            return b;
        }
        return null;
    }
}

