/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s1tbx.analysis.rcp.toolviews.timeseries;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JPanel;
import org.esa.s1tbx.analysis.rcp.toolviews.timeseries.GraphData;
import org.esa.s1tbx.analysis.rcp.toolviews.timeseries.TimeSeriesSettingsDlg;
import org.esa.snap.graphbuilder.rcp.dialogs.ProductSetPanel;
import org.esa.snap.graphbuilder.rcp.dialogs.PromptDialog;
import org.esa.snap.graphbuilder.rcp.dialogs.support.FileTable;
import org.esa.snap.graphbuilder.rcp.utils.DialogUtils;
import org.esa.snap.ui.AppContext;
import org.esa.snap.ui.color.ColorComboBox;

public class GraphProductSetPanel
extends ProductSetPanel {
    private final ColorComboBox colorCombo = new ColorComboBox();
    private final TimeSeriesSettingsDlg settingsDlg;
    private String title;

    public GraphProductSetPanel(AppContext theAppContext, TimeSeriesSettingsDlg settingsDlg, GraphData graphData, boolean addDeleteButton) {
        super(theAppContext, graphData.getTitle(), new FileTable(), false, true);
        this.title = graphData.getTitle();
        this.settingsDlg = settingsDlg;
        this.colorCombo.setSelectedColor(graphData.getColor());
        this.getButtonPanel().add((Component)this.colorCombo);
        this.getButtonPanel().add(GraphProductSetPanel.createRenameButton(this));
        if (addDeleteButton) {
            this.getButtonPanel().add(this.createDeleteButton(this));
        }
    }

    private static JButton createRenameButton(final GraphProductSetPanel panel) {
        JButton renameBtn = DialogUtils.createButton((String)"renameBtn", (String)"Rename", null, (JPanel)((Object)panel), (DialogUtils.ButtonStyle)DialogUtils.ButtonStyle.Text);
        renameBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PromptDialog dlg = new PromptDialog("Rename", "Name", panel.getTitle(), false);
                dlg.show();
                if (dlg.IsOK()) {
                    panel.setTitle(dlg.getValue());
                }
            }
        });
        return renameBtn;
    }

    private JButton createDeleteButton(final GraphProductSetPanel panel) {
        JButton deleteBtn = DialogUtils.createButton((String)"deleteBtn", (String)"Delete Graph", null, (JPanel)((Object)panel), (DialogUtils.ButtonStyle)DialogUtils.ButtonStyle.Text);
        deleteBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GraphProductSetPanel.this.settingsDlg.removeGraphPanel(panel);
            }
        });
        return deleteBtn;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
        this.setBorderTitle(title);
    }

    public Color getColor() {
        return this.colorCombo.getSelectedColor();
    }
}

