/*
 * Decompiled with CFR 0.152.
 */
package org.esa.s1tbx.analysis.rcp.toolviews.timeseries;

import java.text.DateFormat;
import java.util.ArrayList;
import org.esa.s1tbx.analysis.rcp.toolviews.timeseries.TimeSeriesTimes;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.ui.diagram.DiagramAxis;

public class DateAxis
extends DiagramAxis {
    private TimeSeriesTimes times;
    private final DateFormat dateFormat = ProductData.UTC.createDateFormat((String)"ddMMMyy");

    public DateAxis(String name, String unit) {
        super(name, unit);
    }

    public void setTimes(TimeSeriesTimes times) {
        this.times = times;
    }

    public String[] createTickmarkTexts() {
        ArrayList<String> tickNames = new ArrayList<String>(this.times.length());
        this.setName("Acquisition Date");
        int numTicks = this.getNumMajorTicks();
        double min = this.getMinValue();
        double dist = this.getMajorTickMarkDistance();
        for (int i = 0; i < numTicks; ++i) {
            double mjd = min + (double)i * dist;
            ProductData.UTC newTime = new ProductData.UTC(mjd);
            String tickStr = this.dateFormat.format(newTime.getAsDate());
            tickNames.add(tickStr);
        }
        return tickNames.toArray(new String[tickNames.size()]);
    }
}

